h33158
s 00000/00000/00699
d D 1.5 98/09/02 10:57:27 jpiper 6 5
c 
e
s 00005/00004/00694
d D 1.4 98/08/04 18:48:00 jpiper 5 4
c needed for debugging
e
s 00002/00002/00696
d D 1.3 98/07/30 14:59:48 jpiper 4 3
c Fully Debugged
e
s 00319/00091/00379
d D 1.2 98/07/30 12:25:31 jpiper 3 1
c Unrolled loops - old in SDMatrix.java
e
s 00000/00000/00000
d R 1.2 98/07/30 11:11:18 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/DMatrix/DMatrix.java
e
s 00470/00000/00000
d D 1.1 98/07/30 11:11:17 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
/*## 
 ##  class DMatrix
 ##   
 ##  This class extends Matrix to represent a Matrix of single precision
 ##  floating point numbers.  It contains all the BLAS (basic linear 
 ##  algebra subroutines) and other low-level functions common to all
 ##  matrices.  
 ##  DMatrix's contain no factoring or solving capabilities.
 ##
 ##*/

package edu.rice.linpack.Matrix.DMatrix;
import edu.rice.linpack.Matrix.Matrix;
import edu.rice.linpack.util.*;
import edu.rice.linpack.Vector.*;


public abstract class DMatrix extends Matrix {

  protected double[][] Mat;

  void cons() {
    pivot = new int[cols];
  }
  void cons(int i, int j) {
    Mat = new double[i][j];
    rows = i;
    cols = j;
    pivot = new int[cols];
  }
  void cons(DMatrix M) {
    rows = M.rows;
    cols = M.cols;
    Mat = new double[rows][cols];
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) 
	Mat[i][j] = M.Mat[i][j];
    pivot = new int[cols];
  }    
  void cons(double[][] F) {
    rows = F.length;
    cols = (F[0]).length;
    Mat = F;
    pivot = new int[cols];
  }
  
  /*##
   ##  These routines return a copy of the desired object beginning at
   ##   the element (i,q)  
   ##*/

  public double getElem(int i, int q) {
    return Mat[i][q];
  }
  public double[] getRow(int i, int q) {
    double[] F = new double[cols-q];
    for(int j=0;j<(cols-q);j++)
      F[j] = Mat[i][q+j];
    return F;
  }
  public double[] getColumn(int i, int q) {
    double[] F = new double[rows-q];
    for(int j=0; j<(rows-q);j++) {
      F[j] = Mat[j+q][i];
    }
    return F;
  }

  /*##
   ##  this.setColumn changes column c to F  
   ##*/

  public void setColumn(int c,double[] F) {
    for(int r=0;r<rows;r++) {
      this.Mat[r][c] = F[r];
    }
  }
  public void setElem(int r, int c, double value) {
    this.Mat[r][c] = value;
  }

  public void Print() {
    System.out.println();
    for(int i=0;i<rows;i++) {
      for(int j=0;j<cols;j++) {
	System.out.print(Mat[i][j] + "     ");
      }
      System.out.println();
    }
    System.out.println();
  }

  /*##
   ##  this.swapElem swaps two elements in this DMatrix  
   ##*/

  public void swapElem(int rx, int cx, int ry, int cy) {
    double T = this.Mat[rx][cx];
    this.Mat[rx][cx] = this.Mat[ry][cy];
    this.Mat[ry][cy] = T;
  }

  /*#######################*/
  /*##   BLAS Routines   ##*/

  /*##
   ##  For all BLAS: 
   ##
   ##  On Input:
   ##
   ##     n         int
   ##               The number of elements to be effected. 
   ##
   ##     incx      int
   ##               The amount to increase the column number for 
   ##               this.Mat on each iteration.
   ##
   ##     r,rx      int 
   ##               The initial row in this.Mat.
   ##
   ##     c,cx      int
   ##               The initial column in this.Mat.
   ## 
   ##     B         double[], DMatrix, double[][]
   ##               The other object used in some calculations.
   ##     
   ##     incy      int
   ##               The amount to increase the column number for B.
   ##
   ##     ry        int
   ##               The initial row in B.
   ## 
   ##     cy        int
   ##               The initial column in B.
   ##
   ##     Da        double
   ##               A double used as a scalar.
   ##
   ##     Tg        DTrig
   ##               Holds the sine and cosine values formed in a Givens
   ##               rotation and used in a rotation.
   ##*/

  /*##
   ##  asum - sum of absolute values in a vector
   ##  Returns the sum as a double  
   ##*/

  public double asum(int n, int incx, int r, int c) {
    double dasum = 0;
D 3
    int ix = r;
    for(int i=0;i<n;i++,ix+=incx) 
      dasum += Math.abs(this.Mat[ix][c]);
E 3
I 3
    if(incx != 1) {
      int ix = r;
      for(int i=0;i<n;i++,ix+=incx) 
	dasum += Math.abs(this.Mat[ix][c]);
      return dasum;
    }
    int m = n%6;
    if(m != 0) {
      for(int i=0;i<m;i++) {
D 5
	dasum += Math.abs(this.Mat[i][c]);
E 5
I 5
	dasum += Math.abs(this.Mat[i+r][c]);
E 5
      }
    }
    if(n >= 6) {
      for(int i=m;i<n;i+=6) {
D 5
	dasum += Math.abs(Mat[i][c]) + Math.abs(Mat[i+1][c]) + 
	  Math.abs(Mat[i+2][c]) + Math.abs(Mat[i+3][c]) + 
	  Math.abs(Mat[i+4][c]) + Math.abs(Mat[i+5][c]);
E 5
I 5
	int ir = i+r;
	dasum += Math.abs(Mat[ir][c]) + Math.abs(Mat[ir+1][c]) + 
	  Math.abs(Mat[ir+2][c]) + Math.abs(Mat[ir+3][c]) + 
	  Math.abs(Mat[ir+4][c]) + Math.abs(Mat[ir+5][c]);
E 5
      }
    }
E 3
    return dasum;
  }

  /*##
   ##  axpy - a const times a vector plus a vector 
   ##  Dy is changed in the loop and holds the desired value on return 
   ##*/

  public void axpy(int n, double Da, int incx, int rx, int cx, 
		   Matrix B, int incy, int ry, int cy) {
    
    double[][] Mat2 = ((DMatrix) B).Mat;

    if(n > 0 && Da != 0) {
D 3
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      for(int i=0;i<n;i++,ix+=incx,iy+=incy) 
	Mat2[iy+ry][cy] += Da * Mat[ix+rx][cx];
E 3
I 3

      if(incx != 1 || incy != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	for(int i=0;i<n;i++,ix+=incx,iy+=incy) 
	  Mat2[iy+ry][cy] += Da * Mat[ix+rx][cx];
      }
      else {
	int m = n%4;
	if(m != 0) {
	  for(int i=0;i<m;i++)
	    Mat2[i+ry][cy] += Da * Mat[i+rx][cx];
	}
	if(n >= 4) {
	  for(int i=m;i<n;i+=4) {
	    int iry = i+ry;
	    int irx = i+rx;
	    Mat2[iry][cy] += Da * Mat[irx][cx];
	    Mat2[iry+1][cy] += Da * Mat[irx+1][cx];
	    Mat2[iry+2][cy] += Da * Mat[irx+2][cx];
	    Mat2[iry+3][cy] += Da * Mat[irx+3][cx];
	  }
	}
      }
E 3
    }
  }
  public void axpy(int n, double Da, int incx, int rx, int cx,
		   Vector Be, int incy, int ry) 
       throws WrongDataTypeException 
  {
    double[] B = Be.getDoubleArray();
    this.axpy(n,Da,incx,rx,cx,B,incy,ry);
  }
  public void axpy(int n, double Da, int incx, int rx, int cx,
		   double[] B, int incy, int ry) {
    
    if(n > 0 && Da != 0) {
D 3
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      for(int i=0;i<n;i++,ix+=incx,iy+=incy) 
	B[ry+iy] += Da*Mat[ix+rx][cx];
E 3
I 3
      if(incx != 1 || incy != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	for(int i=0;i<n;i++,ix+=incx,iy+=incy) 
	  B[ry+iy] += Da*Mat[ix+rx][cx];
      }
      else {
	int m = n%4;
	if(m != 0) {
	  for(int i=0;i<m;i++)
	    B[i+ry] += Da * Mat[i+rx][cx];
	}
	if(n >= 4) {
	  for(int i=m;i<n;i+=4) {
	    int iry = i+ry;
	    int irx = i+rx;
	    B[iry] += Da * Mat[irx][cx];
	    B[iry+1] += Da * Mat[irx+1][cx];
	    B[iry+2] += Da * Mat[irx+2][cx];
	    B[iry+3] += Da * Mat[irx+3][cx];
	  }
	}
      }
E 3
    }
  }
D 3

E 3
  /*##
   ##  This version takes an array of doubles and modifies the calling object.
   ##  this.Mat is changed in the loop and holds the desired value on return.
   ##*/

  public void axpy(int n, double Da, Vector Be, int incy, int ry,
		   int incx, int rx, int cx) 
       throws WrongDataTypeException
  {
    double[] B = Be.getDoubleArray();
    this.axpy(n,Da,B,incy,ry,incx,rx,cx);
  }
  public void axpy(int n, double Da, double[] B, int incy, int ry,
		   int incx, int rx, int cx) {
    if(n > 0 && Da != 0) {
D 3
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      for(int i=0;i<n;i++,ix+=incx,iy+=incy) 
	this.Mat[rx+ix][cx] += Da*B[ry+iy];
E 3
I 3
      if(incx != 1 || incy != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	for(int i=0;i<n;i++,ix+=incx,iy+=incy) 
	  this.Mat[rx+ix][cx] += Da*B[ry+iy];
      }
      else {
	int m = n%4;
	if(m != 0) {
	  for(int i=0;i<m;i++)
	    Mat[i+rx][cx] += Da * B[i+ry];
	}
	if(n >= 4) {
	  for(int i=m;i<n;i+=4) {
	    int iry = i+ry;
	    int irx = i+rx;
	    Mat[irx][cx] += Da * B[iry];
	    Mat[irx+1][cx] += Da * B[iry+1];
	    Mat[irx+2][cx] += Da * B[iry+2];
	    Mat[irx+3][cx] += Da * B[iry+3];
	  }
	}
      }
E 3
    }
  }


  /*##
   ##  copy - copies one vector to another 
   ##  B is changed and holds the desired array 
   ##*/

  public void copy(int n, int incx, int rx, int cx, 
		   Vector Be, int incy) 
       throws WrongDataTypeException
  {
    double[] B = Be.getDoubleArray();
    this.copy(n,incx,rx,cx,B,incy);
  }
  public void copy(int n, int incx, int rx, int cx, 
		   double[] B, int incy) {
    if(n > 0) {
D 3
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      
      for(int i=0;i<n;i++,ix+=incx, iy+= incy) 
	B[iy] = Mat[ix+rx][cx];
E 3
I 3
      if(incx != 1 || incy != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	
	for(int i=0;i<n;i++,ix+=incx, iy+= incy) 
	  B[iy] = Mat[ix+rx][cx];
      }
      else {
	int m = n%7;
	if(m != 0) {
	  for(int i=0;i<m;i++) 
	    B[i] = Mat[i+rx][cx];
	}
	if(n >= 7) {
	  for(int i=m;i<n;i+=7) {
	    int irx = i+rx;
	    B[i] = Mat[irx][cx];
	    B[i+1] = Mat[irx+1][cx];
	    B[i+2] = Mat[irx+2][cx];
	    B[i+3] = Mat[irx+3][cx];
	    B[i+4] = Mat[irx+4][cx];
	    B[i+5] = Mat[irx+5][cx];
	    B[i+6] = Mat[irx+6][cx];
	  }
	}
      }
E 3
    }
  }
  public void copy(int n, int incx, int rx, int cx, 
		   Matrix B, int incy, int ry, int cy) {
    
    double[][] Mat2 = ((DMatrix)B).Mat;
    
    if(n > 0) {
D 3
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      
      for(int i=0;i<n;i++,ix+=incx, iy+= incy) 
	Mat2[iy+ry][cy] = Mat[ix+rx][cx];
E 3
I 3
      if(incx != 1 || incy != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	
	for(int i=0;i<n;i++,ix+=incx, iy+= incy) 
	  Mat2[iy+ry][cy] = Mat[ix+rx][cx];
      }
      else {
	int m = n%7;
	if(m != 0) {
	  for(int i=0;i<m;i++) 
	    Mat2[i+ry][cy] = Mat[i+rx][cx];
	}
	if(n >= 7) {
	  for(int i=m;i<n;i+=7) {
	    int irx = i+rx;
	    int iry = i+ry;
	    Mat2[iry][cy] = Mat[irx][cx];
	    Mat2[iry+1][cy] = Mat[irx+1][cx];
	    Mat2[iry+2][cy] = Mat[irx+2][cx];
	    Mat2[iry+3][cy] = Mat[irx+3][cx];
	    Mat2[iry+4][cy] = Mat[irx+4][cx];
	    Mat2[iry+5][cy] = Mat[irx+5][cx];
	    Mat2[iry+6][cy] = Mat[irx+6][cx];
	  }
	}
      }
E 3
    }
  }
  

  /*##
   ##  dot - Dot product between two vectors 
   ##  A double is returned  
   ##*/

  public double dot(int n, int incx, int rx, int cx,
		   DMatrix B, int incy, int ry, int cy) {
    
    double N = 0;
    
    if(n > 0){
D 3
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      
      for(int i=0; i<n;i++,ix+= incx,iy += incy) 
	N += Mat[rx+ix][cx] * B.Mat[ry+iy][cy];
E 3
I 3
      if(incy != 1 || incx != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	
	for(int i=0; i<n;i++,ix+= incx,iy += incy) 
	  N += Mat[rx+ix][cx] * B.Mat[ry+iy][cy];
      }
      else {
	int m = n%5;
	if(m != 0) {
	  for(int i=0;i<m;i++) {
	    N += Mat[i+rx][cx]*B.Mat[ry+i][cy];
	  }
	}
	if(n >= 5) {
	  for(int i=m;i<n;i+=5) {
	    int irx = i+rx;
	    int iry = i+ry;
	    N += Mat[irx][cx]*B.Mat[iry][cy] + 
	      Mat[irx+1][cx]*B.Mat[iry+1][cy] +
	      Mat[irx+2][cx]*B.Mat[iry+2][cy] +  
	      Mat[irx+3][cx]*B.Mat[iry+3][cy] + 
	      Mat[irx+4][cx]*B.Mat[iry+4][cy];
	  }
	}
      }
E 3
    }
    return N;
  }
  public double dot(int n, int incx, int rx, int cx,
		   Vector Be, int incy, int ry) 
       throws WrongDataTypeException
  {
    double[] B = Be.getDoubleArray();
    return this.dot(n,incx,rx,cx,B,incy,ry);
  }
  public double dot(int n, int incx, int rx, int cx,
		   double[] B, int incy, int ry) {

    double N = 0;
    
    if(n > 0){
D 3
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      
      for(int i=0; i<n;i++,ix+= incx,iy += incy) 
	N += Mat[rx+ix][cx] * B[ry+iy];
E 3
I 3
      if(incy != 1 || incx != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	
	for(int i=0; i<n;i++,ix+= incx,iy += incy) 
	  N += Mat[rx+ix][cx] * B[ry+iy];
      }
      else {
	int m = n%5;
	if(m != 0) {
	  for(int i=0;i<m;i++) {
	    N += Mat[i+rx][cx]*B[ry+i];
	  }
	}
	if(n >= 5) {
	  for(int i=m;i<n;i+=5) {
	    int irx = i+rx;
	    int iry = i+ry;
	    N += Mat[irx][cx]*B[iry] + 
	      Mat[irx+1][cx]*B[iry+1] +
	      Mat[irx+2][cx]*B[iry+2] +  
	      Mat[irx+3][cx]*B[iry+3] + 
	      Mat[irx+4][cx]*B[iry+4];
	  }
	}
      }
E 3
    }
    return N;
  }
D 3

E 3
I 3
  
E 3

  /*##
   ##  scal - multiply a vector by a scalar 
   ##  The calling object is changed  
   ##*/

  public void scal(int n, double Da, int incx, int r, int c) {

    if(n > 0 && Da != 1) {
D 3
      int ix = 0;
      for (int i=0;i<n;i++,ix += incx)
	Mat[ix+r][c] *= Da;
    }
  }      

E 3
I 3
      if(incx != 1) {
	int ix = 0;
	for (int i=0;i<n;i++,ix += incx)
	  Mat[ix+r][c] *= Da;
      }
      else {
	int m = n%5;
	if(m != 0) {
	  for(int i=0;i<m;i++) {
	    Mat[i+r][c] *= Da;
	  }
	}
	if(n >= 5) {
	  for(int i=m;i<n;i+=5) {
	    int ir = i+r;
	    Mat[ir][c] *= Da; 
	    Mat[ir+1][c] *= Da;
	    Mat[ir+2][c] *= Da; 
	    Mat[ir+3][c] *= Da; 
	    Mat[ir+4][c] *= Da;
	  }
	}
      }
    }      
  }
E 3
  /*##
   ##  swap - interchanges two vectors 
   ##*/

  public void swap(int n, int incx, int rx, int cx, 
		   Matrix B, int incy, int ry, int cy) {
    
    double[][] Mat2 = ((DMatrix)B).Mat;

    if(n > 0) {
D 3
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      double N;
      for(int i=0;i<n;i++) {
	N = Mat[ix+rx][cx];
	Mat[ix+rx][cx] = Mat2[iy+ry][cy];
	Mat2[iy+ry][cy] = N;
	ix += incx;
	iy += incy;
E 3
I 3
      if(incx != 1 || incy != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	double N;
	for(int i=0;i<n;i++) {
	  N = Mat[ix+rx][cx];
	  Mat[ix+rx][cx] = Mat2[iy+ry][cy];
	  Mat2[iy+ry][cy] = N;
	  ix += incx;
	  iy += incy;
	}
      }
      else {
	int m = n%3;
	if(m != 0) {
	  double temp;
	  for(int i=0;i<m;i++) {
	    temp = Mat[i+rx][cx];
	    Mat[i+rx][cx] = Mat2[i+ry][cy];
	    Mat2[i+ry][cy] = temp;
	  }
	}
	if(n >= 3) {
	  double temp;
D 4
	  for(int i=m;i<n;i++) {
E 4
I 4
	  for(int i=m;i<n;i+=3) {
E 4
	    int irx = i+rx;
	    int iry = i+ry;
	    temp = Mat[irx][cx];
	    Mat[irx][cx] = Mat2[iry][cy];
	    Mat2[iry][cy] = temp;
	    temp = Mat[irx+1][cx];
	    Mat[irx+1][cx] = Mat2[iry+1][cy];
	    Mat2[iry+1][cy] = temp;
	    temp = Mat[irx+2][cx];
	    Mat[irx+2][cx] = Mat2[iry+2][cy];
	    Mat2[iry+2][cy] = temp;
	  }
	}
E 3
      }
    }
  }
D 3

E 3
  /*##
   ##  i_amax - finds the index of element having the max absolute value 
   ##  Returns the index with zero as first element 
   ##*/

  public int i_amax(int n, int incx, int r, int c) {
  
    int max = 0;
    double Dmax;
    
    if(n < 0) 
      return 0;  
    
    if(n > 0) {
D 3
      int ix = incx;
      Dmax = Math.abs(Mat[r][c]);
      for(int i=1;i<n;i++) {
	if(Math.abs(Mat[ix+r][c]) > Dmax) {
	  max = ix;
	  Dmax = Math.abs(Mat[ix+r][c]);
E 3
I 3
      if(incx != 1) {
	int ix = incx;
	Dmax = Math.abs(Mat[r][c]);
	for(int i=1;i<n;i++) {
	  if(Math.abs(Mat[ix+r][c]) > Dmax) {
	    max = ix;
	    Dmax = Math.abs(Mat[ix+r][c]);
	  }
	  ix += incx;
	}
      } 
      else {
	Dmax = Math.abs(Mat[r][c]);
	for(int i=1;i<n;i++) {
D 4
	  if(Math.abs(Mat[r+1][c]) > Dmax) {
E 4
I 4
	  if(Math.abs(Mat[r+i][c]) > Dmax) {
E 4
	    max = i;
	    Dmax = Math.abs(Mat[r+1][c]);
	  }
E 3
	}
D 3
	ix += incx;
E 3
      }
D 3
    } 
E 3
I 3
    }
E 3
    return max;
  }
  
  /*##
   ##  rotg - construct a Givens plane rotation 
   ##  Tg contains the computed sin and cos values 
   ##*/
  
  public void rotg(int r, int c, Trig Tger) {

    DTrig Tg = (DTrig) Tger;

    double Roe = Tg.getB();
    double Da = this.Mat[r][c];
    double R;

    if(Math.abs(Da) > Math.abs(Tg.getB())) 
      Roe = Da;
    double Scale = Math.abs(Da) + Math.abs(Tg.getB());
    if(Scale == 0) {
      Tg.setCos(1);
      Tg.setSin(0);
      R = 0;
    }
    else {
      R = Scale*Math.sqrt(Math.pow(Da/Scale,2) + 
				 Math.pow(Tg.getB()/Scale,2));
      if(Roe < 0) 
	R = -R;
      Tg.setCos(Da/R);
      Tg.setSin(Tg.getB()/R);
    }
    double Z = 1;
    if(Math.abs(Da) > Math.abs(Tg.getB())) 
      Z = Tg.getSin();
    else if(Tg.getCos() != 0) 
      Z = 1/Tg.getCos();

    this.Mat[r][c] = R;
    Tg.setB(Z);
  }
  
  /*##
   ##  rot applies a plane rotation from the parameters figured from Givens 
   ##*/

  public void rot(int n, int incx, int rx, int cx, Matrix B, 
		  int incy, int ry, int cy, Trig Tger) {
    
    DTrig Tg = (DTrig) Tger;
    double[][] Mat2 = ((DMatrix) B).Mat;

    if(n <= 0) 
      return;
    else {
D 3
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;

      double temp;      
      for(int i=0;i<n;i++) {
        temp = (this.Mat[ix+rx][cx] * Tg.getCos()) + 
	  (Mat2[iy+ry][cy] * Tg.getSin());
        Mat2[iy+ry][cy] = (Mat2[iy+ry][cy] * Tg.getCos()) - 
	  (this.Mat[ix+rx][cx] * Tg.getSin());
        this.Mat[ix+rx][cx] = temp;
        ix += incx;
        iy += incy;
E 3
I 3
      if(incx != 1 || incy != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	
	double temp;      
	for(int i=0;i<n;i++) {
	  temp = (this.Mat[ix+rx][cx] * Tg.getCos()) + 
	    (Mat2[iy+ry][cy] * Tg.getSin());
	  Mat2[iy+ry][cy] = (Mat2[iy+ry][cy] * Tg.getCos()) - 
	    (this.Mat[ix+rx][cx] * Tg.getSin());
	  this.Mat[ix+rx][cx] = temp;
	  ix += incx;
	  iy += incy;
	}
      }
      else {
	double temp;
	for(int i=0;i<n;i++) {
	  temp = (Mat[i+rx][cx] * Tg.getCos()) + 
	    (Mat2[i+ry][cy] * Tg.getSin());
	  Mat2[i+ry][cy] = (Mat2[i+ry][cy] * Tg.getCos()) - 
	    (Mat[i+rx][cx] * Tg.getSin());
	  Mat[i+rx][cx] = temp;
	}
E 3
      }
    }
  }

  public double nrm2(int n, int incx, int r, int c) {
    
    int ix;
    double absxi, scale, ssq;
    
    if(n < 1 || incx < 1)
      return 0;
    else if( n == 1) 
      return Math.abs(Mat[r][c]);

    scale = 0;
    ssq = 1; 
    
    for(ix = 0;ix < n*incx;ix+=incx) {
      if(Mat[r+ix][c] != 0) {
	absxi = Math.abs(Mat[r+ix][c]);
	if(scale < absxi) {
	  ssq = 1 + ssq*Math.pow((scale/absxi),2);
	  scale = absxi;
	}
	else 
	  ssq += Math.pow( absxi/scale,2);
      }
    }
    return (scale*Math.sqrt(ssq));
  }
}
E 1
