h60029
s 00012/00012/00093
d D 1.2 98/07/27 13:07:44 jpiper 3 1
c double copy of FPacked
e
s 00000/00000/00000
d R 1.2 98/07/27 12:01:39 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/DMatrix/DPacked.java
e
s 00105/00000/00000
d D 1.1 98/07/27 12:01:38 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
/*  
D 3
 ##  class FPacked
E 3
I 3
 ##  class DPacked
E 3
 ##  
 ##  This class holds the framework for a matrix stored in packed form.
 ##  It contains all the necessary basic routines for matrices adjusted
 ##  for its form.
 ##
 */

D 3
package edu.rice.linpack.Matrix.FMatrix;
E 3
I 3
package edu.rice.linpack.Matrix.DMatrix;
E 3
import edu.rice.linpack.LNumber.*;
import edu.rice.linpack.Vector.*;
import edu.rice.linpack.util.*;

D 3
public abstract class FPacked extends FMatrix {
E 3
I 3
public abstract class DPacked extends DMatrix {
E 3

  protected int order;
        
  public abstract void factor()
       throws SingularMatrixException;

  public abstract LNumber condition()
       throws SingularMatrixException, WrongDataTypeException;
  public abstract LNumber condition(Vector Z)
       throws SingularMatrixException, WrongDataTypeException;

  public abstract void solve(Vector B, int J)
       throws WrongDataTypeException;
  public abstract void solve(Vector B)
       throws WrongDataTypeException;

  public abstract Vector determ();
  public abstract void inverse();

D 3
  public float getElem(int i) {
E 3
I 3
  public double getElem(int i) {
E 3
    return Mat[i][0];
  }
D 3
  public float[] getColumn(int q) {
E 3
I 3
  public double[] getColumn(int q) {
E 3
    return getColumn(0,q);
  }
  public int getOrder() {
    return order;
  }
D 3
  public static float[][] pack(float[][] f) {
E 3
I 3
  public static double[][] pack(double[][] f) {
E 3
    int k = 0;
    int n = f.length;
D 3
    float[][] R = new float[(n*(n+1))/2][1];
E 3
I 3
    double[][] R = new double[(n*(n+1))/2][1];
E 3
    for(int j=0;j<n;j++) {
      for(int i=0;i<=j;i++) {
	R[k][0] = f[i][j];
	k++;
      }
    }	
    return R;
  }

D 3
  public void setColumn(int c,FPacked F) {
E 3
I 3
  public void setColumn(int c,DPacked F) {
E 3
    for(int r=0;r<rows;r++) {
      this.Mat[r+c][0] = F.Mat[r][0];
    }
  }
D 3
  public void setColumn(int n, int rx, float[] f, int ry) {
E 3
I 3
  public void setColumn(int n, int rx, double[] f, int ry) {
E 3
    for(int i=0;i<n;i++) {
      this.Mat[i+rx][0] = f[i+ry];
    }
  }
  public void swapElem(int rx, int ry) {
    this.swapElem(rx,0,ry,0);
  }
  
D 3
  protected float oneNorm() {
    float[] Z = new float[order];
E 3
I 3
  protected double oneNorm() {
    double[] Z = new double[order];
E 3
    
    int j1 = 0;
    for(int j=0;j<order;j++) {
      Z[j] = this.asum(j+1,1,j1,0);
      int ij = j1;
      j1 += j+1;
      for(int i=0;i<j;i++) {
	Z[i] += Math.abs(this.Mat[ij][0]);
	ij++;
      }
    }
D 3
    float anorm = 0;
E 3
I 3
    double anorm = 0;
E 3
    for(int j=0;j<order;j++) 
      anorm = Math.max(anorm, Z[j]);
   
    return anorm;
  }

  public void Print() {
    for(int n=0;n<order;n++) {
      System.out.println();
      for(int j=0;j<order;j++) {
	if(j < n) 
	  System.out.print("           ");
	else {
	  int q = j*(j+1)/2 + n;
	  System.out.print(this.Mat[q][0]+"     ");
	}
      }
    }
    System.out.println();
  }
}
E 1
