h03424
s 00023/00003/00252
d D 1.3 98/07/28 14:56:41 jpiper 4 3
c fixed solveUZ
e
s 00047/00047/00208
d D 1.2 98/07/27 13:08:05 jpiper 3 1
c double created
e
s 00000/00000/00000
d R 1.2 98/07/27 12:01:43 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/DMatrix/DPoBand.java
e
s 00255/00000/00000
d D 1.1 98/07/27 12:01:42 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
/* 
D 3
 ##  class FPoBand
E 3
I 3
 ##  class DPoBand
E 3
 ##
 ##  This class contains the routines for positive definite matrices
 ##  in banded form.
 ##
 */

D 3
package edu.rice.linpack.Matrix.FMatrix;
E 3
I 3
package edu.rice.linpack.Matrix.DMatrix;
E 3
import edu.rice.linpack.LNumber.*;
import edu.rice.linpack.util.*;
import edu.rice.linpack.Vector.*;

D 3
public class FPoBand extends FBanded {
E 3
I 3
public class DPoBand extends DBanded {
E 3
  
  private int M;

D 3
  public FPoBand() {
E 3
I 3
  public DPoBand() {
E 3
    super();
  }
D 3
  public  FPoBand(int c, int M2) {
E 3
I 3
  public  DPoBand(int c, int M2) {
E 3
    super(0,M2,c);
    mu = M2;
    ml = 0;
    M = M2;
  }
D 3
  public FPoBand(float[][] f, int ML, int MU) {
E 3
I 3
  public DPoBand(double[][] f, int ML, int MU) {
E 3
    mu = MU;
    M = mu;
    ml = 0;
    rows = M+1;
    cols = f[0].length;
    Mat = band(f);
  }
D 3
  public FPoBand(float[][] f, int M2) {
E 3
I 3
  public DPoBand(double[][] f, int M2) {
E 3
    mu = M2;
    M = M2;
    ml = 0;
    rows = M+1;
    cols = f[0].length;
D 3
    Mat = new float[rows][cols];
E 3
I 3
    Mat = new double[rows][cols];
E 3
    for(int i=0;i<rows;i++) 
      for(int j=0;j<cols;j++) 
	Mat[i][j] = f[i][j];
  }
D 3
  public FPoBand(FPoFull F, int M2) {
E 3
I 3
  public DPoBand(DPoFull F, int M2) {
E 3
    mu = M2;
    M = M2;
    ml = 0;
    cols = F.numofCols();
    rows = M+1;
    Mat = band(F.Mat);
  }
D 3
  public FPoBand(FPoBand F) {
E 3
I 3
  public DPoBand(DPoBand F) {
E 3
    super(F);
    M = F.M;
  }

D 3
  private float[][] band(float[][] f) {
E 3
I 3
  private double[][] band(double[][] f) {
E 3
    int n = f[0].length;
D 3
    float[][] ret = new float[M+1][n];
E 3
I 3
    double[][] ret = new double[M+1][n];
E 3
    for(int j=0;j<n;j++) {
      int i1 = Math.max(0,j-M);
      for(int i=i1;i<=j;i++) {
	int k = i-j+M;
	ret[k][j] = f[i][j];
      }
    }
    return ret;
  }
D 3
  public FPoFull poUnband() {
    FPoFull Ret = new FPoFull(cols,cols);
E 3
I 3
  public DPoFull poUnband() {
    DPoFull Ret = new DPoFull(cols,cols);
E 3
    for(int j=0;j<cols;j++) {
      int i1 = Math.max(0,j-mu);
      for(int i=i1;i<=j;i++) {
	int k = i-j+mu;
	Ret.Mat[i][j] = this.Mat[k][j];
      }
    }
    return Ret;
  }


D 3
  public float oneNorm() {
E 3
I 3
  public double oneNorm() {
E 3
    
D 3
    float[] Z = new float[cols];
E 3
I 3
    double[] Z = new double[cols];
E 3

    for(int j=0;j<cols;j++) {
      int l = Math.min(j,M);
      int mu = Math.max(M-j,0);
      Z[j] = this.asum(l+1, 1,mu,j);
      int k = j - l;
      for(int i=mu;i<M;i++,k++) 
	Z[k] += Math.abs(this.Mat[i][j]);
    }
D 3
    float anorm = 0;//oneNorm;
E 3
I 3
    double anorm = 0;
E 3
    for(int j=0;j<cols;j++) 
      anorm = Math.max(anorm, Z[j]);

    return anorm;
  }

  public void factor() 
       throws SingularMatrixException
  {
D 3
    float S;
E 3
I 3
    double S;
E 3

    for(int j=0;j<cols;j++) {
      S = 0;
      int ik = M;
      int jk = Math.max(j-M,0);
      int mu = Math.max(M-j,0);
      
      for(int k=mu;k<M;k++,ik--,jk++) {
D 3
	float T = this.Mat[k][j] - this.dot(k-mu,1,ik,jk,this,1,mu,j);
E 3
I 3
	double T = this.Mat[k][j] - this.dot(k-mu,1,ik,jk,this,1,mu,j);
E 3
	T = T/this.Mat[M][jk];
	this.Mat[k][j] = T;
	S += T*T;
      }
      S = this.Mat[M][j] - S;    
      if(S <= 0) 
	throw new SingularMatrixException(j+1);
      else 
D 3
	this.Mat[M][j] = (float)Math.sqrt(S);
E 3
I 3
	this.Mat[M][j] = Math.sqrt(S);
E 3
    }
  }

  public LNumber condition() 
       throws SingularMatrixException, WrongDataTypeException
  {
D 3
    Vector Z = new FVector(cols);
E 3
I 3
    Vector Z = new DVector(cols);
E 3
    return this.condition(Z);
  }
  public LNumber condition(Vector Ze) 
       throws SingularMatrixException, WrongDataTypeException
  {

D 3
    float[] Z = Ze.getFloatArray();
    float anorm = this.oneNorm();
E 3
I 3
    double[] Z = Ze.getDoubleArray();
    double anorm = this.oneNorm();
E 3
   
    this.factor();
    
D 3
    float ek = 1;
E 3
I 3
    double ek = 1;
E 3
    for(int j=0;j<cols;j++) 
      Z[j] = 0;
      
    for(int k=0;k<cols;k++) {
      if(Z[k] != 0) 
D 3
	ek = FUtil.signOf(ek,-Z[k]);
E 3
I 3
	ek = DUtil.signOf(ek,-Z[k]);
E 3
      if(Math.abs(ek - Z[k]) > this.Mat[M][k]) {
D 3
	float S = this.Mat[M][k]/Math.abs(ek-Z[k]);
	FUtil.scal(cols,S,Z,1);
E 3
I 3
	double S = this.Mat[M][k]/Math.abs(ek-Z[k]);
	DUtil.scal(cols,S,Z,1);
E 3
	ek *= S;
      }
D 3
      float wk = ek - Z[k];
      float wkm = -ek - Z[k];
      float S = Math.abs(wk);
      float SM = Math.abs(wkm);
E 3
I 3
      double wk = ek - Z[k];
      double wkm = -ek - Z[k];
      double S = Math.abs(wk);
      double SM = Math.abs(wkm);
E 3
      wk = wk/this.Mat[M][k];
      wkm = wkm/this.Mat[M][k];
      int kp = k+1;
      int J2 = Math.min(kp+M,cols);
      int i = M-1;
      
      if(kp < J2) {
	for(int j=kp;j<J2;j++,i--) {
	  SM += Math.abs(Z[j] + wkm*this.Mat[i][j]);
	  Z[j] += wk*this.Mat[i][j];
	  S += Math.abs(Z[j]);
	}
	if(S < SM) {
D 3
	  float T = wkm - wk;
E 3
I 3
	  double T = wkm - wk;
E 3
	  wk = wkm;
	  i = M - 1;
	  for(int j=kp;j<J2;j++,i--) 
	    Z[j] += T*this.Mat[i][j];
	}
      }
      Z[k] = wk;
    }
D 3
    float S = 1/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
E 3
I 3
    double S = 1/DUtil.asum(cols,Z,1);
    DUtil.scal(cols,S,Z,1);
E 3
    
D 4
    this.solveUZ(M,Z,1);
E 4
I 4
    this.solveUZ(M,Z);
E 4
    
D 3
    float ynorm = this.solveTrans(M,Z);
E 3
I 3
    double ynorm = this.solveTrans(M,Z);
E 3
      
    ynorm = this.solveUZ(M,Z,ynorm);
  
D 3
    LFloat R = new LFloat();
E 3
I 3
    LDouble R = new LDouble();
E 3

    if(anorm != 0) 
D 3
      R.setFloat(ynorm/anorm);
E 3
I 3
      R.setDouble(ynorm/anorm);
E 3
    return R;
  }
I 4
  void solveUZ(int M, double[] Z) {
    for(int k=cols-1;k>=0;k--) {
      if(Math.abs(Z[k]) > Math.abs(this.Mat[M][k])) {
	double S = Math.abs(this.Mat[M][k])/Math.abs(Z[k]);
	DUtil.scal(cols,S,Z,1);
      }
      
      if(this.Mat[M][k] != 0)
	Z[k] /= this.Mat[M][k];
      else
	Z[k] = 1;
      int lm = Math.min(k,M);
      int la = M - lm;
      int lz = k - lm;
      double T = -Z[k];
      this.axpy(lm,T,1,la,k,Z,1,lz);
    }
    double S = 1.0/DUtil.asum(cols,Z,1);
    DUtil.scal(cols,S,Z,1);
  }
E 4
D 3
  private float solveTrans (int M, float[] Z) {
E 3
I 3
  private double solveTrans (int M, double[] Z) {
E 3
    
D 3
    float ynorm = 1;
E 3
I 3
    double ynorm = 1;
E 3

    for(int k=0;k<cols;k++) {
      int LM = Math.min(k,M);
      int la = M - LM;
      int lb = k - LM;
      Z[k] -= this.dot(LM,1,la,k,Z,1,lb);
      if(Math.abs(Z[k]) > this.Mat[M][k]) {
D 3
	float S = this.Mat[M][k]/Math.abs(Z[k]);
	FUtil.scal(cols,S,Z,1);
E 3
I 3
	double S = this.Mat[M][k]/Math.abs(Z[k]);
	DUtil.scal(cols,S,Z,1);
E 3
	ynorm *= S;
      }
      Z[k] /= this.Mat[M][k];
    }
D 3
    float S = 1/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
E 3
I 3
    double S = 1/DUtil.asum(cols,Z,1);
    DUtil.scal(cols,S,Z,1);
E 3
    ynorm *= S;
    
    return ynorm;
  }

  public void solve(Vector B, int J) 
       throws WrongDataTypeException
  {
    this.solve(B);
  }
  public void solve(Vector Be) 
       throws WrongDataTypeException
  {
D 3
    float[] B = Be.getFloatArray();
E 3
I 3
    double[] B = Be.getDoubleArray();
E 3
    this.solveTransRY(M,B);
    this.solveRX(M,B);
  }

  public Vector determ() {

D 3
    float[] Det = new float[2];
E 3
I 3
    double[] Det = new double[2];
E 3
    
    Det[0] = 1;
    Det[1] = 0;
    
    for(int i=0;i<cols;i++) {
      Det[0] *= Math.pow(this.Mat[M][i],2);
      
      if(Det[0] == 0) {
D 3
	FVector V = new FVector(Det);
E 3
I 3
D 4
	FVector V = new DVector(Det);
E 4
I 4
	DVector V = new DVector(Det);
E 4
E 3
	return V;
      }
      else 
D 4
	FUtil.detNorm(Det);
E 4
I 4
	DUtil.detNorm(Det);
E 4
    }
D 3
    FVector V2 = new FVector(Det);
E 3
I 3
    DVector V2 = new DVector(Det);
E 3
    return V2;
  }
}
  
  
	
E 1
