h08594
s 00038/00000/00316
d D 1.4 98/08/12 17:09:22 jpiper 5 4
c Needed for testing
e
s 00017/00001/00299
d D 1.3 98/07/28 14:56:33 jpiper 4 3
c fixed solveUZ
e
s 00040/00040/00260
d D 1.2 98/07/27 13:08:30 jpiper 3 1
c created double version
e
s 00000/00000/00000
d R 1.2 98/07/27 12:02:07 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/DMatrix/DPoFull.java
e
s 00300/00000/00000
d D 1.1 98/07/27 12:02:06 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
/*  
D 3
 ##  class FPoFull
E 3
I 3
 ##  class DPoFull
E 3
 ##  
 ##  This class holds the routines for positive definite matrices in full
 ##  form.  It also holds the Cholesky routines for decomposing.  
 ##
 */

D 3
package edu.rice.linpack.Matrix.FMatrix;
E 3
I 3
package edu.rice.linpack.Matrix.DMatrix;
E 3
import edu.rice.linpack.util.*;
import edu.rice.linpack.Vector.*;
import edu.rice.linpack.LNumber.*;

D 3
public class FPoFull extends FFull {
E 3
I 3
public class DPoFull extends DFull {
E 3

D 3
  public FPoFull() {
E 3
I 3
  public DPoFull() {
E 3
    super();
  }
D 3
  public FPoFull(int n, int q) {
E 3
I 3
  public DPoFull(int n, int q) {
E 3
    super(n, q);
  }
D 3
  public FPoFull(float[][] f) {
E 3
I 3
  public DPoFull(double[][] f) {
E 3
    super(f);
  }
D 3
  public FPoFull(FPoFull F) {
E 3
I 3
  public DPoFull(DPoFull F) {
E 3
    super(F);
  }

D 3
  public FPoPack pack() {
    FPoPack P = new FPoPack(this.Mat);
E 3
I 3
  public DPoPack pack() {
    DPoPack P = new DPoPack(this.Mat);
E 3
    return P;
  }
  
  public void setPivots(int[] p) {
    int q = Math.min(p.length,cols);
    for(int i=0;i<q;i++) 
      pivot[i] = p[i];
  }
  public void setPivotElem(int i, int piv) {
    pivot[i] = piv;
  }

I 5
  public void transpose() {
  }

  public double getElem(int i, int j) {
    if(i > j)
      return super.getElem(j,i);
    return super.getElem(i,j);
  }
  public double[] getRow(int i) {
    return getRow(i,0);
  }
  public double[] getColumn(int i) {
    return getRow(i,0);
  }
  public double[] getColumn(int i, int j) {
    return getRow(i,j);
  }
  public double[] getRow(int i, int j) {
    double[] F = new double[rows - j];
    for(int k=0;k<i && k<(rows-j);k++) 
      F[k] = Mat[j+k][i];
    for(int k=i;k<(rows-j);k++) 
      F[k] = Mat[j+k][i];
    return F;
  }
  public void setColumn(int c, double[] F) {
    for(int r=0;r<c;r++) 
      Mat[r][c] = F[r];
    for(int r=c;r<rows;r++) 
      Mat[r][c] = F[r];
  }
  public void setElem(int i, int c, double L) {
    if(i > c)
      super.setElem(c,i,L);
    else
      super.setElem(i,c,L);
  }

E 5
D 3
  protected float oneNorm() {
    float[] Z = new float[cols];
E 3
I 3
  protected double oneNorm() {
    double[] Z = new double[cols];
E 3
    
    for(int j=0;j<cols;j++) {
      Z[j] = this.asum(j+1,1,0,j);
      for(int i=0;i<j;i++) {
	Z[i] += Math.abs(this.Mat[i][j]);
      }
    }
D 3
    float anorm = 0;
E 3
I 3
    double anorm = 0;
E 3
    for(int j=0;j<cols;j++) 
      anorm = Math.max(anorm,Z[j]);
    return anorm;
  }

  /*  Downdate, decompose, update, and exchange are untested 
D 3
      Also, need to test both FUtil.rotg and this.rotg
E 3
I 3
      Also, need to test both DUtil.rotg and this.rotg
E 3

      */

  public void chPDecompose() 
       throws SingularMatrixException
  {
    Pul P = new Pul(0,-1);
    this.chPivot(P);
    this.decom(P);
  }
  public void chDecompose()
       throws SingularMatrixException
  {
    Pul P = new Pul(0,-1);
    this.decom(P);
  }
  private void decom (Pul P) 
       throws SingularMatrixException
  {
D 3
    float[] W = new float[cols];
E 3
I 3
    double[] W = new double[cols];
E 3

    System.out.println("CHOLESKY DECOMPOSE");

    for(int k=0;k<cols;k++) {
      // Reduction loop //
      
D 3
      float maxdia = this.Mat[k][k];
E 3
I 3
      double maxdia = this.Mat[k][k];
E 3
      int kp = k+1;
      int maxln = k;

      if((k >= P.pl) && (k < P.pu)) {
	for(int q=kp;q<=P.pu;q++) {
	  if(this.Mat[q][q] > maxdia) {
	    maxdia = this.Mat[q][q];
	    maxln = q;
	  }
	}
      }
      if(maxdia < 0) 
	throw new SingularMatrixException(k+1);
      
      else {
	if(k != maxln) {
	  this.swap(k,1,0,k,this,1,0,maxln);
	  this.Mat[maxln][maxln] = this.Mat[k][k];
	  this.Mat[k][k] = maxdia;
D 3
	  FUtil.swapElems(pivot, k, maxln);
E 3
I 3
	  DUtil.swapElems(pivot, k, maxln);
E 3
	}
D 3
	W[k] = (float)Math.sqrt(this.Mat[k][k]);
E 3
I 3
	W[k] = Math.sqrt(this.Mat[k][k]);
E 3
	this.Mat[k][k] = W[k];
	for(int j=kp;j<cols;j++) {
	  if(k != maxln) 
	    this.chSwaps(k,j,maxln);
	  this.Mat[k][j] = this.Mat[k][j]/W[k];
	  W[j] = this.Mat[k][j];
	  this.axpy(j-k,-W[j],W,1,kp,1,kp,j);
	}
      }
    }
  }
  private void chPivot(Pul P) {
    
    this.swaperSki(P);

    // change pivots //
    
    P.pu = cols-1;
    for(int k=P.pu;k>=P.pl;k--) {
      if(pivot[k] < 0) {
	pivot[k] = -pivot[k];
	if(P.pu != k) {
	  this.swap(k,1,0,k,this,1,0,P.pu);
	  this.swapElem(k,k,P.pu,P.pu);
	  for(int j=k+1;j<cols;j++) 
	    this.chSwaps(k,j,P.pu);
D 3
	  FUtil.swapElems(pivot,k,P.pu);
E 3
I 3
	  DUtil.swapElems(pivot,k,P.pu);
E 3
	}
	P.pu--;
      }
    }
  }
  void swap2(int j, Pul P) {
    if(j != P.pl) {
      this.swap(P.pl,1,0,j,this,1,0,P.pl);
      this.swapElem(j,j,P.pl,P.pl);
      for(int q=P.pl+1;q<cols;q++) 
	this.chSwaps(P.pl,q,j);
      pivot[j] = pivot[P.pl];
      pivot[P.pl] = j+1;
    }
    P.pl++;
  }
  private void chSwaps(int k, int j, int q) {
    if(j < q) 
      this.swapElem(k,j,j,q);
    else if(j > q) 
      this.swapElem(k,j,q,j);
  }



  public void factor() 
       throws SingularMatrixException
  {
    for(int j=0;j<cols;j++) {
D 3
      float S = 0;
E 3
I 3
      double S = 0;
E 3
      for(int k=0;k<j;k++) {
D 3
	float T = this.Mat[k][j] - this.dot(k,1,0,k,this,1,0,j);
E 3
I 3
	double T = this.Mat[k][j] - this.dot(k,1,0,k,this,1,0,j);
E 3
	T = T/this.Mat[k][k];
	this.Mat[k][j] = T;
	S += T*T;
      }
      S = this.Mat[j][j] - S;
      if(S <= 0) 
	throw new SingularMatrixException(j+1);
      else 
D 3
	this.Mat[j][j] = (float)Math.sqrt(S);
E 3
I 3
	this.Mat[j][j] = Math.sqrt(S);
E 3
    }
  }  
  
  public LNumber condition() 
       throws SingularMatrixException, WrongDataTypeException
  {
D 3
    Vector Z = new FVector(cols);
E 3
I 3
    Vector Z = new DVector(cols);
E 3
    return this.condition(Z);
  }
  public LNumber condition(Vector Ze) 
       throws SingularMatrixException, WrongDataTypeException
  {
D 3
    float[] Z = Ze.getFloatArray();
E 3
I 3
    double[] Z = Ze.getDoubleArray();
E 3

D 3
    float anorm = this.oneNorm();
E 3
I 3
    double anorm = this.oneNorm();
E 3

    //  Factor //
    
    this.factor();
    
    /*  RCond = 1/(norm(A)*(estimate of norm(inverse(A)))) .
	Estimate = norm(Z)/norm(Y) where  A*Z = Y  and  A*Y = E .
	The components of  E  are chosen to cause maximum local 
	growth in the elements of W  where  trans(R)*W = E .
	The vectors are frequently rescaled to avoid overflow.
	*/
    //  Solve trans(R)*W = E  //
    
    for(int j=0;j<cols;j++) 
      Z[j] = 0;
      
    this.solveTransUW(Z);
    
D 3
    float S = 1/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
E 3
I 3
    double S = 1/DUtil.asum(cols,Z,1);
    DUtil.scal(cols,S,Z,1);
E 3

    //  Solve R*Y = W  //
    
D 4
    this.solveUZ(Z,0);
E 4
I 4
    this.solveUZ(Z);
E 4
    
    //  Solve trans(R)*V = Y  //
    
D 3
    float ynorm = this.solveTransRV(Z);
E 3
I 3
    double ynorm = this.solveTransRV(Z);
E 3
    
    //  Solve R*Z = V  //
    
    ynorm = this.solveUZ(Z,ynorm);
    
D 3
    LFloat R = new LFloat();
E 3
I 3
    LDouble R = new LDouble();
E 3

    if(anorm != 0) 
D 3
      R.setFloat(ynorm/anorm);
E 3
I 3
      R.setDouble(ynorm/anorm);
E 3
  
    return R;
I 4
  }
  void solveUZ(double[] Z) {
    for(int k=cols-1;k>=0;k--) {
      if(Math.abs(Z[k]) > Math.abs(this.Mat[k][k])) {
	double S = Math.abs(this.Mat[k][k])/Math.abs(Z[k]);
	DUtil.scal(cols,S,Z,1);
      } 
      if(this.Mat[k][k] != 0) 
	Z[k] = Z[k]/this.Mat[k][k];
      else 
	Z[k] = 1;

      this.axpy(k,-Z[k],1,0,k,Z,1,0);
    }
    double S = 1.0/DUtil.asum(cols,Z,1);
    DUtil.scal(cols,S,Z,1);
E 4
  }
D 3
  private float solveTransRV (float[] Z) {
    float ynorm = 1;
E 3
I 3
  private double solveTransRV (double[] Z) {
    double ynorm = 1;
E 3
    for(int k=0;k<cols;k++) {
      Z[k] = Z[k] - this.dot(k,1,0,k,Z,1,0);
      if(Math.abs(Z[k]) > this.Mat[k][k]) {
D 3
	float S = this.Mat[k][k]/Math.abs(Z[k]);
	FUtil.scal(cols,S,Z,1);
E 3
I 3
	double S = this.Mat[k][k]/Math.abs(Z[k]);
	DUtil.scal(cols,S,Z,1);
E 3
	ynorm *= S;
      }
      Z[k] = Z[k]/this.Mat[k][k];
    }
D 3
    float S = 1/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
E 3
I 3
    double S = 1/DUtil.asum(cols,Z,1);
    DUtil.scal(cols,S,Z,1);
E 3
    ynorm *= S;
  
    return ynorm;
  }

  public void solve(Vector B, int Job) 
       throws WrongDataTypeException
  {
    this.solve(B);
  }
  public void solve(Vector Be) 
       throws WrongDataTypeException
  {
    
D 3
    float[] B = Be.getFloatArray();
E 3
I 3
    double[] B = Be.getDoubleArray();
E 3

    // Solve Trans(R)*Y = B //

    this.solveTransAX(B);

    // Solve R*X = Y  //

    this.solveUX(B);

    return;
  }
  
  public Vector determ() {
D 3
    float[] Det = new float[2];
E 3
I 3
    double[] Det = new double[2];
E 3
    
    Det[0] = 1;
    Det[1] = 0;
    for(int i=0;i<cols && Det[0] != 0;i++) {
D 3
      Det[0] *= (float)Math.pow(this.Mat[i][i],2);
E 3
I 3
      Det[0] *= Math.pow(this.Mat[i][i],2);
E 3
      if(Det[0] != 0) 
D 3
	FUtil.detNorm(Det);
E 3
I 3
	DUtil.detNorm(Det);
E 3
    }
D 3
    FVector V = new FVector(Det);
E 3
I 3
    DVector V = new DVector(Det);
E 3
    return V;
  }
  
  public void inverse() {
    
    //  Compute inverse(R)  //

    this.invertU();

    //  Form inv(R)*trans(inv(R))  //
    
    for(int j=0;j<cols;j++) {
      for(int k=0;k<j;k++) 
	this.axpy(k+1,this.Mat[k][j],1,0,j,this,1,0,k);
      this.scal(j+1,this.Mat[j][j],1,0,j);
    }
  }
}
E 1
