h60656
s 00002/00002/00343
d D 1.5 98/08/06 16:22:42 jpiper 7 6
c needed for Debugging
e
s 00001/00001/00344
d D 1.4 98/07/29 11:53:25 jpiper 6 5
i 4
c Merged changes between child workspace "/home/jpiper/MyJavaLinpack" and
c  parent workspace "/net/una7/JavaLinpack".
c 
e
s 00002/00002/00328
d D 1.3 98/07/28 14:57:25 zoran 5 3
c fixed the argument name error in the constructor
e
s 00017/00002/00328
d D 1.2.1.1 98/07/28 14:56:22 jpiper 4 3
c fixed solveUZ and F.Mat undefined error
e
s 00064/00064/00266
d D 1.2 98/07/27 13:08:38 jpiper 3 1
c created double version
e
s 00000/00000/00000
d R 1.2 98/07/27 12:02:02 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/DMatrix/DPoPack.java
e
s 00330/00000/00000
d D 1.1 98/07/27 12:02:01 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
/*  
D 3
 ##  class FPoPack
E 3
I 3
 ##  class DPoPack
E 3
 ##
 ##  This class contains the routines for positive definite matrices
 ##  in packed form.
 ##
 */

D 3
package edu.rice.linpack.Matrix.FMatrix;
E 3
I 3
package edu.rice.linpack.Matrix.DMatrix;
E 3
import edu.rice.linpack.util.*;
import edu.rice.linpack.Vector.*;
import edu.rice.linpack.LNumber.*;

D 3
public class FPoPack extends FPacked {
E 3
I 3
public class DPoPack extends DPacked {
E 3

D 3
  public FPoPack() {
E 3
I 3
  public DPoPack() {
E 3
    super();
    order = 0;
  }  
D 3
  public FPoPack(int o) {
E 3
I 3
  public DPoPack(int o) {
E 3
    order = o;
D 3
    float r = (float).5*(o*(o+1));
E 3
I 3
    double r = .5*(o*(o+1));
E 3
    rows = (int) r;
    cols = 1;
D 3
    Mat = new float[rows][1];
E 3
I 3
    Mat = new double[rows][1];
E 3
  }
D 3
  public FPoPack(float[] f, int o) {
E 3
I 3
  public DPoPack(double[] f, int o) {
E 3
    rows = f.length;
    cols = 1;
D 3
    Mat = new float[rows][cols];
E 3
I 3
    Mat = new double[rows][cols];
E 3
    for(int i=0;i<rows;i++) 
      Mat[i][0] = f[i];
    order = o;
  }
D 3
  public FPoPack(float[][] f, int o) {
E 3
I 3
  public DPoPack(double[][] f, int o) {
E 3
    rows = f.length;
    cols = 1;
    order = o;
D 3
    Mat = new float[rows][1];
E 3
I 3
    Mat = new double[rows][1];
E 3
    for(int i=0;i<rows;i++) 
      Mat[i][0] = f[i][0];
  }
D 3
  public FPoPack(float[][] f) {
E 3
I 3
  public DPoPack(double[][] f) {
E 3
    cols = 1;
    order = f.length;
D 3
    float r = (float).5*(order*(order + 1));
E 3
I 3
    double r = .5*(order*(order + 1));
E 3
    rows = (int) r;
D 3
    Mat = new float[rows][1];
E 3
I 3
    Mat = new double[rows][1];
E 3
    Mat = pack(f);
  }
D 3
  public FPoPack(FPoPack F) {
E 3
I 3
  public DPoPack(DPoPack F) {
E 3
    rows = F.rows;
    cols = 1;
D 3
    Mat = new float[rows][1];
E 3
I 3
    Mat = new double[rows][1];
E 3
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) 
	Mat[i][j] = F.Mat[i][j];
    order = F.order;
  }
D 3
  public FPoPack(FPoFull F) {
E 3
I 3
D 5
  public DPoPack(DPoFull D) {
E 5
I 5
  public DPoPack(DPoFull F) {
E 5
E 3
    cols = 1;
D 3
    order = F.numofRows();
    float r = (float).5*(order*(order + 1));
E 3
I 3
D 5
    order = D.numofRows();
E 5
I 5
    order = F.numofRows();
E 5
    double r = .5*(order*(order + 1));
E 3
    rows = (int)r;
D 3
    Mat = new float[rows][1];
E 3
I 3
    Mat = new double[rows][1];
E 3
D 4
    Mat = pack(F.Mat);
E 4
I 4
D 6
    Mat = pack(D.Mat);
E 6
I 6
    Mat = pack(F.Mat);
E 6
E 4
  }

D 3
  public FPoFull unpack() {
E 3
I 3
  public DPoFull unpack() {
E 3
    int k = 0;
    int n = this.order;
D 3
    FPoFull R = new FPoFull(n,n);
E 3
I 3
    DPoFull R = new DPoFull(n,n);
E 3
    for(int j=0;j<n;j++) {
      for(int i=0;i<=j;i++) {
	R.Mat[i][j] = this.Mat[k][0];
	if(j != i)
	  R.Mat[j][i] = this.Mat[k][0];
	k++;
      }
    }	
    return R;
  }

  /* All have been completely tested
     
   */

  public void factor() 
       throws SingularMatrixException
  {
    int jj = -1;
D 3
    float S;
E 3
I 3
    double S;
E 3

    for(int j=0;j<order;j++) {
      S = 0;
      if(j > 0) {
D 3
	int kj = (int)((float).5*(j*(j+1)));
E 3
I 3
	int kj = (int)(.5*(j*(j+1)));
E 3
	int kk = -1;
	for(int k=0;k<j;k++) {
D 3
	  float T = this.Mat[kj][0] - this.dot(k,1,kk+1,0,this,1,jj+1,0);
E 3
I 3
	  double T = this.Mat[kj][0] - this.dot(k,1,kk+1,0,this,1,jj+1,0);
E 3
	  kk += k+1;
	  T = T/this.Mat[kk][0];
	  this.Mat[kj][0] = T;
	  S += T*T;
	  kj++;
	}
      }
      jj += j+1;
      S = this.Mat[jj][0] - S;
      if(S <= 0) 
	throw new SingularMatrixException(j+1);
      else 
D 3
	this.Mat[jj][0] = (float)Math.sqrt(S);
E 3
I 3
	this.Mat[jj][0] = Math.sqrt(S);
E 3
    }
  } 

  public LNumber condition() 
       throws SingularMatrixException, WrongDataTypeException
  {
D 3
    Vector Z = new FVector(order);
E 3
I 3
    Vector Z = new DVector(order);
E 3
    return this.condition(Z);
  }
  public LNumber condition(Vector Ze) 
       throws SingularMatrixException, WrongDataTypeException
  {
D 3
    float[] Z = Ze.getFloatArray();
E 3
I 3
    double[] Z = Ze.getDoubleArray();
E 3

D 3
    float anorm = this.oneNorm();
E 3
I 3
    double anorm = this.oneNorm();
E 3

    //  Factor  //

    this.factor();

    for(int j=0;j<order;j++) 
      Z[j] = 0;
    
    this.solveTransUW(Z);
      
D 3
    float S = 1/FUtil.asum(order,Z,1);
    FUtil.scal(order,S,Z,1);
E 3
I 3
    double S = 1/DUtil.asum(order,Z,1);
    DUtil.scal(order,S,Z,1);
E 3
     
D 4
    this.solveUZ(Z,0);
E 4
I 4
    this.solveUZ(Z);
E 4

D 3
    float ynorm = this.solveTransRV(Z);
E 3
I 3
    double ynorm = this.solveTransRV(Z);
E 3
    
    ynorm = this.solveUZ(Z,ynorm);
D 7
      
E 7
I 7
     
E 7
D 3
    LFloat R = new LFloat();
E 3
I 3
    LDouble R = new LDouble();
E 3

    if(anorm != 0)
D 3
      R.setFloat(ynorm/anorm);
E 3
I 3
      R.setDouble(ynorm/anorm);
E 3

    return R;
  }
D 3
  private void solveTransUW(float[] Z) {
    float ek = 1;
E 3
I 3
  private void solveTransUW(double[] Z) {
    double ek = 1;
E 3
    int kk = -1;
    for(int k=0;k<order;k++) {
      int kp = k+1;
      kk += kp;
      if(Z[k] != 0) 
D 3
	ek = FUtil.signOf(ek,-Z[k]);
E 3
I 3
	ek = DUtil.signOf(ek,-Z[k]);
E 3
      if(Math.abs(ek-Z[k]) > this.Mat[kk][0]) {
D 3
	float S = this.Mat[kk][0]/Math.abs(ek-Z[k]);
	FUtil.scal(order,S,Z,1);
E 3
I 3
	double S = this.Mat[kk][0]/Math.abs(ek-Z[k]);
	DUtil.scal(order,S,Z,1);
E 3
	ek *= S;
      }
D 3
      float wk = ek - Z[k];
      float wkm = -ek - Z[k];
      float S = Math.abs(wk);
      float SM = Math.abs(wkm);
E 3
I 3
      double wk = ek - Z[k];
      double wkm = -ek - Z[k];
      double S = Math.abs(wk);
      double SM = Math.abs(wkm);
E 3
      wk = wk/this.Mat[kk][0];
      wkm = wkm/this.Mat[kk][0];
      int kj = kk + kp;
      if(kp < order) {
	for(int j=kp;j<order;j++) {
	  SM += Math.abs(Z[j] + wkm*this.Mat[kj][0]);
	  Z[j] += wk*this.Mat[kj][0];
	  S += Math.abs(Z[j]);
	  kj += j+1;
	}
	if(S < SM) {
D 3
	  float T = wkm - wk;
E 3
I 3
	  double T = wkm - wk;
E 3
	  wk = wkm;
	  kj = kk + kp;
	  for(int j=kp;j<order;j++) {
	    Z[j] += T*this.Mat[kj][0];
	    kj += j+1;
	  }
	}
      }
      Z[k] = wk;
    }
  }
D 3
  private float solveUZ(float[] Z, float ynorm) {
E 3
I 3
  private double solveUZ(double[] Z, double ynorm) {
E 3
    
    int kk = order*(order+1)/2 - 1;
    for(int k=order-1;k>=0;k--) {
      if(Math.abs(Z[k]) > this.Mat[kk][0]) {
D 3
	float S = this.Mat[kk][0]/Math.abs(Z[k]);
	FUtil.scal(order,S,Z,1);
E 3
I 3
	double S = this.Mat[kk][0]/Math.abs(Z[k]);
	DUtil.scal(order,S,Z,1);
E 3
	ynorm *= S;
      }
      Z[k] = Z[k]/this.Mat[kk][0];
      kk = kk - k - 1;
      this.axpy(k,-Z[k],1,kk+1,0,Z,1,0);
    }
D 3
    float S = 1/FUtil.asum(order,Z,1);
    FUtil.scal(order,S,Z,1);
E 3
I 3
    double S = 1/DUtil.asum(order,Z,1);
    DUtil.scal(order,S,Z,1);
E 3
    ynorm *= S;

    return ynorm;
I 4
  }
  private void solveUZ(double[] Z) {
    
    int kk = order*(order+1)/2 - 1;
    for(int k=order-1;k>=0;k--) {
      if(Math.abs(Z[k]) > this.Mat[kk][0]) {
	double S = this.Mat[kk][0]/Math.abs(Z[k]);
	DUtil.scal(order,S,Z,1);
      }
      Z[k] = Z[k]/this.Mat[kk][0];
      kk = kk - k - 1;
      this.axpy(k,-Z[k],1,kk+1,0,Z,1,0);
    }
    double S = 1/DUtil.asum(order,Z,1);
    DUtil.scal(order,S,Z,1);
E 4
  }
D 3
  private float solveTransRV(float[] Z) {
E 3
I 3
  private double solveTransRV(double[] Z) {
E 3
    
    int kk = -1;
D 3
    float ynorm = 1;
E 3
I 3
    double ynorm = 1;
E 3
    for(int k=0;k<order;k++) {
      Z[k] -= this.dot(k,1,kk+1,0,Z,1,0);
      kk += k+1;
      if(Math.abs(Z[k]) > this.Mat[kk][0]) {
D 3
	float S = this.Mat[kk][0]/Math.abs(Z[k]);
	FUtil.scal(order,S,Z,1);
E 3
I 3
	double S = this.Mat[kk][0]/Math.abs(Z[k]);
	DUtil.scal(order,S,Z,1);
E 3
	ynorm *= S;
      }
      Z[k] = Z[k]/this.Mat[kk][0];
    }
D 3
    float S = 1/FUtil.asum(order,Z,1);
    FUtil.scal(order,S,Z,1);
E 3
I 3
    double S = 1/DUtil.asum(order,Z,1);
    DUtil.scal(order,S,Z,1);
E 3
    ynorm *= S;
  
    return ynorm;
  }
  
  
  public void solve(Vector B, int J) 
       throws WrongDataTypeException
  {
    this.solve(B);
  }
  public void solve(Vector Be) 
       throws WrongDataTypeException
  {
    
D 3
    float[] B = Be.getFloatArray();
E 3
I 3
    double[] B = Be.getDoubleArray();
E 3

    int kk = -1;
    for(int k = 0;k<order;k++) {
D 3
      float T = this.dot(k,1,kk+1,0,B,1,0);
E 3
I 3
      double T = this.dot(k,1,kk+1,0,B,1,0);
E 3
      kk += k+1;
      B[k] = (B[k] - T)/this.Mat[kk][0];
    }
    for(int kb=0;kb<order;kb++) {
      int k = order - kb - 1;
      B[k] = B[k]/this.Mat[kk][0];
      kk -= k+1;
      this.axpy(k,-B[k],1,kk+1,0,B,1,0);
    }
  }
  
  public Vector determ() {
    
D 3
    float[] Det = new float[2];
E 3
I 3
    double[] Det = new double[2];
E 3
    
    Det[0] = 1;
    Det[1] = 0;
    
    int ii = 0;
    for(int k=0;k<order;k++) {
      Det[0] *= Math.pow(this.Mat[ii][0],2); 
      
      if(Det[0] == 0) {
D 3
	FVector V = new FVector(Det);
E 3
I 3
	DVector V = new DVector(Det);
E 3
	return V;
      }
      else 
D 3
	FUtil.detNorm(Det);
E 3
I 3
	DUtil.detNorm(Det);
E 3
      ii += k+2;
    }
D 3
    FVector V2 = new FVector(Det);
E 3
I 3
    DVector V2 = new DVector(Det);
E 3
    return V2;
  }

  public void inverse() {
    int kk = 0;
    int k1 = 0;
    for(int k=0;k<order;k++) {
      this.Mat[kk][0] = 1/this.Mat[kk][0];
D 3
      float T = -this.Mat[kk][0];
E 3
I 3
      double T = -this.Mat[kk][0];
E 3
      this.scal(k,T,1,k1,0);
      int kp = k+1;
      int j1 = kk+1;
      int kj = kk+k+1;
      if(order > kp) {
	for(int j=kp;j<order;j++) {
	  T = this.Mat[kj][0];
D 7
	  this.Mat[kj][0] = 0;
E 7
I 7
	  Mat[kj][0] = 0;
E 7
	  this.axpy(k+1,T,1,k1,0,this,1,j1,0);
	  j1 += j+1;
	  kj += j+1;
	}
      }
      k1 = kk+1;
      kk += k+2;
    }
    int jj = 0;
    int j1 = 0;
    for(int j=0;j<order;j++) {
      int jm = j-1;
      k1 = 0;
      int kj = j1;
      if(j > 0) {
	for(int k=0;k<j;k++) {
D 3
	  float T = this.Mat[kj][0];
E 3
I 3
	  double T = this.Mat[kj][0];
E 3
	  this.axpy(k+1,T,1,j1,0,this,1,k1,0);
	  k1 += k+1;
	  kj++;
	}
      }
D 3
      float T = this.Mat[jj][0];
E 3
I 3
      double T = this.Mat[jj][0];
E 3
      this.scal(j+1,T,1,j1,0);
      j1 = jj + 1;
      jj += j+2;
    }
  }
}




E 1
