h41153
s 00013/00013/00088
d D 1.2 98/07/27 13:09:12 jpiper 3 1
c double version
e
s 00000/00000/00000
d R 1.2 98/07/27 12:01:48 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/DMatrix/DTDiag.java
e
s 00101/00000/00000
d D 1.1 98/07/27 12:01:47 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
/*
D 3
 ##  class FTDiag
E 3
I 3
 ##  class DTDiag
E 3
 ##
 ##  This class holds the routines for a tridiagonal matrix.  The storage
 ##  is the same as banded matrices.
 ##
 */

D 3
package edu.rice.linpack.Matrix.FMatrix;
E 3
I 3
package edu.rice.linpack.Matrix.DMatrix;
E 3
import edu.rice.linpack.util.*;
import edu.rice.linpack.Vector.*;

D 3
public class FTDiag extends FMatrix {
E 3
I 3
public class DTDiag extends DMatrix {
E 3

D 3
  public FTDiag() {
E 3
I 3
  public DTDiag() {
E 3
    super();
  }
D 3
  public FTDiag(int i, int j) {
E 3
I 3
  public DTDiag(int i, int j) {
E 3
    cons(3,j);
  }
D 3
  public FTDiag(float[][] f) {
E 3
I 3
  public DTDiag(double[][] f) {
E 3
    cols = f.length;
    rows = 3;
    int cm = cols - 1;
D 3
    Mat = new float[3][cols];
E 3
I 3
    Mat = new double[3][cols];
E 3
    Mat[1][0] = f[0][0];
    Mat[0][0] = f[0][1]; 
    for(int i=1;i<cm;i++) {
      Mat[2][i] = f[i][i-1];
      Mat[1][i] = f[i][i];
      Mat[0][i] = f[i][i+1];
    }
    Mat[1][cm] = f[cm][cm];
    Mat[2][cm] = f[cm][cm-1];
  }
D 3
  public FTDiag(float[] a, float[] b, float[] c) {
E 3
I 3
  public DTDiag(double[] a, double[] b, double[] c) {
E 3
    cols = a.length;
    rows = 3;
D 3
    Mat = new float[3][cols];
E 3
I 3
    Mat = new double[3][cols];
E 3
    Mat[1][0] = b[0];
    Mat[0][0] = c[0];
    for(int i=1;i<cols-1;i++) {
      Mat[2][i] = a[i];
      Mat[1][i] = b[i];
      Mat[0][i] = c[i];
    }
    Mat[2][cols-1] = a[cols-1];
    Mat[1][cols-1] = b[cols-1];
  }
D 3
  public FTDiag(FTDiag F) {
E 3
I 3
  public DTDiag(DTDiag F) {
E 3
    cons(F);
  }

  public void solve(Vector Be) 
       throws WrongDataTypeException, SingularMatrixException
  {
D 3
    float[] B = Be.getFloatArray();
E 3
I 3
    double[] B = Be.getDoubleArray();
E 3

    this.Mat[2][0] = this.Mat[1][0];

    int nm = cols-1;
    if(cols > 0) {
      this.Mat[1][0] = this.Mat[0][0];
      this.Mat[0][0] = 0;
      this.Mat[0][nm] = 0;  

      for(int k=0;k<nm;k++) {
	int kp = k+1;

	if(Math.abs(this.Mat[2][kp]) >= Math.abs(this.Mat[2][k])) {
	  this.swap(3,1,0,kp,this,1,0,k);
D 3
	  FUtil.swapElems(B,kp,k);
E 3
I 3
	  DUtil.swapElems(B,kp,k);
E 3
	}
	if(this.Mat[2][k] == 0) 
	  throw new SingularMatrixException(k+1);
	else {
D 3
	  float T = -this.Mat[2][kp]/this.Mat[2][k];
E 3
I 3
	  double T = -this.Mat[2][kp]/this.Mat[2][k];
E 3
	  this.Mat[2][kp] = this.Mat[1][kp] + T*this.Mat[1][k];
	  this.Mat[1][kp] = this.Mat[0][kp] + T*this.Mat[0][k];
	  this.Mat[0][kp] = 0;
	  B[kp] += T*B[k];
	}
      }
    }
    if(this.Mat[2][nm] == 0) 
      throw new SingularMatrixException(cols);
    else {
      int nm2 = nm - 1;
      B[nm] = B[nm]/this.Mat[2][nm];
      if(cols > 0) {
	B[nm2] = (B[nm2] - this.Mat[1][nm2]*B[nm])/this.Mat[2][nm2];
	if(nm2 > 0) {
	  for(int k=nm2-1;k>=0;k--) {
	    B[k] = (B[k] - this.Mat[1][k]*B[k+1] - 
		    this.Mat[0][k]*B[k+2])/this.Mat[2][k];
	  }
	}
      }
    }
  }
}
E 1
