h06680
s 00002/00003/00171
d D 1.4 98/08/11 15:13:00 jpiper 5 4
c needed for debugging
e
s 00001/00005/00173
d D 1.3 98/07/28 09:59:33 jpiper 4 3
c Fixed Constructor
e
s 00035/00035/00143
d D 1.2 98/07/27 13:09:31 jpiper 3 1
c double version
e
s 00000/00000/00000
d R 1.2 98/07/27 12:02:29 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/DMatrix/DTriLow.java
e
s 00178/00000/00000
d D 1.1 98/07/27 12:02:28 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
D 3
package edu.rice.linpack.Matrix.FMatrix;
E 3
I 3
package edu.rice.linpack.Matrix.DMatrix;
E 3
import edu.rice.linpack.util.*;
import edu.rice.linpack.Vector.*;
import edu.rice.linpack.LNumber.*;

D 3
public class FTriLow extends FTriFull {
E 3
I 3
public class DTriLow extends DTriFull {
E 3

D 3
  public FTriLow() {
E 3
I 3
  public DTriLow() {
E 3
    super();
  }
D 3
  public FTriLow(int i, int j) {
    Mat = new float[i][j];
E 3
I 3
  public DTriLow(int i, int j) {
    Mat = new double[i][j];
E 3
    rows = i;
    cols = j;
  }
D 3
  public FTriLow(float[][] F) {
E 3
I 3
  public DTriLow(double[][] F) {
E 3
    rows = F.length;
    cols = (F[0]).length;
D 3
    Mat = new float[rows][cols];
E 3
I 3
D 4
    Mat = new double[rows][cols];
E 3
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) {
	Mat[i][j] = F[i][j];
      }
E 4
I 4
    Mat = F;
E 4
  }
D 3
  public FTriLow(FTriLow M) {
E 3
I 3
  public DTriLow(DTriLow M) {
E 3
    rows = M.rows;
    cols = M.cols;
D 3
    Mat = new float[rows][cols];
E 3
I 3
    Mat = new double[rows][cols];
E 3
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) 
	Mat[i][j] = M.Mat[i][j];
  }

D 3
  protected float oneNorm() {
    float tnorm = 0;
E 3
I 3
  protected double oneNorm() {
    double tnorm = 0;
E 3
    for(int j=0;j<cols;j++) {
      int q = cols-j;
      tnorm = Math.max(tnorm,this.asum(q,1,j,j));
    }
    return tnorm;
  }

  public LNumber condition(Vector Ze) 
       throws SingularMatrixException, WrongDataTypeException
  {
 
D 3
    float[] Z = Ze.getFloatArray();
E 3
I 3
    double[] Z = Ze.getDoubleArray();
E 3

D 3
    float S;
    float tnorm = this.oneNorm();
    float ynorm;
E 3
I 3
    double S;
    double tnorm = this.oneNorm();
    double ynorm;
E 3

    try {
      this.zeroDiag();
    } finally {
      
D 3
      float ek = 1;
E 3
I 3
      double ek = 1;
E 3
      for(int j=0;j<cols;j++) 
	Z[j] = 0;
      
      for(int k=cols-1;k>=0;k--) {
	if(Z[k] != 0) 
D 3
	  ek = FUtil.signOf(ek,-Z[k]); 
E 3
I 3
	  ek = DUtil.signOf(ek,-Z[k]); 
E 3
D 5
	
E 5
	if(Math.abs(ek-Z[k]) > Math.abs(this.Mat[k][k])) {
	  S = Math.abs(this.Mat[k][k])/Math.abs(ek-Z[k]);
D 3
	  FUtil.scal(cols,S,Z,1);
E 3
I 3
	  DUtil.scal(cols,S,Z,1);
E 3
	  ek *= S;
	}
D 3
	float wk = ek - Z[k];
	float wkm = -ek - Z[k];
E 3
I 3
	double wk = ek - Z[k];
	double wkm = -ek - Z[k];
E 3
	S = Math.abs(wk);
D 3
	float SM = Math.abs(wkm);
E 3
I 3
	double SM = Math.abs(wkm);
E 3
      
	if(this.Mat[k][k] != 0) {
	  wk = wk/this.Mat[k][k];
	  wkm = wkm/this.Mat[k][k];
	}
	else {
	  wk = 1;
	  wkm = 1;
	}
	
	if(k > 0) {
	  for(int j=0;j<k;j++) {
	    SM += Math.abs(Z[j] + wkm*this.Mat[k][j]);
	    Z[j] += wk*this.Mat[k][j];
	    S += Math.abs(Z[j]);
	  }
	  if(S < SM) {
D 3
	    float T = wkm - wk;
E 3
I 3
	    double T = wkm - wk;
E 3
	    wk = wkm;
	    for(int j=0;j<k;j++) 
	      Z[j] += T*this.Mat[k][j];
	  }
D 5
      }
E 5
I 5
	}
E 5
	Z[k] = wk;
      }
D 3
      S = 1/FUtil.asum(cols,Z,1);
      FUtil.scal(cols,S,Z,1);
E 3
I 3
      S = 1/DUtil.asum(cols,Z,1);
      DUtil.scal(cols,S,Z,1);
E 3

      ynorm = this.solveTZ(Z);
    }
D 3
    LFloat R = new LFloat();
E 3
I 3
    LDouble R = new LDouble();
E 3
    if(tnorm != 0) 
D 3
      R.setFloat(ynorm/tnorm);
E 3
I 3
      R.setDouble(ynorm/tnorm);
E 3

    return R;
  }
D 3
  private float solveTZ(float[] Z) {
    float ynorm = 1;
E 3
I 3
  private double solveTZ(double[] Z) {
    double ynorm = 1;
E 3
    
    for(int k=0;k<cols;k++) {
      if(Math.abs(Z[k]) > Math.abs(this.Mat[k][k])) {
D 3
	float S = Math.abs(this.Mat[k][k])/Math.abs(Z[k]);
	FUtil.scal(cols,S,Z,1);
E 3
I 3
	double S = Math.abs(this.Mat[k][k])/Math.abs(Z[k]);
	DUtil.scal(cols,S,Z,1);
E 3
	ynorm *= S;
      }
      if(this.Mat[k][k] != 0) 
	Z[k] = Z[k]/this.Mat[k][k];
      else 
	Z[k] = 1;
D 5
      
E 5
I 5

E 5
      int q = k+1;
      if(q < cols) 
	this.axpy(cols-q,-Z[k],1,q,k,Z,1,q);
    }
D 3
    float S = 1/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
E 3
I 3
    double S = 1/DUtil.asum(cols,Z,1);
    DUtil.scal(cols,S,Z,1);
E 3
    ynorm *= S;

    return ynorm;
  }

  public void solve(Vector Be, int job) 
       throws WrongDataTypeException
  {    
D 3
    float[] B = Be.getFloatArray();
E 3
I 3
    double[] B = Be.getDoubleArray();
E 3

    if(job != 0) {
      int nm = cols-1;
      B[nm] = B[nm]/this.Mat[nm][nm];
      if(cols > 0) {
	for(int jj=1;jj<cols;jj++) {
	  int j = cols - jj - 1;
	  B[j] -= this.dot(jj,1,j+1,j,B,1,j+1);
	  B[j] = B[j]/this.Mat[j][j];
	}
      }
    }
    else {
      B[0] = B[0]/this.Mat[0][0];
      for(int j=1;j<cols;j++) {
D 3
	float T = -B[j-1];
E 3
I 3
	double T = -B[j-1];
E 3
	this.axpy(cols-j, T, 1,j,j-1,B,1,j);
	B[j] = B[j]/this.Mat[j][j];    
      }
    }
  }
  
  public void inverse() {
    for(int k=cols-1;k>=0;k--) {
      if(this.Mat[k][k] == 0) 
	return;
      else {
	this.Mat[k][k] = 1/this.Mat[k][k];
D 3
	float T = -this.Mat[k][k];
E 3
I 3
	double T = -this.Mat[k][k];
E 3
	this.scal(cols-k-1,T,1,k+1,k);
	for(int j=0;j<k;j++) {
	  T = this.Mat[k][j];
	  this.Mat[k][j] = 0;
	  this.axpy(cols-k,T,1,k,k,this,1,k,j);
	}
      }
    }
  }
}
      
E 1
