h27308
s 00001/00005/00125
d D 1.3 98/07/28 09:59:41 jpiper 4 3
c Fixed constructor
e
s 00022/00022/00108
d D 1.2 98/07/27 13:09:38 jpiper 3 1
c double version
e
s 00000/00000/00000
d R 1.2 98/07/27 12:02:29 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/DMatrix/DTriUp.java
e
s 00130/00000/00000
d D 1.1 98/07/27 12:02:28 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
/*
D 3
 ##  class FTriUp
E 3
I 3
 ##  class DTriUp
E 3
 ##  
 ##  This class holds the routines for a upper triangular matrix stored
 ##  in full form.  There is no factor routine; triangular matrices are
 ##  already in factored form.
 ##
 */

D 3
package edu.rice.linpack.Matrix.FMatrix;
E 3
I 3
package edu.rice.linpack.Matrix.DMatrix;
E 3
import edu.rice.linpack.util.*;
import edu.rice.linpack.Vector.*;
import edu.rice.linpack.LNumber.*;

D 3
public class FTriUp extends FTriFull {
E 3
I 3
public class DTriUp extends DTriFull {
E 3

D 3
  public FTriUp() {
E 3
I 3
  public DTriUp() {
E 3
    super();
  }
D 3
  public FTriUp(int i, int j) {
    Mat = new float[i][j];
E 3
I 3
  public DTriUp(int i, int j) {
    Mat = new double[i][j];
E 3
    rows = i;
    cols = j;
  }
D 3
  public FTriUp(float[][] F) {
E 3
I 3
  public DTriUp(double[][] F) {
E 3
    rows = F.length;
    cols = (F[0]).length;
D 3
    Mat = new float[rows][cols];
E 3
I 3
D 4
    Mat = new double[rows][cols];
E 3
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) {
	Mat[i][j] = F[i][j];
      }
E 4
I 4
    Mat = F;
E 4
  }
D 3
  public FTriUp(FTriUp M) {
E 3
I 3
  public DTriUp(DTriUp M) {
E 3
    rows = M.rows;
    cols = M.cols;
D 3
    Mat = new float[rows][cols];
E 3
I 3
    Mat = new double[rows][cols];
E 3
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) 
	Mat[i][j] = M.Mat[i][j];
  }

D 3
  protected float oneNorm() {
    float tnorm = 0;
E 3
I 3
  protected double oneNorm() {
    double tnorm = 0;
E 3
    for(int j=0;j<cols;j++) 
      tnorm = Math.max(tnorm,this.asum(j+1,1,0,j));
    return tnorm;
  }

  /*  All of the methods are tested and work well except perhaps
      condition.  
	*/

  public LNumber condition(Vector Ze) 
       throws WrongDataTypeException, SingularMatrixException
  {
 
D 3
    float[] Z = Ze.getFloatArray();
E 3
I 3
    double[] Z = Ze.getDoubleArray();
E 3

D 3
    float tnorm = this.oneNorm();
    float ynorm;
E 3
I 3
    double tnorm = this.oneNorm();
    double ynorm;
E 3

    try {
      this.zeroDiag();
    } finally {
    
    for(int j=0;j<cols;j++) 
      Z[j] = 0;
        
    this.solveTransUW(Z);

D 3
    float S = 1/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
E 3
I 3
    double S = 1/DUtil.asum(cols,Z,1);
    DUtil.scal(cols,S,Z,1);
E 3

    ynorm = this.solveUZ(Z,1);
    }
D 3
    LFloat R = new LFloat();
E 3
I 3
    LDouble R = new LDouble();
E 3
    
    if(tnorm != 0) 
D 3
      R.setFloat(ynorm/tnorm);
E 3
I 3
      R.setDouble(ynorm/tnorm);
E 3

    return R;
  }

  public void solve(Vector Be, int job) 
       throws WrongDataTypeException
  {

D 3
    float[] B = Be.getFloatArray();
E 3
I 3
    double[] B = Be.getDoubleArray();
E 3

    if(job == 0) {
      int nm = cols-1;
      B[nm] = B[nm]/this.Mat[nm][nm];
      if(cols > 0) {
	for(int j=nm-1;j>=0;j--) {
D 3
	  float T = -B[j+1];
E 3
I 3
	  double T = -B[j+1];
E 3
	  this.axpy(j+1, T, 1,0,j+1,B,1,0);
	  B[j] = B[j]/this.Mat[j][j];    
	}
      }
    }
    else {
      B[0] = B[0]/this.Mat[0][0];
      if(cols > 1) {
	for(int j=1;j<cols;j++) {
	  B[j] -= this.dot(j,1,0,j,B,1,0);
	  B[j] = B[j]/this.Mat[j][j];
	}
      }
    }
  }
  
  public void inverse() {
    for(int k=0;k<cols;k++) {
      if(this.Mat[k][k] == 0)
	return;
      else {
	this.Mat[k][k] = 1/this.Mat[k][k];
D 3
	float T = -this.Mat[k][k];
E 3
I 3
	double T = -this.Mat[k][k];
E 3
	this.scal(k,T,1,0,k);
	int kp = k+1;
	for(int j=kp;j<cols;j++) {
	  T = this.Mat[k][j];
	  this.Mat[k][j] = 0;
	  this.axpy(k+1,T,1,0,k,this,1,0,j);
	}
      }
    }
  }
}
E 1
