h12383
s 00001/00001/00237
d D 1.4 98/08/11 15:12:33 jpiper 5 4
c needed for debugging
e
s 00037/00001/00201
d D 1.3 98/07/31 17:57:37 jpiper 4 3
c Added dot for matMult
e
s 00077/00019/00125
d D 1.2 98/07/30 12:25:14 jpiper 3 1
c Unrolled Loops
e
s 00000/00000/00000
d R 1.2 98/07/30 12:16:40 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/DMatrix/DUtil.java
e
s 00144/00000/00000
d D 1.1 98/07/30 12:16:39 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
package edu.rice.linpack.Matrix.DMatrix;
import edu.rice.linpack.util.*;

public abstract class DUtil {

  public static double asum(int n, double[] V, int incx) {
    double dasum = 0;
D 3
    int ix = 0;
    for(int i=0;i<n;i++,ix+=incx) 
      dasum += Math.abs(V[ix]);
E 3
I 3
    if(incx != 1) {
      int ix = 0;
      for(int i=0;i<n;i++,ix+=incx) 
	dasum += Math.abs(V[ix]);
      return dasum;
    }
    int m = n%6;
    if(m != 0) {
      for(int i=0;i<m;i++) {
	dasum += Math.abs(V[i]);
      }
    }
    if(n >= 6) {
      for(int i=m;i<n;i+=6) {
	dasum += Math.abs(V[i]) + Math.abs(V[i+1]) + 
	  Math.abs(V[i+2]) + Math.abs(V[i+3]) + 
	  Math.abs(V[i+4]) + Math.abs(V[i+5]);
      }
    }
E 3
    return dasum;
  }
D 3

E 3
I 3
  
E 3
  public static void scal(int n, double Da, double[] V, int incx) {
    scal(n,Da,V,incx,0);
  }
  public static void scal(int n, double Da, double[] V, int incx, int r) {
    if(n > 0 && Da != 1) {
D 3
      int ix = 0;
      for(int i=0;i<n;i++,ix += incx)
	V[ix+r] *= Da;
E 3
I 3
      if(incx != 1) {
	int ix = 0;
	for(int i=0;i<n;i++,ix += incx)
	  V[ix+r] *= Da;
      }
      else {
	int m = n%5;
	if(m != 0) {
	  for(int i=0;i<m;i++) {
	    V[i+r] *= Da;
	  }
	}
	if(n >= 5) {
	  for(int i=m;i<n;i+=5) {
	    int ir = i+r;
	    V[ir] *= Da; 
	    V[ir+1] *= Da;
	    V[ir+2] *= Da; 
	    V[ir+3] *= Da; 
	    V[ir+4] *= Da;
	  }
	}
      }
E 3
    }
D 3
    return;
E 3
  }

  public static double signOf(double ek, double zk) {
    if(zk < 0) 
      return -Math.abs(ek);
    return Math.abs(ek);
  }
  
  public static void swapElems(double[] Z, int k1, int k2) {
    double temp = Z[k1];
    Z[k1] = Z[k2];
    Z[k2] = temp;
  }
  public static void swapElems(int[] Z, int k1, int k2) {
    int temp = Z[k1];
    Z[k1] = Z[k2];
    Z[k2] = temp;
  }

  public static void detNorm(double[] Det) {
    while(Math.abs(Det[0]) < 1) {
      Det[0] *= 10;
      Det[1] -= 1;
    }
    while(Math.abs(Det[0]) >= 10) {
      Det[0] /= 10;
      Det[1]++;
    }
  }
  public static void copy(int n, double[] A, int incx, int rx, 
			  double[] B, int incy, int ry) {
    if(n <= 0)
      return;
D 3
    
    int ix = 0;
    int iy = 0;
    if(incx < 0)
      ix = (-n+1)*incx;
    if(incy < 0)
      iy = (-n+1)*incy;
    for(int i=0;i<n;i++) {
      B[iy+ry] = A[ix+rx];
      ix += incx;
      iy += incy;
E 3
I 3

    if(incx != 1 || incy != 1) {
      int ix = 0;
      int iy = 0;
      if(incx < 0)
	ix = (-n+1)*incx;
      if(incy < 0)
	iy = (-n+1)*incy;
      for(int i=0;i<n;i++) {
	B[iy+ry] = A[ix+rx];
	ix += incx;
	iy += incy;
      }
    }
    else {
      int m = n%7;
      if(m != 0) {
	for(int i=0;i<m;i++) 
D 5
	  B[i] = A[i+rx];
E 5
I 5
	  B[i+ry] = A[i+rx];
E 5
      }
      if(n >= 7) {
	for(int i=m;i<n;i+=7) {
	  int irx = i+rx;
	  int iry = i+ry;
	  B[iry] = A[irx];
	  B[iry+1] = A[irx+1];
	  B[iry+2] = A[irx+2];
	  B[iry+3] = A[irx+3];
	  B[iry+4] = A[irx+4];
	  B[iry+5] = A[irx+5];
	  B[iry+6] = A[irx+6];
	}
      }
E 3
    }
  }
I 3
D 4
  
E 4
I 4
  public static double dot(int n, double[] A, int incx, int rx, 
		    double[] B, int incy, int ry) {

    double N = 0;
    
    if(n > 0){
      if(incy != 1 || incx != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	
	for(int i=0; i<n;i++,ix+= incx,iy += incy) 
	  N += A[rx+ix] * B[ry+iy];
      }
      else {
	int m = n%5;
	if(m != 0) {
	  for(int i=0;i<m;i++) {
	    N += A[i+rx]*B[ry+i];
	  }
	}
	if(n >= 5) {
	  for(int i=m;i<n;i+=5) {
	    int irx = i+rx;
	    int iry = i+ry;
	    N += A[irx]*B[iry] + 
	      A[irx+1]*B[iry+1] +
	      A[irx+2]*B[iry+2] +  
	      A[irx+3]*B[iry+3] + 
	      A[irx+4]*B[iry+4];
	  }
	}
      }
    }
    return N;
  }
E 4
E 3
  
  public static double nrm2(int n, double[] S, int incx, int r) {
    
    int ix;
    double absxi, scale, ssq;
    
    if(n < 1 || incx < 1)
      return 0;
    else if( n == 1) 
      return Math.abs(S[r]);
    
    scale = 0;
    ssq = 1; 
    
    for(ix = 0;ix < n*incx;ix+=incx) {
      if(S[r+ix] != 0) {
	absxi = Math.abs(S[r+ix]);
	if(scale < absxi) {
	  ssq = 1 + ssq*Math.pow((scale/absxi),2);
	  scale = absxi;
	}
	else 
	  ssq += Math.pow( absxi/scale,2);
      }
    }
    return (scale*Math.sqrt(ssq));
  }

  public static void rotg(Trig Qt) {
    
    DTrig Q = (DTrig) Qt;

    double Roe = Q.getB();
    double R;

    if(Math.abs(Q.getA()) > Math.abs(Roe)) 
      Roe = Q.getA();
    double scale = Math.abs(Q.getA()) + Math.abs(Q.getB());
    if(scale == 0) {
      Q.setCos(1);
      Q.setSin(0);
      R = 0;
    }
    else {
      R = scale*Math.sqrt(Math.pow(Q.getA()/scale,2)+
			  Math.pow(Q.getB()/scale,2));
      R = DUtil.signOf(1,Roe)*R;
      Q.setCos(Q.getA()/R);
      Q.setSin(Q.getB()/R);
    }
    double Z = 1;
    if(Math.abs(Q.getA()) > Math.abs(Q.getB())) 
      Z = Q.getSin();
    else if(Q.getCos() != 0) 
      Z = 1/Q.getCos();

    Q.setA(R);
    Q.setB(Z);
  }

  public static void Print(double[] S) {
    int n = S.length;
    System.out.print("Vector:  ");
    for(int i=0;i<n;i++) {
      System.out.print(S[i]+"   ");
    }
    System.out.println();
  }
  public static double aMax(double a, double b, double c, double d, double e) {
    double scale = Math.max(Math.abs(a),Math.abs(b));
    double scal2 = Math.max(Math.abs(c),Math.abs(d));
    scale = Math.max(scale,Math.abs(e));
    return Math.max(scale, scal2);
  }
}
E 1
