h25900
s 00001/00005/00469
d D 1.4 98/07/28 10:00:51 jpiper 8 7
c Fixed constructor
e
s 00407/00000/00067
d D 1.3 98/07/28 09:18:30 jpiper 7 3
i 6
c Merged changes between child workspace "/home/jpiper/MyJavaLinpack" and
c  parent workspace "/net/una7/JavaLinpack".
c 
e
s 00067/00067/00407
d D 1.1.1.2 98/07/27 13:07:33 jpiper 6 5
c double copy of FMatrix
e
s 00474/00000/00000
d D 1.1.1.1 98/07/27 12:01:34 jpiper 5 1
c 
e
s 00000/00000/00000
d R 1.3 98/07/27 09:37:13 Codemgr 4 3
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/DMatrix/DMatrix.java
e
s 00000/00000/00000
d D 1.2 98/07/27 09:37:12 jpiper 3 1
c date and time created 98/07/27 09:37:12 by jpiper
e
s 00000/00000/00000
d R 1.2 70/01/01 00:00:01 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 3 2 src/edu/rice/linpack/Matrix/DMatrix/oldstuff/SDMatrix.java
c Name history : 2 1 src/edu/rice/linpack/Matrix/DMatrix/SDMatrix.java
c Name history : 1 0 src/edu/rice/linpack/Matrix/DMatrix/DMatrix.java
e
s 00000/00000/00000
d D 1.1 70/01/01 00:00:00 Fake 1 0
c Fake CodeManager delta to combine two files with no common deltas
e
u
U
f e 0
t
T
I 7
/*## 
E 7
I 3
E 3
I 5
/*## 
D 6
 ##  class FMatrix
E 6
I 6
 ##  class DMatrix
I 7
 ##   
 ##  This class extends Matrix to represent a Matrix of single precision
 ##  floating point numbers.  It contains all the BLAS (basic linear 
 ##  algebra subroutines) and other low-level functions common to all
 ##  matrices.  
E 7
E 6
 ##   
 ##  This class extends Matrix to represent a Matrix of single precision
 ##  floating point numbers.  It contains all the BLAS (basic linear 
 ##  algebra subroutines) and other low-level functions common to all
 ##  matrices.  
D 6
 ##  FMatrix's contain no factoring or solving capabilities.
E 6
I 6
 ##  DMatrix's contain no factoring or solving capabilities.
I 7
 ##
 ##*/

E 7
E 6
 ##
 ##*/

D 6
package edu.rice.linpack.Matrix.FMatrix;
E 6
I 6
package edu.rice.linpack.Matrix.DMatrix;
I 7
import edu.rice.linpack.Matrix.Matrix;
import edu.rice.linpack.util.*;
import edu.rice.linpack.Vector.*;


E 7
E 6
import edu.rice.linpack.Matrix.Matrix;
import edu.rice.linpack.util.*;
import edu.rice.linpack.Vector.*;


D 6
public abstract class FMatrix extends Matrix {
E 6
I 6
public abstract class DMatrix extends Matrix {
I 7

E 7
E 6

D 6
  protected float[][] Mat;
E 6
I 6
  protected double[][] Mat;
I 7

  void cons() {
    pivot = new int[cols];
  }
  void cons(int i, int j) {
E 7
E 6

  void cons() {
    pivot = new int[cols];
  }
  void cons(int i, int j) {
D 6
    Mat = new float[i][j];
E 6
I 6
    Mat = new double[i][j];
I 7
    rows = i;
    cols = j;
    pivot = new int[cols];
  }
E 7
E 6
    rows = i;
    cols = j;
    pivot = new int[cols];
  }
D 6
  void cons(FMatrix M) {
E 6
I 6
  void cons(DMatrix M) {
I 7
    rows = M.rows;
    cols = M.cols;
E 7
E 6
    rows = M.rows;
    cols = M.cols;
D 6
    Mat = new float[rows][cols];
E 6
I 6
    Mat = new double[rows][cols];
I 7
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) 
	Mat[i][j] = M.Mat[i][j];
    pivot = new int[cols];
  }    
E 7
E 6
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) 
	Mat[i][j] = M.Mat[i][j];
    pivot = new int[cols];
  }    
D 6
  void cons(float[][] F) {
E 6
I 6
  void cons(double[][] F) {
I 7
    rows = F.length;
    cols = (F[0]).length;
E 7
E 6
    rows = F.length;
    cols = (F[0]).length;
D 6
    Mat = new float[rows][cols];
E 6
I 6
D 8
    Mat = new double[rows][cols];
I 7
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) {
	Mat[i][j] = F[i][j];
      }
E 8
I 8
    Mat = F;
E 8
    pivot = new int[cols];
  }
  
  /*##
   ##  These routines return a copy of the desired object beginning at
   ##   the element (i,q)  
   ##*/

E 7
E 6
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) {
	Mat[i][j] = F[i][j];
      }
    pivot = new int[cols];
  }
  
  /*##
   ##  These routines return a copy of the desired object beginning at
   ##   the element (i,q)  
   ##*/

D 6
  public float getElem(int i, int q) {
E 6
I 6
  public double getElem(int i, int q) {
I 7
    return Mat[i][q];
  }
E 7
E 6
    return Mat[i][q];
  }
D 6
  public float[] getRow(int i, int q) {
    float[] F = new float[cols-q];
E 6
I 6
  public double[] getRow(int i, int q) {
    double[] F = new double[cols-q];
I 7
    for(int j=0;j<(cols-q);j++)
      F[j] = Mat[i][q+j];
    return F;
  }
E 7
E 6
    for(int j=0;j<(cols-q);j++)
      F[j] = Mat[i][q+j];
    return F;
  }
D 6
  public float[] getColumn(int i, int q) {
    float[] F = new float[rows-q];
E 6
I 6
  public double[] getColumn(int i, int q) {
    double[] F = new double[rows-q];
I 7
    for(int j=0; j<(rows-q);j++) {
      F[j] = Mat[j+q][i];
    }
    return F;
  }

  /*##
   ##  this.setColumn changes column c to F  
   ##*/

E 7
E 6
    for(int j=0; j<(rows-q);j++) {
      F[j] = Mat[j+q][i];
    }
    return F;
  }

  /*##
   ##  this.setColumn changes column c to F  
   ##*/

D 6
  public void setColumn(int c,float[] F) {
E 6
I 6
  public void setColumn(int c,double[] F) {
I 7
    for(int r=0;r<rows;r++) {
      this.Mat[r][c] = F[r];
    }
  }
E 7
E 6
    for(int r=0;r<rows;r++) {
      this.Mat[r][c] = F[r];
    }
  }
D 6
  public void setElem(int r, int c, float value) {
E 6
I 6
  public void setElem(int r, int c, double value) {
I 7
    this.Mat[r][c] = value;
  }

  public void Print() {
    System.out.println();
    for(int i=0;i<rows;i++) {
      for(int j=0;j<cols;j++) {
	System.out.print(Mat[i][j] + "     ");
      }
      System.out.println();
    }
    System.out.println();
  }

  /*##
E 7
E 6
    this.Mat[r][c] = value;
  }

  public void Print() {
    System.out.println();
    for(int i=0;i<rows;i++) {
      for(int j=0;j<cols;j++) {
	System.out.print(Mat[i][j] + "     ");
      }
      System.out.println();
    }
    System.out.println();
  }

  /*##
D 6
   ##  this.swapElem swaps two elements in this FMatrix  
E 6
I 6
   ##  this.swapElem swaps two elements in this DMatrix  
I 7
   ##*/

  public void swapElem(int rx, int cx, int ry, int cy) {
E 7
E 6
   ##*/

  public void swapElem(int rx, int cx, int ry, int cy) {
D 6
    float T = this.Mat[rx][cx];
E 6
I 6
    double T = this.Mat[rx][cx];
I 7
    this.Mat[rx][cx] = this.Mat[ry][cy];
    this.Mat[ry][cy] = T;
  }

  /*#######################*/
  /*##   BLAS Routines   ##*/

  /*##
   ##  For all BLAS: 
   ##
   ##  On Input:
   ##
   ##     n         int
   ##               The number of elements to be effected. 
   ##
   ##     incx      int
   ##               The amount to increase the column number for 
   ##               this.Mat on each iteration.
   ##
   ##     r,rx      int 
   ##               The initial row in this.Mat.
   ##
   ##     c,cx      int
   ##               The initial column in this.Mat.
   ## 
E 7
E 6
    this.Mat[rx][cx] = this.Mat[ry][cy];
    this.Mat[ry][cy] = T;
  }

  /*#######################*/
  /*##   BLAS Routines   ##*/

  /*##
   ##  For all BLAS: 
   ##
   ##  On Input:
   ##
   ##     n         int
   ##               The number of elements to be effected. 
   ##
   ##     incx      int
   ##               The amount to increase the column number for 
   ##               this.Mat on each iteration.
   ##
   ##     r,rx      int 
   ##               The initial row in this.Mat.
   ##
   ##     c,cx      int
   ##               The initial column in this.Mat.
   ## 
D 6
   ##     B         float[], FMatrix, float[][]
E 6
I 6
   ##     B         double[], DMatrix, double[][]
I 7
   ##               The other object used in some calculations.
   ##     
   ##     incy      int
   ##               The amount to increase the column number for B.
   ##
   ##     ry        int
   ##               The initial row in B.
   ## 
   ##     cy        int
   ##               The initial column in B.
   ##
E 7
E 6
   ##               The other object used in some calculations.
   ##     
   ##     incy      int
   ##               The amount to increase the column number for B.
   ##
   ##     ry        int
   ##               The initial row in B.
   ## 
   ##     cy        int
   ##               The initial column in B.
   ##
D 6
   ##     Da        float
   ##               A float used as a scalar.
E 6
I 6
   ##     Da        double
   ##               A double used as a scalar.
I 7
   ##
E 7
E 6
   ##
D 6
   ##     Tg        FTrig
E 6
I 6
   ##     Tg        DTrig
I 7
   ##               Holds the sine and cosine values formed in a Givens
   ##               rotation and used in a rotation.
   ##*/

  /*##
   ##  asum - sum of absolute values in a vector
E 7
E 6
   ##               Holds the sine and cosine values formed in a Givens
   ##               rotation and used in a rotation.
   ##*/

  /*##
   ##  asum - sum of absolute values in a vector
D 6
   ##  Returns the sum as a float  
E 6
I 6
   ##  Returns the sum as a double  
I 7
   ##*/

E 7
E 6
   ##*/

D 6
  public float asum(int n, int incx, int r, int c) {
    float dasum = 0;
E 6
I 6
  public double asum(int n, int incx, int r, int c) {
    double dasum = 0;
I 7
    int ix = r;
    for(int i=0;i<n;i++,ix+=incx) 
      dasum += Math.abs(this.Mat[ix][c]);
    return dasum;
  }

  /*##
   ##  axpy - a const times a vector plus a vector 
   ##  Dy is changed in the loop and holds the desired value on return 
   ##*/

E 7
E 6
    int ix = r;
    for(int i=0;i<n;i++,ix+=incx) 
      dasum += Math.abs(this.Mat[ix][c]);
    return dasum;
  }

  /*##
   ##  axpy - a const times a vector plus a vector 
   ##  Dy is changed in the loop and holds the desired value on return 
   ##*/

D 6
  public void axpy(int n, float Da, int incx, int rx, int cx, 
E 6
I 6
  public void axpy(int n, double Da, int incx, int rx, int cx, 
I 7
		   Matrix B, int incy, int ry, int cy) {
    
E 7
E 6
		   Matrix B, int incy, int ry, int cy) {
    
D 6
    float[][] Mat2 = ((FMatrix) B).Mat;
E 6
I 6
    double[][] Mat2 = ((DMatrix) B).Mat;
I 7

    if(n > 0 && Da != 0) {
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      for(int i=0;i<n;i++,ix+=incx,iy+=incy) 
	Mat2[iy+ry][cy] += Da * Mat[ix+rx][cx];
    }
  }
E 7
E 6

    if(n > 0 && Da != 0) {
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      for(int i=0;i<n;i++,ix+=incx,iy+=incy) 
	Mat2[iy+ry][cy] += Da * Mat[ix+rx][cx];
    }
  }
D 6
  public void axpy(int n, float Da, int incx, int rx, int cx,
E 6
I 6
  public void axpy(int n, double Da, int incx, int rx, int cx,
I 7
		   Vector Be, int incy, int ry) 
       throws WrongDataTypeException 
  {
E 7
E 6
		   Vector Be, int incy, int ry) 
       throws WrongDataTypeException 
  {
D 6
    float[] B = Be.getFloatArray();
E 6
I 6
    double[] B = Be.getDoubleArray();
I 7
    this.axpy(n,Da,incx,rx,cx,B,incy,ry);
  }
E 7
E 6
    this.axpy(n,Da,incx,rx,cx,B,incy,ry);
  }
D 6
  public void axpy(int n, float Da, int incx, int rx, int cx,
		   float[] B, int incy, int ry) {
E 6
I 6
  public void axpy(int n, double Da, int incx, int rx, int cx,
		   double[] B, int incy, int ry) {
I 7
    
    if(n > 0 && Da != 0) {
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      for(int i=0;i<n;i++,ix+=incx,iy+=incy) 
	B[ry+iy] += Da*Mat[ix+rx][cx];
    }
  }

  /*##
E 7
E 6
    
    if(n > 0 && Da != 0) {
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      for(int i=0;i<n;i++,ix+=incx,iy+=incy) 
	B[ry+iy] += Da*Mat[ix+rx][cx];
    }
  }

  /*##
D 6
   ##  This version takes an array of floats and modifies the calling object.
E 6
I 6
   ##  This version takes an array of doubles and modifies the calling object.
I 7
   ##  this.Mat is changed in the loop and holds the desired value on return.
   ##*/

E 7
E 6
   ##  this.Mat is changed in the loop and holds the desired value on return.
   ##*/

D 6
  public void axpy(int n, float Da, Vector Be, int incy, int ry,
E 6
I 6
  public void axpy(int n, double Da, Vector Be, int incy, int ry,
I 7
		   int incx, int rx, int cx) 
       throws WrongDataTypeException
  {
E 7
E 6
		   int incx, int rx, int cx) 
       throws WrongDataTypeException
  {
D 6
    float[] B = Be.getFloatArray();
E 6
I 6
    double[] B = Be.getDoubleArray();
I 7
    this.axpy(n,Da,B,incy,ry,incx,rx,cx);
  }
E 7
E 6
    this.axpy(n,Da,B,incy,ry,incx,rx,cx);
  }
D 6
  public void axpy(int n, float Da, float[] B, int incy, int ry,
E 6
I 6
  public void axpy(int n, double Da, double[] B, int incy, int ry,
I 7
		   int incx, int rx, int cx) {
    if(n > 0 && Da != 0) {
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      for(int i=0;i<n;i++,ix+=incx,iy+=incy) 
	this.Mat[rx+ix][cx] += Da*B[ry+iy];
    }
  }


  /*##
   ##  copy - copies one vector to another 
   ##  B is changed and holds the desired array 
   ##*/

  public void copy(int n, int incx, int rx, int cx, 
		   Vector Be, int incy) 
       throws WrongDataTypeException
  {
E 7
E 6
		   int incx, int rx, int cx) {
    if(n > 0 && Da != 0) {
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      for(int i=0;i<n;i++,ix+=incx,iy+=incy) 
	this.Mat[rx+ix][cx] += Da*B[ry+iy];
    }
  }


  /*##
   ##  copy - copies one vector to another 
   ##  B is changed and holds the desired array 
   ##*/

  public void copy(int n, int incx, int rx, int cx, 
		   Vector Be, int incy) 
       throws WrongDataTypeException
  {
D 6
    float[] B = Be.getFloatArray();
E 6
I 6
    double[] B = Be.getDoubleArray();
I 7
    this.copy(n,incx,rx,cx,B,incy);
  }
  public void copy(int n, int incx, int rx, int cx, 
E 7
E 6
    this.copy(n,incx,rx,cx,B,incy);
  }
  public void copy(int n, int incx, int rx, int cx, 
D 6
		   float[] B, int incy) {
E 6
I 6
		   double[] B, int incy) {
I 7
    if(n > 0) {
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      
      for(int i=0;i<n;i++,ix+=incx, iy+= incy) 
	B[iy] = Mat[ix+rx][cx];
    }
  }
  public void copy(int n, int incx, int rx, int cx, 
		   Matrix B, int incy, int ry, int cy) {
    
E 7
E 6
    if(n > 0) {
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      
      for(int i=0;i<n;i++,ix+=incx, iy+= incy) 
	B[iy] = Mat[ix+rx][cx];
    }
  }
  public void copy(int n, int incx, int rx, int cx, 
		   Matrix B, int incy, int ry, int cy) {
    
D 6
    float[][] Mat2 = ((FMatrix)B).Mat;
E 6
I 6
    double[][] Mat2 = ((DMatrix)B).Mat;
I 7
    
    if(n > 0) {
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      
      for(int i=0;i<n;i++,ix+=incx, iy+= incy) 
	Mat2[iy+ry][cy] = Mat[ix+rx][cx];
    }
  }
  

  /*##
   ##  dot - Dot product between two vectors 
E 7
E 6
    
    if(n > 0) {
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      
      for(int i=0;i<n;i++,ix+=incx, iy+= incy) 
	Mat2[iy+ry][cy] = Mat[ix+rx][cx];
    }
  }
  

  /*##
   ##  dot - Dot product between two vectors 
D 6
   ##  A float is returned  
E 6
I 6
   ##  A double is returned  
I 7
   ##*/

E 7
E 6
   ##*/

D 6
  public float dot(int n, int incx, int rx, int cx,
		   FMatrix B, int incy, int ry, int cy) {
E 6
I 6
  public double dot(int n, int incx, int rx, int cx,
		   DMatrix B, int incy, int ry, int cy) {
I 7
    
E 7
E 6
    
D 6
    float N = 0;
E 6
I 6
    double N = 0;
I 7
    
    if(n > 0){
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      
      for(int i=0; i<n;i++,ix+= incx,iy += incy) 
	N += Mat[rx+ix][cx] * B.Mat[ry+iy][cy];
    }
    return N;
  }
E 7
E 6
    
    if(n > 0){
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      
      for(int i=0; i<n;i++,ix+= incx,iy += incy) 
	N += Mat[rx+ix][cx] * B.Mat[ry+iy][cy];
    }
    return N;
  }
D 6
  public float dot(int n, int incx, int rx, int cx,
E 6
I 6
  public double dot(int n, int incx, int rx, int cx,
I 7
		   Vector Be, int incy, int ry) 
       throws WrongDataTypeException
  {
E 7
E 6
		   Vector Be, int incy, int ry) 
       throws WrongDataTypeException
  {
D 6
    float[] B = Be.getFloatArray();
E 6
I 6
    double[] B = Be.getDoubleArray();
I 7
    return this.dot(n,incx,rx,cx,B,incy,ry);
  }
E 7
E 6
    return this.dot(n,incx,rx,cx,B,incy,ry);
  }
D 6
  public float dot(int n, int incx, int rx, int cx,
		   float[] B, int incy, int ry) {
E 6
I 6
  public double dot(int n, int incx, int rx, int cx,
		   double[] B, int incy, int ry) {
I 7

E 7
E 6

D 6
    float N = 0;
E 6
I 6
    double N = 0;
I 7
    
    if(n > 0){
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      
      for(int i=0; i<n;i++,ix+= incx,iy += incy) 
	N += Mat[rx+ix][cx] * B[ry+iy];
    }
    return N;
  }


  /*##
   ##  scal - multiply a vector by a scalar 
   ##  The calling object is changed  
   ##*/

E 7
E 6
    
    if(n > 0){
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      
      for(int i=0; i<n;i++,ix+= incx,iy += incy) 
	N += Mat[rx+ix][cx] * B[ry+iy];
    }
    return N;
  }


  /*##
   ##  scal - multiply a vector by a scalar 
   ##  The calling object is changed  
   ##*/

D 6
  public void scal(int n, float Da, int incx, int r, int c) {
E 6
I 6
  public void scal(int n, double Da, int incx, int r, int c) {
I 7

    if(n > 0 && Da != 1) {
      int ix = 0;
      for (int i=0;i<n;i++,ix += incx)
	Mat[ix+r][c] *= Da;
    }
  }      

  /*##
   ##  swap - interchanges two vectors 
   ##*/

  public void swap(int n, int incx, int rx, int cx, 
		   Matrix B, int incy, int ry, int cy) {
    
E 7
E 6

    if(n > 0 && Da != 1) {
      int ix = 0;
      for (int i=0;i<n;i++,ix += incx)
	Mat[ix+r][c] *= Da;
    }
  }      

  /*##
   ##  swap - interchanges two vectors 
   ##*/

  public void swap(int n, int incx, int rx, int cx, 
		   Matrix B, int incy, int ry, int cy) {
    
D 6
    float[][] Mat2 = ((FMatrix)B).Mat;
E 6
I 6
    double[][] Mat2 = ((DMatrix)B).Mat;
I 7

    if(n > 0) {
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
E 7
E 6

    if(n > 0) {
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
D 6
      float N;
E 6
I 6
      double N;
I 7
      for(int i=0;i<n;i++) {
	N = Mat[ix+rx][cx];
	Mat[ix+rx][cx] = Mat2[iy+ry][cy];
	Mat2[iy+ry][cy] = N;
	ix += incx;
	iy += incy;
      }
    }
  }

  /*##
   ##  i_amax - finds the index of element having the max absolute value 
   ##  Returns the index with zero as first element 
   ##*/

  public int i_amax(int n, int incx, int r, int c) {
  
    int max = 0;
E 7
E 6
      for(int i=0;i<n;i++) {
	N = Mat[ix+rx][cx];
	Mat[ix+rx][cx] = Mat2[iy+ry][cy];
	Mat2[iy+ry][cy] = N;
	ix += incx;
	iy += incy;
      }
    }
  }

  /*##
   ##  i_amax - finds the index of element having the max absolute value 
   ##  Returns the index with zero as first element 
   ##*/

  public int i_amax(int n, int incx, int r, int c) {
  
    int max = 0;
D 6
    float Dmax;
E 6
I 6
    double Dmax;
I 7
    
    if(n < 0) 
      return 0;  
    
    if(n > 0) {
      int ix = incx;
      Dmax = Math.abs(Mat[r][c]);
      for(int i=1;i<n;i++) {
	if(Math.abs(Mat[ix+r][c]) > Dmax) {
	  max = ix;
	  Dmax = Math.abs(Mat[ix+r][c]);
	}
	ix += incx;
      }
    } 
    return max;
  }
  
  /*##
   ##  rotg - construct a Givens plane rotation 
   ##  Tg contains the computed sin and cos values 
   ##*/
  
  public void rotg(int r, int c, Trig Tger) {

E 7
E 6
    
    if(n < 0) 
      return 0;  
    
    if(n > 0) {
      int ix = incx;
      Dmax = Math.abs(Mat[r][c]);
      for(int i=1;i<n;i++) {
	if(Math.abs(Mat[ix+r][c]) > Dmax) {
	  max = ix;
	  Dmax = Math.abs(Mat[ix+r][c]);
	}
	ix += incx;
      }
    } 
    return max;
  }
  
  /*##
   ##  rotg - construct a Givens plane rotation 
   ##  Tg contains the computed sin and cos values 
   ##*/
  
  public void rotg(int r, int c, Trig Tger) {

D 6
    FTrig Tg = (FTrig) Tger;
E 6
I 6
    DTrig Tg = (DTrig) Tger;
I 7

E 7
E 6

D 6
    float Roe = Tg.getB();
    float Da = this.Mat[r][c];
    float R;
E 6
I 6
    double Roe = Tg.getB();
    double Da = this.Mat[r][c];
    double R;
I 7

    if(Math.abs(Da) > Math.abs(Tg.getB())) 
      Roe = Da;
E 7
E 6

    if(Math.abs(Da) > Math.abs(Tg.getB())) 
      Roe = Da;
D 6
    float Scale = Math.abs(Da) + Math.abs(Tg.getB());
E 6
I 6
    double Scale = Math.abs(Da) + Math.abs(Tg.getB());
I 7
    if(Scale == 0) {
      Tg.setCos(1);
      Tg.setSin(0);
      R = 0;
    }
    else {
E 7
E 6
    if(Scale == 0) {
      Tg.setCos(1);
      Tg.setSin(0);
      R = 0;
    }
    else {
D 6
      R = Scale*(float)Math.sqrt(Math.pow(Da/Scale,2) + 
E 6
I 6
      R = Scale*Math.sqrt(Math.pow(Da/Scale,2) + 
I 7
				 Math.pow(Tg.getB()/Scale,2));
      if(Roe < 0) 
	R = -R;
      Tg.setCos(Da/R);
      Tg.setSin(Tg.getB()/R);
    }
E 7
E 6
				 Math.pow(Tg.getB()/Scale,2));
      if(Roe < 0) 
	R = -R;
      Tg.setCos(Da/R);
      Tg.setSin(Tg.getB()/R);
    }
D 6
    float Z = 1;
E 6
I 6
    double Z = 1;
I 7
    if(Math.abs(Da) > Math.abs(Tg.getB())) 
      Z = Tg.getSin();
    else if(Tg.getCos() != 0) 
      Z = 1/Tg.getCos();

    this.Mat[r][c] = R;
    Tg.setB(Z);
  }
  
  /*##
   ##  rot applies a plane rotation from the parameters figured from Givens 
   ##*/

  public void rot(int n, int incx, int rx, int cx, Matrix B, 
		  int incy, int ry, int cy, Trig Tger) {
    
E 7
E 6
    if(Math.abs(Da) > Math.abs(Tg.getB())) 
      Z = Tg.getSin();
    else if(Tg.getCos() != 0) 
      Z = 1/Tg.getCos();

    this.Mat[r][c] = R;
    Tg.setB(Z);
  }
  
  /*##
   ##  rot applies a plane rotation from the parameters figured from Givens 
   ##*/

  public void rot(int n, int incx, int rx, int cx, Matrix B, 
		  int incy, int ry, int cy, Trig Tger) {
    
D 6
    FTrig Tg = (FTrig) Tger;
    float[][] Mat2 = ((FMatrix) B).Mat;
E 6
I 6
    DTrig Tg = (DTrig) Tger;
    double[][] Mat2 = ((DMatrix) B).Mat;
I 7

    if(n <= 0) 
      return;
    else {
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;

E 7
E 6

    if(n <= 0) 
      return;
    else {
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;

D 6
      float temp;      
E 6
I 6
      double temp;      
I 7
      for(int i=0;i<n;i++) {
        temp = (this.Mat[ix+rx][cx] * Tg.getCos()) + 
	  (Mat2[iy+ry][cy] * Tg.getSin());
        Mat2[iy+ry][cy] = (Mat2[iy+ry][cy] * Tg.getCos()) - 
	  (this.Mat[ix+rx][cx] * Tg.getSin());
        this.Mat[ix+rx][cx] = temp;
        ix += incx;
        iy += incy;
      }
    }
  }

E 7
E 6
      for(int i=0;i<n;i++) {
        temp = (this.Mat[ix+rx][cx] * Tg.getCos()) + 
	  (Mat2[iy+ry][cy] * Tg.getSin());
        Mat2[iy+ry][cy] = (Mat2[iy+ry][cy] * Tg.getCos()) - 
	  (this.Mat[ix+rx][cx] * Tg.getSin());
        this.Mat[ix+rx][cx] = temp;
        ix += incx;
        iy += incy;
      }
    }
  }

D 6
  public float nrm2(int n, int incx, int r, int c) {
E 6
I 6
  public double nrm2(int n, int incx, int r, int c) {
I 7
    
    int ix;
E 7
E 6
    
    int ix;
D 6
    float absxi, scale, ssq;
E 6
I 6
    double absxi, scale, ssq;
I 7
    
    if(n < 1 || incx < 1)
      return 0;
    else if( n == 1) 
      return Math.abs(Mat[r][c]);

    scale = 0;
    ssq = 1; 
    
    for(ix = 0;ix < n*incx;ix+=incx) {
      if(Mat[r+ix][c] != 0) {
	absxi = Math.abs(Mat[r+ix][c]);
	if(scale < absxi) {
E 7
E 6
    
    if(n < 1 || incx < 1)
      return 0;
    else if( n == 1) 
      return Math.abs(Mat[r][c]);

    scale = 0;
    ssq = 1; 
    
    for(ix = 0;ix < n*incx;ix+=incx) {
      if(Mat[r+ix][c] != 0) {
	absxi = Math.abs(Mat[r+ix][c]);
	if(scale < absxi) {
D 6
	  ssq = 1 + ssq*(float)Math.pow((scale/absxi),2);
E 6
I 6
	  ssq = 1 + ssq*Math.pow((scale/absxi),2);
I 7
	  scale = absxi;
	}
	else 
E 7
E 6
	  scale = absxi;
	}
	else 
D 6
	  ssq += (float)Math.pow( absxi/scale,2);
E 6
I 6
	  ssq += Math.pow( absxi/scale,2);
I 7
      }
    }
E 7
E 6
      }
    }
D 6
    return (scale*(float)Math.sqrt(ssq));
E 6
I 6
    return (scale*Math.sqrt(ssq));
I 7
  }
}
E 7
E 6
  }
}
E 5
