h56238
s 00029/00029/00115
d D 1.2 98/07/27 13:09:49 jpiper 3 1
c double version
e
s 00000/00000/00000
d R 1.2 98/07/27 12:02:29 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 3 2 src/edu/rice/linpack/Matrix/DMatrix/oldstuff/SDUtil.java
c Name history : 2 1 src/edu/rice/linpack/Matrix/DMatrix/SDUtil.java
c Name history : 1 0 src/edu/rice/linpack/Matrix/DMatrix/DUtil.java
e
s 00144/00000/00000
d D 1.1 98/07/27 12:02:28 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
D 3
package edu.rice.linpack.Matrix.FMatrix;
E 3
I 3
package edu.rice.linpack.Matrix.DMatrix;
E 3
import edu.rice.linpack.util.*;

D 3
public abstract class FUtil {
E 3
I 3
public abstract class DUtil {
E 3

D 3
  public static float asum(int n, float[] V, int incx) {
    float dasum = 0;
E 3
I 3
  public static double asum(int n, double[] V, int incx) {
    double dasum = 0;
E 3
    int ix = 0;
    for(int i=0;i<n;i++,ix+=incx) 
      dasum += Math.abs(V[ix]);
    return dasum;
  }

D 3
  public static void scal(int n, float Da, float[] V, int incx) {
E 3
I 3
  public static void scal(int n, double Da, double[] V, int incx) {
E 3
    scal(n,Da,V,incx,0);
  }
D 3
  public static void scal(int n, float Da, float[] V, int incx, int r) {
E 3
I 3
  public static void scal(int n, double Da, double[] V, int incx, int r) {
E 3
    if(n > 0 && Da != 1) {
      int ix = 0;
      for(int i=0;i<n;i++,ix += incx)
	V[ix+r] *= Da;
    }
    return;
  }

D 3
  public static float signOf(float ek, float zk) {
E 3
I 3
  public static double signOf(double ek, double zk) {
E 3
    if(zk < 0) 
      return -Math.abs(ek);
    return Math.abs(ek);
  }
  
D 3
  public static void swapElems(float[] Z, int k1, int k2) {
    float temp = Z[k1];
E 3
I 3
  public static void swapElems(double[] Z, int k1, int k2) {
    double temp = Z[k1];
E 3
    Z[k1] = Z[k2];
    Z[k2] = temp;
  }
  public static void swapElems(int[] Z, int k1, int k2) {
    int temp = Z[k1];
    Z[k1] = Z[k2];
    Z[k2] = temp;
  }

D 3
  public static void detNorm(float[] Det) {
E 3
I 3
  public static void detNorm(double[] Det) {
E 3
    while(Math.abs(Det[0]) < 1) {
      Det[0] *= 10;
      Det[1] -= 1;
    }
    while(Math.abs(Det[0]) >= 10) {
      Det[0] /= 10;
      Det[1]++;
    }
  }
D 3
  public static void copy(int n, float[] A, int incx, int rx, 
			  float[] B, int incy, int ry) {
E 3
I 3
  public static void copy(int n, double[] A, int incx, int rx, 
			  double[] B, int incy, int ry) {
E 3
    if(n <= 0)
      return;
    
    int ix = 0;
    int iy = 0;
    if(incx < 0)
      ix = (-n+1)*incx;
    if(incy < 0)
      iy = (-n+1)*incy;
    for(int i=0;i<n;i++) {
      B[iy+ry] = A[ix+rx];
      ix += incx;
      iy += incy;
    }
  }
  
D 3
  public static float nrm2(int n, float[] S, int incx, int r) {
E 3
I 3
  public static double nrm2(int n, double[] S, int incx, int r) {
E 3
    
    int ix;
D 3
    float absxi, scale, ssq;
E 3
I 3
    double absxi, scale, ssq;
E 3
    
    if(n < 1 || incx < 1)
      return 0;
    else if( n == 1) 
      return Math.abs(S[r]);
    
    scale = 0;
    ssq = 1; 
    
    for(ix = 0;ix < n*incx;ix+=incx) {
      if(S[r+ix] != 0) {
	absxi = Math.abs(S[r+ix]);
	if(scale < absxi) {
D 3
	  ssq = 1 + ssq*(float)Math.pow((scale/absxi),2);
E 3
I 3
	  ssq = 1 + ssq*Math.pow((scale/absxi),2);
E 3
	  scale = absxi;
	}
	else 
D 3
	  ssq += (float)Math.pow( absxi/scale,2);
E 3
I 3
	  ssq += Math.pow( absxi/scale,2);
E 3
      }
    }
D 3
    return (scale*(float)Math.sqrt(ssq));
E 3
I 3
    return (scale*Math.sqrt(ssq));
E 3
  }

  public static void rotg(Trig Qt) {
    
D 3
    FTrig Q = (FTrig) Qt;
E 3
I 3
    DTrig Q = (DTrig) Qt;
E 3

D 3
    float Roe = Q.getB();
    float R;
E 3
I 3
    double Roe = Q.getB();
    double R;
E 3

    if(Math.abs(Q.getA()) > Math.abs(Roe)) 
      Roe = Q.getA();
D 3
    float scale = Math.abs(Q.getA()) + Math.abs(Q.getB());
E 3
I 3
    double scale = Math.abs(Q.getA()) + Math.abs(Q.getB());
E 3
    if(scale == 0) {
      Q.setCos(1);
      Q.setSin(0);
      R = 0;
    }
    else {
D 3
      R = scale*(float)Math.sqrt(Math.pow(Q.getA()/scale,2)+
				 Math.pow(Q.getB()/scale,2));
      R = FUtil.signOf(1,Roe)*R;
E 3
I 3
      R = scale*Math.sqrt(Math.pow(Q.getA()/scale,2)+
			  Math.pow(Q.getB()/scale,2));
      R = DUtil.signOf(1,Roe)*R;
E 3
      Q.setCos(Q.getA()/R);
      Q.setSin(Q.getB()/R);
    }
D 3
    float Z = 1;
E 3
I 3
    double Z = 1;
E 3
    if(Math.abs(Q.getA()) > Math.abs(Q.getB())) 
      Z = Q.getSin();
    else if(Q.getCos() != 0) 
      Z = 1/Q.getCos();

    Q.setA(R);
    Q.setB(Z);
  }

D 3
  public static void Print(float[] S) {
E 3
I 3
  public static void Print(double[] S) {
E 3
    int n = S.length;
    System.out.print("Vector:  ");
    for(int i=0;i<n;i++) {
      System.out.print(S[i]+"   ");
    }
    System.out.println();
  }
D 3
  public static float aMax(float a, float b, float c, float d, float e) {
    float scale = Math.max(Math.abs(a),Math.abs(b));
    float scal2 = Math.max(Math.abs(c),Math.abs(d));
E 3
I 3
  public static double aMax(double a, double b, double c, double d, double e) {
    double scale = Math.max(Math.abs(a),Math.abs(b));
    double scal2 = Math.max(Math.abs(c),Math.abs(d));
E 3
    scale = Math.max(scale,Math.abs(e));
    return Math.max(scale, scal2);
  }
}
E 1
