package edu.rice.linpack.Matrix.DMatrix;
import edu.rice.linpack.util.*;

public abstract class DUtil {

  public static double asum(int n, double[] V, int incx) {
    double dasum = 0;
    int ix = 0;
    for(int i=0;i<n;i++,ix+=incx) 
      dasum += Math.abs(V[ix]);
    return dasum;
  }

  public static void scal(int n, double Da, double[] V, int incx) {
    scal(n,Da,V,incx,0);
  }
  public static void scal(int n, double Da, double[] V, int incx, int r) {
    if(n > 0 && Da != 1) {
      int ix = 0;
      for(int i=0;i<n;i++,ix += incx)
	V[ix+r] *= Da;
    }
    return;
  }

  public static double signOf(double ek, double zk) {
    if(zk < 0) 
      return -Math.abs(ek);
    return Math.abs(ek);
  }
  
  public static void swapElems(double[] Z, int k1, int k2) {
    double temp = Z[k1];
    Z[k1] = Z[k2];
    Z[k2] = temp;
  }
  public static void swapElems(int[] Z, int k1, int k2) {
    int temp = Z[k1];
    Z[k1] = Z[k2];
    Z[k2] = temp;
  }

  public static void detNorm(double[] Det) {
    while(Math.abs(Det[0]) < 1) {
      Det[0] *= 10;
      Det[1] -= 1;
    }
    while(Math.abs(Det[0]) >= 10) {
      Det[0] /= 10;
      Det[1]++;
    }
  }
  public static void copy(int n, double[] A, int incx, int rx, 
			  double[] B, int incy, int ry) {
    if(n <= 0)
      return;
    
    int ix = 0;
    int iy = 0;
    if(incx < 0)
      ix = (-n+1)*incx;
    if(incy < 0)
      iy = (-n+1)*incy;
    for(int i=0;i<n;i++) {
      B[iy+ry] = A[ix+rx];
      ix += incx;
      iy += incy;
    }
  }
  
  public static double nrm2(int n, double[] S, int incx, int r) {
    
    int ix;
    double absxi, scale, ssq;
    
    if(n < 1 || incx < 1)
      return 0;
    else if( n == 1) 
      return Math.abs(S[r]);
    
    scale = 0;
    ssq = 1; 
    
    for(ix = 0;ix < n*incx;ix+=incx) {
      if(S[r+ix] != 0) {
	absxi = Math.abs(S[r+ix]);
	if(scale < absxi) {
	  ssq = 1 + ssq*Math.pow((scale/absxi),2);
	  scale = absxi;
	}
	else 
	  ssq += Math.pow( absxi/scale,2);
      }
    }
    return (scale*Math.sqrt(ssq));
  }

  public static void rotg(Trig Qt) {
    
    DTrig Q = (DTrig) Qt;

    double Roe = Q.getB();
    double R;

    if(Math.abs(Q.getA()) > Math.abs(Roe)) 
      Roe = Q.getA();
    double scale = Math.abs(Q.getA()) + Math.abs(Q.getB());
    if(scale == 0) {
      Q.setCos(1);
      Q.setSin(0);
      R = 0;
    }
    else {
      R = scale*Math.sqrt(Math.pow(Q.getA()/scale,2)+
			  Math.pow(Q.getB()/scale,2));
      R = DUtil.signOf(1,Roe)*R;
      Q.setCos(Q.getA()/R);
      Q.setSin(Q.getB()/R);
    }
    double Z = 1;
    if(Math.abs(Q.getA()) > Math.abs(Q.getB())) 
      Z = Q.getSin();
    else if(Q.getCos() != 0) 
      Z = 1/Q.getCos();

    Q.setA(R);
    Q.setB(Z);
  }

  public static void Print(double[] S) {
    int n = S.length;
    System.out.print("Vector:  ");
    for(int i=0;i<n;i++) {
      System.out.print(S[i]+"   ");
    }
    System.out.println();
  }
  public static double aMax(double a, double b, double c, double d, double e) {
    double scale = Math.max(Math.abs(a),Math.abs(b));
    double scal2 = Math.max(Math.abs(c),Math.abs(d));
    scale = Math.max(scale,Math.abs(e));
    return Math.max(scale, scal2);
  }
}
