/*  
 ##  class FPoPack
 ##
 ##  This class contains the routines for positive definite matrices
 ##  in packed form.
 ##
 */

package edu.rice.linpack.Matrix.FMatrix;
import edu.rice.linpack.util.*;
import edu.rice.linpack.Vector.*;
import edu.rice.linpack.LNumber.*;

public class FPoPack extends FPacked {

  public FPoPack() {
    super();
    order = 0;
  }  
  public FPoPack(int o) {
    order = o;
    float r = (float).5*(o*(o+1));
    rows = (int) r;
    cols = 1;
    Mat = new float[rows][1];
  }
  public FPoPack(float[] f, int o) {
    rows = f.length;
    cols = 1;
    Mat = new float[rows][cols];
    for(int i=0;i<rows;i++) 
      Mat[i][0] = f[i];
    order = o;
  }
  public FPoPack(float[][] f, int o) {
    rows = f.length;
    cols = 1;
    order = o;
    Mat = new float[rows][1];
    for(int i=0;i<rows;i++) 
      Mat[i][0] = f[i][0];
  }
  public FPoPack(float[][] f) {
    cols = 1;
    order = f.length;
    float r = (float).5*(order*(order + 1));
    rows = (int) r;
    Mat = new float[rows][1];
    Mat = pack(f);
  }
  public FPoPack(FPoPack F) {
    rows = F.rows;
    cols = 1;
    Mat = new float[rows][1];
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) 
	Mat[i][j] = F.Mat[i][j];
    order = F.order;
  }
  public FPoPack(FPoFull F) {
    cols = 1;
    order = F.numofRows();
    float r = (float).5*(order*(order + 1));
    rows = (int)r;
    Mat = new float[rows][1];
    Mat = pack(F.Mat);
  }

  public FPoFull unpack() {
    int k = 0;
    int n = this.order;
    FPoFull R = new FPoFull(n,n);
    for(int j=0;j<n;j++) {
      for(int i=0;i<=j;i++) {
	R.Mat[i][j] = this.Mat[k][0];
	if(j != i)
	  R.Mat[j][i] = this.Mat[k][0];
	k++;
      }
    }	
    return R;
  }

  /* All have been completely tested
     
   */

  public void factor() 
       throws SingularMatrixException
  {
    int jj = -1;
    float S;

    for(int j=0;j<order;j++) {
      S = 0;
      if(j > 0) {
	int kj = (int)((float).5*(j*(j+1)));
	int kk = -1;
	for(int k=0;k<j;k++) {
	  float T = this.Mat[kj][0] - this.dot(k,1,kk+1,0,this,1,jj+1,0);
	  kk += k+1;
	  T = T/this.Mat[kk][0];
	  this.Mat[kj][0] = T;
	  S += T*T;
	  kj++;
	}
      }
      jj += j+1;
      S = this.Mat[jj][0] - S;
      if(S <= 0) 
	throw new SingularMatrixException(j+1);
      else 
	this.Mat[jj][0] = (float)Math.sqrt(S);
    }
  } 

  public LNumber condition() 
       throws SingularMatrixException, WrongDataTypeException
  {
    Vector Z = new FVector(order);
    return this.condition(Z);
  }
  public LNumber condition(Vector Ze) 
       throws SingularMatrixException, WrongDataTypeException
  {
    float[] Z = Ze.getFloatArray();

    float anorm = this.oneNorm();

    //  Factor  //

    this.factor();

    for(int j=0;j<order;j++) 
      Z[j] = 0;
    
    this.solveTransUW(Z);
      
    float S = 1/FUtil.asum(order,Z,1);
    FUtil.scal(order,S,Z,1);
     
    this.solveUZ(Z);

    float ynorm = this.solveTransRV(Z);
    
    ynorm = this.solveUZ(Z,ynorm);
      
    LFloat R;

    if(anorm != 0)
      R = new LFloat(ynorm/anorm);
    else
      R = new LFloat(anorm);

    return R;
  }
  private void solveTransUW(float[] Z) {
    float ek = 1;
    int kk = -1;
    for(int k=0;k<order;k++) {
      int kp = k+1;
      kk += kp;
      if(Z[k] != 0) 
	ek = FUtil.signOf(ek,-Z[k]);
      if(Math.abs(ek-Z[k]) > this.Mat[kk][0]) {
	float S = this.Mat[kk][0]/Math.abs(ek-Z[k]);
	FUtil.scal(order,S,Z,1);
	ek *= S;
      }
      float wk = ek - Z[k];
      float wkm = -ek - Z[k];
      float S = Math.abs(wk);
      float SM = Math.abs(wkm);
      wk = wk/this.Mat[kk][0];
      wkm = wkm/this.Mat[kk][0];
      int kj = kk + kp;
      if(kp < order) {
	for(int j=kp;j<order;j++) {
	  SM += Math.abs(Z[j] + wkm*this.Mat[kj][0]);
	  Z[j] += wk*this.Mat[kj][0];
	  S += Math.abs(Z[j]);
	  kj += j+1;
	}
	if(S < SM) {
	  float T = wkm - wk;
	  wk = wkm;
	  kj = kk + kp;
	  for(int j=kp;j<order;j++) {
	    Z[j] += T*this.Mat[kj][0];
	    kj += j+1;
	  }
	}
      }
      Z[k] = wk;
    }
  }
  private float solveUZ(float[] Z, float ynorm) {
    
    int kk = order*(order+1)/2 - 1;
    for(int k=order-1;k>=0;k--) {
      if(Math.abs(Z[k]) > this.Mat[kk][0]) {
	float S = this.Mat[kk][0]/Math.abs(Z[k]);
	FUtil.scal(order,S,Z,1);
	ynorm *= S;
      }
      Z[k] = Z[k]/this.Mat[kk][0];
      kk = kk - k - 1;
      this.axpy(k,-Z[k],1,kk+1,0,Z,1,0);
    }
    float S = 1/FUtil.asum(order,Z,1);
    FUtil.scal(order,S,Z,1);
    ynorm *= S;

    return ynorm;
  }
  private void solveUZ(float[] Z) {
    int kk = order*(order+1)/2 - 1;
    for(int k=order-1;k>=0;k--) {
      if(Math.abs(Z[k]) > this.Mat[kk][0]) {
	float S = this.Mat[kk][0]/Math.abs(Z[k]);
	FUtil.scal(order,S,Z,1);
      }
      Z[k] = Z[k]/this.Mat[kk][0];
      kk = kk - k - 1;
      this.axpy(k,-Z[k],1,kk+1,0,Z,1,0);
    }
    float S = 1/FUtil.asum(order,Z,1);
    FUtil.scal(order,S,Z,1);
  }
  private float solveTransRV(float[] Z) {
    
    int kk = -1;
    float ynorm = 1;
    for(int k=0;k<order;k++) {
      Z[k] -= this.dot(k,1,kk+1,0,Z,1,0);
      kk += k+1;
      if(Math.abs(Z[k]) > this.Mat[kk][0]) {
	float S = this.Mat[kk][0]/Math.abs(Z[k]);
	FUtil.scal(order,S,Z,1);
	ynorm *= S;
      }
      Z[k] = Z[k]/this.Mat[kk][0];
    }
    float S = 1/FUtil.asum(order,Z,1);
    FUtil.scal(order,S,Z,1);
    ynorm *= S;
  
    return ynorm;
  }
  
  
  public void solve(Vector B, int J) 
       throws WrongDataTypeException
  {
    this.solve(B);
  }
  public void solve(Vector Be) 
       throws WrongDataTypeException
  {
    
    float[] B = Be.getFloatArray();

    int kk = -1;
    for(int k = 0;k<order;k++) {
      float T = this.dot(k,1,kk+1,0,B,1,0);
      kk += k+1;
      B[k] = (B[k] - T)/this.Mat[kk][0];
    }
    for(int kb=0;kb<order;kb++) {
      int k = order - kb - 1;
      B[k] = B[k]/this.Mat[kk][0];
      kk -= k+1;
      this.axpy(k,-B[k],1,kk+1,0,B,1,0);
    }
  }
  
  public Vector determ() {
    
    float[] Det = new float[2];
    
    Det[0] = 1;
    Det[1] = 0;
    
    int ii = 0;
    for(int k=0;k<order;k++) {
      Det[0] *= Math.pow(this.Mat[ii][0],2); 
      
      if(Det[0] == 0) {
	FVector V = new FVector(Det);
	return V;
      }
      else 
	FUtil.detNorm(Det);
      ii += k+2;
    }
    FVector V2 = new FVector(Det);
    return V2;
  }

  public void inverse() {
    int kk = 0;
    int k1 = 0;
    for(int k=0;k<order;k++) {
      this.Mat[kk][0] = 1/this.Mat[kk][0];
      float T = -this.Mat[kk][0];
      this.scal(k,T,1,k1,0);
      int kp = k+1;
      int j1 = kk+1;
      int kj = kk+k+1;
      if(order > kp) {
	for(int j=kp;j<order;j++) {
	  T = this.Mat[kj][0];
	  this.Mat[kj][0] = 0;
	  this.axpy(k+1,T,1,k1,0,this,1,j1,0);
	  j1 += j+1;
	  kj += j+1;
	}
      }
      k1 = kk+1;
      kk += k+2;
    }
    int jj = 0;
    int j1 = 0;
    for(int j=0;j<order;j++) {
      int jm = j-1;
      k1 = 0;
      int kj = j1;
      if(j > 0) {
	for(int k=0;k<j;k++) {
	  float T = this.Mat[kj][0];
	  this.axpy(k+1,T,1,j1,0,this,1,k1,0);
	  k1 += k+1;
	  kj++;
	}
      }
      float T = this.Mat[jj][0];
      this.scal(j+1,T,1,j1,0);
      j1 = jj + 1;
      jj += j+2;
    }
  }
}




