h17521
s 00004/00002/00426
d D 1.4 98/08/28 15:40:35 jpiper 5 4
c 
e
s 00001/00001/00427
d D 1.3 98/08/03 18:47:56 jpiper 4 3
c made small changes
e
s 00000/00000/00428
d D 1.2 98/07/27 14:08:32 jpiper 3 1
c fixed constructor
e
s 00000/00000/00000
d R 1.2 98/07/27 09:26:39 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/FMatrix/FBanded.java
e
s 00428/00000/00000
d D 1.1 98/07/27 09:26:38 zoran 1 0
c date and time created 98/07/27 09:26:38 by zoran
e
u
U
f e 0
t
T
I 1
/*
 ##  class FBanded
 ##  
 ##  This class holds the frame for matrices stored in banded form.
 ##  It also contains the Gaussian routines for banded matrices.
 ##
 */


package edu.rice.linpack.Matrix.FMatrix;
import edu.rice.linpack.LNumber.*;
import edu.rice.linpack.util.*;
import edu.rice.linpack.Vector.*;

public class FBanded extends FMatrix {

  protected int mu, ml;

  public FBanded() {
    super();
    cons();
  }
  public FBanded(int ML, int MU, int columns) {
    cons(2*ML+MU+1,columns);
    mu = MU;
    ml = ML;
  }
  // This is for unbanded float arrays //
  public FBanded(float[][] f, int ML, int MU) {
    mu = MU;
D 4
    ml = ml;
E 4
I 4
    ml = ML;
E 4
    Mat = band(f,ml,mu);
    rows = Mat.length;
    cols = Mat[0].length;
    pivot = new int[cols];
  }
  // This is for banded float arrays //
  public FBanded(float[][] f, int ML) {
    cons(f);
    ml = ML;
    mu = f.length - 1 - 2*ML;
  }
  public FBanded(FFull F, int Ml, int Mu) {
    mu = Mu;
    ml = Ml;
    Mat = band(F.Mat,ml,mu);
    rows = Mat.length;
    cols = Mat[0].length;
    pivot = new int[cols];
  }
  public FBanded(FBanded F) {
    cons(F);
    mu = F.mu;
    ml = F.ml;
  }

  private float[][] band(float[][] f, int Ml, int Mu) {
    int n = f[0].length;
    float[][] Fband = new float[2*ml+mu+1][n];
    int M = Ml + Mu;
    for(int j=0;j<n;j++) {
      int i1 = Math.max(0,j-Mu);
      int i2 = Math.min(n,j+Ml+1);
      for(int i=i1;i<i2;i++) {
	int k = i - j + M;
	Fband[k][j] = f[i][j];
      }
    }
    return Fband;
  }
  public FFull unband() {
    FFull Fband = new FFull(cols,cols);
    int M = ml + mu;
    for(int j=0;j<cols;j++) {
      int i1 = Math.max(0,j-mu);
      int i2 = Math.min(cols,j+ml+1);
      for(int i=i1;i<i2;i++) {
	int k = i - j + M;
	Fband.Mat[i][j] = this.Mat[k][j];
      }
    }
    return Fband;
  }  
  
  public float oneNorm() {
    float anorm = 0;
    int L = ml;
    int is = L + mu;
    for(int j=0;j<cols;j++) {
      anorm = Math.max(anorm,this.asum(L+1,1,is,j));
      if(is > ml) 
	is--;
      if(j < mu)
	L++;
      if(j >= cols-ml-1)
	L--;  
    }
    return anorm;
  }

  /*  Factor and solve are both completely checked
      Determ is fully tested and works fine.  
      Condition is fully tested and works fine.
      */

  /*  Pivots are java based  */

  public void factor() 
       throws SingularMatrixException
  {
    
    int info = 0;
    int M = ml + mu + 1;
    float T;
    
    int Ji = Math.min(cols,M) - 1;
    int io;
    for(int Jz=mu+1;Jz < Ji;Jz++) {
      io = M - 1 - Jz;
      for(int i=io;i < ml;i++) 
	this.Mat[i][Jz] = 0;
    }
    
    int Jz = Ji;
    int Ju = 0;
    
    /* Gaussian elimination with partial pivoting */

    int colsm = cols - 1;
    if(cols > 1) {
      int kp;
      for(int k=0;k<colsm;k++,Jz++) {
	kp = k+1;
	if(Jz < cols) 
	  for(int i=0;i<ml;i++) 
	    this.Mat[i][Jz] = 0;
	
	int lm = Math.min(ml, colsm-k) - 1;
	int L = this.i_amax(lm+2,1,M-1,k) + M - 1;
	pivot[k] = L + kp - M;

	if(this.Mat[L][k] != 0) {
	  if(L != M-1) 
	    this.swapElem(L,k,M-1,k);
	  
	  T = (float)-1.0/this.Mat[M-1][k];
	  this.scal(lm+1,T,1,M,k);
	  
	  /*  ROW ELIMINATION WITH COLUMN INDEXING */

	  Ju = Math.min(Math.max(Ju,mu+pivot[k]),colsm);
	  int MM = M-2;
	  for(int j=kp;j<=Ju;j++) {
	    L--;
	    T = this.Mat[L][j];
	    if(L != MM) 
	      this.swapElem(L,j,MM,j);
	    this.axpy(lm+1, T,1,M,k,this,1,MM+1,j);
	    MM--;
	  }
	}
	else 
	  info = k+1;
      }
    }
    pivot[cols-1] = cols-1;
    if(this.Mat[M-1][cols-1] == 0) 
      info = cols;
    if(info != 0)
      throw new SingularMatrixException(info);
  }

  public LNumber condition() 
       throws SingularMatrixException, WrongDataTypeException
  {
    Vector Z = new FVector(cols);
    return this.condition(Z);
  }
  public LNumber condition(Vector Ze) 
       throws SingularMatrixException, WrongDataTypeException
  {
    float[] Z = Ze.getFloatArray();
    
    // Compute 1-Norm of this //

    float anorm = this.oneNorm();
    float ynorm;

    // Factor //

    try {
      this.factor();
    } finally {
    
      // Rcond = 1/(norm(this) * (Estimate of norm(inv(this)))) //
      
      for(int j=0;j<cols;j++)
	Z[j] = 0;
      
      int M = ml + mu;
      
      this.solveTransUW(M,Z);
      
      float S = (float)1.0/FUtil.asum(cols,Z,1);
      FUtil.scal(cols,S,Z,1);
     
      this.solveLV(M,Z);
      
      ynorm = this.solveTransLY(M,Z);
    
      // Solve U*Z = W //
      
      ynorm = this.solveUZ(M,Z,ynorm);
    }   
D 5
    LFloat R = new LFloat();
E 5
I 5
    LFloat R;
E 5
    
    if(anorm != 0)
D 5
      R.setFloat(ynorm/anorm);
E 5
I 5
      R = new LFloat(ynorm/anorm);
    else
      R = new LFloat(anorm);
E 5
    
    return R;
  }
  private void solveTransUW(int M, float[] Z) {

    float ek = 1;
    int Ju = 0;
    for(int k=0;k<cols;k++) {
      
      if(Z[k] != 0) 
	ek = FUtil.signOf(ek,-Z[k]);
      if(Math.abs(ek-Z[k]) > Math.abs(this.Mat[M][k])) {
	float S = Math.abs(this.Mat[M][k])/Math.abs(ek-Z[k]);
	FUtil.scal(cols,S,Z,1);
	ek *= S;
      }
      
      float wk = ek - Z[k];
      float wkm = -ek - Z[k];
      float S = Math.abs(wk);
      float SM = Math.abs(wkm);
      if(this.Mat[M][k] != 0) {
	wk = wk/this.Mat[M][k];
	wkm = wkm/this.Mat[M][k];
      }
      else {
	wk = 1;
	wkm = 1;
      }
      int kp = k + 1;
      Ju = Math.min(Math.max(Ju,mu+pivot[k]+1),cols);
      int MM = M-1;
      if(kp < Ju) {
	for(int j=kp;j<Ju; j++,MM--) {
	  SM += Math.abs(Z[j]+wkm*this.Mat[MM][j]);
	  Z[j] += wk*this.Mat[MM][j];
	  S += Math.abs(Z[j]);
	}
	if(S < SM) {
	  float T = wkm - wk;
	  wk = wkm;
	  MM = M-1;
	  for(int j=kp;j<Ju;j++,MM--) 
	    Z[j] += T*this.Mat[MM][j];
	}
      }
      Z[k] = wk;
    }
  }
  private void solveLV(int M, float[] Z) {
    
    for(int k=cols-1;k>=0;k--) {
      int lm = Math.min(ml,cols-k-1);
      if(k < cols-1)
	Z[k] += this.dot(lm, 1,M+1,k, Z, 1, k+1);
      if(Math.abs(Z[k]) > 1) {
	float S = (float)1.0/Math.abs(Z[k]);
	FUtil.scal(cols,S,Z,1);
      }
      int L = pivot[k];
      FUtil.swapElems(Z,L,k);
    }
    
    float S = (float)1.0/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
  }
  private float solveTransLY(int M, float[] Z) {
    float ynorm = 1;

    for(int k=0;k<cols;k++) {
      int L = pivot[k];
      FUtil.swapElems(Z,L,k);
      int lm = Math.min(ml,cols-k-1);
      if(k < cols)
	this.axpy(lm,Z[k],1,M+1,k, Z, 1, k+1);
      if(Math.abs(Z[k]) > 1) {
	float S = (float)1.0/Math.abs(Z[k]);
	FUtil.scal(cols,S,Z,1);
	ynorm *= S;
      }
    }
    float S = (float)1.0/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
    ynorm *= S;
    
    return ynorm;
  }
  float solveUZ(int M, float[] Z, float ynorm){
    
    for(int k=cols-1;k>=0;k--) {
      if(Math.abs(Z[k]) > Math.abs(this.Mat[M][k])) {
	float S = Math.abs(this.Mat[M][k])/Math.abs(Z[k]);
	FUtil.scal(cols,S,Z,1);
	ynorm *= S;
      }
      
      if(this.Mat[M][k] != 0)
	Z[k] /= this.Mat[M][k];
      else
	Z[k] = 1;
      int lm = Math.min(k,M);
      int la = M - lm;
      int lz = k - lm;
      float T = -Z[k];
      this.axpy(lm,T,1,la,k,Z,1,lz);
    }

    float S = (float)1.0/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
    ynorm *= S;
  
    return ynorm;
  }
  
  public void solve(Vector B) 
       throws WrongDataTypeException
  {
    this.solve(B,0);
  }
  public void solve(Vector Be, int Job) 
       throws WrongDataTypeException
  {
    
    float[] B = Be.getFloatArray();

    int M = mu+ml+1;
    int nm = cols-1;
    float T;

    if(Job == 0) {
      if(ml != 0) {
	if(nm > 0) {
	  for(int k=0;k<nm;k++) {
	    int lm = Math.min(ml,nm-k);
	    int l = pivot[k];
	    T = B[l];
	    if(l != k) 
	      FUtil.swapElems(B,l,k);
	    this.axpy(lm,T,1,M,k,B,1,k+1);
	  }
	}
      }

      //  Solve U*X=Y  //

      this.solveRX(M-1,B);

    }
    else {

      //  Job is non-zero, solve trans(A)*X=B  //

      this.solveTransRY(M-1,B);

      if(ml != 0) {
	for(int k=cols-2;k>=0;k--) {
	  int lm = Math.min(ml,nm-k);
	  B[k] += this.dot(lm,1,M,k,B,1,k+1);
	  int l = pivot[k];
	  if(l != k) 
	    FUtil.swapElems(B,l,k);
	}
      }
    }
    return; 
  }
  void solveTransRY(int M, float[] B) {
    for(int k=0;k<cols;k++) {
      int lm = Math.min(k,M);
      int la = M-lm;
      int lb = k-lm;
      float T = this.dot(lm,1,la,k,B,1,lb);
      B[k] = (B[k] - T)/this.Mat[M][k];
    }
  }
  void solveRX(int M, float[] B){
    for(int k=cols-1;k>=0;k--) {
      int LM = Math.min(k,M);
      int la = M - LM;
      int lb = k - LM;
      B[k] /= this.Mat[M][k];
      float T = -B[k];
      this.axpy(LM,T,1,la,k,B,1,lb);
    }
  }
	    
  public Vector determ() {
    
    float[] Det = new float[2];
    int M = mu + ml + 1;
    
    Det[0] = 1;
    Det[1] = 0;

    for(int i=0;i<cols;i++) {
      if(pivot[i] != i) 
	Det[0] = -Det[0];
      Det[0] *= this.Mat[M-1][i];
      
      if(Det[0] == 0) {
	FVector V = new FVector(Det);
	return V;
      }      
      else 
	FUtil.detNorm(Det);
    }
    FVector V2 = new FVector(Det);
    return V2;
  }
}
E 1
