h55720
s 00000/00000/00000
d R 1.2 98/07/27 09:26:44 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/FMatrix/FTriFull.java
e
s 00063/00000/00000
d D 1.1 98/07/27 09:26:43 zoran 1 0
c date and time created 98/07/27 09:26:43 by zoran
e
u
U
f e 0
t
T
I 1
/*
 ##  class FTriFull
 ##
 ##  This class contains the framework for triangular matrices.
 ##
 */

package edu.rice.linpack.Matrix.FMatrix;
import edu.rice.linpack.util.*;
import edu.rice.linpack.Vector.*;
import edu.rice.linpack.LNumber.*;

public abstract class FTriFull extends FFull {

  public abstract LNumber condition(Vector Z)
       throws WrongDataTypeException, SingularMatrixException;  
  public abstract void solve(Vector B, int J)
       throws WrongDataTypeException;
  public abstract void inverse();

  public void solve(Vector Be) 
       throws WrongDataTypeException
  {
    this.solve(Be,0);
  }


  void zeroDiag() 
       throws SingularMatrixException
  {
    for(int i=0;i<cols;i++) {
      if(this.Mat[i][i] == 0) 
	throw new SingularMatrixException(i+1);
    }
  }

  public void factor() 
       throws SingularMatrixException
  {
    this.zeroDiag();
  }
 
  public Vector determ() {
    
    float[] Det = new float[2];        
    Det[0] = 1;
    Det[1] = 0;
    
    for(int i=0;i<cols;i++) {
      Det[0] *= this.Mat[i][i];
      
      if(Det[0] == 0) {
	Det[1] = 0;
	FVector D = new FVector(Det);
	return D;
      }
      else 
	FUtil.detNorm(Det);
    }
    FVector De = new FVector(Det);
    return De;
  }
}
E 1
