package edu.rice.linpack.Matrix.FMatrix;
import edu.rice.linpack.util.*;

public abstract class FUtil {

  public static float asum(int n, float[] V, int incx) {
    float dasum = 0;
    int ix = 0;
    for(int i=0;i<n;i++,ix+=incx) 
      dasum += Math.abs(V[ix]);
    return dasum;
  }

  public static void scal(int n, float Da, float[] V, int incx) {
    scal(n,Da,V,incx,0);
  }
  public static void scal(int n, float Da, float[] V, int incx, int r) {
    if(n > 0 && Da != 1) {
      int ix = 0;
      for(int i=0;i<n;i++,ix += incx)
	V[ix+r] *= Da;
    }
    return;
  }

  public static float signOf(float ek, float zk) {
    if(zk < 0) 
      return -Math.abs(ek);
    return Math.abs(ek);
  }
  
  public static void swapElems(float[] Z, int k1, int k2) {
    float temp = Z[k1];
    Z[k1] = Z[k2];
    Z[k2] = temp;
  }
  public static void swapElems(int[] Z, int k1, int k2) {
    int temp = Z[k1];
    Z[k1] = Z[k2];
    Z[k2] = temp;
  }

  public static void detNorm(float[] Det) {
    while(Math.abs(Det[0]) < 1) {
      Det[0] *= 10;
      Det[1] -= 1;
    }
    while(Math.abs(Det[0]) >= 10) {
      Det[0] /= 10;
      Det[1]++;
    }
  }
  public static void copy(int n, float[] A, int incx, int rx, 
			  float[] B, int incy, int ry) {
    if(n <= 0)
      return;
    
    int ix = 0;
    int iy = 0;
    if(incx < 0)
      ix = (-n+1)*incx;
    if(incy < 0)
      iy = (-n+1)*incy;
    for(int i=0;i<n;i++) {
      B[iy+ry] = A[ix+rx];
      ix += incx;
      iy += incy;
    }
  }
  public static float dot(int n, float[] A, int incx, int rx, 
			  float[] B, int incy, int ry) {

    float N = 0;
    
    if(n > 0){
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      
      for(int i=0; i<n;i++,ix+= incx,iy += incy) 
	N += A[rx+ix] * B[ry+iy];
    }
    return N;
  }

  public static float nrm2(int n, float[] S, int incx, int r) {
    
    int ix;
    float absxi, scale, ssq;
    
    if(n < 1 || incx < 1)
      return 0;
    else if( n == 1) 
      return Math.abs(S[r]);
    
    scale = 0;
    ssq = 1; 
    
    for(ix = 0;ix < n*incx;ix+=incx) {
      if(S[r+ix] != 0) {
	absxi = Math.abs(S[r+ix]);
	if(scale < absxi) {
	  ssq = 1 + ssq*(float)Math.pow((scale/absxi),2);
	  scale = absxi;
	}
	else 
	  ssq += (float)Math.pow( absxi/scale,2);
      }
    }
    return (scale*(float)Math.sqrt(ssq));
  }

  public static void rotg(Trig Qt) {
    
    FTrig Q = (FTrig) Qt;

    float Roe = Q.getB();
    float R;

    if(Math.abs(Q.getA()) > Math.abs(Roe)) 
      Roe = Q.getA();
    float scale = Math.abs(Q.getA()) + Math.abs(Q.getB());
    if(scale == 0) {
      Q.setCos(1);
      Q.setSin(0);
      R = 0;
    }
    else {
      R = scale*(float)Math.sqrt(Math.pow(Q.getA()/scale,2)+
				 Math.pow(Q.getB()/scale,2));
      R = FUtil.signOf(1,Roe)*R;
      Q.setCos(Q.getA()/R);
      Q.setSin(Q.getB()/R);
    }
    float Z = 1;
    if(Math.abs(Q.getA()) > Math.abs(Q.getB())) 
      Z = Q.getSin();
    else if(Q.getCos() != 0) 
      Z = 1/Q.getCos();

    Q.setA(R);
    Q.setB(Z);
  }

  public static void Print(float[] S) {
    int n = S.length;
    System.out.print("Vector:  ");
    for(int i=0;i<n;i++) {
      System.out.print(S[i]+"   ");
    }
    System.out.println();
  }
  public static float aMax(float a, float b, float c, float d, float e) {
    float scale = Math.max(Math.abs(a),Math.abs(b));
    float scal2 = Math.max(Math.abs(c),Math.abs(d));
    scale = Math.max(scale,Math.abs(e));
    return Math.max(scale, scal2);
  }
}
