/*## 
 ##  class Matrix 
 ##  
 ##  This class holds the basic structure of the
 ##  classes that extended it.
 ## 
 ##*/

package edu.rice.linpack.Matrix;
import java.lang.*;
import edu.rice.linpack.util.*;
import edu.rice.linpack.Vector.*;
import edu.rice.linpack.LNumber.*;

public abstract class Matrix {

  protected int rows, cols;
  protected int[] pivot;
  
  public int numofRows() {
    return rows;
  }
  public int numofCols() {
    return cols;
  }
  public int[] getPivots() {
    return pivot;
  }
  
  public void factor() 
       throws SingularMatrixException, UnsupportedMethodException
  {
    throw new UnsupportedMethodException();
  }
  public LNumber condition()
       throws WrongDataTypeException, SingularMatrixException, 
	 UnsupportedMethodException
  {
    throw new UnsupportedMethodException();
  }
  public LNumber condition(Vector Z)
       throws WrongDataTypeException, SingularMatrixException,
	 UnsupportedMethodException
  {
    throw new UnsupportedMethodException();
  }
  public void solve(Vector B, int i)
       throws WrongDataTypeException, UnsupportedMethodException,   
	 UnsupportedMethodException
  {
    throw new UnsupportedMethodException();
  }
  public void solve(Vector B)
       throws WrongDataTypeException, SingularMatrixException,
	 UnsupportedMethodException
  {
    throw new UnsupportedMethodException();
  }
  public void inverse() 
       throws UnsupportedMethodException
  {
    throw new UnsupportedMethodException();
  }
  public Vector determ() 
       throws UnsupportedMethodException
  {
    throw new UnsupportedMethodException();
  }
  public void Factor_and_Solve(Vector B) 
       throws WrongDataTypeException, SingularMatrixException, 
	 UnsupportedMethodException
  {
    this.factor();
    this.solve(B);
  }

  public abstract void copy(int n, int incx, int rowx, int colx, 
			    Vector B, int incy)
       throws WrongDataTypeException;
  public abstract void copy(int n, int incx, int rowx, int colx,
			    Matrix B, int incy, int rowy, int coly);
  public abstract void swap(int n, int incx, int rowx, int colx,
			    Matrix B, int incy, int rowy, int coly);
  public abstract void swapElem(int rowX, int colX, int rowY, int colY);
  public abstract int i_amax(int n, int incx, int row, int col);
  public abstract void rotg(int r, int c, Trig Tger);
  public abstract void rot(int n, int incx, int rx, int cx, Matrix B,
			   int incy, int ry, int cy, Trig Tger);
}
