/*  
 ##  class NPacked
 ##  
 ##  This class holds the framework for a matrix stored in packed form.
 ##  It contains all the necessary basic routines for matrices adjusted
 ##  for its form.
 ##
 */

package edu.rice.linpack.Matrix.NMatrix;
import edu.rice.linpack.LNumber.*;
import edu.rice.linpack.util.*;

public abstract class NPacked extends NMatrix {
  
  protected int order;
  
  public abstract void factor()
       throws SingularMatrixException;
       
  public abstract LNumber condition()
       throws SingularMatrixException;
  public abstract LNumber condition(LNumber[] Z)
       throws SingularMatrixException;

  public abstract void solve(LNumber[] B, int J);
  public abstract void solve(LNumber[] B);

  public abstract LNumber[] determ();
  public abstract void inverse();

  public LNumber getElem(int i) {
    return Mat[i][0];
  }
  public LNumber[] getColumn(int q) {
    return getColumn(0,q);
  }
  public int getOrder() {
    return order;
  }
  public static LNumber[][] pack(LNumber[][] f) {
    int k = 0;
    int n = f.length;
    LNumber[][] R = new LNumber[(n*(n+1))/2][1];
    for(int j=0;j<n;j++) {
      for(int i=0;i<=j;i++) {
	R[k][0] = f[i][j];
	k++;
      }
    }	
    return R;
  }

  public void setColumn(int c,NPacked F) {
    for(int r=0;r<rows;r++) {
      this.Mat[r+c][0] = F.Mat[r][0];
    }
  }
  public void setColumn(int n, int rx, LNumber[] f, int ry) {
    for(int i=0;i<n;i++) {
      this.Mat[i+rx][0] = f[i+ry];
    }
  }
  public void swapElem(int rx, int ry) {
    this.swapElem(rx,0,ry,0);
  }
  
  protected LNumber oneNorm() {
    LNumber[] Z = new LNumber[order];
    
    int j1 = 0;
    for(int j=0;j<order;j++) {
      Z[j] = this.asum(j+1,1,j1,0);
      int ij = j1;
      j1 += j+1;
      for(int i=0;i<j;i++) {
	Z[i].addTo(Mat[ij][0].abs());
	ij++;
      }
    }
    LNumber anorm = Z[0];
    for(int j=1;j<order;j++) 
      anorm.maxTo(Z[j]);
    
    return anorm.Clone();
  }

  public void Print() {
    for(int n=0;n<order;n++) {
      System.out.println();
      for(int j=0;j<order;j++) {
	if(j < n) 
	  System.out.print("           ");
	else {
	  int q = j*(j+1)/2 + n;
	  Mat[q][0].Print();
	  System.out.print("    ");
	}
      }
    }
    System.out.println();
  }
}
