package edu.rice.linpack.Matrix.NMatrix;

import edu.rice.linpack.util.*;
import edu.rice.linpack.LNumber.*;

public class NPoDiag extends NTDiag {

  public NPoDiag() {
    super();
  }
  public NPoDiag(int i, int j) {
    super(2,j);
  }
  public NPoDiag(LNumber[][] f) {
    cols = f.length;
    rows = 2;
    Mat = new LNumber[2][cols];
    for(int i=0;i<cols-1;i++) {
      Mat[1][i] = f[i][i];
      Mat[0][i] = f[i][i+1];
    }
    Mat[1][cols-1] = f[cols-1][cols-1];
    Mat[0][cols-1] = f[cols-1][cols-1].Clone();
    Mat[0][cols-1].setZero();
  }
  public NPoDiag(LNumber[] a, LNumber[] b) {
    cols = a.length;
    rows = 2;
    Mat = new LNumber[2][cols];
    for(int i=0;i<cols-1;i++) {
      Mat[1][i] = a[i];
      Mat[0][i] = b[i];
    }
    Mat[1][cols-1] = a[cols-1];
    Mat[0][cols-1] = a[cols-1].Clone();
    Mat[0][cols-1].setZero();
  }
  public NPoDiag(NPoDiag F) {
    super(F);
  }

  public void solve(LNumber[] B) {
    if(cols == 1) 
      B[0].divTo(Mat[1][0]);
    else {
      int nm = cols-1;
      int nhalf = nm/2;
      
      if(cols > 2) {
	int kbm = nm-1;
	
	for(int k=0;k<nhalf;k++) {
	  LNumber T = Mat[0][k].div(Mat[1][k]);
	  Mat[1][k+1].subTo(T.mult(Mat[0][k]));
	  B[k+1].subTo(T.mult(B[k]));
	  T = Mat[0][kbm].div(Mat[1][kbm+1]);
	  Mat[1][kbm].subTo(T.mult(Mat[0][kbm]));
	  B[kbm].subTo(T.mult(B[kbm+1]));
	  kbm--;
	}
      }
      int kp = nhalf;
      
      //  Clean up for possible etc.  //

      if(cols%2 == 0) {
	LNumber T = Mat[0][kp].div(Mat[1][kp]);
	Mat[1][kp+1].subTo(T.mult(Mat[0][kp]));
	B[kp+1].subTo(T.mult(B[kp]));
	kp++;
      }
      
      //  Back solve  //

      B[kp].divTo(Mat[1][kp]);
      if(cols > 2) {
	int k = kp - 1;
	int kw = kp + nhalf;
	for(int kf = kp;kf<kw;kf++) {
	  B[k] = (B[k].sub(Mat[0][k].mult(B[k+1]))).div(Mat[1][k]);
	  B[kf+1] = (B[kf+1].sub(Mat[0][kf].mult(B[kf]))).div(Mat[1][kf+1]);
	  k--;
	}
      }
      if(cols%2 == 0) 
	B[0] = (B[0].sub(Mat[0][0].mult(B[1]))).div(Mat[1][0]);
    }
  }
}
