package edu.rice.linpack.Matrix.NMatrix;

import edu.rice.linpack.util.*;
import edu.rice.linpack.LNumber.*;

public class NSiFull extends NFull {

  public NSiFull() {
    super();
  }
  public NSiFull(int n, int j) {
    super(n,j);
  }
  public NSiFull(LNumber[][] f) {
    super(f);
  }
  public NSiFull(NSiFull F) {
    super(F);
  }

  public NSiPack pack() {
    NSiPack S = new NSiPack(this.Mat);
    return S;
  }

  public void transpose() {
  }

  public LNumber getElem(int i, int j) {
    if(i > j)
      return super.getElem(j,i);
    return super.getElem(i,j);
  }
  public LNumber[] getRow(int i) {
    return getRow(i,0);
  }
  public LNumber[] getColumn(int i) {
    return getRow(i,0);
  }
  public LNumber[] getColumn(int i, int j) {
    return getRow(i,j);
  }
  public LNumber[] getRow(int i, int j) {
    LNumber[] F = new LNumber[rows - j];
    for(int k=0;k<i && k<(rows-j);k++) {
      F[k] = Mat[j+k][i];
    }
    for(int k=i;k<(rows-j);k++) {
      F[k] = Mat[j+k][i];
    }
    return F;
  }
  public void setColumn(int c, LNumber[] F) {
    for(int r=0;r<c;r++) 
      Mat[r][c] = F[r].Clone();
    for(int r=c;r<rows;r++) 
      Mat[r][c] = F[r].Clone();
  }
  public void setElem(int i, int c, LNumber L) {
    if(i > c)
      super.setElem(c,i,L);
    else
      super.setElem(i,c,L);
  }

  protected LNumber oneNorm() {
    LNumber[] Z = new LNumber[cols];
    
    for(int j=0;j<cols;j++) {
      Z[j] = this.asum(j+1,1,0,j);
      for(int i=0;i<j;i++) {
	Z[i].addTo(Mat[i][j].abs());
      }
    }
    LNumber anorm = Z[0].Clone();
    for(int j=1;j<cols;j++) 
      anorm.maxTo(Z[j]);
    return anorm;
  }

  /*
      inertia returns values different from matlab in sparse mats.
      */ 

  public void factor() 
       throws SingularMatrixException
  {    
    int info = 0;
    int kstep = 1;
    boolean swap;
    
    LNumber alpha = Mat[0][0].Clone();
    alpha.setOne();
    alpha.addTo(Math.sqrt(17));
    alpha.divTo(8);
    
    for(int k=cols-1;k>=0;k-=kstep) {
      if (k == 0) {
	pivot[0] = 1;
	if(Mat[0][0].equals(0)) 
	  throw new SingularMatrixException(1);
      }
      else {
	int km = k - 1;
	
	LNumber absakk = Mat[k][k].abs();
	int imax = this.i_amax(k,1,0,k);
	LNumber colmax = Mat[imax][k].abs();
	
	if(absakk.greaterOrEqual(alpha.mult(colmax))) {
	  kstep = 1;
	  swap = false;
	}
	else {
	  LNumber rowmax = Mat[0][0].Clone();
	  rowmax.setZero();
	  for(int j=imax+1;j<=k;j++) 
	    rowmax.maxTo(Mat[imax][j].abs());
	  if(imax != 0) {
	    int jmax = this.i_amax(imax,1,0,imax);
	    rowmax.maxTo(Mat[jmax][imax].abs());
	  }
	  if((Mat[imax][imax].abs()).greaterOrEqual(alpha.mult(rowmax))) {
	    kstep = 1;
	    swap = true;
	  }
	  else {
	    if(absakk.greaterOrEqual(alpha.mult(colmax)
				     .mult(colmax.div(rowmax)))) {
	      kstep = 1;
	      swap = false;
	    }
	    else {
	      kstep = 2;
	      swap = (imax != km);
	    }
	  }
	}
	if((absakk.max(colmax)).equals(0)) {
	  pivot[k] = k+1;
	  info = k+1;
	}
	else {
	  if(kstep == 1) {
	    if(swap) {
	      this.swap(imax+1,1,0,imax,this,1,0,k);
	      for(int j=k;j>=imax;j--) 
		this.swapElem(j,k,imax,j);
	    }
	    for(int j=km;j>=0;j--) {
	      LNumber mulk = (Mat[j][k].div(Mat[k][k])).negateTo();
	      this.axpy(j+1,mulk,1,0,k,this,1,0,j);
	      Mat[j][k] = mulk;
	    }
	    if(swap) 
	      pivot[k] = imax+1;
	    else 
	      pivot[k] = k+1;
	  }
	  else {
	    if(swap) {
	      this.swap(imax+1,1,0,imax,this,1,0,km);
	      for(int j=km;j >= imax;j--) 
		this.swapElem(j,km,imax,j);
	      this.swapElem(km,k,imax,k);
	    }
	    if(k > 1) {
	      LNumber ak = Mat[k][k].div(Mat[km][k]);
	      LNumber akm = Mat[km][km].div(Mat[km][k]);
	      LNumber dnom = (ak.mult(akm)).subFrom(1);
	      for(int j=km-1;j>=0;j--) 
		this.mulk(k,j,ak,akm,dnom);
	    }
	    if(swap) 
	      pivot[k] = -imax - 1;
	    else 
	      pivot[k] =  -k;
	    pivot[km] = pivot[k];
	  }
	}
      }
    }
    if(info != 0) 
      throw new SingularMatrixException(info);
  }
  private void mulk(int k, int j, LNumber ak, LNumber akm, LNumber dnom) {
    int km = k-1;
    LNumber Bk = Mat[j][k].div(this.Mat[km][k]);
    LNumber Bkm = Mat[j][km].div(this.Mat[km][k]);
    LNumber Mulk = ((akm.mult(Bk)).sub(Bkm)).div(dnom);
    LNumber Mulkm = ((ak.mult(Bkm)).sub(Bk)).div(dnom);
    this.axpy(j+1,Mulk,1,0,k,this,1,0,j);
    this.axpy(j+1,Mulkm,1,0,km,this,1,0,j);
    Mat[j][k] = Mulk;
    Mat[j][km] = Mulkm;
  }
  
  public LNumber condition() 
       throws SingularMatrixException
  {
    LNumber[] Z = new LNumber[cols];
    return this.condition(Z);
  }
  public LNumber condition(LNumber[] Z) 
       throws SingularMatrixException
  {
    LNumber S;

    LNumber anorm = this.oneNorm();
    LNumber ynorm;

    //  Factor  //

    try {
      this.factor();
    } finally {

      //  Compute the inverse of the condition  //
      
      for(int j=0;j<cols;j++) {
	Z[j] = Mat[0][0].Clone();
	Z[j].setZero();
      }
      
      this.solveUDW(Z);
      
      //  Solve trans(U)*Y = W  //
      
      this.solveTransUY(Z);

      S = (NUtil.asum(cols,Z,1)).invTo();
      NUtil.scal(cols,S,Z,1);

      ynorm = this.solveUDV(Z);
    
      this.solveTransUY(Z);

      S = (NUtil.asum(cols,Z,1)).invTo();
      NUtil.scal(cols,S,Z,1);
      ynorm.multTo(S);
    }
    LNumber R;

    if(!anorm.equals(0))
      R = ynorm.div(anorm);
    else
      R = anorm;
    
    return R;
  }
  private void solveTransUY(LNumber[] Z) {

    int ks = 1;
    for(int k=0;k<cols;k+=ks) {
      ks = 1;
      if(pivot[k] < 0) 
	ks = 2;
      if(k != 0) {
	Z[k].addTo(this.dot(k,1,0,k,Z,1,0));
	if(ks == 2) 
	  Z[k+1].addTo(this.dot(k,1,0,k+1,Z,1,0));
	int kp = Math.abs(pivot[k]) - 1;
	if(kp != k) 
	  NUtil.swapElems(Z,k,kp);
      }
    }
  }
  private LNumber solveUDV(LNumber[] Z) {
    
    int ks = 1;
    LNumber ynorm = Z[0].Clone();
    ynorm.setOne();
    
    for(int k=cols-1;k>=0;k-=ks) {
      ks = 1;
      if(pivot[k] < 0) 
	ks = 2;
      if(k != ks-1) {
	int kp = Math.abs(pivot[k]) - 1;
	int kps = k - ks + 1;
	if(kp != kps) 
	  NUtil.swapElems(Z,kp,kps);
	this.axpy(k-ks+1,Z[k],1,0,k,Z,1,0);
	if(ks == 2) 
	  this.axpy(k-ks+1,Z[k-1],1,0,k-1,Z,1,0);
      }
      if(ks == 1) {
	if((Z[k].abs()).greaterThan(Mat[k][k].abs())) {
	  LNumber S = (Mat[k][k].abs()).div(Z[k].abs());
	  NUtil.scal(cols,S,Z,1);
	  ynorm.multTo(S);
	}
	if(Mat[k][k].equals(0)) 
	  Z[k].setOne();
	else 
	  Z[k].divTo(Mat[k][k]);
      }
      else 
	this.Zfixer(k, Z);
    }
    LNumber S = (NUtil.asum(cols,Z,1)).invTo();
    NUtil.scal(cols,S,Z,1);
    ynorm.multTo(S);
    
    return ynorm;
  }
  private void solveUDW(LNumber[] Z) {
    
    int ks = 1;
    LNumber ek = Z[0].Clone();
    ek.setOne();
    for(int k=cols-1;k>=0;k-=ks) {
      ks = 1;
      if(pivot[k] < 0) 
	ks = 2;
      int kp = Math.abs(pivot[k]) - 1;
      int kps = k + 1 - ks;
      if(kp != kps) 
	NUtil.swapElems(Z,kp,kps);
      if(!Z[k].equals(0)) 
	ek = NUtil.signOfA(ek,Z[k]);
      Z[k].addTo(ek);
      this.axpy(k-ks+1,Z[k],1,0,k,Z,1,0);
      if(ks == 1) {
	if((Z[k].abs()).greaterThan(Mat[k][k].abs())) {
	  LNumber S = (Mat[k][k].abs()).div(Z[k].abs());
	  NUtil.scal(cols,S,Z,1);
	  ek.multTo(S);
	}
	if(Mat[k][k].equals(0)) 
	  Z[k].setOne();
	else 
	  Z[k].divTo(Mat[k][k]);
      }
      else {
	if(!Z[k-1].equals(0)) 
	  ek = NUtil.signOfA(ek,Z[k-1]);
	Z[k-1].addTo(ek);
	axpy(k-ks+1, Z[k-1], 1,0,k-1,Z,1,0);
	this.Zfixer(k,Z);
      }
    }
    LNumber S = (NUtil.asum(cols,Z,1)).invTo();
    NUtil.scal(cols,S,Z,1);
  }
  private void Zfixer(int k, LNumber[] Z) {
    int km = k-1;
    LNumber ak = Mat[k][k].div(Mat[km][k]);
    LNumber akm = Mat[km][km].div(Mat[km][k]);
    LNumber bk = Z[k].div(Mat[km][k]);
    LNumber bkm = Z[km].div(Mat[km][k]);
    LNumber denom = (ak.mult(akm)).sub(1);	
    Z[k] = ((akm.mult(bk)).sub(bkm)).div(denom);
    Z[km] = ((ak.mult(bkm)).sub(bk)).div(denom);
  }

  public void solve(LNumber[] B, int Job) {
    this.solve(B);
  }
  public void solve(LNumber[] B) {
    
    //  Loop backward applying the transformations and D inv to B  //
    this.loopback(B);

    //  Loop forward applying the transformations  // 
    this.loopforward(B);
  }
  private void loopback(LNumber[] B) {
    int kstep = 1;
    for(int k=cols-1;k>=0;k-=kstep) {
      if(pivot[k] >= 0) {
	if(k != 0) {
	  int kp = pivot[k] - 1;
	  if(kp != k) 
	    NUtil.swapElems(B,k,kp);
	  this.axpy(k,B[k],1,0,k,B,1,0);
	}
	B[k].divTo(Mat[k][k]);
	kstep = 1;
      }
      else {
	int km = k-1;
	if(k != 1) {
	  int kp = Math.abs(pivot[k]) - 1;
	  if(kp != km) 
	    NUtil.swapElems(B,km,kp);
	  this.axpy(km,B[k],1,0,k,B,1,0);
	  this.axpy(km,B[km],1,0,km,B,1,0);
	}
	this.Zfixer(k,B);
	kstep = 2;
      }
    }
  }
  private void loopforward(LNumber[] B) {
    int kstep = 1;
    for(int k=0;k<cols;k+=kstep) {
      if(pivot[k] >= 0) 
	kstep = 1;
      else 
	kstep = 2;
      if(k != 0) {
	B[k].addTo(this.dot(k,1,0,k,B,1,0));
	if(kstep == 2) 
	  B[k+1].addTo(this.dot(k,1,0,k+1,B,1,0));
	int kp = Math.abs(pivot[k]) - 1;
	if(kp != k) 
	  NUtil.swapElems(B,k,kp);
      }
    }
  }

  public LNumber[] determ() {
    
    LNumber[] Det = new LNumber[2];
    Det[0] = Mat[0][0].Clone();
    Det[1] = Mat[0][0].Clone();
    Det[0].setOne();
    Det[1].setZero();
    
    LNumber Q1 = Mat[0][0].Clone();
    Q1.setZero();
    LNumber Q2 = Mat[0][0].Clone();
    Q2.setZero();
    TD G = new TD(Q1,Q2);

    for(int k=0;k<cols;k++) {

      this.TDer(G,k);
      Det[0].multTo(G.D);
      if(!Det[0].equals(0)) 
	NUtil.detNorm(Det);
    }
    return Det;
  }

  public int[] inertia() {

    int[] iner = new int[3];
    
    iner[0] = 0;
    iner[1] = 0;
    iner[2] = 0;
    
    LNumber Q1 = Mat[0][0].Clone();
    Q1.setZero();
    LNumber Q2 = Mat[0][0].Clone();
    Q2.setZero();
    TD A = new TD(Q1,Q2);
    
    for(int k=0;k<cols;k++) {
      this.TDer(A,k);
      
      if((A.D).greaterThan(0)) 
	iner[0] += 1;
      else if((A.D).equals(0)) 
	iner[2] += 1;
      else 
	iner[1] += 1;
    } 
    return iner;
  }
  private void TDer(TD A, int k) {
    A.D = Mat[k][k].Clone();
      
    if(pivot[k] < 0) {
      if((A.T).equals(0)) {
	A.T = Mat[k][k+1].abs();
	A.D = (((A.D).div(A.T)).mult(Mat[k+1][k+1])).sub(A.T);
      }
      else {
	A.D = (A.T).Clone();
	(A.T).setZero();
      }
    }
  }

  public void inverse() {
    
    LNumber[] Work = new LNumber[cols];
    int kstep;

    for(int k=0;k<cols;k+=kstep) {
      int kp = k + 1;
      if(pivot[k] >= 0) {
	Mat[k][k].invTo();
	
	if(k > 0) {
	  this.copy(k,1,0,k,Work,1);
	  for(int j=0;j<k;j++) {
	    Mat[j][k] = this.dot(j+1,1,0,j,Work,1,0);
	    this.axpy(j,Work[j],1,0,j,this,1,0,k);
	  }
	  Mat[k][k].addTo(this.dot(k,1,0,k,Work,1,0));
	}
	kstep = 1;
      }
      else {
	this.invAdj(k,kp);
	if(k > 0) {
	  this.copy(k,1,0,kp,Work,1);
	  
	  for(int j=0;j<k;j++) {
	    Mat[j][kp] = this.dot(j+1,1,0,j,Work,1,0);
	    this.axpy(j,Work[j],1,0,j,this,1,0,kp);
	  }
	  Mat[kp][kp].addTo(this.dot(k,1,0,kp,Work,1,0));
	  Mat[k][kp].addTo(this.dot(k,1,0,k,this,1,0,kp));
	  this.copy(k,1,0,k,Work,1);
	  
	  for(int j=0;j<k;j++) {
	    Mat[j][k] = this.dot(j+1,1,0,j,Work,1,0);
	    this.axpy(j,Work[j],1,0,j,this,1,0,k);
	  }
	  Mat[k][k].addTo(this.dot(k,1,0,k,Work,1,0));
	}
	kstep = 2;
      }
      int ks = Math.abs(pivot[k]) - 1;
      if(ks != kp) {
	this.swap(ks+1,1,0,ks,this,1,0,k);
	for(int j=k;j>=ks;j--) 
	  this.swapElem(j,k,ks,j);
	if(kstep != 1) 
	  this.swapElem(k,kp,ks,kp);
      }
    }
  }
  private void invAdj(int k, int kp) {
    LNumber T = Mat[k][kp].abs();
    LNumber ak = Mat[k][k].div(T);
    LNumber akp = Mat[kp][kp].div(T);
    LNumber akkp = Mat[k][kp].div(T);
    LNumber D = T.mult((ak.mult(akp)).sub(1));
    this.Mat[k][k] = akp.div(D);
    this.Mat[kp][kp] = ak.div(D);
    this.Mat[k][kp] = (akkp.div(D)).negateTo();
  }
}
