package edu.rice.linpack.Matrix.NMatrix;

import edu.rice.linpack.util.*;
import edu.rice.linpack.LNumber.*;

public class NSiPack extends NPacked {
  
  public NSiPack() {
    super();
    order = 0;
  }  
  public NSiPack(int o) {
    order = o;
    rows = (int)(.5*(order*(order + 1)));
    cols = 1;
    Mat = new LNumber[rows][1];
    pivot = new int[order];
  }
  public NSiPack(LNumber[] N, int o) {
    rows = N.length;
    cols = 1;
    Mat = new LNumber[rows][cols];
    for(int i=0;i<rows;i++) 
      Mat[i][0] = N[i];
    order = o;
    pivot = new int[order];
  }
  public NSiPack(LNumber[][] f, int o) {
    rows = f.length;
    cols = 1;
    order = o;
    Mat = new LNumber[rows][1];
    Mat = f;
    pivot = new int[order];
  }
  public NSiPack(LNumber[][] f) {
    cols = 1;
    order = f.length;
    rows = (int)(.5*(order*(order + 1)));
    Mat = new LNumber[rows][1];
    Mat = pack(f);
    pivot = new int[order];
  }
  public NSiPack(NSiPack N) {
    rows = N.numofRows();
    cols = 1;
    Mat = new LNumber[rows][1];
    for(int i=0;i<rows;i++) 
      Mat[i][0] = (N.getElem(i,0)).Clone();
    order = N.getOrder();
    pivot = new int[order];
  }
  public NSiPack(NSiFull F) {
    cols = 1;
    order = F.numofRows();
    float r = (float).5*(order*(order+1));
    rows = (int)r;
    Mat = new LNumber[rows][1];
    Mat = pack(F.Mat);
  }
  
  public NSiFull unpack() {
    int k = 0;
    int n = this.order;
    NSiFull R = new NSiFull(n,n);
    for(int j=0;j<n;j++) {
      for(int i=0;i<=j;i++) {
	R.Mat[i][j] = Mat[k][0];
	if(j != i)
	  R.Mat[j][i] = Mat[k][0];
	k++;
      }
    }	
    return R;
  }

  public void factor() 
       throws SingularMatrixException
  {

    int info = 0;
    int kstep = 1;
    boolean swap;
    int im = 0;

    LNumber alpha = Mat[0][0].Clone();
    alpha.setOne();
    alpha.addTo(Math.sqrt(17));
    alpha.divTo(8);

    int ik = (order*(order-1))/2 - 1;
    
    for(int k=order-1;k>=0;k -= kstep) {
      if(k == 0) {
	pivot[0] = 1;
	if(Mat[0][0].equals(0)) 
	  throw new SingularMatrixException(1);
      }
      else if(k > 0) {
	int km = k-1;
	int kk = ik+k+1;
	LNumber absakk = Mat[kk][0].abs();
	
	int imax = this.i_amax(k,1,ik+1,0);
	int imk = ik+imax+1;
	LNumber colmax = Mat[imk][0].abs();
	
	if(absakk.greaterOrEqual(alpha.mult(colmax))) {
	  kstep = 1;
	  swap = false;
	}
	else {
	  LNumber rowmax = colmax.Clone();
	  rowmax.setZero();
	  im = imax*(imax+1)/2 - 1;
	  int imj = im + 2*(imax+1);

	  for(int j=imax+1;j<=k;j++) {
	    rowmax.maxTo(Mat[imj][0].abs());
	    imj += j + 1;
	  }
	  if(imax != 0) {
	    int jmax = this.i_amax(imax,1,im+1,0);
	    int jmim = jmax+im;
	    rowmax.maxTo(Mat[jmim][0].abs());
	  }
	  int imim = imax+im+1;
	  if((Mat[imim][0].abs()).greaterOrEqual(alpha.mult(rowmax))) {
	    kstep = 1;
	    swap = true;
	  }
	  else if(absakk.greaterOrEqual(alpha.mult(colmax)
					.mult((colmax.div(rowmax))))) {
	    kstep = 1;
	    swap = false;
	  }
	  else {
	    kstep = 2;
	    swap = imax != km;
	  }
	}
	if((absakk.max(colmax)).equals(0)) {
	  pivot[k] = k + 1;
	  info = k+1;
	}
	else {
	  if(kstep == 1) {
	    if(swap) {
	      this.swap(imax+1,1,im+1,0,this,1,ik+1,0);
	      int imj = ik + imax + 1;
	      for(int j=k;j>=imax;j--) {
		int jk = ik + j + 1;
		this.swapElem(jk,imj);
		imj -= j;
	      }
	    }
	    int ij = ik - k;
	    for(int j=k-1;j>=0;j--) {
	      int jk = ik + j + 1;
	      LNumber mulk = (Mat[jk][0].div(Mat[kk][0])).negateTo();
	      this.axpy(j+1,mulk,1,ik+1,0,this,1,ij+1,0);
	      Mat[jk][0] = mulk;
	      ij -= j;
	    }
	    pivot[k] = k + 1;
	    if(swap) 
	      pivot[k] = imax + 1;
	  }
	  else {
	    int kmk = ik + k;
	    int ikm = ik - k;
	    
	    if(swap) {
	      this.swap(imax+1,1,im+1,0,this,1,ikm+1,0);
	      int imj = ikm + imax + 1;
	      for(int j=km;j>=imax;j--) {
		int jkm = ikm + j + 1;
		this.swapElem(jkm,imj);
		imj -= j;
	      }
	      this.swapElem(kmk,imk);
	    }
	    int km2 = k - 2;
	    if(km2 >= 0) {
	      LNumber ak = Mat[kk][0].div(Mat[kmk][0]);
	      int kmkm = ikm + k;
	      LNumber akm = Mat[kmkm][0].div(Mat[kmk][0]);
	      LNumber denom = (ak.mult(akm)).subFrom(1);
	      int ij = ik - k - (k-1);
	      for(int j=km2;j>=0;j--) {
		this.mulk(j,ik,ikm,kmk,ij,ak,akm,denom);
		ij -= j;
	      }
	    }
	    pivot[k] = -k;
	    if(swap) 
	      pivot[k] = -imax - 1;
	    pivot[k-1] = pivot[k];
	  }
	  ik -= k;
	  if(kstep == 2) 
	    ik -= k-2;
	}
      }
    }
    if(info != 0)
      throw new SingularMatrixException(info);
  }
  public void mulk(int j,int ik, int ikm, int kmk, int ij,
		   LNumber ak, LNumber akm, LNumber denom) {
    int jk = ik + j + 1;
    int jkm = ikm + j + 1;
    LNumber Bk = Mat[jk][0].div(Mat[kmk][0]);
    LNumber Bkm = Mat[jkm][0].div(Mat[kmk][0]);
    LNumber mulk = ((akm.mult(Bk)).sub(Bkm)).div(denom);
    LNumber mulkm = ((ak.mult(Bkm)).sub(Bk)).div(denom);
    this.axpy(j+1,mulk,1,ik+1,0,this,1,ij+1,0);
    this.axpy(j+1,mulkm,1,ikm+1,0,this,1,ij+1,0);
    Mat[jk][0] = mulk;
    Mat[jkm][0] = mulkm;
  }

  public LNumber condition() 
       throws SingularMatrixException
  {
    LNumber[] Z = new LNumber[order];
    return this.condition(Z);
  }
  public LNumber condition(LNumber[] Z) 
       throws SingularMatrixException
  {
    LNumber anorm = this.oneNorm();
    LNumber ynorm;

    try {
      this.factor();
    } finally {

      //  Solve norms  //
    
      for(int j=0;j<order;j++) {
	Z[j] = Mat[0][0].Clone();
	Z[j].setZero();
      }

      this.solveUDW(Z);
    
      this.solveTransUY(Z);
    
      LNumber S = (NUtil.asum(order,Z,1)).invTo();
      NUtil.scal(order,S,Z,1);
    
      ynorm = this.solveUDV(Z);

      this.solveTransUY(Z);
    
      S = (NUtil.asum(order,Z,1)).invTo();
      NUtil.scal(order,S,Z,1);
      ynorm.multTo(S);
    }
    LNumber R;
    if(!anorm.equals(0))
      R = ynorm.div(anorm);
    else
      R = anorm;
    
    return R;
  }
  private void solveUDW(LNumber[] Z) {
    LNumber ek = Z[0].Clone();
    ek.setOne();
    int topk = (order*(order-1))/2;
    int ks;
    for(int k=order-1;k >= 0;k-=ks) {
      int kk = topk+k;
      int topkm = topk-k;
      ks = 1;
      if(pivot[k] < 0) 
	ks = 2;
      int kp = Math.abs(pivot[k]) - 1;
      int kps = k+1-ks;
      if(kp != kps) 
	NUtil.swapElems(Z,kp,kps);
      if(!Z[k].equals(0)) 
	ek = NUtil.signOfA(ek,Z[k]); 
      Z[k].addTo(ek);
      this.axpy(k-ks+1,Z[k],1,topk,0,Z,1,0);
      if(ks == 1) {
	if((Z[k].abs()).greaterOrEqual(Mat[kk][0].abs())) {
	  LNumber S = (Mat[kk][0].abs()).div(Z[k].abs());
	  NUtil.scal(order,S,Z,1);
	  ek.multTo(S);
	}
	if(!Mat[kk][0].equals(0)) 
	  Z[k].divTo(Mat[kk][0]);
	else
	  Z[k].setOne();
      }
      else {
	if(!Z[k-1].equals(0))
	  ek = NUtil.signOfA(ek,Z[k-1]);
	Z[k-1].addTo(ek);
	this.axpy(k-ks+1,Z[k-1],1,topkm,0,Z,1,0);
	this.Zfixer(k,kk,topk-1,Z);
      }
      topk = topkm;
      if(ks == 2) 
	topk -= k-1;
    }
    LNumber S = (NUtil.asum(order,Z,1)).invTo();
    NUtil.scal(order,S,Z,1);
  }
  private void solveTransUY(LNumber[] Z) {
    int topk = 0;
    int ks = 1;
    for(int k=0;k<order;k+=ks) {
      ks = 1;
      if(pivot[k] < 0) 
	ks = 2;
      if(k != 0) {
	Z[k].addTo(this.dot(k,1,topk,0,Z,1,0));
	int topkp = topk + k + 1;
	if(ks == 2) 
	  Z[k+1].addTo(this.dot(k,1,topkp,0,Z,1,0));
	int kp = Math.abs(pivot[k]) - 1;
	if(kp != k) 
	  NUtil.swapElems(Z,k,kp);
      }
      topk += k+1;
      if(ks == 2) 
	topk += k+2;
    }
  }
  private LNumber solveUDV(LNumber[] Z) {
    
    LNumber ynorm = Z[0].Clone();
    ynorm.setOne();
    
    int topk = order*(order-1)/2;
    int ks;
    for(int k=order-1;k >= 0;k-=ks) {
      int kk = topk+k;
      int topkm = topk-k;
      ks = 1;
      if(pivot[k] < 0) 
	ks = 2;
      if(k != ks-1) {
	int kp = Math.abs(pivot[k]) - 1;
	int kps = k + 1 - ks;
	if(kp != kps) 
	  NUtil.swapElems(Z,kp,kps);
	this.axpy(k-ks+1,Z[k],1,topk,0,Z,1,0);
	if(ks == 2) 
	  this.axpy(k-ks+1,Z[k-1],1,topkm,0,Z,1,0);
      }
      if(ks == 1) {
	if((Z[k].abs()).greaterThan(Mat[kk][0].abs())) {
	  LNumber S = (Mat[kk][0].abs()).div(Z[k].abs());
	  NUtil.scal(order,S,Z,1);
	  ynorm.multTo(S);
	}
	if(Mat[kk][0].equals(0)) 
	  Z[k].setOne();
	else 
	  Z[k].divTo(Mat[kk][0]);
      }
      else 
	Zfixer(k,kk,topk-1,Z);
      topk = topkm;
      if(ks == 2) 
	topk -= k-1;
    }
    LNumber S = (NUtil.asum(order,Z,1)).invTo();
    NUtil.scal(order,S,Z,1);
    ynorm.multTo(S);
    
    return ynorm;
  }
  private void Zfixer(int k, int kk, int topk, LNumber[] Z) {
    int kmk = topk+k;
    int kmkm = topk;
    LNumber ak = Mat[kk][0].div(Mat[kmk][0]);
    LNumber akm = Mat[kmkm][0].div(Mat[kmk][0]);
    LNumber bk = Z[k].div(Mat[kmk][0]);
    LNumber bkm = Z[k-1].div(Mat[kmk][0]);
    LNumber denom = (ak.mult(akm)).sub(1);
    Z[k] = ((akm.mult(bk)).sub(bkm)).div(denom);
    Z[k-1] = ((ak.mult(bkm)).sub(bk)).div(denom);
  }

  public void solve(LNumber[] B, int J) {
    this.solve(B);
  }
  public void solve(LNumber[] B) {

    int k = order-1;
    int ik = (order*(order-1))/2 - 1;
    
    while(k >= 0) {
      int kk = ik+k+1;
      if(pivot[k] >= 0) {
	if(k != 0) {
	  int kp = pivot[k] - 1;
	  if(kp != k) 
	    NUtil.swapElems(B,k,kp);
	  this.axpy(k,B[k],1,ik+1,0,B,1,0);  
	}

	B[k].divTo(Mat[kk][0]);
	k--;
	ik = ik - k - 1;
      }
      else {
	int ikm = ik - k;
	if(k != 1) {
	  int kp = Math.abs(pivot[k]) - 1;
	  if(kp != k-1) 
	    NUtil.swapElems(B,k-1,kp);
	  this.axpy(k-1,B[k],1,ik+1,0,B,1,0);
	  this.axpy(k-1,B[k-1],1,ikm+1,0,B,1,0);
	}
	this.Zfixer(k,kk,ik,B);
	k -= 2;
	ik = ik - k - k - 3;
      }
    }
    k = 0;
    ik = 0;
    while(k < order) {
      if(pivot[k] >= 0) {
	if(k != 0) {
	  B[k].addTo(this.dot(k,1,ik,0,B,1,0));
	  int kp = pivot[k] - 1;
	  if(kp != k) 
	    NUtil.swapElems(B,k,kp);
	}
	ik += k+1;
	k++;
      }
      else {
	if(k != 0) {
	  B[k].addTo(this.dot(k,1,ik,0,B,1,0));
	  int ikp = ik+k+1;
	  B[k+1].addTo(this.dot(k,1,ikp,0,B,1,0));
	  int kp = Math.abs(pivot[k]) - 1;
	  if(kp != k) 
	    NUtil.swapElems(B,k,kp);
	}
	ik += k+k+3;
	k += 2;
      }
    }
  }    

  public LNumber[] determ() {
    LNumber[] Det = new LNumber[2];
    Det[0] = Mat[0][0].Clone();
    Det[1] = Det[0].Clone();
    Det[0].setOne();
    Det[1].setZero();
    
    LNumber Q1 = Mat[0][0].Clone();
    Q1.setZero();
    LNumber Q2 = Mat[0][0].Clone();
    Q2.setZero();
    TD A = new TD(Q1,Q2);
    
    int kk;
    int ik = -1;
    for(int k=0;k<order;k++) {
      ik += k;
      kk = ik+k+1;
      this.TDer(A,k,ik,kk);
      
      Det[0].multTo(A.D);
      if(!Det[0].equals(0)) 
	NUtil.detNorm(Det);
    }
    return Det;
  }
  
  public int[] inertia() {
    int[] in = new int[3];
    
    for(int j=0;j<3;j++)
      in[j] = 0;
        
    LNumber Q1 = Mat[0][0].Clone();
    Q1.setZero();
    LNumber Q2 = Mat[0][0].Clone();
    Q2.setZero();
    TD A = new TD(Q1,Q2);

    int kk;
    int ik = -1;
    for(int k=0;k<order;k++) {
      ik += k;
      kk = ik+k+1;
      this.TDer(A,k,ik,kk);
      
      if((A.D).greaterThan(0)) 
	in[0]++;
      else if((A.D).equals(0))
	in[2]++;
      else
	in[1]++;      
    }
    return in;
  }
  private void TDer(TD A, int k, int ik, int kk) {
    A.D = Mat[kk][0].Clone();
    
    if(pivot[k] < 0) {
      if((A.T).equals(0)) {
	int ikp = ik+k+1;
	int kkp = ikp+k+1;
	A.T = Mat[kkp][0].abs();
	A.D = (((A.D).div(A.T)).mult(Mat[kkp+1][0])).sub(A.T);
      }
      else {
	A.D = (A.T).Clone();
	(A.T).setZero();
      }
    }
  }
  
  public void inverse() {
    
    LNumber[] Work = new LNumber[order];

    int ik = -1;
    int kstep;
    for(int k=0;k<order;k+=kstep) {
      int km = k - 1;
      int kk = ik + k + 1;
      int ikp = ik + k + 1;
      int kkp = ikp + k + 1;
      
      if(pivot[k] >= 0) {
	Mat[kk][0].invTo();
	if(k > 0) {
	  this.copy(k,1,ik+1,0,Work,1);
	  int ij = -1;
	  for(int j=0;j<k;j++) {
	    int jk = ik + j + 1;
	    Mat[jk][0] = this.dot(j+1,1,ij+1,0,Work,1,0);
	    this.axpy(j,Work[j],1,ij+1,0,this,1,ik+1,0);
	    ij += j + 1;
	  }
	  Mat[kk][0].addTo(this.dot(k,1,ik+1,0,Work,1,0));
	}
	kstep = 1;
      }
      else {
	this.invAdj(kk,kkp);
	if(k > 0) {
	  this.copy(k,1,ikp+1,0,Work,1);
	  int ij = -1;
	  for(int j=0;j<k;j++) {
	    int jkp = ikp + j +1;
	    Mat[jkp][0] = this.dot(j+1,1,ij+1,0,Work,1,0);
	    this.axpy(j,Work[j],1,ij+1,0,this,1,ikp+1,0);
	    ij += j + 1;
	  }
	  Mat[kkp+1][0].addTo(this.dot(k,1,ikp+1,0,Work,1,0));
	  Mat[kkp][0].addTo(this.dot(k,1,ik+1,0,this,1,ikp+1,0));
	  this.copy(k,1,ik+1,0,Work,1);
	  
	  ij = -1;
	  for(int j=0;j<k;j++) {
	    int jk = ik+j+1;
	    Mat[jk][0] = this.dot(j+1,1,ij+1,0,Work,1,0);
	    this.axpy(j,Work[j],1,ij+1,0,this,1,ik+1,0);
	    ij += j+1;
	  }
	  Mat[kk][0].addTo(this.dot(k,1,ik+1,0,Work,1,0));
	}
	kstep = 2;
      }
      
      //  Swap  //

      int ks = Math.abs(pivot[k]);
      if(ks-1 != k) {
	int iks = (ks*(ks-1))/2 - 1;
	this.swap(ks,1,iks+1,0,this,1,ik+1,0);
	int ksj = ik + ks;
	for(int j=k;j>=ks-1;j--) {
	  int jk = ik + j + 1;
	  this.swapElem(jk,ksj);
	  ksj -= j;
	}
	if(kstep == 2) {
	  int kskp = ikp + ks;
	  this.swapElem(kskp,kkp);
	}
      }
      ik += k + 1;
      if(kstep == 2) 
	ik += k+2;
    }
  }  
  private void invAdj(int kk, int kkp) {
    LNumber T = Mat[kkp][0].abs();
    LNumber ak = Mat[kk][0].div(T);
    LNumber akp = Mat[kkp+1][0].div(T);
    LNumber akkp = Mat[kkp][0].div(T);
    LNumber D = T.mult((ak.mult(akp)).sub(1));
    Mat[kk][0] = akp.div(D);
    Mat[kkp+1][0] = ak.div(D);
    Mat[kkp][0] = (akkp.div(D)).negateTo();
  }
}

