/*
 ##  class NTriFull
 ##
 ##  This class contains the framework for triangular matrices.
 ##
 */

package edu.rice.linpack.Matrix.NMatrix;

import edu.rice.linpack.util.*;
import edu.rice.linpack.LNumber.*;

public abstract class NTriFull extends NFull {

  public abstract LNumber condition(LNumber[] Z)
       throws SingularMatrixException;  
  public abstract void solve(LNumber[] B, int J);
  public abstract void inverse();

  public void solve(LNumber[] B) {
    this.solve(B,0);
  }

  void zeroDiag() 
       throws SingularMatrixException
  {
    for(int i=0;i<cols;i++) {
      if(Mat[i][i].equals(0)) 
	throw new SingularMatrixException(i+1);
    }
  }

  public void factor() 
       throws SingularMatrixException
  {
    this.zeroDiag();
  }
 
  public LNumber[] determ() {
    
    LNumber[] Det = new LNumber[2];        
    Det[0] = Mat[0][0].Clone();
    Det[1] = Det[0].Clone();
    Det[0].setOne();
    Det[1].setZero();
    
    for(int i=0;i<cols;i++) {
      Det[0].multTo(Mat[i][i]);
      
      if(Det[0].equals(0)) {
	Det[1].setZero();
	return Det;
      }
      else 
	NUtil.detNorm(Det);
    }
    return Det;
  }
}
