package edu.rice.linpack.Matrix.NMatrix;

import edu.rice.linpack.util.*;
import edu.rice.linpack.LNumber.*;

public class NTriLow extends NTriFull {

  public NTriLow() {
    super();
  }
  public NTriLow(int i, int j) {
    Mat = new LNumber[i][j];
    rows = i;
    cols = j;
  }
  public NTriLow(LNumber[][] F) {
    rows = F.length;
    cols = (F[0]).length;
    Mat = F;
  }
  public NTriLow(NTriLow M) {
    rows = M.rows;
    cols = M.cols;
    Mat = new LNumber[rows][cols];
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) 
	Mat[i][j] = (M.getElem(i,j)).Clone();
  }

  protected LNumber oneNorm() {
    LNumber tnorm = Mat[0][0].Clone();
    tnorm.setZero();
    for(int j=0;j<cols;j++) {
      int q = cols-j;
      tnorm.maxTo(this.asum(q,1,j,j));
    }
    return tnorm;
  }

  public LNumber condition(LNumber[] Z) 
       throws SingularMatrixException
  {
    LNumber S;
    LNumber tnorm = this.oneNorm();
    LNumber ynorm;

    try {
      this.zeroDiag();
    } finally {
      
      LNumber ek = Mat[0][0].Clone();
      ek.setOne();
      for(int j=0;j<cols;j++) {
	Z[j] = Mat[0][0].Clone();
	Z[j].setZero();
      }
      
      for(int k=cols-1;k>=0;k--) {
	if(!Z[k].equals(0)) 
	  ek = NUtil.signOfA(ek,Z[k].negate()); 
	if(((ek.sub(Z[k])).abs()).greaterThan(Mat[k][k].abs())) {
	  S = (Mat[k][k].abs()).div((ek.sub(Z[k])).abs());
	  NUtil.scal(cols,S,Z,1);
	  ek.multTo(S);
	}
	LNumber wk = ek.sub(Z[k]);
	LNumber wkm = (ek.add(Z[k])).negateTo();
	S = wk.abs();
	LNumber SM = wkm.abs();
      
	if(!Mat[k][k].equals(0)) {
	  wk.divTo(Mat[k][k]);
	  wkm.divTo(Mat[k][k]);
	}
	else {
	  wk.setOne();
	  wkm.setOne();
	}
	
	if(k > 0) {
	  for(int j=0;j<k;j++) {
	    SM.addTo((Z[j].add(wkm.mult(Mat[k][j]))).abs());
	    Z[j].addTo(wk.mult(Mat[k][j]));
	    S.addTo(Z[j].abs());
	  }
	  if(SM.greaterThan(S)) {
	    LNumber T = wkm.sub(wk);
	    wk = wkm.Clone();
	    for(int j=0;j<k;j++) 
	      Z[j].addTo(T.mult(Mat[k][j]));
	  }
	}
	Z[k] = wk.Clone();
      }
      S = (NUtil.asum(cols,Z,1)).invTo();
      NUtil.scal(cols,S,Z,1);

      ynorm = this.solveTZ(Z);
    }
    LNumber R;

    if(tnorm.equals(0))
      R = tnorm;
    else
      R = ynorm.div(tnorm);

    return R;
  }
  private LNumber solveTZ(LNumber[] Z) {
    LNumber ynorm = Z[0].Clone();
    ynorm.setOne();
    
    for(int k=0;k<cols;k++) {
      if((Z[k].abs()).greaterThan(Mat[k][k].abs())) {
	LNumber S = (Mat[k][k].abs()).div(Z[k].abs());
	NUtil.scal(cols,S,Z,1);
	ynorm.multTo(S);
      }
      if(Mat[k][k].equals(0)) 
	Z[k].setOne();
      else 
	Z[k].divTo(Mat[k][k]);
      int q = k+1;
      if(q < cols) 
	this.axpy(cols-q,Z[k].negate(),1,q,k,Z,1,q);
    }
    LNumber S = (NUtil.asum(cols,Z,1)).invTo();
    NUtil.scal(cols,S,Z,1);
    ynorm.multTo(S);

    return ynorm;
  }

  public void solve(LNumber[] B, int job) {    

    if(job != 0) {
      int nm = cols-1;
      B[nm].divTo(Mat[nm][nm]);
      for(int jj=1;jj<cols;jj++) {
	int j = cols - jj - 1;
	B[j].subTo(this.dot(jj,1,j+1,j,B,1,j+1));
	B[j].divTo(Mat[j][j]);
      }
    }
    else {
      B[0].divTo(this.Mat[0][0]);
      for(int j=1;j<cols;j++) {
	LNumber T = B[j-1].negate();
	this.axpy(cols-j, T, 1,j,j-1,B,1,j);
	B[j].divTo(Mat[j][j]);    
      }
    }
  }
  
  public void inverse() {
    for(int k=cols-1;k>=0;k--) {
      if(Mat[k][k].equals(0)) 
	return;
      else {
	Mat[k][k].invTo();
	LNumber T = Mat[k][k].negate();
	this.scal(cols-k-1,T,1,k+1,k);
	for(int j=0;j<k;j++) {
	  T = Mat[k][j].Clone();
	  Mat[k][j].setZero();
	  this.axpy(cols-k,T,1,k,k,this,1,k,j);
	}
      }
    }
  }
}
      
