package edu.rice.linpack.Matrix.NMatrix;
import edu.rice.linpack.util.*;
import edu.rice.linpack.LNumber.*;

public abstract class NUtil {

  public static LNumber asum(int n, LNumber[] V, int incx) {
    LNumber dasum = V[0].abs();
    if(incx != 1) {
      int ix = incx;
      for(int i=1;i<n;i++,ix+=incx) 
	dasum.addTo(V[ix].abs());
      return dasum;
    } 
    int m = (n-1)%6;
    if(m != 0) {
      for(int i=1;i<=m;i++) {
        dasum.addTo(V[i].abs());
      }
    }
    if(n >= 6) {
      for(int i=m+1;i<n;i+=6) {
        dasum.addTo(((((((V[i].abs())).add(V[i+1].abs()))
		       .add(V[i+2].abs())).add(V[i+3].abs()))
		     .add(V[i+4].abs())).add(V[i+5].abs()));
      }
    }
    return dasum;
  }
  

  public static void scal(int n, LNumber Da, LNumber[] V, int incx) {
    scal(n,Da,V,incx,0);
  }
  public static void scal(int n, LNumber Da, LNumber[] V, int incx, int r) {
    if(n > 0 && !Da.equals(1)) {
      if(incx != 1) {
	int ix = 0;
	for(int i=0;i<n;i++,ix += incx)
	  V[ix+r].multTo(Da);
      }
      else {
	int m = n%5;
        if(m != 0) {
          for(int i=0;i<m;i++) {
            V[i+r].multTo(Da);
          }
        }
        if(n >= 5) {
          for(int i=m;i<n;i+=5) {
            int ir = i+r;
            V[ir].multTo(Da); 
            V[ir+1].multTo(Da);
            V[ir+2].multTo(Da); 
            V[ir+3].multTo(Da); 
            V[ir+4].multTo(Da);
          }
        }
      }
    }
    return;
  }

  public static LNumber signOfA(LNumber ek, LNumber zk) {
    return (ek.abs()).mult(zk.div(zk.abs()));
  }
  public static LNumber signOfA(int val, LNumber zk) {
    return (zk.div(zk.abs())).mult(Math.abs(val));
  }
  public static LNumber signOfM(LNumber ek, LNumber zk) {
    return (ek.abs()).mult(zk.div(zk.modulus()));
  }
  public static LNumber signOfM(int val, LNumber zk) {
    return (zk.div(zk.modulus())).mult(Math.abs(val));
  }
  
  public static void swapElems(LNumber[] Z, int k1, int k2) {
    LNumber temp = Z[k1].Clone();
    Z[k1] = Z[k2].Clone();
    Z[k2] = temp.Clone();
  }
  public static void swapElems(int[] Z, int k1, int k2) {
    int temp = Z[k1];
    Z[k1] = Z[k2];
    Z[k2] = temp;
  }

  public static void detNorm(LNumber[] Det) {
    while(!(Det[0].abs()).greaterOrEqual(1)) {
      Det[0].multTo(10);
      Det[1].subTo(1);
    }
    while((Det[0].abs()).greaterOrEqual(10)) {
      Det[0].divTo(10);
      Det[1].pplus();
    }
  }
  public static void copy(int n, LNumber[] A, int incx, int rx, 
			  LNumber[] B, int incy, int ry) {
    if(n <= 0)
      return;
    
    if(incx != 1 || incy != 1) {
      int ix = 0;
      int iy = 0;
      if(incx < 0)
	ix = (-n+1)*incx;
      if(incy < 0)
	iy = (-n+1)*incy;
      for(int i=0;i<n;i++) {
	B[iy+ry] = A[ix+rx].Clone();
	ix += incx;
	iy += incy;
      }
    }
    else {
      int m = n%7;
      if(m != 0) {
        for(int i=0;i<m;i++) 
          B[i+ry] = A[i+rx].Clone();
      }
      if(n >= 7) {
        for(int i=m;i<n;i+=7) {
          int irx = i+rx;
          int iry = i+ry;
          B[iry] = A[irx].Clone();
          B[iry+1] = A[irx+1].Clone();
          B[iry+2] = A[irx+2].Clone();
          B[iry+3] = A[irx+3].Clone();
          B[iry+4] = A[irx+4].Clone();
          B[iry+5] = A[irx+5].Clone();
          B[iry+6] = A[irx+6].Clone();
        }
      }
    }
  }
  public static LNumber dot(int n, LNumber[] A, int incx, int rx,
			    LNumber[] B, int incy, int ry) {

    LNumber N = A[rx].Clone();
    N.setZero();
    
    if(n > 0){
      if(incy != 1 || incx != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	
	for(int i=0; i<n;i++,ix+= incx,iy += incy) 
	  N.addTo(A[rx+ix].mult(B[ry+iy]));
      }
      else {
	int m = n%5;
        if(m != 0) {
          for(int i=0;i<m;i++) {
            N.addTo(A[i+rx].mult(B[ry+i]));
          }
        }
        if(n >= 5) {
          for(int i=m;i<n;i+=5) {
            int irx = i+rx;
            int iry = i+ry;
            N.addTo(((((A[irx].mult(B[iry])).add(A[irx+1].mult(B[iry+1])))
		      .add(A[irx+2].mult(B[iry+2])))
		     .add(A[irx+3].mult(B[iry+3])))
		    .add(A[irx+4].mult(B[iry+4])));
          }
        }
      }
    }
    return N;
  }

  public static LNumber nrm2(int n, LNumber[] S, int incx, int r) {
    
    int ix;
    LNumber absxi, scale, ssq;
    
    if(n < 1 || incx < 1) 
      return null;
    
    scale = S[r].Clone();
    scale.setZero();

    if( n == 1) 
      return (S[r].abs());
    
    ssq = scale.Clone();
    ssq.setOne(); 
    
    for(ix = 0;ix < n*incx;ix+=incx) {
      S[r+ix].ssq(ssq,scale);

      /*
	equals(0)) {
	absxi = S[r+ix].abs();
	if(absxi.greaterThan(scale)) {
	  ssq = (ssq.mult((scale.div(absxi)).square())).pplus();
	  scale = absxi;
	}
	else 
	  ssq.addTo((absxi.div(scale)).square());
      }
      */
    }
    return scale.mult(ssq.sqrt());
  }

  public static void rotg(Trig Qt) {
    
    NTrig Q = (NTrig) Qt;

    LNumber Roe = Q.getB();
    LNumber R;

    if(((Q.getA()).abs()).greaterThan(Roe.abs())) 
      Roe = Q.getA();
    LNumber scale = ((Q.getA()).abs()).add((Q.getB()).abs());
    if(scale.equals(0)) {
      Q.setCosOne();
      Q.setSinZero();
      R = (Q.getSin()).Clone();
    }
    else {
      R = scale.mult(((Q.getA().div(scale)).square()
		     .add((Q.getB().div(scale)).square())).sqrt());
      R.multTo(NUtil.signOfA(1,Roe));
      Q.setCos((Q.getA()).div(R));
      Q.setSin((Q.getB()).div(R));
    }
    LNumber Z;
    if(((Q.getA()).abs()).greaterThan((Q.getB()).abs())) 
      Z = (Q.getSin()).Clone();
    else if(!(Q.getCos()).equals(0)) 
      Z = Q.getCos().inv();
    else {
      Z = scale.Clone();
      Z.setOne();
    }
    
    Q.setA(R);
    Q.setB(Z);
  }
  
  public static void Print(LNumber[] S) {
    int n = S.length;
    System.out.print("Vector:  ");
    for(int i=0;i<n;i++) {
      if(S[i] != null) {
	S[i].Print();
	System.out.print("   ");
      }
      else 
	System.out.println("0.0   ");
    }
    System.out.println();
  }
  public static LNumber aMax(LNumber a, LNumber b, LNumber c, 
			     LNumber d, LNumber e) {
    return (((((a.abs()).max(b.abs())).max(e.abs()))
	     .max(c.abs())).max(d.abs()));
  }
}
