h17567
s 00003/00003/00458
d D 1.10 98/08/28 15:41:19 jpiper 11 10
c Fixed for limited access and complex numbers
e
s 00011/00011/00450
d D 1.9 98/08/12 17:05:19 jpiper 10 9
c Adjusted for LNumbers
e
s 00017/00010/00444
d D 1.8 98/08/06 16:20:33 jpiper 9 8
c needed for debugging
e
s 00018/00034/00436
d D 1.7 98/08/05 19:05:27 jpiper 8 7
c Finished debugging
e
s 00019/00020/00451
d D 1.6 98/08/04 18:46:54 jpiper 7 6
c debugged - still not right
e
s 00064/00027/00407
d D 1.5 98/08/03 18:48:13 jpiper 6 5
c Middle of debugging
e
s 00004/00008/00430
d D 1.4 98/07/30 17:11:16 jpiper 5 4
c No WrongDataType for LNumbers
e
s 00019/00002/00419
d D 1.3 98/07/29 11:45:23 jpiper 4 3
c Constructors Tested
e
s 00123/00130/00298
d D 1.2 98/07/27 19:09:15 jpiper 3 1
c Still needs debugging
e
s 00000/00000/00000
d R 1.2 98/07/27 17:34:18 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/NMatrix/NBanded.java
e
s 00428/00000/00000
d D 1.1 98/07/27 17:34:17 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
/*
D 3
 ##  class FBanded
E 3
I 3
 ##  class NBanded
E 3
 ##  
 ##  This class holds the frame for matrices stored in banded form.
 ##  It also contains the Gaussian routines for banded matrices.
 ##
 */

D 4

E 4
D 3
package edu.rice.linpack.Matrix.FMatrix;
E 3
I 3
package edu.rice.linpack.Matrix.NMatrix;
E 3
import edu.rice.linpack.LNumber.*;
import edu.rice.linpack.util.*;
D 3
import edu.rice.linpack.Vector.*;
E 3

D 3
public class FBanded extends FMatrix {
E 3
I 3
public class NBanded extends NMatrix {
E 3

  protected int mu, ml;
D 3

  public FBanded() {
E 3
I 3
  
  public NBanded() {
E 3
    super();
    cons();
  }
D 3
  public FBanded(int ML, int MU, int columns) {
E 3
I 3
  public NBanded(int ML, int MU, int columns) {
E 3
    cons(2*ML+MU+1,columns);
    mu = MU;
    ml = ML;
  }
D 3
  // This is for unbanded float arrays //
  public FBanded(float[][] f, int ML, int MU) {
E 3
I 3
  // This is for unbanded LNumber arrays //
  public NBanded(LNumber[][] f, int ML, int MU) {
E 3
    mu = MU;
D 6
    ml = ml;
E 6
I 6
    ml = ML;
E 6
    Mat = band(f,ml,mu);
    rows = Mat.length;
    cols = Mat[0].length;
    pivot = new int[cols];
  }
D 3
  // This is for banded float arrays //
  public FBanded(float[][] f, int ML) {
E 3
I 3
  // This is for banded LNumber arrays //
  public NBanded(LNumber[][] f, int ML) {
E 3
    cons(f);
    ml = ML;
    mu = f.length - 1 - 2*ML;
  }
D 3
  public FBanded(FFull F, int Ml, int Mu) {
E 3
I 3
  public NBanded(NFull F, int Ml, int Mu) {
E 3
    mu = Mu;
    ml = Ml;
    Mat = band(F.Mat,ml,mu);
    rows = Mat.length;
    cols = Mat[0].length;
    pivot = new int[cols];
  }
D 3
  public FBanded(FBanded F) {
E 3
I 3
  public NBanded(NBanded F) {
E 3
D 6
    cons(F);
E 6
    mu = F.mu;
    ml = F.ml;
I 6
    rows = F.numofRows();
    cols = F.numofCols();
    pivot = new int[cols];
    int M = ml+mu;
    Mat = new LNumber[rows][cols];
    for(int j=0;j<cols;j++) {
      int low = Math.max(0,M-j);
D 9
      int hi = Math.min(rows,rows+M-j+1);
E 9
I 9
      int hi;
      if(ml > 0)
	hi = Math.min(rows,rows+M-j+1);
      else 
	hi = rows;
E 9
      for(int i=low;i<hi;i++) 
	Mat[i][j] = (F.getElem(i,j)).Clone();
    }
E 6
  }

D 3
  private float[][] band(float[][] f, int Ml, int Mu) {
E 3
I 3
D 6
  private LNumber[][] band(LNumber[][] f, int Ml, int Mu) {
E 6
I 6
  private static LNumber[][] band(LNumber[][] f, int Ml, int Mu) {
E 6
E 3
    int n = f[0].length;
D 3
    float[][] Fband = new float[2*ml+mu+1][n];
E 3
I 3
D 6
    LNumber[][] Fband = new LNumber[2*ml+mu+1][n];
E 6
I 6
    LNumber[][] Fband = new LNumber[2*Ml+Mu+1][n];
E 6
E 3
    int M = Ml + Mu;
    for(int j=0;j<n;j++) {
D 6
      int i1 = Math.max(0,j-Mu);
      int i2 = Math.min(n,j+Ml+1);
      for(int i=i1;i<i2;i++) {
E 6
I 6
      int i1 = Math.max(0,M-j);
      int i2 = Math.min(n,n+M-j);
      for(int i=0;i<n;i++) {
E 6
	int k = i - j + M;
D 6
	Fband[k][j] = f[i][j];
E 6
I 6
	if(k>=i1 && k<i2 && k<(M+Ml+1)) {
	  if(k>=Ml) 
	    Fband[k][j] = f[i][j];
	  else {
	    LNumber T = f[0][0].Clone();
	    T.setZero();
	    Fband[k][j] = T;
	  }
	}
E 6
      }
    }
    return Fband;
  }
D 3
  public FFull unband() {
    FFull Fband = new FFull(cols,cols);
E 3
I 3
  public NFull unband() {
    NFull Fband = new NFull(cols,cols);
E 3
    int M = ml + mu;
    for(int j=0;j<cols;j++) {
D 6
      int i1 = Math.max(0,j-mu);
      int i2 = Math.min(cols,j+ml+1);
      for(int i=i1;i<i2;i++) {
E 6
I 6
      int low = Math.max(0,M-j);
      int hi = Math.min(cols,cols+M-j);
      for(int i=0;i<cols;i++) {
E 6
	int k = i - j + M;
D 3
	Fband.Mat[i][j] = this.Mat[k][j];
E 3
I 3
D 6
	Fband.setElem(i,j,Mat[k][j]);
E 6
I 6
	if(k>=low && k<hi && k<rows) 
	  Fband.setElem(i,j,Mat[k][j]);
	else {
	  LNumber T = Mat[M][M].Clone();
	  T.setZero();
	  Fband.setElem(i,j,T);
	}
E 6
E 3
      }
    }
    return Fband;
  }  
D 4
  
E 4
I 4
  public void Print() {
    System.out.println(); 
    for(int j=0;j<rows;j++) {
      int i1 = Math.max(0,ml+mu-j);
      int i2 = Math.min(cols,cols+mu+ml-j);
      for(int i=0;i<cols;i++) {
D 6
	if(i>=i1 && i<i2 && j>=ml) {
	  int k = i - j + ml + mu;
	  Mat[j][i].Print();
	  System.out.print("   ");
E 6
I 6
	if(i>=i1 && i<i2) {
	  if(j>=ml || Mat[j][i] != null) {
	    Mat[j][i].Print();
	    System.out.print("   ");
	  }
	  else
	    System.out.print("0.00   ");
E 6
	}
	else
	  System.out.print("0.00   ");
      }
      System.out.println();
    }
    System.out.println();
  }

E 4
D 3
  public float oneNorm() {
    float anorm = 0;
E 3
I 3
  public LNumber oneNorm() {
E 3
    int L = ml;
    int is = L + mu;
I 6
D 7
    System.out.println(L+" "+mu+" "+ml+" "+is);
E 7
E 6
I 3
    LNumber anorm = this.asum(L+1,1,is,0);
E 3
    for(int j=0;j<cols;j++) {
D 3
      anorm = Math.max(anorm,this.asum(L+1,1,is,j));
E 3
      if(is > ml) 
	is--;
      if(j < mu)
	L++;
      if(j >= cols-ml-1)
D 6
	L--;  
I 3
      anorm = anorm.max(this.asum(L+1,1,is,j+1));
E 6
I 6
	L--; 
      if(j < cols-1)
	anorm = anorm.max(this.asum(L+1,1,is,j+1));
E 6
E 3
    }
    return anorm;
  }

D 3
  /*  Factor and solve are both completely checked
      Determ is fully tested and works fine.  
      Condition is fully tested and works fine.
      */

E 3
  /*  Pivots are java based  */

  public void factor() 
       throws SingularMatrixException
  {
    
    int info = 0;
    int M = ml + mu + 1;
D 3
    float T;
E 3
I 3
    LNumber T;
E 3
    
    int Ji = Math.min(cols,M) - 1;
    int io;
    for(int Jz=mu+1;Jz < Ji;Jz++) {
I 6
D 8
      System.out.println("B1");
E 8
E 6
      io = M - 1 - Jz;
D 6
      for(int i=io;i < ml;i++) 
E 6
I 6
D 8
      for(int i=io;i < ml;i++) {
	System.out.println("B2");
E 8
I 8
      for(int i=io;i < ml;i++) 
E 8
E 6
D 3
	this.Mat[i][Jz] = 0;
E 3
I 3
	Mat[i][Jz].setZero();
I 6
D 8
      }
E 8
E 6
E 3
    }
    
    int Jz = Ji;
    int Ju = 0;
    
    /* Gaussian elimination with partial pivoting */

    int colsm = cols - 1;
    if(cols > 1) {
I 6
D 8
      System.out.println("B3");
E 8
E 6
      int kp;
      for(int k=0;k<colsm;k++,Jz++) {
	kp = k+1;
	if(Jz < cols) 
	  for(int i=0;i<ml;i++) 
D 3
	    this.Mat[i][Jz] = 0;
E 3
I 3
	    Mat[i][Jz].setZero();
E 3
	
	int lm = Math.min(ml, colsm-k) - 1;
	int L = this.i_amax(lm+2,1,M-1,k) + M - 1;
	pivot[k] = L + kp - M;

D 3
	if(this.Mat[L][k] != 0) {
E 3
I 3
D 6
	if(!Mat[L][k].equals(0)) {
E 6
I 6
	if(!(Mat[L][k].equals(0))) {
E 6
E 3
	  if(L != M-1) 
	    this.swapElem(L,k,M-1,k);
D 6
	  
E 6
D 3
	  T = (float)-1.0/this.Mat[M-1][k];
E 3
I 3
D 10
	  T = (Mat[M-1][k].inv()).negate();
E 10
I 10
	  T = (Mat[M-1][k].inv()).negateTo();
E 10
E 3
	  this.scal(lm+1,T,1,M,k);
D 6
	  
E 6
	  /*  ROW ELIMINATION WITH COLUMN INDEXING */

	  Ju = Math.min(Math.max(Ju,mu+pivot[k]),colsm);
	  int MM = M-2;
	  for(int j=kp;j<=Ju;j++) {
	    L--;
D 6
	    T = this.Mat[L][j];
E 6
I 6
	    T = Mat[L][j].Clone();
E 6
	    if(L != MM) 
	      this.swapElem(L,j,MM,j);
	    this.axpy(lm+1, T,1,M,k,this,1,MM+1,j);
	    MM--;
	  }
	}
D 6
	else 
E 6
I 6
D 8
	else {
	  System.out.println("B10");
E 8
I 8
	else 
E 8
E 6
	  info = k+1;
I 6
D 8
	}
E 8
E 6
      }
    }
    pivot[cols-1] = cols-1;
D 3
    if(this.Mat[M-1][cols-1] == 0) 
E 3
I 3
D 6
    if(Mat[M-1][cols-1].equals(0)) 
E 6
I 6
D 8
    if(Mat[M-1][cols-1].equals(0)) {
      System.out.println("B11");
E 8
I 8
    if(Mat[M-1][cols-1].equals(0)) 
E 8
E 6
E 3
      info = cols;
D 6
    if(info != 0)
E 6
I 6
D 8
    }
    if(info != 0) {
      System.out.println("B12");
E 8
I 8
    if(info != 0) 
E 8
E 6
      throw new SingularMatrixException(info);
I 6
D 8
    }
E 8
E 6
  }

  public LNumber condition() 
D 5
       throws SingularMatrixException, WrongDataTypeException
E 5
I 5
       throws SingularMatrixException
E 5
  {
D 3
    Vector Z = new FVector(cols);
E 3
I 3
    LNumber[] Z = new LNumber[cols];
E 3
    return this.condition(Z);
  }
D 3
  public LNumber condition(Vector Ze) 
E 3
I 3
  public LNumber condition(LNumber[] Z) 
E 3
D 5
       throws SingularMatrixException, WrongDataTypeException
E 5
I 5
       throws SingularMatrixException
E 5
  {
D 3
    float[] Z = Ze.getFloatArray();
    
E 3
    // Compute 1-Norm of this //

D 3
    float anorm = this.oneNorm();
    float ynorm;
E 3
I 3
    LNumber anorm = this.oneNorm();
    LNumber ynorm;
E 3

    // Factor //

    try {
      this.factor();
    } finally {
D 6
    
E 6
I 6
D 8
      System.out.println("C1");
E 8
I 8

E 8
E 6
      // Rcond = 1/(norm(this) * (Estimate of norm(inv(this)))) //
I 9

      int M = ml + mu;
E 9
      
D 3
      for(int j=0;j<cols;j++)
	Z[j] = 0;
      
E 3
I 3
      for(int j=0;j<cols;j++) {
D 9
	Z[j] = Mat[0][0].Clone();
E 9
I 9
	Z[j] = Mat[M][0].Clone();
E 9
	Z[j].setZero();
      }
E 3
D 9
      int M = ml + mu;
E 9
      
      this.solveTransUW(M,Z);
D 7
      
E 7
I 7

E 7
D 3
      float S = (float)1.0/FUtil.asum(cols,Z,1);
      FUtil.scal(cols,S,Z,1);
     
E 3
I 3
D 10
      LNumber S = (NUtil.asum(cols,Z,1)).inv();
E 10
I 10
      LNumber S = (NUtil.asum(cols,Z,1)).invTo();
E 10
      NUtil.scal(cols,S,Z,1);
      
E 3
      this.solveLV(M,Z);
      
      ynorm = this.solveTransLY(M,Z);
D 3
    
E 3
I 3
      
E 3
      // Solve U*Z = W //
      
      ynorm = this.solveUZ(M,Z,ynorm);
    }   
D 3
    LFloat R = new LFloat();
    
    if(anorm != 0)
      R.setFloat(ynorm/anorm);
E 3
I 3
    LNumber R;
E 3
D 7
    
E 7
I 7

E 7
I 3
    if(!anorm.equals(0))
      R = ynorm.div(anorm);
    else
      R = anorm;
I 7

E 7
E 3
    return R;
  }
D 3
  private void solveTransUW(int M, float[] Z) {
E 3
I 3
  private void solveTransUW(int M, LNumber[] Z) {
E 3
D 8

E 8
D 3
    float ek = 1;
E 3
I 3
D 9
    LNumber ek = Mat[0][0].Clone();
E 9
I 9
    LNumber ek = Mat[mu+ml][0].Clone();
E 9
    ek.setOne();
E 3
    int Ju = 0;
D 7
    for(int k=0;k<cols;k++) {
      
E 7
I 7
D 8
    for(int k=0;k<cols;k++) {      
E 8
I 8
    for(int k=0;k<cols;k++) {
E 8
E 7
D 3
      if(Z[k] != 0) 
	ek = FUtil.signOf(ek,-Z[k]);
      if(Math.abs(ek-Z[k]) > Math.abs(this.Mat[M][k])) {
	float S = Math.abs(this.Mat[M][k])/Math.abs(ek-Z[k]);
	FUtil.scal(cols,S,Z,1);
	ek *= S;
E 3
I 3
      if(!Z[k].equals(0)) 
D 10
	ek = NUtil.signOf(ek,Z[k].mult(-1));
E 10
I 10
D 11
	ek = NUtil.signOf(ek,Z[k].negate());
E 11
I 11
	ek = NUtil.signOfA(ek,Z[k].negate());
E 11
E 10
      if(((ek.sub(Z[k])).abs()).greaterThan(Mat[M][k].abs())) {
	LNumber S = (Mat[M][k].abs()).div((ek.sub(Z[k])).abs());
	NUtil.scal(cols,S,Z,1);
D 7
	ek = ek.mult(S);
E 7
I 7
	ek.multTo(S);
E 7
E 3
      }
      
D 3
      float wk = ek - Z[k];
      float wkm = -ek - Z[k];
      float S = Math.abs(wk);
      float SM = Math.abs(wkm);
      if(this.Mat[M][k] != 0) {
	wk = wk/this.Mat[M][k];
	wkm = wkm/this.Mat[M][k];
E 3
I 3
      LNumber wk = ek.sub(Z[k]);
D 10
      LNumber wkm = (ek.mult(-1)).sub(Z[k]);
E 10
I 10
      LNumber wkm = (ek.negate()).sub(Z[k]);
E 10
      LNumber S = wk.abs();
      LNumber SM = wkm.abs();
      if(!Mat[M][k].equals(0)) {
D 7
	wk = wk.div(Mat[M][k]);
	wkm = wkm.div(Mat[M][k]);
E 7
I 7
	wk.divTo(Mat[M][k]);
	wkm.divTo(Mat[M][k]);
E 7
E 3
      }
D 8
      else {
E 8
I 8
      else 
E 8
D 3
	wk = 1;
	wkm = 1;
E 3
I 3
	wk.setOne();
	wkm.setOne();
E 3
D 8
      }
E 8
      int kp = k + 1;
      Ju = Math.min(Math.max(Ju,mu+pivot[k]+1),cols);
      int MM = M-1;
      if(kp < Ju) {
	for(int j=kp;j<Ju; j++,MM--) {
D 3
	  SM += Math.abs(Z[j]+wkm*this.Mat[MM][j]);
	  Z[j] += wk*this.Mat[MM][j];
	  S += Math.abs(Z[j]);
E 3
I 3
D 7
	  SM = SM.add((Z[j].add(wkm.mult(Mat[MM][j]))).abs());
	  Z[j] = Z[j].add(wk.mult(Mat[MM][j]));
	  S = S.add(Z[j].abs());
E 7
I 7
	  SM.addTo((Z[j].add(wkm.mult(Mat[MM][j]))).abs());
	  Z[j].addTo(wk.mult(Mat[MM][j]));
	  S.addTo(Z[j].abs());
E 7
E 3
	}
D 3
	if(S < SM) {
	  float T = wkm - wk;
E 3
I 3
	if(SM.greaterThan(S)) {
	  LNumber T = wkm.sub(wk);
E 3
D 7
	  wk = wkm;
E 7
I 7
D 11
	  wk.set(wkm);
E 11
I 11
	  wk = wkm.Clone();
E 11
E 7
	  MM = M-1;
	  for(int j=kp;j<Ju;j++,MM--) 
D 3
	    Z[j] += T*this.Mat[MM][j];
E 3
I 3
D 7
	    Z[j] = Z[j].add(T.mult(Mat[MM][j]));
E 7
I 7
	    Z[j].addTo(T.mult(Mat[MM][j]));
E 7
E 3
	}
      }
D 7
      Z[k] = wk;
E 7
I 7
D 11
      Z[k].set(wk);
E 11
I 11
      Z[k] = wk.Clone();
E 11
E 7
    }
  }
D 3
  private void solveLV(int M, float[] Z) {
E 3
I 3
  private void solveLV(int M, LNumber[] Z) {
E 3
    
    for(int k=cols-1;k>=0;k--) {
      int lm = Math.min(ml,cols-k-1);
D 8
      if(k < cols-1)
E 8
I 8
      if(k < cols-1) 
E 8
D 3
	Z[k] += this.dot(lm, 1,M+1,k, Z, 1, k+1);
      if(Math.abs(Z[k]) > 1) {
	float S = (float)1.0/Math.abs(Z[k]);
	FUtil.scal(cols,S,Z,1);
E 3
I 3
D 7
	Z[k] = Z[k].add(dot(lm,1,M+1,k,Z,1,k+1));
E 7
I 7
	Z[k].addTo(dot(lm,1,M+1,k,Z,1,k+1));
E 7
D 8
      if((Z[k].abs()).greaterThan(1)) {
E 8
I 8
D 9
      if((Z[k].abs()).greaterThan(1)) 
E 9
I 9
      if((Z[k].abs()).greaterThan(1)) {
E 9
E 8
D 10
	LNumber S = (Z[k].abs()).inv();
E 10
I 10
	LNumber S = (Z[k].abs()).invTo();
E 10
	NUtil.scal(cols,S,Z,1);
I 9
      }
E 9
E 3
D 8
      }
E 8
      int L = pivot[k];
D 3
      FUtil.swapElems(Z,L,k);
E 3
I 3
      NUtil.swapElems(Z,L,k);
E 3
    }
    
D 3
    float S = (float)1.0/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
E 3
I 3
D 10
    LNumber S = (NUtil.asum(cols,Z,1)).inv();
E 10
I 10
    LNumber S = (NUtil.asum(cols,Z,1)).invTo();
E 10
    NUtil.scal(cols,S,Z,1);
E 3
  }
D 3
  private float solveTransLY(int M, float[] Z) {
    float ynorm = 1;

E 3
I 3
  private LNumber solveTransLY(int M, LNumber[] Z) {
    LNumber ynorm = Z[0].abs();
    ynorm.setOne();
    
E 3
    for(int k=0;k<cols;k++) {
      int L = pivot[k];
D 3
      FUtil.swapElems(Z,L,k);
E 3
I 3
      NUtil.swapElems(Z,L,k);
E 3
      int lm = Math.min(ml,cols-k-1);
D 8
      if(k < cols)
E 8
I 8
      if(k < cols) 
E 8
	this.axpy(lm,Z[k],1,M+1,k, Z, 1, k+1);
D 3
      if(Math.abs(Z[k]) > 1) {
	float S = (float)1.0/Math.abs(Z[k]);
	FUtil.scal(cols,S,Z,1);
	ynorm *= S;
E 3
I 3
D 8
      if((Z[k].abs()).greaterThan(1)) {
E 8
I 8
D 9
      if((Z[k].abs()).greaterThan(1)) 
E 9
I 9
      if((Z[k].abs()).greaterThan(1)) {
E 9
E 8
D 10
	LNumber S = (Z[k].abs()).inv();
E 10
I 10
	LNumber S = (Z[k].abs()).invTo();
E 10
	NUtil.scal(cols,S,Z,1);
D 7
	ynorm = ynorm.mult(S);
E 7
I 7
	ynorm.multTo(S);
I 9
      }
E 9
E 7
E 3
D 8
      }
E 8
    }
D 3
    float S = (float)1.0/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
    ynorm *= S;
E 3
I 3
D 10
    LNumber S = (NUtil.asum(cols,Z,1)).inv();
E 10
I 10
    LNumber S = (NUtil.asum(cols,Z,1)).invTo();
E 10
    NUtil.scal(cols,S,Z,1);
D 7
    ynorm = ynorm.mult(S);
E 7
I 7
    ynorm.multTo(S);
E 7
E 3
    
    return ynorm;
  }
D 3
  float solveUZ(int M, float[] Z, float ynorm){
E 3
I 3
  LNumber solveUZ(int M, LNumber[] Z, LNumber ynorm){
E 3
    
    for(int k=cols-1;k>=0;k--) {
D 3
      if(Math.abs(Z[k]) > Math.abs(this.Mat[M][k])) {
	float S = Math.abs(this.Mat[M][k])/Math.abs(Z[k]);
	FUtil.scal(cols,S,Z,1);
	ynorm *= S;
E 3
I 3
      if((Z[k].abs()).greaterThan(Mat[M][k].abs())) {
	LNumber S = (Mat[M][k].abs()).div(Z[k].abs());
	NUtil.scal(cols,S,Z,1);
D 7
	ynorm = ynorm.mult(S);
E 7
I 7
	ynorm.multTo(S);
E 7
E 3
      }
      
D 3
      if(this.Mat[M][k] != 0)
	Z[k] /= this.Mat[M][k];
E 3
I 3
D 8
      if(!Mat[M][k].equals(0))
E 8
I 8
      if(!Mat[M][k].equals(0)) 
E 8
D 7
	Z[k] = Z[k].div(Mat[M][k]);
E 7
I 7
	Z[k].divTo(Mat[M][k]);
E 7
E 3
D 8
      else
E 8
I 8
      else 
E 8
D 3
	Z[k] = 1;
E 3
I 3
	Z[k].setOne();
E 3
      int lm = Math.min(k,M);
      int la = M - lm;
      int lz = k - lm;
D 3
      float T = -Z[k];
E 3
I 3
D 10
      LNumber T = Z[k].mult(-1);
E 10
I 10
      LNumber T = Z[k].negate();
E 10
E 3
      this.axpy(lm,T,1,la,k,Z,1,lz);
    }

D 3
    float S = (float)1.0/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
    ynorm *= S;
E 3
I 3
D 10
    LNumber S = (NUtil.asum(cols,Z,1)).inv();
E 10
I 10
    LNumber S = (NUtil.asum(cols,Z,1)).invTo();
E 10
    NUtil.scal(cols,S,Z,1);
D 7
    ynorm = ynorm.mult(S);
E 7
I 7
    ynorm.multTo(S);
E 7
E 3
  
    return ynorm;
  }
  
D 3
  public void solve(Vector B) 
E 3
I 3
D 5
  public void solve(LNumber[] B) 
E 3
       throws WrongDataTypeException
  {
E 5
I 5
  public void solve(LNumber[] B) {
E 5
    this.solve(B,0);
  }
D 3
  public void solve(Vector Be, int Job) 
E 3
I 3
D 5
  public void solve(LNumber[] B, int Job) 
E 3
       throws WrongDataTypeException
  {
E 5
I 5
  public void solve(LNumber[] B, int Job) {
E 5
    
D 3
    float[] B = Be.getFloatArray();

E 3
    int M = mu+ml+1;
    int nm = cols-1;
D 3
    float T;
E 3
I 3
    LNumber T;
E 3

    if(Job == 0) {
      if(ml != 0) {
	if(nm > 0) {
	  for(int k=0;k<nm;k++) {
	    int lm = Math.min(ml,nm-k);
	    int l = pivot[k];
D 8
	    T = B[l];
E 8
I 8
	    T = B[l].Clone();
E 8
	    if(l != k) 
D 3
	      FUtil.swapElems(B,l,k);
E 3
I 3
	      NUtil.swapElems(B,l,k);
E 3
	    this.axpy(lm,T,1,M,k,B,1,k+1);
	  }
	}
      }

      //  Solve U*X=Y  //

      this.solveRX(M-1,B);
D 8

E 8
    }
    else {

      //  Job is non-zero, solve trans(A)*X=B  //

      this.solveTransRY(M-1,B);

      if(ml != 0) {
	for(int k=cols-2;k>=0;k--) {
	  int lm = Math.min(ml,nm-k);
D 3
	  B[k] += this.dot(lm,1,M,k,B,1,k+1);
E 3
I 3
	  B[k] = B[k].add(dot(lm,1,M,k,B,1,k+1));
E 3
	  int l = pivot[k];
	  if(l != k) 
D 3
	    FUtil.swapElems(B,l,k);
E 3
I 3
	    NUtil.swapElems(B,l,k);
E 3
	}
      }
    }
    return; 
  }
D 3
  void solveTransRY(int M, float[] B) {
E 3
I 3
  void solveTransRY(int M, LNumber[] B) {
E 3
    for(int k=0;k<cols;k++) {
      int lm = Math.min(k,M);
      int la = M-lm;
      int lb = k-lm;
D 3
      float T = this.dot(lm,1,la,k,B,1,lb);
      B[k] = (B[k] - T)/this.Mat[M][k];
E 3
I 3
      LNumber T = this.dot(lm,1,la,k,B,1,lb);
      B[k] = (B[k].sub(T)).div(Mat[M][k]);
E 3
    }
  }
D 3
  void solveRX(int M, float[] B){
E 3
I 3
  void solveRX(int M, LNumber[] B){
E 3
    for(int k=cols-1;k>=0;k--) {
      int LM = Math.min(k,M);
      int la = M - LM;
      int lb = k - LM;
D 3
      B[k] /= this.Mat[M][k];
      float T = -B[k];
E 3
I 3
D 8
      B[k] = B[k].div(Mat[M][k]);
      LNumber T = B[k].mult(-1);
E 3
      this.axpy(LM,T,1,la,k,B,1,lb);
E 8
I 8
      B[k].divTo(Mat[M][k]);
D 10
      this.axpy(LM,B[k].mult(-1),1,la,k,B,1,lb);
E 10
I 10
      this.axpy(LM,B[k].negate(),1,la,k,B,1,lb);
E 10
E 8
    }
  }
	    
D 3
  public Vector determ() {
E 3
I 3
  public LNumber[] determ() {
E 3
    
D 3
    float[] Det = new float[2];
E 3
I 3
    LNumber[] Det = new LNumber[2];
E 3
D 9
    int M = mu + ml + 1;
E 9
I 9
    int M = mu + ml;
E 9
    
D 3
    Det[0] = 1;
    Det[1] = 0;
E 3
I 3
D 9
    Det[0] = Mat[0][0].Clone();
    Det[1] = Mat[0][0].abs();
E 9
I 9
    Det[0] = Mat[M][0].Clone();
    Det[1] = Det[0].Clone();
E 9
    Det[0].setOne();
    Det[1].setZero();
E 3

    for(int i=0;i<cols;i++) {
      if(pivot[i] != i) 
D 3
	Det[0] = -Det[0];
      Det[0] *= this.Mat[M-1][i];
E 3
I 3
D 8
	Det[0] = Det[0].mult(-1);
      Det[0] = Det[0].mult(Mat[M-1][i]);
E 8
I 8
	Det[0].multTo(-1);
D 9
      Det[0].multTo(Mat[M-1][i]);
E 9
I 9
      Det[0].multTo(Mat[M][i]);
E 9
E 8
E 3
      
D 3
      if(Det[0] == 0) {
	FVector V = new FVector(Det);
	return V;
      }      
E 3
I 3
      if(Det[0].equals(0)) 
	return Det;
E 3
      else 
D 3
	FUtil.detNorm(Det);
E 3
I 3
	NUtil.detNorm(Det);
E 3
    }
D 3
    FVector V2 = new FVector(Det);
    return V2;
E 3
I 3
    return Det;
E 3
  }
}
E 1
