h19667
s 00030/00030/01592
d D 1.16 98/08/28 15:41:31 jpiper 19 18
c Fixed for limited access and complex numbers
e
s 00055/00157/01567
d D 1.15 98/08/12 17:06:21 jpiper 18 17
c adjusted for LNumber
e
s 00013/00039/01711
d D 1.14 98/08/11 16:44:21 jpiper 17 16
c debugged chol.exchange
e
s 00001/00001/01749
d D 1.13 98/08/06 16:20:22 jpiper 16 15
c Needed for debugging
e
s 00108/00026/01642
d D 1.12 98/08/03 18:48:43 jpiper 15 14
c Put chol stuff here so SiFull can use it - need to do this for F & D
e
s 00114/00013/01554
d D 1.11 98/07/31 17:59:04 jpiper 14 12
c Added transpose and mult
e
s 00001/00001/01572
d D 1.8.1.1 98/07/30 17:14:05 zoran 13 9
c ȁ
e
s 00008/00011/01559
d D 1.10 98/07/30 17:10:16 jpiper 12 11
c Fixed small bug
e
s 00020/00023/01550
d D 1.9 98/07/30 16:51:42 jpiper 11 9
c fixed bugh
e
s 00010/00015/01555
d D 1.7.1.1 98/07/30 12:33:22 jpiper 10 8
c Double checked for slowdowns
e
s 00003/00000/01570
d D 1.8 98/07/30 10:34:57 zoran 9 8
c add getPivot() method 
e
s 00005/00008/01565
d D 1.7 98/07/30 10:02:49 jpiper 8 7
c SVD is completely checked
e
s 00001/00001/01572
d D 1.6 98/07/29 18:58:47 jpiper 7 6
c SVD is almost done - i can't get one small part to run
e
s 00028/00017/01545
d D 1.5 98/07/29 17:49:53 jpiper 6 5
c Checked QR and LU - both work great
e
s 00059/00047/01503
d D 1.4 98/07/29 11:45:35 jpiper 5 4
c SVD partially tested
e
s 00001/00001/01549
d D 1.3 98/07/28 10:03:01 jpiper 4 3
c Quitting to putback
e
s 01537/00023/00013
d D 1.2 98/07/27 19:09:24 jpiper 3 1
c Needs debugging
e
s 00000/00000/00000
d R 1.2 98/07/27 12:54:31 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/NMatrix/NFull.java
e
s 00036/00000/00000
d D 1.1 98/07/27 11:54:30 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
package edu.rice.linpack.Matrix.NMatrix;
D 3


E 3
I 3
import edu.rice.linpack.LNumber.*;
import edu.rice.linpack.util.*;
E 3

public class NFull extends NMatrix {

D 3
  void cons() {
    pivot = new int[cols];
E 3
I 3
  public NFull() {
    super();
    cons();
E 3
  }
D 3
  void cons(int i, int j) {
    Mat = new LNumber[i][j];
    rows = i;
    cols = j;
    pivot = new int[cols];
E 3
I 3
  public NFull(int i, int j) {
    cons(i,j);
E 3
  }
I 5
D 14
  public NFull(float[][] f) {
    cons(f);
  }
  public NFull(double[][] d) {
    cons(d);
  }
E 14
E 5
D 3
  void cons(NMatrix M) {
    rows = M.rows;
    cols = M.cols;
    Mat = new LNumber[rows][cols];
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) 
	Mat[i][j] = new LNumber(M.Mat[i][j]);
    pivot = new int[cols];
  }    
  void cons(LNumber[][] F) {
    rows = F.length;
    cols = (F[0]).length;
E 3
I 3
  public NFull(LNumber[][] f) {
    cons(f);
  }
  public NFull(NFull F) {
    cons(F);
  }
  public NFull(int ni, int nj, LNumber[][] f, int strow, int stcol) {
    rows = ni;
    cols = nj;
E 3
    Mat = new LNumber[rows][cols];
D 3
    for(int i=0;i<rows;i++)
E 3
I 3
    for(int i=0;i<rows;i++) {
E 3
      for(int j=0;j<cols;j++) {
D 3
	Mat[i][j] = new LNumber(F[i][j]);
E 3
I 3
	Mat[i][j] = f[i+strow][j+stcol];
E 3
      }
I 3
    }
E 3
    pivot = new int[cols];
  }

I 3
  public NBanded band(int ml, int mu) {
    NBanded B = new NBanded(ml,mu,cols);
    int M = ml+mu;
    for(int j=0;j<cols;j++) {
D 15
      int i1 = Math.max(0,j-mu);
      int i2 = Math.min(cols-1,j+ml);
      for(int i=i1;i<=i2;i++) {
E 15
I 15
      int i1 = Math.max(0,M-j);
      int i2 = Math.min(cols,cols+M-j);
      for(int i=0;i<rows;i++) {
E 15
	int k = i-j+M;
D 5
	B.Mat[k][j] = this.Mat[i][j];
E 5
I 5
D 15
	B.setElem(k,j,Mat[i][j]);
E 15
I 15
	if(k>=i1 && k<i2 && k<B.numofRows()) {
	  if(k>=ml) 
	    B.setElem(k,j,Mat[i][j]);	
	  else {
D 18
	    LNumber T = Mat[0][0].Clone();
E 18
I 18
	    LNumber T = newOfType();
E 18
	    T.setZero();
	    B.setElem(k,j,T);
	  }
	}
E 15
E 5
      }
    }
    return B;
  }
D 18
  public void setPivot(int[] f) {
    for(int i=0;i<cols;i++) 
      pivot[i] = f[i];
  }
  public void setPivot(int i, int p) {
    pivot[i] = p;
  }
E 18
I 9
D 19
  public int[] getPivot() {
    return pivot;
E 19
I 19
  public void setPivot(int i, int p) {
    pivot[i] = p;
E 19
  }
I 18
  public void setPivots(int[] p) {
    int q = Math.min(p.length,cols);
    for(int i=0;i<q;i++) 
      pivot[i] = p[i];
  }
  public void setPivotElem(int i, int piv) {
    pivot[i] = piv;
  }
E 18
E 9

I 14
  public void transpose() {
    if(rows == cols) 
      for(int i=0;i<rows;i++) {
	for(int j=0;j<i;j++) {
	  this.swapElem(i,j,j,i);
	}
      }
    else {
      LNumber[][] G = new LNumber[cols][rows];
      for(int i=0;i<rows;i++) {
	for(int j=0;j<cols;j++) {
	  G[j][i] = Mat[i][j];
	}
      }
      Mat = G;
      cols = rows;
      rows = G.length;
    }
  }
  public void transpose(NFull N) {
    for(int i=0;i<rows;i++) {
      for(int j=0;j<cols;j++) {
D 18
	N.refElem(j,i,Mat[i][j]);
E 18
I 18
	N.setElem(j,i,Mat[i][j]);
E 18
      }
    }
  }

  public NFull matMult(NFull N) {
    NFull G = new NFull(rows,N.numofCols());
    for(int i=0;i<rows;i++) {
      LNumber[] L = this.getRow(i,0);
      for(int j=0;j<N.numofCols();j++) {
	G.setElem(i,j,N.dot(cols,1,0,j,L,1,0));
      }
    }
    return G;
  }
  public void matMultTo(NFull N) {
    LNumber[][] G = new LNumber[rows][N.numofCols()];
    for(int i=0;i<rows;i++) {
      LNumber[] L = this.getRow(i,0);
      for(int j=0;j<N.numofCols();j++) {
	G[i][j] = N.dot(cols,1,0,j,L,1,0);
      }
    }
    Mat = G;
    cols = N.numofCols();
  }
  public NFull matMultRev(NFull N) {
    NFull G = new NFull(N.numofRows(),cols);
    for(int i=0;i<N.numofRows();i++) {
      LNumber[] L = N.getRow(i,0);
      for(int j=0;j<cols;j++) {
	G.setElem(i,j,this.dot(rows,1,0,j,L,1,0));
      }
    }
    return G;
  }

  public LNumber[] matVec(LNumber[] N) {
    LNumber[] G = new LNumber[rows];
    for(int i=0;i<rows;i++) {
      LNumber[] L = this.getRow(i,0);
      G[i] = NUtil.dot(cols,L,1,0,N,1,0);
    }
    return G;
  }

E 14
  private LNumber oneNorm() {
    LNumber a = this.asum(cols,1,0,0);
    for(int j=1;j<cols;j++) 
D 5
      a = a.max(this.asum(cols,1,0,j));
    return a;
E 5
I 5
      a.maxTo(this.asum(cols,1,0,j));
D 18
    return a.Clone();
E 18
I 18
    return a;
E 18
E 5
  }
  
  /*##  
   ##  svDecompose is a subroutine to reduce a single precision nXp 
   ##  NFull by orthogonal transformations U and V to diagonal form.  
   ##  The diagonal elements S[i] are the singular values of this 
   ##  NFull.  The columns of U are the corresponding left singular
   ##  vectors, and the columns of V the right singular vectors.
   ##
   ##  On Entry:
   ##
   ##     this      NFull where this.numofRows() >= n.
   ##               Contains the NFull whose singular value
   ##               decomposition is to be computed.  This NFull
   ##               is destroyed by svDecompose
   ##
   ##     n         int
   ##               n is the number of columns of the section of this
   ##               NFull that is to be used.
   ##
   ##     p         int
   ##               p is the number of rows of the section of this 
   ##               NFull that is to be used.
   ##
   ##     job       int
   ##               job controls the computation of the singular
   ##               vectors.  It has the decimal expansion AB
   ##               with the following meaning:
   ##
   ##                    A == 0    Do not compute the left singular
   ##                              vectors.
   ##                    A == 1    Return the n left singular vectors
   ##                              in U.
   ##                    A >= 2    Return the first min(n,p) singluar
   ##                              vectors in U.
   ##                    B == 0    Do not compute the right singular
   ##                              vectors.
   ##                    B == 1    Return the right singular vectors
   ##                              in V.
   ##
   ##  On Return:
   ##
   ##     S         LNumber[MM], where MM = Math.min(n+1,p).    
   ##               the first min(n,p) entries of S contain the 
   ##               singular values of this NFull arranged in 
   ##               descending order of magnitude.
   ##
   ##     E         LNumber[p]
   ##               E ordinarily contains zeros.  However see the 
   ##               discussion of info for exceptions.
   ##
   ##     U         LNumber[n][k], where if job(A) == 1 then k == n
   ##                               else k == Min(n,p)
   ##               U contains the NFull of right singular vectors.
   ##               U is not referenced if job(A) == 0.  
   ##
   ##     V         LNumber[p][p]
   ##               V contains the NFull of right singular vectors.
   ##               V is not referenced if job == 0.  
   ##
   ##     info      int
   ##               The singular values (and their corresponding
   ##               singular vectors) S(info),S(info+1),...,S(M-1)
   ##               are correct (here M=min(n,p)).  Thus if 
   ##               info == 0, all the singular values and their 
   ##               vectors are correct.  In any event, the matrix
   ##               B = U.transpose()*this*V is the bidiagonal matrix
   ##               with the elements of S on its diagonal and the 
   ##               elements of E on its super-diagonal.  Thus the 
   ##               singular values of this and B are the same.
   ##*/


D 6
  public int svDecompose(LNumber[] S, LNumber[] E, NFull U, NFull V, int job) {
E 6
I 6
  public int svDecompose(LNumber[] S, LNumber[] E, NFull U, NFull V, 
			 int job) {
E 6
    
    LNumber[] W = new LNumber[rows];
    int info = 0;
    
    /*##  
      ##  This is the maximum number of iterations.
      ##*/
    int MAXIT = 30;

    /*##  
      ##  Determine what is to be computed
      ##*/

    boolean wantU = false;
    boolean wantV = false;
    int jobu = (job%100)/10;
    int NCU = rows;
    if(jobu > 1) 
      NCU = Math.min(cols,rows);
    if(jobu != 0) 
      wantU = true;
    if(job%10 != 0) 
      wantV = true;
    int NCT = Math.min(rows-1,cols);
    int NRT = Math.max(0,Math.min(cols-2,rows));
    int lu = Math.max(NCT,NRT);
    for(int q=0;q<lu;q++) {
      int qp = q+1;
      if(q < NCT) { 
	S[q] = nrm2(rows-q,1,q,q);
	if(!S[q].equals(0)) {
	  if(!Mat[q][q].equals(0)) 
D 19
	    S[q] = NUtil.signOf(S[q],Mat[q][q]);
E 19
I 19
	    S[q] = NUtil.signOfM(S[q],Mat[q][q]);
E 19
	  this.scal(rows-q,S[q].inv(),1,q,q);
D 8
	  this.Mat[q][q].pplus();
E 8
I 8
	  Mat[q][q].pplus();
E 8
	}
D 18
	S[q].negate();
E 18
I 18
	S[q].negateTo();
E 18
      }
      for(int j=qp;j<cols;j++) {
D 6
	if(q < NCT) 
E 6
I 6
	if(q < NCT) {
E 6
	  if(!S[q].equals(0)) {
D 5
	    LNumber T = (dot(rows-q,1,q,q,this,1,q,j).div(Mat[q][q])).negate();
E 5
I 5
	    LNumber T = (dot(rows-q,1,q,q,this,1,q,j).div(Mat[q][q]))
D 18
	      .negate();
E 18
I 18
	      .negateTo();
E 18
E 5
	    this.axpy(rows-q,T,1,q,q,this,1,q,j);
	  }
I 6
	}
E 6
D 5
	E[j] = Mat[q][j];
E 5
I 5
	E[j] = Mat[q][j].Clone();
E 5
      }
      if(wantU && q<NCT) 
	for(int i=q;i<rows;i++) 
D 6
	  U.setElem(i,q,Mat[i][q].Clone());
      
E 6
I 6
	  U.setElem(i,q,Mat[i][q]);

E 6
      /*##  
       ##  Compute the q-th row transformation and place the q-th
       ##   super-diagonal in E[q]  
       ##*/

      if(q < NRT) {
	E[q] = NUtil.nrm2(cols-qp,E,1,qp);
	if(!E[q].equals(0)) {
	  if(!E[qp].equals(0)) 
D 10
D 19
	    E[q] = NUtil.signOf(E[q],E[qp]);
E 19
I 19
	    E[q] = NUtil.signOfM(E[q],E[qp]);
E 19
E 10
I 10
	    E[q].set(NUtil.signOf(E[q],E[qp]));
E 10
	  NUtil.scal(cols-qp,E[q].inv(),E,1,qp);
	  E[qp].pplus();
	}
D 18
	E[q].negate();
E 18
I 18
	E[q].negateTo();
E 18
	if(qp < rows && !E[q].equals(0)) {
	  for(int i=qp;i<rows;i++) {
	    W[i] = E[q].Clone();
	    W[i].setZero();
	  }
	  for(int j=qp;j<cols;j++) 
	    this.axpy(rows-qp,E[j],1,qp,j,W,1,qp);
	  for(int j=qp;j<cols;j++) 
D 18
	    this.axpy(rows-qp,(E[j].div(E[qp])).negate(),W,1,qp,1,qp,j);
E 18
I 18
	    this.axpy(rows-qp,(E[j].div(E[qp])).negateTo(),W,1,qp,1,qp,j);
E 18
	}
	if(wantV) 
	  for(int i=qp;i<cols;i++) 
D 10
	    V.setElem(i,q,E[i].Clone());
E 10
I 10
	    V.setElem(i,q,E[i]);
E 10
      }
    }
    int M = Math.min(rows+1,cols);
    if(NCT < cols) 
      S[NCT] = Mat[NCT][NCT];
D 8
    if(rows < M) 
E 8
I 8
    if(rows < M) {
D 18
      S[M-1] = Mat[0][0].Clone();
E 18
I 18
      S[M-1] = newOfType();
E 18
E 8
      S[M-1].setZero();
I 8
    }
E 8
    if(NRT+1 < M) 
D 10
      E[NRT] = Mat[NRT][M-1];
E 10
I 10
      E[NRT] = Mat[NRT][M-1].Clone();
    System.out.println(NRT+" "+M);
    if(NRT < 1)
      E[M-1] = Mat[0][0].Clone();
E 10
    E[M-1].setZero();

    if(wantU) 
      U.generateU(NCT,NCU,S);
    if(wantV) 
      V.generateV(NRT,E);

    int iter = 0;
    int MM = M;
    while(M>0) {
I 6
D 7
      System.out.println("M "+M);
E 7
E 6
      if(iter >= MAXIT) 
	return M;
      else {
	int q = qgetter(M-2,S,E);
	if(q == M-2) {
	  q++;
	  if(!S[q].greaterOrEqual(0)) {
D 18
	    S[q].negate();
E 18
I 18
	    S[q].negateTo();
E 18
D 5
	    if(wantV) {
	      LNumber P = S[q].Clone();
	      P.setZero();
	      P.sub(1);
	      V.scal(cols,P,1,0,q);
	    }
E 5
I 5
	    if(wantV) 
	      V.scal(cols,-1,1,0,q);
E 5
	  }
	  boolean notDone = true;
	  while(q < MM-1 && notDone) {
	    if(S[q+1].greaterThan(S[q])) {
	      NUtil.swapElems(S,q,q+1);
D 6
	      
E 6
	      if(wantV && q < cols-1) 
		V.swap(cols,1,0,q,V,1,0,q+1);
	      if(wantU && q < rows-1) 
		U.swap(rows,1,0,q,U,1,0,q+1);
D 6
	      
E 6
	      q++;
	    }
D 6
	    else
E 6
I 6
	    else 
E 6
	      notDone = false;
	  }
	  iter = 0;
	  M--;
	}
	else {
	  int qs = this.findNextStep(q,M,S,E);
I 7
D 8
	  System.out.println("QS "+qs+" "+q+" "+(M-1));
E 8
E 7
	  if(qs == q) {
	    q++;
	    NTrig Tg = this.fggetter(q,M,S,E);
	    
	    for(int k=q;k<M-1;k++) {
	      NUtil.rotg(Tg);
	      if(k != q) 
D 19
		E[k-1].set(Tg.getA());
E 19
I 19
		E[k-1] = Tg.getA();
E 19
	      Tg.setA(((Tg.getCos()).mult(S[k]))
		      .add((Tg.getSin()).mult(E[k])));
D 10
	      E[k] = ((Tg.getCos()).mult(E[k])).sub((Tg.getSin()).mult(S[k]));
E 10
I 10
	      E[k].set(((Tg.getCos()).mult(E[k])).sub((Tg.getSin())
						      .mult(S[k])));
E 10
	      Tg.setB((Tg.getSin()).mult(S[k+1]));
D 5
	      S[k+1] = S[k+1].mult(Tg.getCos());
E 5
I 5
	      S[k+1].multTo(Tg.getCos());
E 5
	      if(wantV) 
		V.rot(cols,1,0,k,V,1,0,k+1,Tg);
	      NUtil.rotg(Tg);
D 19
	      S[k].set(Tg.getA());
E 19
I 19
	      S[k] = Tg.getA();
E 19
	      Tg.setA((E[k].mult(Tg.getCos())).add(S[k+1].mult(Tg.getSin())));
D 10
D 18
	      S[k+1] = (E[k].mult((Tg.getSin()).mult(-1)))
E 18
I 18
	      S[k+1] = (E[k].mult((Tg.getSin()).negate()))
E 18
		.add(S[k+1].mult(Tg.getCos()));
E 10
I 10
	      S[k+1].set((E[k].mult((Tg.getSin()).mult(-1)))
			 .add(S[k+1].mult(Tg.getCos())));
E 10
	      Tg.setB((Tg.getSin()).mult(E[k+1]));
D 5
	      E[k+1] = E[k+1].mult(Tg.getCos());
E 5
I 5
	      E[k+1].multTo(Tg.getCos());
E 5
	      if(wantU && k < rows-1) 
		U.rot(rows,1,0,k,U,1,0,k+1,Tg);
	    }
	    E[M-2] = Tg.getA();
	    iter++;
	  }
	  else if(qs == M-1) {
	    q++;
	    int MMOne = M-2;
	    NTrig Tg = new NTrig();
	    Tg.setB(E[MMOne].Clone());
	    E[MMOne].setZero();
	    for(int k=MMOne;k>=q;k--) {
	      Tg.setA(S[k]);
	      NUtil.rotg(Tg);
I 6
	      S[k] = Tg.getA();
E 6
	      if(k != q) {
D 18
		Tg.setB(((Tg.getSin()).mult(E[k-1])).negate());
E 18
I 18
		Tg.setB(((Tg.getSin()).mult(E[k-1])).negateTo());
E 18
D 5
		E[k-1] = E[k-1].mult(Tg.getCos());
E 5
I 5
		E[k-1].multTo(Tg.getCos());
E 5
	      }
	      if(wantV) 
		V.rot(cols,1,0,k,V,1,0,MMOne+1,Tg);
	    }
	  }
	  else {
I 6
D 8
	    System.out.println("SVD 36");
E 8
E 6
	    q = qs;
	    NTrig Tg = new NTrig();
	    Tg.setB(E[q].Clone());
	    E[q].setZero();
	    q++;
	    for(int k=q;k<M;k++) {
I 6
D 8
	      System.out.println("SVD 37");
E 8
E 6
	      Tg.setA(S[k]);
	      NUtil.rotg(Tg);
I 6
	      S[k] = Tg.getA();
E 6
D 18
	      Tg.setB(((Tg.getSin()).mult(E[k])).negate());
E 18
I 18
	      Tg.setB(((Tg.getSin()).mult(E[k])).negateTo());
E 18
D 5
	      E[k] = E[k].mult(Tg.getCos());
E 5
I 5
	      E[k].multTo(Tg.getCos());
E 5
D 6
	      if(wantU) 
E 6
I 6
D 8
	      if(wantU) {
		System.out.println("SVD 38");
E 8
I 8
	      if(wantU) 
E 8
E 6
		U.rot(rows,1,0,k,U,1,0,q-1,Tg);
I 6
D 8
	      }
E 8
E 6
	    }
	  }
	}
      }
    }
    return info;
  }
  private void generateU(int NCT, int NCU, LNumber[] S) {
    for(int j=NCT;j<NCU;j++) {
      for(int i=0;i<cols;i++) {
D 5
	this.Mat[i][j].setZero();
E 5
I 5
	Mat[i][j] = S[0].Clone();
	Mat[i][j].setZero();
E 5
      }
D 5
      this.Mat[j][j].setOne();
E 5
I 5
      Mat[j][j].setOne();
E 5
    }
    if(NCT > 0) {
      for(int q=NCT-1;q>=0;q--) {
	if(!S[q].equals(0)) {
	  for(int j=q+1;j<NCU;j++) {
D 5
	    LNumber T = (dot(cols-q,1,q,q,this,1,q,j).div(Mat[q][q])).negate();
E 5
I 5
	    LNumber T = (dot(cols-q,1,q,q,this,1,q,j).div(Mat[q][q]))
D 18
	      .negate();
E 18
I 18
	      .negateTo();
E 18
E 5
	    this.axpy(cols-q,T,1,q,q,this,1,q,j);
	  }
	  this.scal(cols-q,-1,1,q,q);
	  this.Mat[q][q].pplus();
D 5
	  for(int i=0;i<q;i++) 
E 5
I 5
	  for(int i=0;i<q;i++) { 
	    Mat[i][q] = S[0].Clone();
E 5
	    this.Mat[i][q].setZero();
I 5
	  }
E 5
	}
	else {
D 5
	  for(int i=0;i<cols;i++) 
E 5
I 5
	  for(int i=0;i<cols;i++) {
	    Mat[i][q] = S[0].Clone();
E 5
	    this.Mat[i][q].setZero();
I 5
	  }
E 5
	  this.Mat[q][q].setOne();
	}
      }
I 6
D 10
D 18
      /*
      for(int q=NCT;q<cols;q++) {
	for(int i=0;i<rows;i++) {
	  Mat[i][q] = S[0].Clone();
	  this.Mat[i][q].setZero();
	}
	Mat[q][q].setOne();
      }
      */
E 18
E 10
E 6
    }
  }
  private void generateV(int NRT, LNumber[] E) {
    for(int q=cols-1;q>=0;q--) {
      int qp = q+1;
D 5
      if((q < NRT) && (E[q] != 0)) {
E 5
I 5
D 6
      System.out.println("QP "+qp+" "+rows);
E 6
      if((q < NRT) && (!E[q].equals(0))) {
E 5
	for(int j=qp;j<rows;j++) {
	  LNumber T = (dot(rows-qp,1,qp,q,this,1,qp,j).div(Mat[qp][q]))
D 18
		       .negate();
E 18
I 18
		       .negateTo();
E 18
	  this.axpy(rows-qp,T,1,qp,q,this,1,qp,j);
	}	    
      }
D 5
      for(int i=0;i<rows;i++) 
	this.Mat[i][q].setZero();
      this.Mat[q][q].setOne();
E 5
I 5
      for(int i=0;i<rows;i++) {
	Mat[i][q] = E[0].Clone();
	Mat[i][q].setZero();
      }
      Mat[q][q].setOne();
E 5
    }
  }
  private int qgetter(int st, LNumber[] S, LNumber[] E) {
    for(int q=st;q >= 0;q--) {
D 19
      LNumber Test = (S[q].abs()).add(S[q+1].abs());
      LNumber ZTest = Test.add(E[q].abs());
E 19
I 19
      LNumber Test = (S[q].modulus()).add(S[q+1].modulus());
      LNumber ZTest = Test.add(E[q].modulus());
E 19
      if(ZTest.equals(Test)) {
	E[q].setZero();
	return q;
      }
    }
    return -1;
  }
  private int findNextStep(int q, int M, LNumber[] S, LNumber[] E) {
    for(int qs=M-1;qs>q;qs--) {
D 19
      LNumber Test = E[qs].abs();
E 19
I 19
      LNumber Test = E[qs].modulus();
E 19
      if(qs == M-1) 
	Test.setZero();
      if(qs != q+1) 
D 5
	Test = Test.add(E[qs-1].abs());
E 5
I 5
D 19
	Test.addTo(E[qs-1].abs());
E 5
      LNumber Ztest = Test.add(S[qs].abs());
E 19
I 19
	Test.addTo(E[qs-1].modulus());
      LNumber Ztest = Test.add(S[qs].modulus());
E 19
      if(Ztest.equals(Test)) {
	S[qs].setZero();
	return qs;
      }
    }
    return q;
  }
  private NTrig fggetter(int q, int M, LNumber[] S, LNumber[] E) {
    NTrig Tg = new NTrig();
    LNumber scale = NUtil.aMax(S[M-1],S[M-2],E[M-2],S[q],E[q]);
    LNumber SM = S[M-1].div(scale);
    LNumber SMM = S[M-2].div(scale);
    LNumber EMM = E[M-2].div(scale);
    LNumber Sq = S[q].div(scale);
    LNumber Eq = E[q].div(scale);
    LNumber B = (((SMM.add(SM)).mult(SMM.sub(SM))).add(EMM.square())).div(2);
    LNumber C = (SM.mult(EMM)).square();
    LNumber shift = C.Clone();
    shift.setZero();
    if(!(B.equals(0) && C.equals(0))) {
      shift = ((B.square()).add(C)).sqrt();
      if(!B.greaterOrEqual(0)) 
D 18
	shift.negate();
E 18
I 18
	shift.negateTo();
E 18
      shift = C.div(B.add(shift));
    }
    Tg.setA(((Sq.add(SM)).mult(Sq.sub(SM))).sub(shift));
    Tg.setB(Sq.mult(Eq));
D 6
  
E 6
I 6
    
E 6
    return Tg;
  }

  /*##
   ##  qrDecompose uses Householder transformations to compute the
   ##  QR factorization of an n by p NFull.  Column pivoting
   ##  based on the 2-norms of the reduced columns may be
   ##  performed at the user's option.
   ##
   ##  On Entry:
   ##
   ##    this    NFull - Mat[L][p], where L >= n            
   ##            NFull contains the NFull whose decomposition is to 
   ##            be computed.
   ##
   ##
   ##    n       int 
   ##            n is the number of rows of NFull.Mat to be used in
   ##            the calculation
   ##
   ##    p       int 
   ##            p is the number of columns of NFull.Mat to be used
   ##            in the calculation
   ##
   ##    pivot   int[p]
   ##            pivot contains ints that control the selection
   ##            of the pivot columns.  The k-th column NFull.Mat[0][k]
   ##            is placed in one of three classes according to the 
   ##            value of pivot[k]:
   ##
   ##               if pivot[k] > 0, then NFull.getColumn(k,0) is an
   ##                                  initial column.
   ##
   ##               if pivot[k] == 0, then NFull.getColumn(k,0) is a
   ##                                  free column.
   ##
   ##               if pivot[k] < 0, then NFull.getColumn(k,0) is a 
   ##                                  final column.
   ##
   ##            Before the decomposition is computed, initial columns
   ##            are moved to the beginning of NFull.Mat and final
   ##            columns to the end.  Both initial and final columns
   ##            are frozen in place during the computation and only 
   ##            free columns are moved.  At the k-th stage of the 
   ##            reduction, if NFull.getColumn(k,0) is occupied by a
   ##            free column it is interchanged with the free column of
   ##            largest reduced norm.  pivot is not referenced if 
   ##            job == 0.
   ##
   ##
   ##  On Return
   ##
   ##    this    NFull.Mat contains in its upper triangle the upper
   ##            triangular matrix R of the QR factorization.
   ##            Below its diagonal NFull.Mat contains information 
   ##            from which the orthogonal part of the decomposition
   ##            can be recovered.  Note that if pivoting has
   ##            been requested, the decomposition is not that
   ##            of the original NFull.Mat, but that of NFull.Mat
   ##            with its columns permuted as described by pivot.
   ##
   ##    QRaux   LNumber[p]
   ##            QRaux contains further information required to recover 
   ##            the orthogonal part of the decomposition.
   ##
   ##    pivot   pivot[k-1] contains the index of the column of the
   ##            original matrix that has been interchanged into 
   ##            the k-th column, if pivoting was requested.
   ##*/

  public void qrPDecompose(LNumber[] QRaux) {
    Pul P = new Pul(0,-1);
    this.qrPivot(P);
    this.qrDecom(P, QRaux);
  }
  private void qrPivot(Pul P) {
    this.swaperSki(P);
D 6

E 6
    P.pu = cols-1;
    for(int j=P.pu;j>=0;j--) {
      if(pivot[j] < 0) {
	pivot[j] = -pivot[j];
	if(j != P.pu) {
	  this.swap(rows,1,0,P.pu,this,1,0,j);
	  NUtil.swapElems(pivot,P.pu,j);
	}
	P.pu--;
      }
    }
  }
  void swaperSki(Pul P) {
    for(int j=0;j<cols;j++) {
      boolean swapj = (pivot[j] > 0);
      if(pivot[j] < 0) 
	pivot[j] = -j-1;
      else 
	pivot[j] = j+1;

      if(swapj) 
	this.swap2(j,P);
    }
  }
  void swap2(int j, Pul P) {
    if(j != P.pl) 
      this.swap(rows,1,0,P.pl,this,1,0,j);
    pivot[j] = pivot[P.pl];
    pivot[P.pl] = j+1;
    P.pl++;
  }
   
  public void qrDecompose(LNumber[] QRaux) {
    Pul P = new Pul(0,-1);
    qrDecom(P,QRaux);
  }
  private void qrDecom(Pul P, LNumber[] QRaux) {
    LNumber[] Work = new LNumber[cols];

    for(int j=P.pl;j<=P.pu;j++) {
      QRaux[j] = this.nrm2(rows,1,0,j);
      Work[j] = QRaux[j].Clone();
    }
    int qup = Math.min(rows,cols);
    for(int q=0;q<qup;q++) {
      if(q >= P.pl && q<P.pu) {
	LNumber maxnorm = QRaux[q];
	int maxj = q;
	for(int j=q;j<=P.pu;j++) {
	  if(QRaux[j].greaterOrEqual(maxnorm)) {
	    maxnorm = QRaux[j];
	    maxj = j;
	  }
	}
	if(maxj != q) {
	  this.swap(rows,1,0,q,this,1,0,maxj);
	  QRaux[maxj] = QRaux[q].Clone();
	  Work[maxj] = Work[q].Clone();
	  NUtil.swapElems(pivot,maxj,q);
	}
      }
I 6
D 18
      QRaux[q] = Mat[0][0].Clone();
E 18
I 18
      QRaux[q] = newOfType();
E 18
E 6
      QRaux[q].setZero();
      if(q < rows-1) {
	LNumber normxq = this.nrm2(rows-q,1,q,q);
	if(!normxq.equals(0)) {
	  if(!this.Mat[q][q].equals(0)) 
D 19
	    normxq = NUtil.signOf(normxq,Mat[q][q]);
E 19
I 19
	    normxq = NUtil.signOfM(normxq,Mat[q][q]);
E 19
	  this.scal(rows-q,normxq.inv(),1,q,q);
	  this.Mat[q][q].pplus();
	  for(int j=q+1;j<cols;j++) {
	    LNumber T = ((dot(rows-q,1,q,q,this,1,q,j)).div(Mat[q][q]))
D 18
	      .negate();
E 18
I 18
	      .negateTo();
E 18
	    this.axpy(rows-q,T,1,q,q,this,1,q,j);
	    if(j >= P.pl && j <= P.pu) {
	      if(!QRaux[j].equals(0)) {
D 19
		LNumber TT = (((Mat[q][j].abs()).div(QRaux[j])).square())
E 19
I 19
		LNumber TT = (((Mat[q][j].modulus()).div(QRaux[j])).square())
E 19
		  .subFrom(1);
D 5
		TT = TT.max(0);
E 5
I 5
D 6
		if(!TT.greaterThan(0))
E 6
I 6
		if(!TT.greaterThan(0)) 
E 6
		  TT.setZero();
E 5
		T = TT.Clone();
D 5
		TT = ((TT.mult((QRaux[j].div(Work[j])).square())).mult(.5))
E 5
I 5
		TT = ((TT.mult((QRaux[j].div(Work[j])).square())).div(2))
E 5
		  .add(1);
		if(!TT.equals(1)) 
D 5
		  QRaux[j] = QRaux[j].mult(T.sqrt());
E 5
I 5
		  QRaux[j].multTo(T.sqrt());
E 5
		else {
		  QRaux[j] = this.nrm2(rows-q-1,1,q+1,j);
		  Work[j] = QRaux[j].Clone();
		}
	      }
	    }
	  }
	  QRaux[q] = Mat[q][q];
D 18
	  Mat[q][q] = normxq.mult(-1);
E 18
I 18
	  Mat[q][q] = normxq.negate();
E 18
	}
      }
    }
  }

  /*##
   ##  The following qr*** routines apply the output of qrDecompose to 
   ##  compute coordinate transformations, projections, and least squares
   ##  solutions.
   ##  for k < Min(n,p), let XK be the matrix
   ##
   ##        XK = (this.getColumn(pivot(0)-1,0),
   ##                 this.getColumn(pivot(1)-1,0),
   ##                 ... ,this.getColumn(pivot(k)-1,0));
   ##
   ##  formed from columns pivot[0], ... , pivot[k] of the original
   ##  n X p matrix NFull.Mat that was input to qrDecompose (if no
   ##  pivoting was done, XK consists of the first k+1 columns of 
   ##  NFull.Mat in their original order).  qrDecompose produces a 
   ##  factored orthogonal matrix Q and an upper triang. matrix R s.t.
   ##
   ##          XK = Q * (R)
   ##                   (0)
   ##
   ##  this information is contained in coded form in NFull.Mat and QRaux
   ##
   ##  On Entry
   ##
   ##    this   NFull.Mat[n][p]
   ##           NFull.Mat contains the output of qrDecompose
   ##
   ##    n      int 
   ##           n is the number of rows of the matrix XK.  It must
   ##           have the same value as n in qrDecompose.
   ##
   ##    k      int 
   ##           k is the number of columns of the matrix XK.  k
   ##           must not be greater than min(n,p), where p is the 
   ##           same as in qrDecompose.
   ##
   ##    QRaux  LNumber[p]
   ##           QRaux contains the auxiliary output from qrDecompose.
   ##
   ##    Y      LNumber[n]
   ##           Y contains the vector that is to be manipulated
   ##           by qr***.
   ##
   ##  On Return from its respective function
   ##
   ##  qrQy:
   ##    Qy     LNumber[n]
   ##           Qy contains Q*Y
   ##
   ##  qrQty:
   ##    Qty    LNumber[n]
   ##           Qty contains Q.transpose()*Y
   ##
   ##  qrQB:
   ##    B      LNumber[k]
   ##           B contains the solution of the least squares problem
   ##
   ##                minimize norm2(Y - XK*B),
   ##
   ##           (Note that if pivoting was requested in qrDecompose, 
   ##           the j-th component of B will be associated with column
   ##           pivot[j-1]-1 of the original NFull.Mat that was input
   ##           into qrDecompose.)
   ##
   ##    info   int
   ##           info is zero unless R is exactly singular in the 
   ##           computation of B.  In this case, info is the index plus
   ##           one of the first zero diagonal element of R and B is 
   ##           left unaltered.
   ##
   ##  qrQRSD:
   ##    Rsd    LNumber[n]
   ##           Rsd contains the least squares residual Y - XK*B,
   ##           Rsd is also the orthogonal projection of Y onto the
   ##           orthogonal complement of the column space of XK.
   ##
   ##  qrXB:
   ##    Xb     LNumber[n]
   ##           Xb contains the least squares approximation XK*B,
   ##           Xb is also the orthogonal projection of Y onto the 
   ##           column space of NFull.Mat.
   ##*/
  
  public void qrQy(LNumber[] QRaux, LNumber[] Y, LNumber[] Qy) {
    
    int k = Math.min(rows,cols);
    int ju = Math.min(k,rows-1) - 1;
    
    if(ju < 0) 
      Qy[0] = Y[0].Clone();
    else {
      NUtil.copy(rows,Y,1,0,Qy,1,0);
      for(int j=ju;j>=0;j--) 
	this.qrsolver(j,Qy,QRaux);
    }
  }
  
  public void qrQty(LNumber[] QRaux, LNumber[] Y,LNumber[] Qty) {
    
    int k = Math.min(rows,cols);
D 6

E 6
    int ju = Math.min(k,rows-1) - 1;
    
    if(ju < 0) 
      Qty[0] = Y[0].Clone();
    else {
      NUtil.copy(rows,Y,1,0,Qty,1,0);
      for(int j=0;j<=ju;j++) 
	this.qrsolver(j,Qty,QRaux);
    }
  }

  public int qrB(LNumber[] QRaux, LNumber[] Y,
		 LNumber[] Qty, LNumber[] B) {

    int k = Math.min(cols,rows);
D 6

E 6
    int ju = Math.min(k,rows-1) - 1;
    
    qrQty(QRaux,Y,Qty);

    if(ju < 0) {
      if(Mat[0][0].equals(0)) 
	return 1;
      else 
	B[0] = Y[0].div(Mat[0][0]);
    }
    else {
      NUtil.copy(k,Qty,1,0,B,1,0);
      for(int j=k-1;j>=0;j--) {
	if(Mat[j][j].equals(0)) 
	  return j+1;
	else {
D 5
	  B[j] = B[j].div(Mat[j][j]);
E 5
I 5
	  B[j].divTo(Mat[j][j]);
E 5
	  if(j > 0) 
D 18
	    this.axpy(j,B[j].mult(-1),1,0,j,B,1,0);
E 18
I 18
	    this.axpy(j,B[j].negate(),1,0,j,B,1,0);
E 18
	}
      }
    }
    return 0;
  }

  public void qrXB(LNumber[] QRaux, LNumber[] Y,
		  LNumber[] Qty, LNumber[] Xb) {
    
    int k = Math.min(cols,rows);
D 6

E 6
    int ju = Math.min(k,rows-1) - 1;
    
    qrQty(QRaux,Y,Qty);

    if(ju < 0) 
      Xb[0] = Y[0].Clone();
    else {
      NUtil.copy(k,Qty,1,0,Xb,1,0);
      for(int i=k;i<rows;i++) {
	Xb[i] = Y[0].Clone();
	Xb[i].setZero();
      }
      for(int j=ju;j>=0;j--) 
	this.qrsolver(j,Xb,QRaux);
    }
  }
  public void qrRSD(LNumber[] QRaux, LNumber[] Y,
		    LNumber[] Qty, LNumber[] Rsd) {

    int k = Math.min(cols,rows);
    int ju = Math.min(k,rows-1) - 1;
    
    qrQty(QRaux,Y,Qty);
    
    if(ju < 0) {
      Rsd[0] = Y[0].Clone();
      Rsd[0].setZero();
    }
    else {
      int kp = k+1;
      if(k < rows) 
	NUtil.copy(rows-k,Qty,1,k,Rsd,1,k);
      for(int i=0;i<k;i++) {
	Rsd[i] = Y[0].Clone();
	Rsd[i].setZero();
      }
      for(int j=ju;j>=0;j--) 
	this.qrsolver(j,Rsd,QRaux);
    }
  }
  private void qrsolver(int j, LNumber[] R, LNumber[] QRaux) {
    if(!QRaux[j].equals(0)) {
      LNumber Temp = Mat[j][j].Clone();
      Mat[j][j] = QRaux[j];
D 18
      LNumber T = (dot(rows-j,1,j,j,R,1,j).div(Mat[j][j])).negate();
E 18
I 18
      LNumber T = (dot(rows-j,1,j,j,R,1,j).div(Mat[j][j])).negateTo();
E 18
      this.axpy(rows-j,T,1,j,j,R,1,j);
      Mat[j][j] = Temp;
    }
  }

I 15
D 18
  public void setPivots(int[] p) {
    int q = Math.min(p.length,cols);
    for(int i=0;i<q;i++) 
      pivot[i] = p[i];
  }
  public void setPivotElem(int i, int piv) {
    pivot[i] = piv;
  }

  void decom(Pul P) 
       throws SingularMatrixException
  {
    LNumber[] W = new LNumber[cols];
    
    for(int k=0;k<cols;k++) {
      // Reduction loop //
      LNumber maxdia = Mat[k][k];
      int kp = k+1;
      int maxln = k;

      if((k >= P.pl) && (k < P.pu)) {
	for(int q=kp;q<=P.pu;q++) {
	  if(Mat[q][q].greaterThan(maxdia)) {
	    maxdia = this.Mat[q][q];
	    maxln = q;
	  }
	}
      }
      if(!maxdia.greaterOrEqual(0)) 
	throw new SingularMatrixException(k+1);
      
      else {
	if(k != maxln) {
	  this.swap(k,1,0,k,this,1,0,maxln);
	  Mat[maxln][maxln] = Mat[k][k];
	  Mat[k][k] = maxdia;
	  NUtil.swapElems(pivot, k, maxln);
	}
	W[k] = Mat[k][k].sqrt();
	Mat[k][k] = W[k];
	for(int j=kp;j<cols;j++) {
	  if(k != maxln) {
	    this.chSwaps(k,j,maxln);
	  }
	  Mat[k][j].divTo(W[k]);
	  W[j] = Mat[k][j];
	  this.axpy(j-k,W[j].mult(-1),W,1,kp,1,kp,j);
	}
      }
    }
  }
  void chPivot(Pul P) {
    
    this.swaperSki(P);

    // change pivots //
    
    P.pu = cols-1;
    for(int k=P.pu;k>=P.pl;k--) {
      if(pivot[k] < 0) {
	pivot[k] = -pivot[k];
	if(P.pu != k) {
	  this.swap(k,1,0,k,this,1,0,P.pu);
	  this.swapElem(k,k,P.pu,P.pu);
	  for(int j=k+1;j<cols;j++) {
	    this.chSwaps(k,j,P.pu);
	  }
	  NUtil.swapElems(pivot,k,P.pu);
	}
	P.pu--;
      }
    }
  }
D 16
  private void chSwaps(int k, int j, int q) {
E 16
I 16
  void chSwaps(int k, int j, int q) {
E 16
    if(j < q) 
      this.swapElem(k,j,j,q);
    else if(j > q) 
      this.swapElem(k,j,q,j);
  }
E 18

E 15
D 18
  public void chUpdate(LNumber[] X,LNumber[][] Z,  
		     LNumber[] Y, LNumber[] Rho, LNumber[] C, LNumber[] S) {
E 18
I 18
  public void chUpdate(LNumber[] X,LNumber[][] Z,LNumber[] Y, LNumber[] Rho, 
		       LNumber[] C, LNumber[] S) {
E 18
    
    // Update the matrix //

    for(int j=0;j<cols;j++) {
      LNumber Xj = X[j].Clone();
D 14
      
E 14
I 14
D 18
      System.out.println("U1");
E 18
E 14
      for(int i=0;i<j;i++) {
I 14
D 18
	System.out.println("U2");
E 18
E 14
	LNumber T = (C[i].mult(Mat[i][j])).add(S[i].mult(Xj));
	Xj = (C[i].mult(Xj)).sub(S[i].mult(Mat[i][j]));
D 18
	Mat[i][j] = T;
E 18
I 18
D 19
	Mat[i][j].set(T);
E 19
I 19
	Mat[i][j] = T;
E 19
E 18
      }
      NTrig Tg = new NTrig(Xj,C[j],S[j]);
      this.rotg(j,j,Tg);
I 18
      C[j] = Tg.getCos();
      S[j] = Tg.getSin();
E 18
    }
    for(int j=0;j<Z[0].length;j++) {
      LNumber Zeta = Y[j].Clone();
I 14
D 18
      System.out.println("U3");
E 18
E 14
      for(int i=0;i<cols;i++) {
I 14
D 18
	System.out.println("U4");
E 18
E 14
	LNumber T = (C[i].mult(Z[i][j])).add(S[i].mult(Zeta));
	Zeta = (C[i].mult(Zeta)).sub(S[i].mult(Z[i][j]));
D 18
	Z[i][j] = T;
E 18
I 18
D 19
	Z[i][j].set(T);
E 19
I 19
	Z[i][j] = T;
E 19
E 18
      }
D 19
      LNumber azeta = Zeta.abs();
E 19
I 19
      LNumber azeta = Zeta.modulus();
E 19
      if(!azeta.equals(0) && Rho[j].greaterOrEqual(0)) {
	LNumber scale = azeta.mult(Rho[j]);
	Rho[j] = scale.mult((((azeta.div(scale)).square())
			     .add((Rho[j].div(scale)).square())).sqrt());
I 14
D 18
	System.out.println("U5");
E 18
E 14
      }
    }
  }
  public int chDowndate(LNumber[] X,LNumber[][] Z,
		      LNumber[] Y,LNumber[] Rho,LNumber[] C,LNumber[] S) {
    
    int info = 0;
    LNumber Zeta;

    S[0] = X[0].div(Mat[0][0]);
    for(int j=1;j<cols;j++) {
I 14
D 18
      System.out.println("D1");
E 18
E 14
      S[j] = X[j].sub(dot(j,1,0,j,S,1,0));
D 5
      S[j] = S[j].div(Mat[j][j]);
E 5
I 5
      S[j].divTo(Mat[j][j]);
E 5
    }
    LNumber norm = NUtil.nrm2(cols,S,1,0);
D 14
    if(norm.greaterOrEqual(1)) 
E 14
I 14
D 18
    if(norm.greaterOrEqual(1)) {
      System.out.println("D2");
E 18
I 18
    if(norm.greaterOrEqual(1)) 
E 18
E 14
      info = -1;
I 14
D 18
    }
E 18
E 14
    else {
I 14
D 18
      System.out.println("D3");
E 18
E 14
      LNumber alpha = ((norm.square()).subFrom(1)).sqrt();
      for(int i=cols-1;i>=0;i--) {
I 14
D 18
	System.out.println("D4");
E 18
E 14
D 19
	LNumber scale = alpha.add(S[i].abs());
E 19
I 19
	LNumber scale = alpha.add(S[i].modulus());
E 19
	LNumber A = alpha.div(scale);
	LNumber B = S[i].div(scale);
	norm = (A.square().add(B.square())).sqrt();
	C[i] = A.div(norm);
	S[i] = B.div(norm);
	alpha = scale.mult(norm);
      }
      for(int j=0;j<cols;j++) {
I 14
D 18
	System.out.println("D5");
E 18
E 14
	LNumber XX = alpha.Clone();
	XX.setZero();
	LNumber T;
	for(int i=j;i>=0;i--) {
I 14
D 18
	  System.out.println("D6");
E 18
E 14
	  T = (C[i].mult(XX)).add(S[i].mult(Mat[i][j]));
	  Mat[i][j] = (C[i].mult(Mat[i][j])).sub(S[i].mult(XX));
	  XX = T;
	}
      }
      for(int j=0;j<Z[0].length;j++) {
	Zeta = Y[j];
I 14
D 18
	System.out.println("D7");
E 18
E 14
	for(int i=0;i<cols;i++) {
I 14
D 18
	  System.out.println("D8");
E 18
E 14
	  Z[i][j] = (Z[i][j].sub(S[i].mult(Zeta))).div(C[i]);
	  Zeta = (C[i].mult(Zeta)).sub(S[i].mult(Z[i][j]));
	}
D 19
	LNumber azeta = Zeta.abs();
E 19
I 19
	LNumber azeta = Zeta.modulus();
E 19
	if(azeta.greaterThan(Rho[j])) {
	  info = 1;
I 14
D 18
	  System.out.println("D9");
E 18
E 14
	  Rho[j].setOne();
D 18
	  Rho[j].negate();
E 18
I 18
	  Rho[j].negateTo();
E 18
	}
D 14
	else 
E 14
I 14
D 18
	else {
	  System.out.println("D10");
E 18
I 18
	else 
E 18
E 14
D 5
	  Rho[j] = Rho[j].mult((((azeta.div(Rho[j])).square())
				.subFrom(1)).sqrt());
E 5
I 5
	  Rho[j].multTo((((azeta.div(Rho[j])).square()).subFrom(1)).sqrt());
I 14
D 18
	}
E 18
E 14
E 5
      }
    }
    return info;
  }

  public void chExchange(int k, int q, NFull Z,
		       LNumber[] C, LNumber[] S, int job) {
    
    /* k and l are java (0 based) indices */

    int km = k-1;
    int kp = k+1;
    int qmkp = q-k;
    int qm = q-1;
    
    if(job == 1) {
D 17
      for(int i=0;i<=q;i++) {
I 14
	System.out.println("E1");
E 17
I 17
      for(int i=0;i<=q;i++) 
E 17
E 14
D 15
	int ii = q-i;
	S[i] = Mat[ii][q];
E 15
I 15
	S[i] = Mat[q-i][q].Clone();
E 15
D 17
      }
E 17
      for(int j=qm;j>=k;j--) {
D 14
	for(int i=0;i<=j;i++) 
E 14
I 14
D 17
	System.out.println("E2");
	for(int i=0;i<=j;i++) {
	  System.out.println("E3");
E 17
I 17
	for(int i=0;i<=j;i++) 
E 17
E 14
D 15
	  Mat[i][j+1] = Mat[i][j];
E 15
I 15
D 19
	  Mat[i][j+1].set(Mat[i][j]);
E 19
I 19
	  Mat[i][j+1] = Mat[i][j].Clone();
E 19
E 15
I 14
D 17
	}
E 17
E 14
	Mat[j+1][j+1].setZero();
      }
D 17
      for(int i=0;i<k;i++) {
I 14
	System.out.println("E4");
E 17
I 17
      for(int i=0;i<k;i++) 
E 17
E 14
D 15
	int ii = q-i;
	Mat[i][k] = S[ii];
E 15
I 15
D 19
	Mat[i][k].set(S[q-i]);
E 19
I 19
	Mat[i][k] = S[q-i].Clone();
E 19
E 15
D 17
      }
E 17
D 15
      LNumber T = S[0];
E 15
I 15
      LNumber T = S[0].Clone();
E 15
      NTrig Tg = new NTrig();
      for(int i=0;i<qmkp;i++) {
I 14
D 17
	System.out.println("E5");
E 17
E 14
	Tg.setA(S[i+1]);
	Tg.setB(T);
	NUtil.rotg(Tg);
D 15
	T = S[i+1];
	C[i] = Tg.getCos();
	S[i] = Tg.getSin();
E 15
I 15
D 17
	T.set(S[i+1]);
E 17
I 17
	S[i+1] = Tg.getA();
	T = S[i+1].Clone();
E 17
	C[i] = (Tg.getCos()).Clone();
D 19
	S[i].set(Tg.getSin());
E 19
I 19
	S[i] = Tg.getSin().Clone();
E 19
E 15
      }
D 15
      Mat[k][k] = T;
E 15
I 15
D 19
      Mat[k][k].set(T);
E 19
I 19
      Mat[k][k] = T.Clone();
E 19
E 15
      for(int j=kp;j<cols;j++) {
I 14
D 17
	System.out.println("E6");
E 17
E 14
	int iq = Math.max(0,q-j);
	for(int ii = iq;ii<qmkp;ii++) {
	  int i = qm-ii;
I 14
D 17
	  System.out.println("E7");
E 17
E 14
	  this.applyTrans(j,i,ii,C,S);
	}
      }
      for(int j=0;j<Z.numofCols();j++) 
	for(int ii=0;ii<qmkp;ii++) {
I 14
D 17
	  System.out.println("E8");
E 17
E 14
	  int i = qm - ii;
	  Z.applyTrans(j,i,ii,C,S);
	}
    }
    else {
D 17
      for(int i=0;i<=k;i++) {
I 14
	System.out.println("E9");
E 17
I 17
      for(int i=0;i<=k;i++) 
E 17
E 14
D 15
	int ii = qmkp + i;
	S[ii] = Mat[i][k];
E 15
I 15
	S[qmkp+i] = Mat[i][k].Clone();
E 15
D 17
      }
E 17
      for(int j=k;j<q;j++) {
D 14
	for(int i=0;i<=j;i++) 
E 14
I 14
D 17
	System.out.println("E10");
	for(int i=0;i<=j;i++) {
	  System.out.println("E11");
E 17
I 17
	for(int i=0;i<=j;i++) 
E 17
E 14
D 15
	  Mat[i][j] = Mat[i][j+1];
E 15
I 15
D 19
	  Mat[i][j].set(Mat[i][j+1]);
E 19
I 19
	  Mat[i][j] = Mat[i][j+1].Clone();
E 19
E 15
I 14
D 17
	}
E 17
E 14
D 15
	S[j-k] = Mat[j+1][j+1];
E 15
I 15
	S[j-k] = Mat[j+1][j+1].Clone();
E 15
      }
D 14
      for(int i=0;i<=k;i++) 
E 14
I 14
D 17
      for(int i=0;i<=k;i++) {
	System.out.println("E12");
E 17
I 17
      for(int i=0;i<=k;i++) 
E 17
E 14
D 15
	Mat[i][q] = S[qmkp+1];
E 15
I 15
D 19
	Mat[i][q].set(S[qmkp+1]);
E 19
I 19
	Mat[i][q] = S[qmkp+1].Clone();
E 19
E 15
I 14
D 17
      }
E 14

D 14
      for(int i=kp;i<=q;i++) 
E 14
I 14
      for(int i=kp;i<=q;i++) {
	System.out.println("E13");
E 17
I 17
      for(int i=kp;i<=q;i++) 
E 17
E 14
	Mat[i][q].setZero();
I 14
D 17
      }
E 14

E 17
      for(int j=k;j<cols;j++) {
I 14
D 17
	System.out.println("E14");
E 17
E 14
	if(j != k) {
I 14
D 17
	  System.out.println("E15");
E 17
E 14
	  int iu = Math.min(j-1,qm);
D 17
	  for(int i=k;i<=iu;i++) {
I 14
	    System.out.println("E16");
E 17
I 17
	  for(int i=k;i<=iu;i++) 
E 17
E 14
D 15
	    int ii = i-k;
	    this.applyTrans(j,i,ii,C,S);
E 15
I 15
	    this.applyTrans(j,i,i-k,C,S);
E 15
D 17
	  }
E 17
	}
	if(j < q) {
I 14
D 17
	  System.out.println("E17");
E 17
E 14
	  int jj = j-k;
	  NTrig Tg = new NTrig(S[jj].Clone(),C[jj],S[jj]);
	  this.rotg(j,j,Tg);
I 17
	  C[jj] = Tg.getCos();
	  S[jj] = Tg.getSin();
E 17
	}
      }
      for(int j=0;j<Z.numofCols();j++) 
D 17
	for(int i=k;i<q;i++) {
I 14
	  System.out.println("E18");
E 17
I 17
	for(int i=k;i<q;i++) 
E 17
E 14
D 15
	  int ii = i-k;
	  Z.applyTrans(j,i,ii,C,S);
E 15
I 15
	  Z.applyTrans(j,i,i-k,C,S);
E 15
D 17
	}
E 17
    }
  } 	   
  private void applyTrans(int j, int i, int ii, LNumber[] C, LNumber[] S) {
    LNumber T = (C[ii].mult(Mat[i][j])).add(S[ii].mult(Mat[i+1][j]));
D 15
    Mat[i+1][j] = (C[ii].mult(Mat[i+1][j])).sub(S[ii].mult(Mat[i][j]));
    Mat[i][j] = T;
I 14
    System.out.println("T1");
E 15
I 15
D 19
    Mat[i+1][j].set((C[ii].mult(Mat[i+1][j])).sub(S[ii].mult(Mat[i][j])));
    Mat[i][j].set(T);
E 19
I 19
    Mat[i+1][j] = (C[ii].mult(Mat[i+1][j])).sub(S[ii].mult(Mat[i][j]));
    Mat[i][j] = T;
E 19
E 15
E 14
  }
	
  /*## 
   ##  NFull.factor factors a single precision LNumbering point matrix by 
   ##  Gaussian elimination.  
   ##   
   ##  NFull.factor is usually called by NFull.condition, but it can be
   ##  called directly with a saving in time if Rcond is not needed.
   ##
   ##  On Entry:
   ##
   ##     this      NFull.Mat[n][n]
   ##               NFull.Mat is the matrix to be factored
   ##
   ##     n         int
   ##               n is the order of NFull.Mat
   ##
   ##  On Return:
   ##
   ##     this      An upper triangular matrix and multipliers used to
   ##               obtain it.  The factorization can be written
   ##               A = L*U where L is a product of permutation and 
   ##               unit lower triangular matrices and U is upper
   ##               triangular.
   ##
   ##     pivot    int[] 
   ##               pivot is a vector of pivot indices
   ##
   ##     info      int
   ##               The returned value where:
   ##               info = 0  normal value
   ##               info = k  if U(k-1,k-1) == 0, indicates solve & 
   ##                determ will divide by 0 if called
   ##*/
  
  public void factor() 
       throws SingularMatrixException
  {
    int info = 0;
    LNumber T;

    int nm = cols - 1;
    if(cols > 1) {
      
      for(int k=0;k < nm; k++) {
	int kp = k+1;
	
	/*##
	 ##  Find L the pivot index  
	 ##*/
	
	int L = this.i_amax(cols-k,1,k,k) + k;
D 11
	
E 11
I 11
D 12
	System.out.println(L+" "+k);
E 12
I 12

E 12
E 11
	pivot[k] = L+1;
D 19
	
E 19
I 19

E 19
	/*##
	 ##  Zero pivot implies this column already triangularized  
	 ##*/

D 19
	if(!Mat[L][k].equals(0)) {
E 19
I 19
	if(!(Mat[L][k].abs()).equals(0)) {
E 19
	  /*##
	   ##  Interchange if necessary 
	   ##*/
	    
	  if(L != k) 
	    this.swapElem(L,k,k,k);
D 11
	  
E 11
I 11
D 12
	  this.Print();
E 12
I 12

E 12
E 11
	  /*##
	   ##  Compute multipliers 
	   ##*/
D 11
	  
	  T = (Mat[k][k].divides(1)).negate();
E 11
I 11

D 18
	  T = (Mat[k][k].inv()).negate();
E 18
I 18
	  T = (Mat[k][k].inv()).negateTo();
E 18
E 11
	  this.scal(nm-k,T,1,kp,k);
D 11
	    
E 11
I 11

E 11
	  /*##
	   ##  Row elimination with column indexing 
	   ##*/
D 11
	  
E 11
I 11
D 12
	  this.Print();
E 12
I 12

E 12
E 11
	  for(int j=kp;j<cols;j++) {
D 11
D 13
	    T = Mat[L][j];
E 13
I 13
	    T = Mat[L][j].Clone();
E 13
E 11
I 11
	    T = Mat[L][j].Clone();
D 12
	    System.out.println("T "+T);
E 12
E 11
	    if(L != k) 
	      this.swapElem(L,j,k,j);
I 11
D 12
	    //this.Print();
E 12
E 11
	    this.axpy(nm-k,T,1,kp,k,this,1,kp,j);
	  }
I 11
D 12
	  this.Print();
E 12
E 11
	}
	else {
	  info = k+1;
	}
      }
    }
    pivot[cols-1] = cols;
D 19
    if(Mat[cols-1][cols-1].equals(0)) 
E 19
I 19
    if((Mat[cols-1][cols-1].abs()).equals(0)) 
E 19
      info = cols;
    if(info != 0)
      throw new SingularMatrixException(info);
  }
  
  /*##
   ##  NFull.condition factors by Gaussian Elimination and estimates the
   ##  condition of NFull.Mat.
   ##
   ##  If Rcond is not needed, factor is slightly faster.
   ##  To solve  Mat*X = B , follow condition by solve.
   ##  To compute  Inverse(Mat)*C , follow condition by solve.
   ##  To compute  Determinant(Mat) , follow condition by determ.
   ##  To compute  Inverse(Mat) , follow condition by inverse
   ##
   ##  On Entry
   ##
   ##    Mat     NFull.Mat[n][n]
   ##            The matrix to be factored.
   ##
   ##    n       int
   ##            The order of NFull.Mat.
   ##
   ##  On Return
   ##
   ##    Mat     An upper triangular matrix and the multipliers
   ##            used to obtain it.  The factorization can be written
   ##            Mat = L*U  where  L  is a product of permutation and unit 
   ##            lower triangular matrices and  U  is upper trinagular.
   ##
   ##    pivot   int[n]
   ##            An array of pivot indices.
   ##
   ##    R       FRcond(int info, LNumber Rcond)
   ##            info:  The value returned from factor
   ##            Rcond:  An estimate of the reciprocal condition of Mat.
   ##            For the system  Mat*X = B , relative perturbations
   ##            in  Mat  and  B  of size  EPSILON  may cause
   ##            relative perturbations in  X  of size  EPSILON/Rcond .
   ##            If  Rcond  is so small that the logical expression
   ##                       1 + Rcond == 1
   ##            is true, then  Mat  may be singular to working
   ##            precision.  In particular,  Rcond  is zero if
   ##            exact singularity is detected or the estimate 
   ##            underflows.
   ##
   ##    Z       LNumber[n]
   ##            A work vector whose contents are usually unimportant.
   ##            If  Mat  is close to a singular matrix, then  Z  is 
   ##            an approximate Null vector in the sense that
   ##            norm(Mat*Z) = Rcond*norm(Mat)*norm(Z) .
   ##*/

  public LNumber condition() 
D 11
       throws WrongDataTypeException, SingularMatrixException
E 11
I 11
       throws SingularMatrixException
E 11
  {
    LNumber[] Z = new LNumber[cols];
    return this.condition(Z);
  }
  public LNumber condition(LNumber[] Z) 
D 11
       throws WrongDataTypeException, SingularMatrixException
E 11
I 11
       throws SingularMatrixException
E 11
  {
    /*##
     ##  Compute 1-Norm of A 
     ##*/
    
    LNumber anorm = this.oneNorm();
    LNumber ynorm;

    /*## 
     ##  Factor 
     ##*/

    try {
      this.factor();
    } finally {

      /*##  
	##  Rcond = 1/A.oneNorm() * est.norm(A.inverse()).  ##
	##  est.norm = norm(Z)/norm(Y) where A*Z = Y and    ##
	##  A.transpose()*Y = E.                            ##
	##  Components of E are chosen to cause max local   ##
	##  growth in W.  Arrays are frequently rescaled    ##
	##  to avoid overflow.                              ##
	##*/
      
      /*##
	##  Solve Trans(U)*W = E    
	##*/
      
      for(int j=0;j<cols;j++) {
D 18
	Z[j] = Mat[0][0].Clone();
E 18
I 18
	Z[j] = this.newOfType();
E 18
	Z[j].setZero();
      }
D 11
      
E 11
I 11
D 12
      //this.Print();
E 12
I 12

E 12
E 11
      this.solveTransUW(Z);
      
D 18
      LNumber S = (NUtil.asum(cols,Z,1)).inv();
E 18
I 18
      LNumber S = (NUtil.asum(cols,Z,1)).invTo();
E 18
      NUtil.scal(cols,S,Z,1);
D 11
      
E 11
I 11
D 12
      //this.Print();
E 12
I 12

E 12
E 11
      /*##
	##  Solve Trans(L)*Y = W 
	##*/

      this.solveTransLY(Z);
D 11
      
E 11
I 11
D 12
      //this.Print();
E 12
I 12

E 12
E 11
      /*##
	##  Solve L*V = Y 
	##*/
      
      ynorm = this.solveLV(Z);
D 11
      
E 11
I 11
D 12
      //this.Print();
E 12
I 12

E 12
E 11
      /*##
	##  Solve U*Z = V 
	##*/
    
      ynorm = this.solveUZ(Z,ynorm);
D 11

E 11
I 11
D 12
      //this.Print();
E 12
I 12

E 12
E 11
      /*##
	##  Make Znorm == 1  
	##*/
    }
    LNumber R;
    
    if(!anorm.equals(0)) 
      R = ynorm.div(anorm);
    else 
      R = anorm;
    
    return R;
  }
  void solveTransUW(LNumber[] Z) {

D 18
    LNumber ek = Z[0].Clone();
E 18
I 18
    LNumber ek = this.newOfType();
E 18
    ek.setOne();

    for(int k=0;k<cols;k++) {
      
      if(!Z[k].equals(0)) 
D 18
	ek = NUtil.signOf(ek,Z[k].mult(-1));
E 18
I 18
D 19
	ek = NUtil.signOf(ek,Z[k].negate());
E 19
I 19
	ek = NUtil.signOfA(ek,Z[k].negate());
E 19
E 18
      
      if(((ek.sub(Z[k])).abs()).greaterThan(Mat[k][k].abs())) {
	LNumber S = (Mat[k][k].abs()).div((ek.sub(Z[k])).abs());
	NUtil.scal(cols,S,Z,1);
D 5
	ek = ek.mult(S);
E 5
I 5
	ek.multTo(S);
E 5
      }
      LNumber wk = ek.sub(Z[k]);
D 18
      LNumber wkm = (ek.mult(-1)).sub(Z[k]);
E 18
I 18
      LNumber wkm = (ek.negate()).sub(Z[k]);
E 18
      LNumber S = wk.abs();
      LNumber SM = wkm.abs();
      if(!Mat[k][k].equals(0)) {
D 5
	wk = wk.div(Mat[k][k]);
	wkm = wkm.div(Mat[k][k]);
E 5
I 5
	wk.divTo(Mat[k][k]);
	wkm.divTo(Mat[k][k]);
E 5
      }      
      else {
	wk.setOne();
	wkm.setOne();
      }
      int kp = k + 1;
      if(kp < cols) {
	for(int j=kp;j<cols;j++) {
D 5
	  SM = SM.add((Z[j].add(wkm.mult(Mat[k][j]))).abs());
E 5
I 5
	  SM.addTo((Z[j].add(wkm.mult(Mat[k][j]))).abs());
E 5
	  Z[j] = Z[j].add(wk.mult(Mat[k][j]));
D 5
	  S = S.add(Z[j].abs());
E 5
I 5
	  S.addTo(Z[j].abs());
E 5
	}
	if(SM.greaterThan(S)) {
	  LNumber T = wkm.sub(wk);
	  wk = wkm;
	  for(int j=kp;j<cols;j++) {
D 5
	    Z[j] = Z[j].add(T.mult(Mat[k][j]));
E 5
I 5
	    Z[j].addTo(T.mult(Mat[k][j]));
E 5
	  }
	}
      }  
      Z[k] = wk;
    }
  }
  private LNumber solveLV(LNumber[] Z) { 

D 4
    LNumber ynorm = Z[0].Clone();
E 4
I 4
    LNumber ynorm = Z[0].abs();
E 4
    ynorm.setOne();
    
    for(int k=0;k<cols;k++) {
      int L = pivot[k] - 1;
      LNumber T = Z[L].Clone();
      NUtil.swapElems(Z,L,k);
      
      if(k < cols-1) 
	this.axpy(cols-k-1,T,1,k+1,k,Z,1,k+1);
      
      if((Z[k].abs()).greaterThan(1)) {
D 18
	LNumber S = (Z[k].abs()).inv();
E 18
I 18
	LNumber S = (Z[k].abs()).invTo();
E 18
	NUtil.scal(cols,S,Z,1);
D 5
	ynorm = ynorm.mult(S);
E 5
I 5
	ynorm.multTo(S);
E 5
      }
    }
D 18
    LNumber S = (NUtil.asum(cols,Z,1)).inv();
E 18
I 18
    LNumber S = (NUtil.asum(cols,Z,1)).invTo();
E 18
    NUtil.scal(cols,S,Z,1);
D 5
    ynorm = ynorm.mult(S);
E 5
I 5
    ynorm.multTo(S);
E 5

    return ynorm;
  }
  private void solveTransLY(LNumber[] Z) {
    for(int k=cols-1;k>=0;k--) {
      if(k < cols-1) {
D 5
	Z[k] = Z[k].add(dot(cols-k-1,1,k+1,k,Z,1,k+1));
E 5
I 5
	Z[k].addTo(dot(cols-k-1,1,k+1,k,Z,1,k+1));
E 5
      }
      if((Z[k].abs()).greaterThan(1)) {
D 18
	LNumber S = (Z[k].abs()).inv();
E 18
I 18
	LNumber S = (Z[k].abs()).invTo();
E 18
	NUtil.scal(cols,S,Z,1);
      }
      int L = pivot[k] - 1;
      NUtil.swapElems(Z,L,k);
    }
    
D 18
    LNumber S = (NUtil.asum(cols,Z,1)).inv();
E 18
I 18
    LNumber S = (NUtil.asum(cols,Z,1)).invTo();
E 18
    NUtil.scal(cols,S,Z,1);
  }
  LNumber solveUZ(LNumber[] Z, LNumber ynorm) {
    for(int k=cols-1;k>=0;k--) {
      if((Z[k].abs()).greaterThan(Mat[k][k].abs())) {
	LNumber S = (Mat[k][k].abs()).div(Z[k].abs());
	NUtil.scal(cols,S,Z,1);
D 5
	ynorm = ynorm.mult(S);
E 5
I 5
	ynorm.multTo(S);
E 5
      } 
      if(!Mat[k][k].equals(0)) 
D 5
	Z[k] = Z[k].div(Mat[k][k]);
E 5
I 5
	Z[k].divTo(Mat[k][k]);
E 5
      else 
	Z[k].setOne();

D 18
      this.axpy(k,Z[k].mult(-1),1,0,k,Z,1,0);
E 18
I 18
      this.axpy(k,Z[k].negate(),1,0,k,Z,1,0);
E 18
    }
D 18
    LNumber S = (NUtil.asum(cols,Z,1)).inv();
E 18
I 18
    LNumber S = (NUtil.asum(cols,Z,1)).invTo();
E 18
    NUtil.scal(cols,S,Z,1);
D 5
    ynorm = ynorm.mult(S);
E 5
I 5
    ynorm.multTo(S);
E 5

    return ynorm;
  }

  /*##
   ##  this.solve solves the single precision system
   ##  A * X = B  or  A.transpose() * X = B 
   ##  using the factors computed by this.condition or this.factor.
   ##
   ##  On Entry
   ##
   ##    this.Mat   LNumber[n][n]
   ##               The output from this.condition or this.factor.
   ##
   ##    n          int    
   ##               The order of this.Mat.      
   ##
   ##    pivot      int(n)    
   ##               The pivot vector from this.condition or this.factor.
   ##
   ##    B          LNumber[n]
   ##               The right hand side vector.
   ##
   ##    Job        int
   ##                = 0         To solve  A*X = B ,
   ##                = non-zero  To solve  A.transpose() * X = B
   ##
   ##  On Return
   ##
   ##     B         The solution vector  X.
   ##
   ##  Error condition
   ##
   ##     A division by zero will occur if the input factor contains a 
   ##     zero on the diagonal.  Technically this indicates singularity
   ##     but it is often caused by improper arguments or improper
   ##     setting of  n.  It will not occur if the subroutines are
   ##     called correctly and if this.condition has set 
   ##     LLNumber.getLNumber > 0  or this.factor threw an exception
   ##
   ##  To compute  A.inverse() * C  where  C  is a FMatrix
   ##  with  p  columns
   ##
   ##        this.condition();
   ##        if (FRcond.Rcond > threshold) {  
   ##          for(int j=0;j<p;j++) 
   ##             this.solve(n,pivot,C,j,0);
   ##        }
   ##*/

D 11
  public void solve(NFull B, int c, int Job) 
       throws WrongDataTypeException
  {
E 11
I 11
  public void solve(NFull B, int c, int Job) {
E 11
    LNumber[] F = B.getColumn(c,0);
    this.solve(F, Job);
    B.setColumn(c,F);
  }
D 11
  public void solve(LNumber[] B) 
       throws WrongDataTypeException
  {
E 11
I 11
  public void solve(LNumber[] B) {
E 11
    this.solve(B,0);
  }
D 11
  public void solve(LNumber[] B, int Job) 
       throws WrongDataTypeException
  {
E 11
I 11
  public void solve(LNumber[] B, int Job) {
E 11
    int nm = cols - 1;
    if(Job == 0) {
      /*##
       ##  Job == 0 - solve A*X = B  
       ##*/
      /*##
       ##  First solve L*Y = B     
       ##*/

      for(int k=0; k<nm;k++) {
	int L = pivot[k] - 1;
	LNumber T = B[L].Clone();
	if(L != k) {
	  B[L] = B[k];
	  B[k] = T;
	}
	this.axpy(nm-k,T,1,k+1,k,B,1,k+1);
      }

      /*##
       ##  Now solve U*X = Y  
       ##*/

      this.solveUX(B);
    }
    else {

      /*##
       ##  Job = nonzero, solve  A.transpose() * X = B  
       ##*/
      /*##
       ##  First solve  U.transpose() * Y = B
       ##*/

      this.solveTransAX(B);

      /*##
       ##  Solve  L.transpose() * X = Y
       ##*/

      for(int k=cols-2;k>=0;k--) {
D 5
	B[k] = B[k].add(dot(nm-k,1,k+1,k,B,1,k+1));
E 5
I 5
	B[k].addTo(dot(nm-k,1,k+1,k,B,1,k+1));
E 5
	int L = pivot[k] - 1;
	if(L != k) 
	  NUtil.swapElems(B,L,k);
      }
    }
    return;
  }
  
  /*##
   ##  Solve U*X = Y  
   ##  This function is used by NPoFull
   ##*/
  
  void solveUX(LNumber[] B) {
    for(int k=cols-1;k>=0;k--) {
D 5
      B[k] = B[k].div(Mat[k][k]);
E 5
I 5
      B[k].divTo(Mat[k][k]);
E 5
D 18
      this.axpy(k,B[k].mult(-1),1,0,k,B,1,0);
E 18
I 18
      this.axpy(k,B[k].negate(),1,0,k,B,1,0);
E 18
    }
  }

  /*##
   ##  Solve  U.transpose() * Y = B
   ##  This function is used by NPoFull
   ##*/

  void solveTransAX (LNumber[] B){
    for(int k=0;k<cols;k++) {
      LNumber T = this.dot(k,1,0,k,B,1,0);
      B[k] = (B[k].sub(T)).div(Mat[k][k]);
    }
  }

  /*##
   ##  this.determ computes the determinant of a NFull using the
   ##  factors computed by this.condition or this.factor.
   ##
   ##  On Entry
   ##
   ##    this.Mat   LNumber[n][n]
   ##               The output from this.condition or this.factor.
   ##
   ##    n          int    
   ##               The order of  this.Mat.
   ##
   ##    pivot      int[n]  
   ##               The pivot vector from this.condition or this.factor.
   ##
   ##  On Return
   ##
   ##    Det        LNumber[2]
   ##               Determinant of original NFull
   ##               Determinant = Det[0] * 10.0**Det[1]
   ##               with  1  <=  Math.abs(Det[0])  <  10
   ##               or  Det[0]  ==  0.
   ##*/

  public LNumber[] determ() {

    LNumber[] Det = new LNumber[2];
    
    /*##
     ##  Compute Determinant  
     ##*/
    
D 18
    Det[0] = Mat[0][0].Clone();
    Det[1] = Mat[0][0].Clone();
E 18
I 18
    Det[0] = newOfType();
    Det[1] = newOfType();
E 18
    Det[0].setOne();
    Det[1].setZero();

    for(int i=0;i<cols;i++) {
      if(pivot[i] != i+1)
D 18
	Det[0].negate();
E 18
I 18
	Det[0].negateTo();
E 18
D 5
      Det[0] = Det[0].mult(Mat[i][i]);
E 5
I 5
      Det[0].multTo(Mat[i][i]);
E 5
D 6
      if(Det[0].equals(0)) {
E 6
I 6
      if(Det[0].equals(0)) 
E 6
	return Det;
D 6
      }      
E 6
      else 
	NUtil.detNorm(Det);
    }
    return Det;
  }
  
  /*##
   ##  this.inverse computes the inverse of a NFull using the
   ##  factors computed by this.condition or this.factor.
   ##
   ##  On Entry
   ##
   ##    this.Mat   LNumber[n][n]
   ##               The output from this.condition or this.factor.
   ##
   ##    n          int    
   ##               The order of  this.Mat.
   ##
   ##    pivot      int[n]  
   ##               The pivot vector from this.condition or this.factor.
   ##
   ##  On Return
   ##
   ##    this.Mat   Inverse of original NFull.Mat 
   ##
   ##  Error condition
   ##
   ##     A division by zero will occur if the input factor contains
   ##     a zero on the diagonal.  It will not occur if the subroutines
   ##     are called correctly and if this.condition has set 
   ##     NRcond.Rcond > 0 or this.factor has set info == 0.
   ##*/

  public void inverse() {
    /*## 
     ##  Compute Inverse of U 
     ##*/

    this.invertU();
    
    /*##
     ##  Form inverse(U)*inverse(L)  
     ##*/

    if(cols > 1) 
      this.invUinvL();
  }
  void invertU () {
        
    for(int k=0;k<cols;k++) {
D 18
      Mat[k][k] = Mat[k][k].inv();
      LNumber T = Mat[k][k].mult(-1);
E 18
I 18
      Mat[k][k].invTo();
      LNumber T = Mat[k][k].negate();
E 18
      this.scal(k,T,1,0,k);
      for(int j=k+1;j<cols;j++) {
	T = Mat[k][j].Clone();
	Mat[k][j].setZero();
	this.axpy(k+1,T,1,0,k,this,1,0,j);
      }
    }
  }
  private void invUinvL() {
    
    LNumber[] Work = new LNumber[cols];
    
    for(int k=cols-1;k>=0;k--) {
      int kp = k+1;
      for(int i=kp;i<cols;i++) {
	Work[i] = Mat[i][k].Clone();
	Mat[i][k].setZero();
      }
      for(int j=kp;j<cols;j++) 
	this.axpy(cols,Work[j],1,0,j,this,1,0,k);

      int L = pivot[k] - 1;
      if(L != k) 
	this.swap(cols,1,0,k,this,1,0,L);
    }
  }
E 3
}
E 1
