h42794
s 00034/00043/00754
d D 1.17 98/08/28 15:41:43 jpiper 20 19
c Fixed for limited access and complex numbers
e
s 00013/00002/00784
d D 1.16 98/08/12 17:06:52 jpiper 19 18
c adjusted for LNumber
e
s 00003/00003/00783
d D 1.15 98/08/06 16:21:27 jpiper 18 17
c Fixed small error
e
s 00009/00007/00777
d D 1.14 98/08/04 18:47:09 jpiper 17 16
c small bug I missed
e
s 00000/00000/00784
d D 1.13 98/08/03 18:49:25 jpiper 16 15
c Needed for debugging
e
s 00000/00003/00784
d D 1.12 98/07/31 18:07:01 jpiper 15 13
i 14
c Accepted child's version in workspace "/home/jpiper/MyJavaLinpack".
c 
e
s 00358/00116/00426
d D 1.10.1.1 98/07/31 17:59:26 jpiper 14 11
c unrolled loops
e
s 00003/00000/00542
d D 1.11 98/07/31 10:59:03 zoran 13 11
c add getMat() method
e
s 00000/00000/00547
d D 1.9.1.1 98/07/30 17:15:17 zoran 12 10
c 
e
s 00005/00010/00537
d D 1.10 98/07/30 17:10:24 jpiper 11 10
c no change
e
s 00015/00013/00532
d D 1.9 98/07/30 12:32:39 jpiper 10 9
c 
e
s 00007/00002/00538
d D 1.8 98/07/29 18:58:28 jpiper 9 8
c Changed Print
e
s 00010/00007/00530
d D 1.7 98/07/29 17:49:33 jpiper 8 7
c Fixed a few blas
e
s 00002/00002/00535
d D 1.6 98/07/29 14:27:17 jpiper 7 6
c Made setElem set the value
e
s 00028/00013/00509
d D 1.5 98/07/29 11:45:50 jpiper 6 5
c Need to unroll loops
e
s 00004/00005/00518
d D 1.4 98/07/28 10:02:49 jpiper 5 4
c Quitting to putback
e
s 00134/00035/00389
d D 1.3 98/07/27 19:09:39 jpiper 4 3
c needs debugging
e
s 00043/00064/00381
d D 1.2 98/07/27 11:52:18 jpiper 3 1
c adjusted for casting.  Need to fix NTrig and what uses it
e
s 00000/00000/00000
d R 1.2 98/07/27 09:26:56 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/NMatrix/NMatrix.java
e
s 00445/00000/00000
d D 1.1 98/07/27 09:26:55 zoran 1 0
c date and time created 98/07/27 09:26:55 by zoran
e
u
U
f e 0
t
T
I 1
/*## 
D 4
 ##  class FMatrix
E 4
I 4
 ##  class NMatrix
E 4
 ##   
D 4
 ##  This class extends Matrix to represent a Matrix of single precision
 ##  floating point numbers.  It contains all the BLAS (basic linear 
E 4
I 4
 ##  It contains all the BLAS (basic linear 
E 4
 ##  algebra subroutines) and other low-level functions common to all
 ##  matrices.  
D 4
 ##  FMatrix's contain no factoring or solving capabilities.
E 4
I 4
 ##  NMatrix contains no factoring or solving capabilities.
E 4
 ##
 ##*/

package edu.rice.linpack.Matrix.NMatrix;
import java.lang.*;
import edu.rice.linpack.LNumber.*;
import edu.rice.linpack.util.*;
D 4
import edu.rice.linpack.Vector.*;
import edu.rice.linpack.Matrix.Matrix;
E 4

D 3
public abstract class NMatrix {
E 3
I 3
D 4
public abstract class NMatrix extends Matrix {
E 4
I 4
public abstract class NMatrix {
E 4
E 3

I 4
  protected int rows, cols;
  protected int[] pivot;
E 4
  protected LNumber[][] Mat;
  
D 3
  void cons() {
    pivot = new int[cols];
  }
  void cons(int i, int j) {
    Mat = new LNumber[i][j];
    rows = i;
    cols = j;
    pivot = new int[cols];
  }
  void cons(NMatrix M) {
    rows = M.rows;
    cols = M.cols;
    Mat = new LNumber[rows][cols];
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) 
	Mat[i][j] = new LNumber(M.Mat[i][j]);
    pivot = new int[cols];
  }    
  void cons(LNumber[][] F) {
    rows = F.length;
    cols = (F[0]).length;
    Mat = new LNumber[rows][cols];
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) {
	Mat[i][j] = new LNumber(F[i][j]);
      }
    pivot = new int[cols];
  }
E 3
D 4
  
E 4
I 4

  public void factor() 
       throws SingularMatrixException, UnsupportedMethodException
  {
    throw new UnsupportedMethodException();
  }
  public LNumber condition()
D 11
       throws WrongDataTypeException, SingularMatrixException, 
	 UnsupportedMethodException
E 11
I 11
       throws SingularMatrixException, UnsupportedMethodException
E 11
  {
    throw new UnsupportedMethodException();
  }
  public LNumber condition(LNumber[] Z)
D 11
       throws WrongDataTypeException, SingularMatrixException,
	 UnsupportedMethodException
E 11
I 11
       throws SingularMatrixException, UnsupportedMethodException
E 11
  {
    throw new UnsupportedMethodException();
  }
  public void solve(LNumber[] B, int i)
D 11
       throws WrongDataTypeException, UnsupportedMethodException,   
E 11
I 11
       throws UnsupportedMethodException,   
E 11
	 UnsupportedMethodException
  {
    throw new UnsupportedMethodException();
  }
  public void solve(LNumber[] B)
D 11
       throws WrongDataTypeException, SingularMatrixException,
	 UnsupportedMethodException
E 11
I 11
       throws SingularMatrixException, UnsupportedMethodException
E 11
  {
    throw new UnsupportedMethodException();
  }
  public void inverse() 
       throws UnsupportedMethodException
  {
    throw new UnsupportedMethodException();
  }
  public LNumber[] determ() 
       throws UnsupportedMethodException
  {
    throw new UnsupportedMethodException();
  }
  public void Factor_and_Solve(LNumber[] B) 
D 11
       throws WrongDataTypeException, SingularMatrixException, 
	 UnsupportedMethodException
E 11
I 11
       throws SingularMatrixException, UnsupportedMethodException
E 11
  {
    this.factor();
    this.solve(B);
  }
D 11

E 11

  void cons() {
    pivot = new int[cols];
  }
  void cons(int i, int j) {
    Mat = new LNumber[i][j];
    rows = i;
    cols = j;
    pivot = new int[cols];
  }
  void cons(NMatrix M) {
    rows = M.numofRows();
    cols = M.numofCols();
    Mat = new LNumber[rows][cols];
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) 
	Mat[i][j] = (M.getElem(i,j)).Clone();
    pivot = new int[cols];
  }    
  void cons(LNumber[][] F) {
    rows = F.length;
    cols = (F[0]).length;
I 6
    Mat = new LNumber[rows][cols];
E 6
    Mat = F;
    pivot = new int[cols];
  }
D 14
  void cons(float[][] f) {
    rows = f.length;
    cols = (f[0]).length;
I 6
    Mat = new LFloat[rows][cols];
E 6
    for(int i=0;i<rows;i++) {
      for(int j=0;j<cols;j++) {
	Mat[i][j] = new LFloat(f[i][j]);
      }
    }
    pivot = new int[cols];
  }
  void cons(double[][] f) {
    rows = f.length;
    cols = (f[0]).length;
I 6
    Mat = new LDouble[rows][cols];
E 6
    for(int i=0;i<rows;i++) {
      for(int j=0;j<cols;j++) {
	Mat[i][j] = new LDouble(f[i][j]);
      }
    }
    pivot = new int[cols];
  }
E 14

  public int numofRows() {
    return rows;
  }
  public int numofCols() {
    return cols;
  }
  public int[] getPivots() {
    return pivot;
  }  
I 13
D 15
  public LNumber[][] getMat() {
    return Mat;
  }  
E 15
E 13

E 4
  /*##
   ##  These routines return a copy of the desired object beginning at
   ##   the element (i,q)  
   ##*/

  public LNumber getElem(int i, int q) {
D 3
    return new LNumber(Mat[i][q]);
E 3
I 3
D 4
    return Mat[i][q].Clone();
E 4
I 4
D 20
    return Mat[i][q];
E 20
I 20
    return Mat[i][q].Clone();
E 20
E 4
E 3
  }
I 19
  public LNumber[] getRow(int i) {
    return this.getRow(i,0);
  }
E 19
  public LNumber[] getRow(int i, int q) {
    LNumber[] F = new LNumber[cols-q];
D 14
    for(int j=0;j<(cols-q);j++)
E 14
I 14
    for(int j=0;j<(cols-q);j++) 
E 14
D 3
      F[j] = new LNumber(Mat[i][q+j]);
E 3
I 3
D 4
      F[j] = Mat[i][q+j].Clone();
E 4
I 4
D 20
      F[j] = Mat[i][q+j];
E 20
I 20
      F[j] = Mat[i][q+j].Clone();
E 20
E 4
E 3
    return F;
  }
I 19
  public LNumber[] getColumn(int i) {
    return this.getColumn(i,0);
  }
E 19
  public LNumber[] getColumn(int i, int q) {
    LNumber[] F = new LNumber[rows-q];
    for(int j=0; j<(rows-q);j++) {
D 3
      F[j] = new LNumber(Mat[j+q][i]);
E 3
I 3
D 4
      F[j] = Mat[j+q][i].Clone();
E 4
I 4
D 20
      F[j] = Mat[j+q][i];
E 20
I 20
      F[j] = Mat[j+q][i].Clone();
E 20
E 4
E 3
    }
    return F;
  }
I 19
  public LNumber newOfType() {
    return Mat[0][0].Clone();
  }

D 20
  /*
E 19
I 14
  public LNumber[][] getMat() {
    return Mat;
  }
E 14
D 19

E 19
I 19
  */
E 20
E 19
  /*##
   ##  this.setColumn changes column c to F  
   ##*/

  public void setColumn(int c,LNumber[] F) {
D 20
    for(int r=0;r<rows;r++) {
D 3
      this.Mat[r][c] = new LNumber(F[r]);
E 3
I 3
D 4
      this.Mat[r][c] = F[r].Clone();
E 4
I 4
D 7
      this.Mat[r][c] = F[r];
E 7
I 7
D 10
      Mat[r][c].set(F[r]);
E 10
I 10
      if(Mat[r][c] == null)
	Mat[r][c] = F[r].Clone();
      else
        Mat[r][c].set(F[r]);
E 10
E 7
E 4
E 3
    }
E 20
I 20
    for(int r=0;r<rows;r++) 
      Mat[r][c] = F[r].Clone();
E 20
  }
  public void setElem(int r, int c, LNumber value) {
D 3
    this.Mat[r][c] = new LNumber(value);
E 3
I 3
D 4
    this.Mat[r][c] = value.Clone();
E 4
I 4
D 7
    this.Mat[r][c] = value;
E 7
I 7
D 8
    Mat[r][c].set(value);
E 8
I 8
D 20
    if(Mat[r][c] == null)
      Mat[r][c] = value.Clone();
    else
      Mat[r][c].set(value);
E 8
E 7
E 4
E 3
  }
I 14
  public void refElem(int r, int c, LNumber F) {
    Mat[r][c] = F;
  }
  public void refMat(LNumber[][] N) {
    Mat = N;
E 20
I 20
    Mat[r][c] = value.Clone();
E 20
  }
E 14

  public void Print() {
D 6
    System.out.println();
E 6
I 6
D 8
    System.out.println("PRINTING"); 
E 8
I 8
    System.out.println(); 
E 8
E 6
    for(int i=0;i<rows;i++) {
      for(int j=0;j<cols;j++) {
D 9
	Mat[i][j].Print();
I 6
	System.out.print("   ");
E 9
I 9
	if(Mat[i][j] != null) {
	  Mat[i][j].Print();
	  System.out.print("   ");
	}
	else {
	  System.out.print("0.0    ");
	}
E 9
E 6
      }
      System.out.println();
    }
    System.out.println();
  }

  /*##
   ##  this.swapElem swaps two elements in this NMatrix  
   ##*/

  public void swapElem(int rx, int cx, int ry, int cy) {
D 3
    LNumber T = new LNumber(this.Mat[rx][cx]);
    this.Mat[rx][cx] = this.Mat[ry][cy];
    this.Mat[ry][cy] = T;
E 3
I 3
D 4
    LNumber T = Mat[rx][cx].Clone();
    this.Mat[rx][cx].set(this.Mat[ry][cy]);
    this.Mat[ry][cy].set(T);
E 4
I 4
D 8
    LNumber T = Mat[rx][cx];
    this.Mat[rx][cx] = this.Mat[ry][cy];
    this.Mat[ry][cy] = T;
E 8
I 8
    LNumber T = Mat[rx][cx].Clone();
D 20
    Mat[rx][cx].set(Mat[ry][cy]);
    Mat[ry][cy].set(T);
E 20
I 20
    Mat[rx][cx] = Mat[ry][cy];
    Mat[ry][cy] = T;
E 20
E 8
E 4
E 3
  }
I 14
  
E 14

  /*#######################*/
  /*##   BLAS Routines   ##*/

  /*##
   ##  For all BLAS: 
   ##
   ##  On Input:
   ##
   ##     n         int
   ##               The number of elements to be effected. 
   ##
   ##     incx      int
   ##               The amount to increase the column number for 
   ##               this.Mat on each iteration.
   ##
   ##     r,rx      int 
   ##               The initial row in this.Mat.
   ##
   ##     c,cx      int
   ##               The initial column in this.Mat.
   ## 
   ##     B         LNumber[], NMatrix, LNumber[][]
   ##               The other object used in some calculations.
   ##     
   ##     incy      int
   ##               The amount to increase the column number for B.
   ##
   ##     ry        int
   ##               The initial row in B.
   ## 
   ##     cy        int
   ##               The initial column in B.
   ##
   ##     Da        LNumber
   ##               A LNumber used as a scalar.
   ##
   ##     Tg        Trig
   ##               Holds the sine and cosine values formed in a Givens
   ##               rotation and used in a rotation.
   ##*/

  /*##
   ##  asum - sum of absolute values in a vector
   ##  Returns the sum as a LNumber  
   ##*/

  public LNumber asum(int n, int incx, int r, int c) {
I 14
    
E 14
D 3
    LNumber dasum = new LNumber();
E 3
I 3
D 5
    LNumber dasum = Mat[0][0].Clone();
    dasum.setZero();
E 3
    int ix = r;
    for(int i=0;i<n;i++,ix+=incx) 
E 5
I 5
    LNumber dasum = Mat[r][c].abs();
D 14
    int ix = r+incx;
    for(int i=1;i<n;i++,ix+=incx) 
E 5
D 6
      dasum = dasum.add(Mat[ix][c].abs());
E 6
I 6
      dasum.addTo(Mat[ix][c].abs());
E 14
I 14
    if(n > 0) {
      if(incx != 1) {
	int ix = r+incx;
	for(int i=1;i<n;i++,ix+=incx) 
	  dasum.addTo(Mat[ix][c].abs());
      }
      else {
D 17
	int m = n%6;
E 17
I 17
	int m = (n-1)%6;
E 17
	if(m != 0) {
D 17
	  for(int i=0;i<m;i++) 
	    dasum.addTo(Mat[i][c].abs());
E 17
I 17
	  for(int i=1;i<=m;i++) 
	    dasum.addTo(Mat[i+r][c].abs());
E 17
	}
	if(n >= 6) {
D 17
	  for(int i=m;i<n;i+=6) {
	    dasum.addTo((((((Mat[i][c].abs()).add(Mat[i+1][c].abs()))
			   .add(Mat[i+2][c].abs())).add(Mat[i+3][c].abs()))
			 .add(Mat[i+4][c].abs())).add(Mat[i+5][c].abs()));
E 17
I 17
	  for(int i=m+1;i<n;i+=6) {
	    
	    int ir = i+r;
	    dasum.addTo((((((Mat[ir][c].abs()).add(Mat[ir+1][c].abs()))
			   .add(Mat[ir+2][c].abs())).add(Mat[ir+3][c].abs()))
			 .add(Mat[ir+4][c].abs())).add(Mat[ir+5][c].abs()));
E 17
	  }
	}
      }
    }
    else 
      dasum.setZero();
E 14
E 6
    return dasum;
  }

  /*##
   ##  axpy - a const times a vector plus a vector 
   ##  Dy is changed in the loop and holds the desired value on return 
   ##*/

  public void axpy(int n, LNumber Da, int incx, int rx, int cx, 
D 4
		   Matrix B, int incy, int ry, int cy) {
E 4
I 4
		   NMatrix B, int incy, int ry, int cy) {
E 4
    
D 4
    LNumber[][] Mat2 = ((NMatrix) B).Mat;

E 4
    if(n > 0 && !Da.equals(0)) {
D 14
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      for(int i=0;i<n;i++,ix+=incx,iy+=incy) 
D 4
	Mat2[iy+ry][cy] = Mat2[iy+ry][cy].add(Da.mult(Mat[ix+rx][cx]));
E 4
I 4
D 6
	B.setElem(iy+ry,cy,(B.getElem(iy+ry,cy)).add(Da.mult(Mat[ix+rx][cx])));
E 6
I 6
	B.setElem(iy+ry,cy,(B.getElem(iy+ry,cy))
		  .add(Da.mult(Mat[ix+rx][cx])));
E 14
I 14
      if(incx != 1 || incy != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	for(int i=0;i<n;i++,ix+=incx,iy+=incy) 
D 20
	  (B.getElem(iy+ry,cy)).addTo(Da.mult(Mat[ix+rx][cx]));
E 20
I 20
	  B.setElem(iy+ry,cy,
		    (B.getElem(iy+ry,cy)).add(Da.mult(Mat[ix+rx][cx])));
E 20
      }
      else {
	int m = n%4;
        if(m != 0) {
          for(int i=0;i<m;i++)
D 20
            (B.getElem(i+ry,cy)).addTo(Da.mult(Mat[i+rx][cx]));
E 20
I 20
            B.setElem(i+ry,cy,
		      ((B.getElem(i+ry,cy)).add(Da.mult(Mat[i+rx][cx]))));
E 20
	}
        if(n >= 4) {
          for(int i=m;i<n;i+=4) {
            int iry = i+ry;
            int irx = i+rx;
D 20
            (B.getElem(iry,cy)).addTo(Da.mult(Mat[irx][cx]));
D 18
	    (B.getElem(iry+1,cy)).add(Da.mult(Mat[irx+1][cx]));
	    (B.getElem(iry+2,cy)).add(Da.mult(Mat[irx+2][cx]));
	    (B.getElem(iry+3,cy)).add(Da.mult(Mat[irx+3][cx]));
E 18
I 18
	    (B.getElem(iry+1,cy)).addTo(Da.mult(Mat[irx+1][cx]));
	    (B.getElem(iry+2,cy)).addTo(Da.mult(Mat[irx+2][cx]));
	    (B.getElem(iry+3,cy)).addTo(Da.mult(Mat[irx+3][cx]));
E 20
I 20
            B.setElem(iry,cy,
		      (B.getElem(iry,cy)).add(Da.mult(Mat[irx][cx])));
	    B.setElem(iry+1,cy,
		      (B.getElem(iry+1,cy)).add(Da.mult(Mat[irx+1][cx])));
	    B.setElem(iry+2,cy,
		      (B.getElem(iry+2,cy)).add(Da.mult(Mat[irx+2][cx])));
	    B.setElem(iry+3,cy,
		      (B.getElem(iry+3,cy)).add(Da.mult(Mat[irx+3][cx])));
E 20
E 18
          }
        }
      }
E 14
E 6
E 4
    }
  }
  public void axpy(int n, LNumber Da, int incx, int rx, int cx,
		   LNumber[] B, int incy, int ry) {
    
    if(n > 0 && !Da.equals(0)) {
D 14
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      for(int i=0;i<n;i++,ix+=incx,iy+=incy) 
D 6
	B[ry+iy] = B[ry+iy].add(Da.mult(Mat[ix+rx][cx]));
E 6
I 6
	B[ry+iy].addTo(Da.mult(Mat[ix+rx][cx]));
E 14
I 14
      if(incx != 1 || incy != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	for(int i=0;i<n;i++,ix+=incx,iy+=incy) 
	  B[ry+iy].addTo(Da.mult(Mat[ix+rx][cx]));
      }
      else {
	int m = n%4;
        if(m != 0) {
          for(int i=0;i<m;i++)
            B[i+ry].addTo(Da.mult(Mat[i+rx][cx]));
        }
        if(n >= 4) {
          for(int i=m;i<n;i+=4) {
            int iry = i+ry;
            int irx = i+rx;
            B[iry].addTo(Da.mult(Mat[irx][cx]));
            B[iry+1].addTo(Da.mult(Mat[irx+1][cx]));
            B[iry+2].addTo(Da.mult(Mat[irx+2][cx]));
            B[iry+3].addTo(Da.mult(Mat[irx+3][cx]));
          }
        }
      }
E 14
E 6
    }
  }
D 14

E 14
I 14
  
E 14
  /*##
   ##  This version takes an array of LNumbers and modifies the calling object.
   ##  this.Mat is changed in the loop and holds the desired value on return.
   ##*/

  public void axpy(int n, LNumber Da, LNumber[] B, int incy, int ry,
		   int incx, int rx, int cx) {
    if(n > 0 && !Da.equals(0)) {
D 14
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      for(int i=0;i<n;i++,ix+=incx,iy+=incy) 
D 6
	Mat[rx+ix][cx] = Mat[rx+ix][cx].add(Da.mult(B[ry+iy]));
E 6
I 6
	Mat[rx+ix][cx].addTo(Da.mult(B[ry+iy]));
E 14
I 14
      if(incx != 1 || incy != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	for(int i=0;i<n;i++,ix+=incx,iy+=incy) 
	  Mat[rx+ix][cx].addTo(Da.mult(B[ry+iy]));
      }
      else {
	int m = n%4;
        if(m != 0) {
          for(int i=0;i<m;i++)
            Mat[i+rx][cx].addTo(Da.mult(B[i+ry]));
        }
        if(n >= 4) {
          for(int i=m;i<n;i+=4) {
            int iry = i+ry;
            int irx = i+rx;
            Mat[irx][cx].addTo(Da.mult(B[iry]));
            Mat[irx+1][cx].addTo(Da.mult(B[iry+1]));
            Mat[irx+2][cx].addTo(Da.mult(B[iry+2]));
            Mat[irx+3][cx].addTo(Da.mult(B[iry+3]));
          }
        }
      }
E 14
E 6
    }
  }


  /*##
   ##  copy - copies one vector to another 
   ##  B is changed and holds the desired array 
   ##*/

  public void copy(int n, int incx, int rx, int cx, 
		   LNumber[] B, int incy) {
    if(n > 0) {
D 14
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      
      for(int i=0;i<n;i++,ix+=incx, iy+= incy) 
D 3
	B[iy] = new LNumber(Mat[ix+rx][cx]);
E 3
I 3
	B[iy] = Mat[ix+rx][cx].Clone();
E 14
I 14
      if(incx != 1 || incy != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	
	for(int i=0;i<n;i++,ix+=incx, iy+= incy) 
	  B[iy] = Mat[ix+rx][cx].Clone();
      }
      else {
	int m = n%7;
	if(m != 0) {
          for(int i=0;i<m;i++) 
            B[i] = Mat[i+rx][cx].Clone();
        }
        if(n >= 7) {
          for(int i=m;i<n;i+=7) {
            int irx = i+rx;
            B[i] = Mat[irx][cx].Clone();
            B[i+1] = Mat[irx+1][cx].Clone();
            B[i+2] = Mat[irx+2][cx].Clone();
            B[i+3] = Mat[irx+3][cx].Clone();
            B[i+4] = Mat[irx+4][cx].Clone();
            B[i+5] = Mat[irx+5][cx].Clone();
            B[i+6] = Mat[irx+6][cx].Clone();
          }
        }
      }
E 14
E 3
    }
  }
  public void copy(int n, int incx, int rx, int cx, 
D 4
		   Matrix B, int incy, int ry, int cy) {
    
    LNumber[][] Mat2 = ((NMatrix)B).Mat;
E 4
I 4
		   NMatrix B, int incy, int ry, int cy) {
E 4
    
    if(n > 0) {
D 14
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      
      for(int i=0;i<n;i++,ix+=incx, iy+= incy) 
D 3
	Mat2[iy+ry][cy] = new LNumber(Mat[ix+rx][cx]);
E 3
I 3
D 4
	Mat2[iy+ry][cy] = Mat[ix+rx][cx].Clone();
E 4
I 4
	B.setElem(iy+ry,cy,Mat[ix+rx][cx].Clone());
E 14
I 14
      if(incx != 1 || incy != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	
	for(int i=0;i<n;i++,ix+=incx, iy+= incy) 
	  B.setElem(iy+ry,cy,Mat[ix+rx][cx].Clone());
      }
      else {
	        int m = n%7;
        if(m != 0) {
          for(int i=0;i<m;i++) 
	    B.setElem(i+ry,cy,Mat[i+rx][cx].Clone());
	}
        if(n >= 7) {
          for(int i=m;i<n;i+=7) {
            int irx = i+rx;
            int iry = i+ry;
	    B.setElem(iry,cy,Mat[irx][cx].Clone());
	    B.setElem(iry+1,cy,Mat[irx+1][cx].Clone());
	    B.setElem(iry+2,cy,Mat[irx+2][cx].Clone());
	    B.setElem(iry+3,cy,Mat[irx+3][cx].Clone());
	    B.setElem(iry+4,cy,Mat[irx+4][cx].Clone());
	    B.setElem(iry+5,cy,Mat[irx+5][cx].Clone());
	    B.setElem(iry+6,cy,Mat[irx+6][cx].Clone());
          }
	}
      }
E 14
E 4
E 3
    }
  }
  

  /*##
   ##  dot - Dot product between two vectors 
   ##  A LNumber is returned  
   ##*/

  public LNumber dot(int n, int incx, int rx, int cx,
		   NMatrix B, int incy, int ry, int cy) {
    
D 3
    LNumber N = new LNumber();
E 3
I 3
D 6
    LNumber N = Mat[0][0].Clone();
E 6
I 6
    LNumber N = Mat[rx][cx].Clone();
E 6
    N.setZero();
E 3
    
    if(n > 0){
D 14
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      
      for(int i=0; i<n;i++,ix+= incx,iy += incy) 
D 6
	N = N.add(Mat[rx+ix][cx].mult(B.Mat[ry+iy][cy]));
E 6
I 6
	N.addTo(Mat[rx+ix][cx].mult(B.Mat[ry+iy][cy]));
E 14
I 14
      if(incy != 1 || incx != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	
	for(int i=0; i<n;i++,ix+= incx,iy += incy) 
	  N.addTo(Mat[rx+ix][cx].mult(B.getElem(ry+iy,cy)));
      }
      else {
	int m = n%5;
        if(m != 0) {
          for(int i=0;i<m;i++) {
	    N.addTo(Mat[rx+i][cx].mult(B.getElem(ry+i,cy)));
          }
        }
        if(n >= 5) {
          for(int i=m;i<n;i+=5) {
            int irx = i+rx;
            int iry = i+ry;
            N.addTo(((((Mat[irx][cx].mult(B.getElem(iry,cy)))
		       .add(Mat[irx+1][cx].mult(B.getElem(iry+1,cy))))
		      .add(Mat[irx+2][cx].mult(B.getElem(iry+2,cy))))
		     .add(Mat[irx+3][cx].mult(B.getElem(iry+3,cy))))
		    .add(Mat[irx+4][cx].mult(B.getElem(iry+4,cy))));
          }
        }
      }
E 14
E 6
    }
    return N;
  }
  public LNumber dot(int n, int incx, int rx, int cx,
		   LNumber[] B, int incy, int ry) {

D 3
    LNumber N = new LNumber();
E 3
I 3
D 6
    LNumber N = Mat[0][0].Clone();
E 6
I 6
    LNumber N = Mat[rx][cx].Clone();
E 6
    N.setZero();
E 3
    
    if(n > 0){
D 14
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      
      for(int i=0; i<n;i++,ix+= incx,iy += incy) 
D 6
	N = N.add(Mat[rx+ix][cx].mult(B[ry+iy]));
E 6
I 6
	N.addTo(Mat[rx+ix][cx].mult(B[ry+iy]));
E 14
I 14
      if(incy != 1 || incx != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	
	for(int i=0; i<n;i++,ix+= incx,iy += incy) 
	  N.addTo(Mat[rx+ix][cx].mult(B[ry+iy]));
      }
      else {
	int m = n%5;
        if(m != 0) {
          for(int i=0;i<m;i++) {
            N.addTo(Mat[i+rx][cx].mult(B[ry+i]));
          }
        }
        if(n >= 5) {
          for(int i=m;i<n;i+=5) {
            int irx = i+rx;
            int iry = i+ry;
            N.addTo(((((Mat[irx][cx].mult(B[iry])) 
		       .add(Mat[irx+1][cx].mult(B[iry+1])))
		      .add(Mat[irx+2][cx].mult(B[iry+2])))
		     .add(Mat[irx+3][cx].mult(B[iry+3])))
		    .add(Mat[irx+4][cx].mult(B[iry+4])));
          }
        }
      }
E 14
E 6
    }
    return N;
  }


  /*##
   ##  scal - multiply a vector by a scalar 
   ##  The calling object is changed  
   ##*/

  public void scal(int n, LNumber Da, int incx, int r, int c) {

D 3
    if(n > 0 && Da != 1) {
E 3
I 3
    if(n > 0 && !Da.equals(1)) {
E 3
D 14
      int ix = 0;
      for (int i=0;i<n;i++,ix += incx)
D 6
	Mat[ix+r][c] =  Mat[ix+r][c].mult(Da);
E 6
I 6
	Mat[ix+r][c].multTo(Da);
    }
E 14
I 14
      if(incx != 1) {
	int ix = 0;
	for (int i=0;i<n;i++,ix += incx)
	  Mat[ix+r][c].multTo(Da);
      }
      else {
	int m = n%5;
        if(m != 0) {
          for(int i=0;i<m;i++) {
            Mat[i+r][c].multTo(Da);
          }
        }
        if(n >= 5) {
          for(int i=m;i<n;i+=5) {
            int ir = i+r;
            Mat[ir][c].multTo(Da); 
            Mat[ir+1][c].multTo(Da);
            Mat[ir+2][c].multTo(Da); 
            Mat[ir+3][c].multTo(Da); 
            Mat[ir+4][c].multTo(Da);
          }
        }
      }
    }      
E 14
  }      
  
  public void scal(int n, int scale, int incx, int r, int c) {

    if(n > 0 && (scale != 1)) {
D 14
      int ix = 0;
      for (int i=0;i<n;i++,ix += incx)
	Mat[ix+r][c].multTo(scale);
E 6
    }
E 14
I 14
      if(incx != 1) {
	int ix = 0;
	for (int i=0;i<n;i++,ix += incx)
	  Mat[ix+r][c].multTo(scale);
      }
      else {
	int m = n%5;
        if(m != 0) {
          for(int i=0;i<m;i++) {
            Mat[i+r][c].multTo(scale);
          }
        }
        if(n >= 5) {
          for(int i=m;i<n;i+=5) {
            int ir = i+r;
            Mat[ir][c].multTo(scale); 
            Mat[ir+1][c].multTo(scale);
            Mat[ir+2][c].multTo(scale); 
            Mat[ir+3][c].multTo(scale); 
            Mat[ir+4][c].multTo(scale);
          }
        }
      }
    }      
E 14
  }      
D 14

E 14
I 14
  
E 14
I 6

E 6
  /*##
   ##  swap - interchanges two vectors 
   ##*/

  public void swap(int n, int incx, int rx, int cx, 
D 4
		   Matrix B, int incy, int ry, int cy) {
E 4
I 4
		   NMatrix B, int incy, int ry, int cy) {
E 4
    
D 4
    LNumber[][] Mat2 = ((NMatrix)B).Mat;

E 4
    if(n > 0) {
D 14
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;
      LNumber N;
      for(int i=0;i<n;i++) {
D 3
	N = new LNumber(Mat[ix+rx][cx]);
	Mat[ix+rx][cx] = Mat2[iy+ry][cy];
	Mat2[iy+ry][cy] = N;
E 3
I 3
D 4
	N = Mat[ix+rx][cx].Clone();
	Mat[ix+rx][cx].set(Mat2[iy+ry][cy]);
	Mat2[iy+ry][cy].set(N);
E 4
I 4
D 8
	N = Mat[ix+rx][cx];
	Mat[ix+rx][cx] = B.getElem(iy+ry,cy);
E 8
I 8
	N = Mat[ix+rx][cx].Clone();
	Mat[ix+rx][cx].set(B.getElem(iy+ry,cy));
E 8
	B.setElem(iy+ry,cy,N);
E 4
E 3
	ix += incx;
	iy += incy;
E 14
I 14
      if(incx != 1 || incy != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	LNumber N;
	for(int i=0;i<n;i++) {
	  N = Mat[ix+rx][cx].Clone();
D 20
	  Mat[ix+rx][cx].set(B.getElem(iy+ry,cy));
E 20
I 20
	  Mat[ix+rx][cx] = B.getElem(iy+ry,cy);
E 20
	  B.setElem(iy+ry,cy,N);
	  ix += incx;
	  iy += incy;
	}
      }
      else {
	int m = n%3;
        if(m != 0) {
          LNumber temp;
          for(int i=0;i<m;i++) {
            temp = Mat[i+rx][cx].Clone();
D 20
            Mat[i+rx][cx].set(B.getElem(i+ry,cy));
E 20
I 20
            Mat[i+rx][cx] = B.getElem(i+ry,cy);
E 20
	    B.setElem(i+ry,cy,temp);
          }
        }
        if(n >= 3) {
          LNumber temp;
          for(int i=m;i<n;i+=3) {
            int irx = i+rx;
            int iry = i+ry;
            temp = Mat[irx][cx].Clone();
D 20
            Mat[irx][cx].set(B.getElem(iry,cy));
E 20
I 20
            Mat[irx][cx] = B.getElem(iry,cy);
E 20
	    B.setElem(iry,cy,temp);
            temp = Mat[irx+1][cx].Clone();
D 20
            Mat[irx+1][cx].set(B.getElem(iry+1,cy));
E 20
I 20
            Mat[irx+1][cx] = B.getElem(iry+1,cy);
E 20
	    B.setElem(iry+1,cy,temp);
            temp = Mat[irx+2][cx].Clone();
D 20
            Mat[irx+2][cx].set(B.getElem(iry+2,cy));
E 20
I 20
            Mat[irx+2][cx] = B.getElem(iry+2,cy);
E 20
	    B.setElem(iry+2,cy,temp);
          }
        }
E 14
      }
    }
  }

  /*##
   ##  i_amax - finds the index of element having the max absolute value 
   ##  Returns the index with zero as first element 
   ##*/

  public int i_amax(int n, int incx, int r, int c) {
  
    int max = 0;
    LNumber Dmax;
    
    if(n < 0) 
      return 0;  
    
    if(n > 0) {
D 14
      int ix = incx;
      Dmax = Mat[r][c].abs();
      for(int i=1;i<n;i++) {
	if((Mat[ix+r][c].abs()).greaterThan(Dmax)) {
	  max = ix;
	  Dmax = Mat[ix+r][c].abs();
E 14
I 14
      if(incx != 1) {
	int ix = incx;
	Dmax = Mat[r][c].abs();
	for(int i=1;i<n;i++) {
D 20
	  if((Mat[ix+r][c].abs()).greaterThan(Dmax)) {
E 20
I 20
	  if(!((Mat[ix+r][c].abs()).lessOrEqual(Dmax))) {
E 20
	    max = ix;
	    Dmax = Mat[ix+r][c].abs();
	  }
	  ix += incx;
E 14
	}
D 14
	ix += incx;
E 14
I 14
      } 
      else {
	Dmax = Mat[r][c].abs();
        for(int i=1;i<n;i++) {
D 20
          if((Mat[r+i][c].abs()).greaterThan(Dmax)) {
E 20
I 20
          if(!((Mat[r+i][c].abs()).lessOrEqual(Dmax))) {
E 20
            max = i;
D 20
            Dmax = Mat[r+1][c].abs();
E 20
I 20
            Dmax = Mat[r+i][c].abs();
E 20
          }
        }
E 14
      }
D 14
    } 
E 14
I 14
    }
E 14
    return max;
  }
  
  /*##
   ##  rotg - construct a Givens plane rotation 
   ##  Tg contains the computed sin and cos values 
   ##*/
  
D 3
  public void rotg(int r, int c, Trig Tg) {
E 3
I 3
D 4
  public void rotg(int r, int c, NTrig Tg) {
E 4
I 4
  public void rotg(int r, int c, Trig Tger) {
    
    NTrig Tg = (NTrig)Tger;
E 4
E 3

    LNumber Roe = Tg.getB();
    LNumber Da = this.Mat[r][c];
    LNumber R;

    if((Da.abs()).greaterThan((Tg.getB()).abs())) 
      Roe = Da;
    LNumber Scale = (Da.abs()).add((Tg.getB().abs()));
    if(Scale.equals(0)) {
D 3
      Tg.setCos(1);
      Tg.setSin(0);
      R = new LNumber();
E 3
I 3
      Tg.setCosOne();
      Tg.setSinZero();
      R = Scale.Clone();
      R.setZero();
E 3
    }
    else {
D 10
      LNumber DoS = Da.div(Scale);
      LNumber ToS = (Tg.getB()).div(Scale);
D 3
      R = Scale.mult(((DoS.mult(Dos)).add(Tos.mult(Tos))).sqrt());
E 3
I 3
      R = Scale.mult(((DoS.mult(DoS)).add(ToS.mult(ToS))).sqrt());
E 10
I 10
      R = Scale.mult((((Da.div(Scale)).square())
		      .add(((Tg.getB()).div(Scale).square()))).sqrt());
E 10
E 3
      if(!Roe.greaterOrEqual(0)) 
D 19
	R.negate();
E 19
I 19
	R.negateTo();
E 19
      Tg.setCos(Da.div(R));
      Tg.setSin(Tg.getB().div(R));
    }
D 3
    LNumber Z = new LNumber(1);
E 3
I 3
D 10
    LNumber Z = Roe.Clone();
    Z.setOne();
E 10
I 10
    LNumber Z;
E 10
E 3
    if((Da.abs()).greaterThan((Tg.getB()).abs())) 
D 10
      Z = Tg.getSin();
E 10
I 10
      Z = (Tg.getSin()).Clone();
E 10
    else if(!(Tg.getCos()).equals(0)) 
      Z = (Tg.getCos()).inv();
D 10

    this.Mat[r][c] = R;
E 10
I 10
    else {
      Z = Roe.Clone();
      Z.setOne();
    }
D 20
    Mat[r][c].set(R);
E 20
I 20
    Mat[r][c] = R.Clone();
E 20
E 10
    Tg.setB(Z);
  }
  
  /*##
   ##  rot applies a plane rotation from the parameters figured from Givens 
   ##*/

  public void rot(int n, int incx, int rx, int cx, NMatrix B, 
D 3
		  int incy, int ry, int cy, Trig Tg) {
E 3
I 3
D 4
		  int incy, int ry, int cy, NTrig Tg) {
E 4
I 4
		  int incy, int ry, int cy, Trig Tger) {
E 4
E 3
    
I 4
    NTrig Tg = (NTrig) Tger;
E 4
    if(n <= 0) 
      return;
    else {
D 14
      int ix = 0;
      int iy = 0;
      if(incx < 0) ix = (-n+1)*incx;
      if(incy < 0) iy = (-n+1)*incy;

      LNumber temp;      
      for(int i=0;i<n;i++) {
        temp = (Mat[ix+rx][cx].mult(Tg.getCos()))
D 4
	  .add((B.Mat[iy+ry][cy]).mult(Tg.getSin()));
        B.Mat[iy+ry][cy] = (B.Mat[iy+ry][cy].mult(Tg.getCos()))
	  .sub(Mat[ix+rx][cx].mult(Tg.getSin()));
E 4
I 4
	  .add((B.getElem(iy+ry,cy).mult(Tg.getSin())));
        B.setElem(iy+ry,cy,((B.getElem(iy+ry,cy)).mult(Tg.getCos()))
		  .sub(Mat[ix+rx][cx].mult(Tg.getSin())));
E 4
        Mat[ix+rx][cx] = temp;
        ix += incx;
        iy += incy;
E 14
I 14
      if(incx != 1 || incy != 1) {
	int ix = 0;
	int iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	
	LNumber temp;      
	for(int i=0;i<n;i++) {
	  temp = (Mat[ix+rx][cx].mult(Tg.getCos()))
	    .add((B.getElem(iy+ry,cy)).mult(Tg.getSin()));
	  B.setElem(iy+ry,cy,((B.getElem(iy+ry,cy)).mult(Tg.getCos()))
		    .sub(Mat[ix+rx][cx].mult(Tg.getSin())));
D 20
	  Mat[ix+rx][cx].set(temp);
E 20
I 20
	  Mat[ix+rx][cx] = temp.Clone();
E 20
	  ix += incx;
	  iy += incy;
	}
      }
      else {
	LNumber temp;
        for(int i=0;i<n;i++) {
          temp = (Mat[i+rx][cx].mult(Tg.getCos()))
	    .add((B.getElem(i+ry,cy)).mult(Tg.getSin()));
      	  B.setElem(i+ry,cy,((B.getElem(i+ry,cy)).mult(Tg.getCos()))
		    .sub(Mat[i+rx][cx].mult(Tg.getSin())));
D 20
          Mat[i+rx][cx].set(temp);
E 20
I 20
          Mat[i+rx][cx] = temp.Clone();
E 20
        }
E 14
      }
    }
  }
  public LNumber nrm2(int n, int incx, int r, int c) {
    
    int ix;
    LNumber absxi, scale, ssq;
D 3
    
    if(n < 1 || incx < 1)
      return new LNumber();
    else if( n == 1) 
      return new LNumber(Mat[r][c].abs());
E 3
I 3
D 6
    scale = Mat[0][0].Clone();
E 6
I 6
    scale = Mat[r][c].Clone();
E 6
    scale.setZero();
E 3

D 3
    scale = new LNumber();
    ssq = new LNumber(1); 
E 3
I 3
    if(n < 1 || incx < 1) 
      return scale;
    else if( n == 1) 
D 5
      return (Mat[r][c].Clone()).abs();
E 5
I 5
      return Mat[r][c].abs();
E 5
    
    ssq = scale.Clone();
    ssq.setOne();
E 3
    
    for(ix = 0;ix < n*incx;ix+=incx) {
I 20
      Mat[ix+r][c].ssq(ssq,scale);
      /*
E 20
      if(!Mat[r+ix][c].equals(0)) {
	absxi = Mat[r+ix][c].abs();
D 3
	if(scale < absxi) {
	  LNumber SoA = new LNumber(scale/absxi);
E 3
I 3
	if(absxi.greaterThan(scale)) {
D 10
	  LNumber SoA = scale.div(absxi);
E 3
D 6
	  ssq = (ssq.mult(SoA.mult(SoA))).add(1);
E 6
I 6
	  ssq = (ssq.mult(SoA.square())).add(1);
E 10
I 10
	  ssq = (ssq.mult((scale.div(absxi)).square())).add(1);
E 10
E 6
	  scale = absxi;
	}
	else {
D 3
	  LNumber AoS = new LNumber(absxi/scale);
E 3
I 3
D 10
	  LNumber AoS = absxi.div(scale);
E 3
D 6
	  ssq = ssq.add(AoS.mult(AoS));
E 6
I 6
	  ssq.addTo(AoS.mult(AoS));
E 10
I 10
	  ssq.addTo((absxi.div(scale)).square());
E 10
E 6
	}
      }
I 20
      */
E 20
    }
D 3
    return (scale*(float)Math.sqrt(ssq));
E 3
I 3
    return (scale.mult(ssq.sqrt()));
E 3
  }
}
E 1
