h64484
s 00000/00000/00103
d D 1.5 98/08/28 15:42:58 jpiper 6 5
c Fixed for limited access and complex numbers
e
s 00001/00000/00102
d D 1.4 98/08/06 16:21:05 jpiper 5 4
c Fully Debugged
e
s 00004/00006/00098
d D 1.3 98/07/31 18:01:18 jpiper 4 3
c removed WrongData Except
e
s 00025/00026/00079
d D 1.2 98/07/29 11:46:03 jpiper 3 1
c Need to unroll loops
e
s 00000/00000/00000
d R 1.2 98/07/28 12:06:24 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/NMatrix/NPacked.java
e
s 00105/00000/00000
d D 1.1 98/07/28 12:06:23 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
/*  
D 3
 ##  class FPacked
E 3
I 3
 ##  class NPacked
E 3
 ##  
 ##  This class holds the framework for a matrix stored in packed form.
 ##  It contains all the necessary basic routines for matrices adjusted
 ##  for its form.
 ##
 */

D 3
package edu.rice.linpack.Matrix.FMatrix;
E 3
I 3
package edu.rice.linpack.Matrix.NMatrix;
E 3
import edu.rice.linpack.LNumber.*;
D 3
import edu.rice.linpack.Vector.*;
E 3
import edu.rice.linpack.util.*;

D 3
public abstract class FPacked extends FMatrix {

E 3
I 3
public abstract class NPacked extends NMatrix {
  
E 3
  protected int order;
D 3
        
E 3
I 3
  
E 3
  public abstract void factor()
       throws SingularMatrixException;
D 3

E 3
I 3
       
E 3
  public abstract LNumber condition()
D 4
       throws SingularMatrixException, WrongDataTypeException;
E 4
I 4
       throws SingularMatrixException;
E 4
D 3
  public abstract LNumber condition(Vector Z)
E 3
I 3
  public abstract LNumber condition(LNumber[] Z)
E 3
D 4
       throws SingularMatrixException, WrongDataTypeException;
E 4
I 4
       throws SingularMatrixException;
E 4

D 3
  public abstract void solve(Vector B, int J)
E 3
I 3
D 4
  public abstract void solve(LNumber[] B, int J)
E 3
       throws WrongDataTypeException;
D 3
  public abstract void solve(Vector B)
E 3
I 3
  public abstract void solve(LNumber[] B)
E 3
       throws WrongDataTypeException;
E 4
I 4
  public abstract void solve(LNumber[] B, int J);
  public abstract void solve(LNumber[] B);
E 4

D 3
  public abstract Vector determ();
E 3
I 3
  public abstract LNumber[] determ();
E 3
  public abstract void inverse();

D 3
  public float getElem(int i) {
E 3
I 3
  public LNumber getElem(int i) {
E 3
    return Mat[i][0];
  }
D 3
  public float[] getColumn(int q) {
E 3
I 3
  public LNumber[] getColumn(int q) {
E 3
    return getColumn(0,q);
  }
  public int getOrder() {
    return order;
  }
D 3
  public static float[][] pack(float[][] f) {
E 3
I 3
  public static LNumber[][] pack(LNumber[][] f) {
E 3
    int k = 0;
    int n = f.length;
D 3
    float[][] R = new float[(n*(n+1))/2][1];
E 3
I 3
    LNumber[][] R = new LNumber[(n*(n+1))/2][1];
E 3
    for(int j=0;j<n;j++) {
      for(int i=0;i<=j;i++) {
	R[k][0] = f[i][j];
	k++;
      }
    }	
    return R;
  }

D 3
  public void setColumn(int c,FPacked F) {
E 3
I 3
  public void setColumn(int c,NPacked F) {
E 3
    for(int r=0;r<rows;r++) {
      this.Mat[r+c][0] = F.Mat[r][0];
    }
  }
D 3
  public void setColumn(int n, int rx, float[] f, int ry) {
E 3
I 3
  public void setColumn(int n, int rx, LNumber[] f, int ry) {
E 3
    for(int i=0;i<n;i++) {
      this.Mat[i+rx][0] = f[i+ry];
    }
  }
  public void swapElem(int rx, int ry) {
    this.swapElem(rx,0,ry,0);
  }
  
D 3
  protected float oneNorm() {
    float[] Z = new float[order];
E 3
I 3
  protected LNumber oneNorm() {
    LNumber[] Z = new LNumber[order];
E 3
    
    int j1 = 0;
    for(int j=0;j<order;j++) {
      Z[j] = this.asum(j+1,1,j1,0);
      int ij = j1;
      j1 += j+1;
      for(int i=0;i<j;i++) {
D 3
	Z[i] += Math.abs(this.Mat[ij][0]);
E 3
I 3
	Z[i].addTo(Mat[ij][0].abs());
E 3
	ij++;
      }
    }
D 3
    float anorm = 0;
    for(int j=0;j<order;j++) 
      anorm = Math.max(anorm, Z[j]);
   
    return anorm;
E 3
I 3
    LNumber anorm = Z[0];
    for(int j=1;j<order;j++) 
      anorm.maxTo(Z[j]);
    
    return anorm.Clone();
E 3
  }

  public void Print() {
    for(int n=0;n<order;n++) {
      System.out.println();
      for(int j=0;j<order;j++) {
	if(j < n) 
	  System.out.print("           ");
	else {
	  int q = j*(j+1)/2 + n;
D 3
	  System.out.print(this.Mat[q][0]+"     ");
E 3
I 3
	  Mat[q][0].Print();
I 5
	  System.out.print("    ");
E 5
E 3
	}
      }
    }
    System.out.println();
  }
}
E 1
