h56948
s 00001/00001/00266
d D 1.7 98/08/28 15:41:50 jpiper 8 7
c Fixed for limited access and complex numbers
e
s 00006/00006/00261
d D 1.6 98/08/12 17:07:10 jpiper 7 6
c adjusted for LNumber
e
s 00011/00010/00256
d D 1.5 98/08/06 16:20:10 jpiper 6 5
c Fully debugged
e
s 00000/00000/00266
d D 1.4 98/08/05 19:05:40 jpiper 5 4
c began debugging
e
s 00004/00008/00262
d D 1.3 98/07/31 18:01:31 jpiper 4 3
c removed WrongExcept
e
s 00113/00098/00157
d D 1.2 98/07/29 11:46:22 jpiper 3 1
c Needs testing
e
s 00000/00000/00000
d R 1.2 98/07/28 12:15:20 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/NMatrix/NPoBand.java
e
s 00255/00000/00000
d D 1.1 98/07/28 12:15:19 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
/* 
D 3
 ##  class FPoBand
E 3
I 3
 ##  class NPoBand
E 3
 ##
 ##  This class contains the routines for positive definite matrices
 ##  in banded form.
 ##
 */

D 3
package edu.rice.linpack.Matrix.FMatrix;
E 3
I 3
package edu.rice.linpack.Matrix.NMatrix;
E 3
import edu.rice.linpack.LNumber.*;
import edu.rice.linpack.util.*;
D 3
import edu.rice.linpack.Vector.*;
E 3

D 3
public class FPoBand extends FBanded {
E 3
I 3
public class NPoBand extends NBanded {
E 3
  
  private int M;

D 3
  public FPoBand() {
E 3
I 3
  public NPoBand() {
E 3
    super();
  }
D 3
  public  FPoBand(int c, int M2) {
E 3
I 3
  public  NPoBand(int c, int M2) {
E 3
    super(0,M2,c);
    mu = M2;
    ml = 0;
    M = M2;
  }
D 3
  public FPoBand(float[][] f, int ML, int MU) {
E 3
I 3
  public NPoBand(LNumber[][] f, int ML, int MU) {
E 3
    mu = MU;
    M = mu;
    ml = 0;
    rows = M+1;
    cols = f[0].length;
D 6
    Mat = band(f);
E 6
I 6
    Mat = band(f,M);
E 6
  }
D 3
  public FPoBand(float[][] f, int M2) {
E 3
I 3
  public NPoBand(LNumber[][] f, int M2) {
E 3
    mu = M2;
    M = M2;
    ml = 0;
    rows = M+1;
    cols = f[0].length;
D 3
    Mat = new float[rows][cols];
    for(int i=0;i<rows;i++) 
      for(int j=0;j<cols;j++) 
	Mat[i][j] = f[i][j];
E 3
I 3
    Mat = f;
E 3
  }
D 3
  public FPoBand(FPoFull F, int M2) {
E 3
I 3
  public NPoBand(NPoFull F, int M2) {
E 3
    mu = M2;
    M = M2;
    ml = 0;
    cols = F.numofCols();
    rows = M+1;
D 6
    Mat = band(F.Mat);
E 6
I 6
    Mat = band(F.Mat,M);
E 6
  }
D 3
  public FPoBand(FPoBand F) {
E 3
I 3
  public NPoBand(NPoBand F) {
E 3
    super(F);
    M = F.M;
  }

D 3
  private float[][] band(float[][] f) {
E 3
I 3
D 6
  private LNumber[][] band(LNumber[][] f) {
E 6
I 6
  private LNumber[][] band(LNumber[][] f,int M) {
E 6
E 3
    int n = f[0].length;
D 3
    float[][] ret = new float[M+1][n];
E 3
I 3
    LNumber[][] ret = new LNumber[M+1][n];
E 3
    for(int j=0;j<n;j++) {
      int i1 = Math.max(0,j-M);
      for(int i=i1;i<=j;i++) {
	int k = i-j+M;
	ret[k][j] = f[i][j];
      }
    }
    return ret;
  }
D 3
  public FPoFull poUnband() {
    FPoFull Ret = new FPoFull(cols,cols);
E 3
I 3
  public NPoFull poUnband() {
    NPoFull Ret = new NPoFull(cols,cols);
E 3
    for(int j=0;j<cols;j++) {
      int i1 = Math.max(0,j-mu);
      for(int i=i1;i<=j;i++) {
	int k = i-j+mu;
	Ret.Mat[i][j] = this.Mat[k][j];
      }
    }
    return Ret;
  }

D 3

  public float oneNorm() {
E 3
I 3
  public LNumber oneNorm() {
E 3
    
D 3
    float[] Z = new float[cols];
E 3
I 3
    LNumber[] Z = new LNumber[cols];
E 3

    for(int j=0;j<cols;j++) {
      int l = Math.min(j,M);
      int mu = Math.max(M-j,0);
      Z[j] = this.asum(l+1, 1,mu,j);
      int k = j - l;
      for(int i=mu;i<M;i++,k++) 
D 3
	Z[k] += Math.abs(this.Mat[i][j]);
E 3
I 3
	Z[k].addTo(Mat[i][j].abs());
E 3
    }
D 3
    float anorm = 0;//oneNorm;
    for(int j=0;j<cols;j++) 
      anorm = Math.max(anorm, Z[j]);
E 3
I 3
    LNumber anorm = Z[0];
    for(int j=1;j<cols;j++) 
      anorm.maxTo(Z[j]);
E 3

D 3
    return anorm;
E 3
I 3
    return anorm.Clone();
E 3
  }

  public void factor() 
       throws SingularMatrixException
  {
D 3
    float S;
E 3
I 3
D 6
    LNumber S = Mat[0][0].Clone();
E 6
I 6
    LNumber S = Mat[M][0].Clone();
E 6
E 3

    for(int j=0;j<cols;j++) {
D 3
      S = 0;
E 3
I 3
      S.setZero();
E 3
      int ik = M;
      int jk = Math.max(j-M,0);
      int mu = Math.max(M-j,0);
      
      for(int k=mu;k<M;k++,ik--,jk++) {
D 3
	float T = this.Mat[k][j] - this.dot(k-mu,1,ik,jk,this,1,mu,j);
	T = T/this.Mat[M][jk];
	this.Mat[k][j] = T;
	S += T*T;
E 3
I 3
	LNumber T = Mat[k][j].sub(this.dot(k-mu,1,ik,jk,this,1,mu,j));
	T.divTo(Mat[M][jk]);
	Mat[k][j] = T;
	S.addTo(T.square());
E 3
      }
D 3
      S = this.Mat[M][j] - S;    
      if(S <= 0) 
E 3
I 3
      S = Mat[M][j].sub(S);    
      if(!S.greaterThan(0)) 
E 3
	throw new SingularMatrixException(j+1);
      else 
D 3
	this.Mat[M][j] = (float)Math.sqrt(S);
E 3
I 3
	Mat[M][j] = S.sqrt();
E 3
    }
  }
D 6

E 6
I 6
  
E 6
  public LNumber condition() 
D 4
       throws SingularMatrixException, WrongDataTypeException
E 4
I 4
       throws SingularMatrixException
E 4
  {
D 3
    Vector Z = new FVector(cols);
E 3
I 3
    LNumber[] Z = new LNumber[cols];
E 3
    return this.condition(Z);
  }
D 3
  public LNumber condition(Vector Ze) 
E 3
I 3
  public LNumber condition(LNumber[] Z) 
E 3
D 4
       throws SingularMatrixException, WrongDataTypeException
E 4
I 4
       throws SingularMatrixException
E 4
  {

D 3
    float[] Z = Ze.getFloatArray();
    float anorm = this.oneNorm();
E 3
I 3
    LNumber anorm = this.oneNorm();
E 3
   
    this.factor();
    
D 3
    float ek = 1;
    for(int j=0;j<cols;j++) 
      Z[j] = 0;
      
E 3
I 3
D 6
    LNumber ek = Mat[0][0].Clone();
E 6
I 6
    LNumber ek = Mat[M][0].Clone();
E 6
    ek.setOne();
    for(int j=0;j<cols;j++) {
      Z[j] = ek.Clone();
      Z[j].setZero();
    }
E 3
    for(int k=0;k<cols;k++) {
D 3
      if(Z[k] != 0) 
	ek = FUtil.signOf(ek,-Z[k]);
      if(Math.abs(ek - Z[k]) > this.Mat[M][k]) {
	float S = this.Mat[M][k]/Math.abs(ek-Z[k]);
	FUtil.scal(cols,S,Z,1);
	ek *= S;
      }
      float wk = ek - Z[k];
      float wkm = -ek - Z[k];
      float S = Math.abs(wk);
      float SM = Math.abs(wkm);
      wk = wk/this.Mat[M][k];
      wkm = wkm/this.Mat[M][k];
E 3
I 3
      if(!Z[k].equals(0)) 
D 7
	ek = NUtil.signOf(ek,Z[k].mult(-1));
E 7
I 7
D 8
	ek = NUtil.signOf(ek,Z[k].negate());
E 8
I 8
	ek = NUtil.signOfA(ek,Z[k].negate());
E 8
E 7
      if(((ek.sub(Z[k])).abs()).greaterThan((Mat[M][k]).abs())) {
	LNumber S = (Mat[M][k].abs()).div((ek.sub(Z[k])).abs());
	NUtil.scal(cols,S,Z,1);
	ek.multTo(S);
      }
      LNumber wk = ek.sub(Z[k]);
D 7
      LNumber wkm = (ek.mult(-1)).sub(Z[k]);
E 7
I 7
      LNumber wkm = (ek.negate()).sub(Z[k]);
E 7
      LNumber S = wk.abs();
      LNumber SM = wkm.abs();
      wk.divTo(Mat[M][k]);
      wkm.divTo(Mat[M][k]);
E 3
      int kp = k+1;
      int J2 = Math.min(kp+M,cols);
      int i = M-1;
      
      if(kp < J2) {
	for(int j=kp;j<J2;j++,i--) {
D 3
	  SM += Math.abs(Z[j] + wkm*this.Mat[i][j]);
	  Z[j] += wk*this.Mat[i][j];
	  S += Math.abs(Z[j]);
E 3
I 3
	  SM.addTo((Z[j].add(wkm.mult(Mat[i][j]))).abs());
	  Z[j].addTo(wk.mult(Mat[i][j]));
	  S.addTo(Z[j].abs());
E 3
	}
D 3
	if(S < SM) {
	  float T = wkm - wk;
E 3
I 3
	if(SM.greaterThan(S)) {
	  LNumber T = wkm.sub(wk);
E 3
	  wk = wkm;
	  i = M - 1;
D 6
	  for(int j=kp;j<J2;j++,i--) 
E 6
I 6
	  for(int j=kp;j<J2;j++,i--)
E 6
D 3
	    Z[j] += T*this.Mat[i][j];
E 3
I 3
	    Z[j].addTo(T.mult(Mat[i][j]));
E 3
	}
      }
      Z[k] = wk;
    }
D 3
    float S = 1/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
E 3
I 3
D 7
    LNumber S = (NUtil.asum(cols,Z,1)).inv();
E 7
I 7
    LNumber S = (NUtil.asum(cols,Z,1)).invTo();
E 7
    NUtil.scal(cols,S,Z,1);
E 3
    
D 3
    this.solveUZ(M,Z,1);
E 3
I 3
    this.solveUZ(M,Z);
E 3
    
D 3
    float ynorm = this.solveTrans(M,Z);
E 3
I 3
    LNumber ynorm = this.solveTrans(M,Z);
E 3
      
    ynorm = this.solveUZ(M,Z,ynorm);
  
D 3
    LFloat R = new LFloat();
E 3
I 3
    if(anorm.equals(0)) 
      return anorm;
E 3

D 3
    if(anorm != 0) 
      R.setFloat(ynorm/anorm);
    return R;
E 3
I 3
    ynorm.divTo(anorm);
    return ynorm;
E 3
  }
D 3
  private float solveTrans (int M, float[] Z) {
E 3
I 3
  void solveUZ(int M, LNumber[] Z) {
    for(int k=cols-1;k>=0;k--) {
      if((Z[k].abs()).greaterThan(Mat[M][k].abs())) {
	LNumber S = (Mat[M][k].abs()).div(Z[k].abs());
	NUtil.scal(cols,S,Z,1);
      }
D 6
      if(!Mat[M][k].equals(0))
E 6
I 6
      if(!Mat[M][k].equals(0)) 
E 6
	Z[k] = Z[k].div(Mat[M][k]);
D 6
      else
E 6
I 6
      else 
E 6
	Z[k].setOne();
I 6

E 6
      int lm = Math.min(k,M);
      int la = M - lm;
      int lz = k - lm;
D 7
      LNumber T = Z[k].mult(-1);
E 7
I 7
      LNumber T = Z[k].negate();
E 7
      this.axpy(lm,T,1,la,k,Z,1,lz);
    }
    
D 7
    LNumber S = (NUtil.asum(cols,Z,1)).inv();
E 7
I 7
    LNumber S = (NUtil.asum(cols,Z,1)).invTo();
E 7
    NUtil.scal(cols,S,Z,1);
  }
  private LNumber solveTrans (int M, LNumber[] Z) {
E 3
    
D 3
    float ynorm = 1;
E 3
I 3
    LNumber ynorm = Z[0].Clone();
    ynorm.setOne();
E 3

    for(int k=0;k<cols;k++) {
      int LM = Math.min(k,M);
      int la = M - LM;
      int lb = k - LM;
D 3
      Z[k] -= this.dot(LM,1,la,k,Z,1,lb);
      if(Math.abs(Z[k]) > this.Mat[M][k]) {
	float S = this.Mat[M][k]/Math.abs(Z[k]);
	FUtil.scal(cols,S,Z,1);
	ynorm *= S;
      }
      Z[k] /= this.Mat[M][k];
    }
    float S = 1/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
    ynorm *= S;
E 3
I 3
      Z[k].subTo(this.dot(LM,1,la,k,Z,1,lb));
      if((Z[k].abs()).greaterThan(Mat[M][k])) {
	LNumber S = Mat[M][k].div(Z[k].abs());
	NUtil.scal(cols,S,Z,1);
	ynorm.multTo(S);
      }
      Z[k].divTo(Mat[M][k]);
    }
D 7
    LNumber S = (NUtil.asum(cols,Z,1)).inv();
E 7
I 7
    LNumber S = (NUtil.asum(cols,Z,1)).invTo();
E 7
    NUtil.scal(cols,S,Z,1);
    ynorm.multTo(S);
E 3
    
    return ynorm;
  }

D 3
  public void solve(Vector B, int J) 
E 3
I 3
D 4
  public void solve(LNumber[] B, int J) 
E 3
       throws WrongDataTypeException
  {
E 4
I 4
  public void solve(LNumber[] B, int J) {
E 4
    this.solve(B);
  }
D 3
  public void solve(Vector Be) 
E 3
I 3
D 4
  public void solve(LNumber[] B) 
E 3
       throws WrongDataTypeException
  {
E 4
I 4
  public void solve(LNumber[] B) {
E 4
D 3
    float[] B = Be.getFloatArray();
E 3
    this.solveTransRY(M,B);
    this.solveRX(M,B);
  }

D 3
  public Vector determ() {
E 3
I 3
  public LNumber[] determ() {
E 3

D 3
    float[] Det = new float[2];
E 3
I 3
    LNumber[] Det = new LNumber[2];
E 3
    
D 3
    Det[0] = 1;
    Det[1] = 0;
E 3
I 3
D 6
    Det[0] = Mat[0][0].Clone();
E 6
I 6
    Det[0] = Mat[M][0].Clone();
E 6
    Det[1] = Det[0].Clone();
    Det[0].setOne();
    Det[1].setZero();
E 3
    
    for(int i=0;i<cols;i++) {
D 3
      Det[0] *= Math.pow(this.Mat[M][i],2);
E 3
I 3
      Det[0].multTo(Mat[M][i].square());
E 3
      
D 3
      if(Det[0] == 0) {
	FVector V = new FVector(Det);
	return V;
      }
E 3
I 3
      if(Det[0].equals(0)) 
	return Det;
E 3
      else 
D 3
	FUtil.detNorm(Det);
E 3
I 3
	NUtil.detNorm(Det);
E 3
    }
D 3
    FVector V2 = new FVector(Det);
    return V2;
E 3
I 3
    return Det;
E 3
  }
}
  
  
	
E 1
