h34202
s 00005/00013/00331
d D 1.6 98/08/28 15:41:57 jpiper 7 6
c Fixed for limited access and complex numbers
e
s 00118/00007/00226
d D 1.5 98/08/12 17:07:45 jpiper 6 5
c adjusted for LNumbers
e
s 00000/00083/00233
d D 1.4 98/08/03 18:49:35 jpiper 5 4
c Removed chol stuff
e
s 00011/00014/00305
d D 1.3 98/07/31 18:01:57 jpiper 4 3
c removed WrongExcept
e
s 00113/00094/00206
d D 1.2 98/07/29 11:47:09 jpiper 3 1
c Choleskys Works, but ex, dd, and ud not tested
e
s 00000/00000/00000
d R 1.2 98/07/28 14:04:12 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/NMatrix/NPoFull.java
e
s 00300/00000/00000
d D 1.1 98/07/28 14:04:11 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
/*  
D 3
 ##  class FPoFull
E 3
I 3
 ##  class NPoFull
E 3
 ##  
 ##  This class holds the routines for positive definite matrices in full
 ##  form.  It also holds the Cholesky routines for decomposing.  
 ##
 */

D 3
package edu.rice.linpack.Matrix.FMatrix;
E 3
I 3
package edu.rice.linpack.Matrix.NMatrix;
E 3
import edu.rice.linpack.util.*;
D 3
import edu.rice.linpack.Vector.*;
E 3
import edu.rice.linpack.LNumber.*;

D 3
public class FPoFull extends FFull {
E 3
I 3
public class NPoFull extends NFull {
E 3

D 3
  public FPoFull() {
E 3
I 3
  public NPoFull() {
E 3
    super();
  }
D 3
  public FPoFull(int n, int q) {
E 3
I 3
  public NPoFull(int n, int q) {
E 3
    super(n, q);
  }
D 3
  public FPoFull(float[][] f) {
E 3
I 3
  public NPoFull(LNumber[][] f) {
E 3
    super(f);
  }
D 3
  public FPoFull(FPoFull F) {
E 3
I 3
  public NPoFull(NPoFull F) {
E 3
    super(F);
  }
I 3
D 4
  public NPoFull(float[][] f) {
    super(f);
  }
  public NPoFull(double[][] d) {
    super(d);
  }
E 4
E 3

D 3
  public FPoPack pack() {
    FPoPack P = new FPoPack(this.Mat);
E 3
I 3
  public NPoPack pack() {
    NPoPack P = new NPoPack(Mat);
E 3
    return P;
  }
  
D 5
  public void setPivots(int[] p) {
    int q = Math.min(p.length,cols);
    for(int i=0;i<q;i++) 
      pivot[i] = p[i];
  }
  public void setPivotElem(int i, int piv) {
    pivot[i] = piv;
  }

E 5
I 4
  public void transpose() {
  }
D 6
  public void transpose(NFull D) {
    D.refMat(this.getMat());
  }
E 6

I 6
  public LNumber getElem(int i, int j) {
    if(i > j)
      return super.getElem(j,i);
    return super.getElem(i,j);
  }
  public LNumber[] getRow(int i) {
    return getRow(i,0);
  }
  public LNumber[] getColumn(int i) {
    return getRow(i,0);
  }
  public LNumber[] getColumn(int i, int j) {
    return getRow(i,j);
  }
  public LNumber[] getRow(int i, int j) {
    LNumber[] F = new LNumber[rows - j];
    for(int k=0;k<i && k<(rows-j);k++) {
      F[k] = Mat[j+k][i];
    }
    for(int k=i;k<(rows-j);k++) {
      F[k] = Mat[j+k][i];
    }
    return F;
  }
  public void setColumn(int c, LNumber[] F) {
D 7
    for(int r=0;r<c;r++) {
      if(Mat[r][c] == null)
	Mat[r][c] = F[r].Clone();
      else
	Mat[r][c].set(F[r]);
    }
    for(int r=c;r<rows;r++) {
      if(Mat[r][c] == null)
	Mat[r][c] = F[r].Clone();
      else
	Mat[r][c].set(F[r]);
    }
E 7
I 7
    for(int r=0;r<c;r++) 
      Mat[r][c] = F[r].Clone();
    for(int r=c;r<rows;r++) 
      Mat[r][c] = F[r].Clone();
E 7
  }
  public void setElem(int i, int c, LNumber L) {
    if(i > c)
      super.setElem(c,i,L);
    else
      super.setElem(i,c,L);
  }
E 6

E 4
D 3
  protected float oneNorm() {
    float[] Z = new float[cols];
E 3
I 3
  protected LNumber oneNorm() {
    LNumber[] Z = new LNumber[cols];
E 3
    
    for(int j=0;j<cols;j++) {
      Z[j] = this.asum(j+1,1,0,j);
      for(int i=0;i<j;i++) {
D 3
	Z[i] += Math.abs(this.Mat[i][j]);
E 3
I 3
	Z[i].addTo(Mat[i][j].abs());
E 3
      }
    }
D 3
    float anorm = 0;
    for(int j=0;j<cols;j++) 
      anorm = Math.max(anorm,Z[j]);
    return anorm;
E 3
I 3
    LNumber anorm = Z[0];
    for(int j=1;j<cols;j++) 
      anorm.maxTo(Z[j]);
    return anorm.Clone();
E 3
  }

D 3
  /*  Downdate, decompose, update, and exchange are untested 
      Also, need to test both FUtil.rotg and this.rotg

      */

E 3
  public void chPDecompose() 
       throws SingularMatrixException
  {
    Pul P = new Pul(0,-1);
    this.chPivot(P);
    this.decom(P);
  }
  public void chDecompose()
       throws SingularMatrixException
  {
    Pul P = new Pul(0,-1);
    this.decom(P);
  }
D 5
  private void decom (Pul P) 
       throws SingularMatrixException
  {
D 3
    float[] W = new float[cols];
E 3
I 3
    LNumber[] W = new LNumber[cols];
E 3

    System.out.println("CHOLESKY DECOMPOSE");

    for(int k=0;k<cols;k++) {
      // Reduction loop //
D 3
      
      float maxdia = this.Mat[k][k];
E 3
I 3
      LNumber maxdia = Mat[k][k];
E 3
      int kp = k+1;
      int maxln = k;

      if((k >= P.pl) && (k < P.pu)) {
	for(int q=kp;q<=P.pu;q++) {
D 3
	  if(this.Mat[q][q] > maxdia) {
E 3
I 3
	  if(Mat[q][q].greaterThan(maxdia)) {
E 3
	    maxdia = this.Mat[q][q];
	    maxln = q;
	  }
	}
      }
D 3
      if(maxdia < 0) 
E 3
I 3
      if(!maxdia.greaterOrEqual(0)) 
E 3
	throw new SingularMatrixException(k+1);
      
      else {
	if(k != maxln) {
	  this.swap(k,1,0,k,this,1,0,maxln);
D 3
	  this.Mat[maxln][maxln] = this.Mat[k][k];
	  this.Mat[k][k] = maxdia;
	  FUtil.swapElems(pivot, k, maxln);
E 3
I 3
	  Mat[maxln][maxln] = Mat[k][k];
	  Mat[k][k] = maxdia;
	  NUtil.swapElems(pivot, k, maxln);
E 3
	}
D 3
	W[k] = (float)Math.sqrt(this.Mat[k][k]);
	this.Mat[k][k] = W[k];
E 3
I 3
	W[k] = Mat[k][k].sqrt();
	Mat[k][k] = W[k];
E 3
	for(int j=kp;j<cols;j++) {
D 3
	  if(k != maxln) 
E 3
I 3
	  if(k != maxln) {
E 3
	    this.chSwaps(k,j,maxln);
D 3
	  this.Mat[k][j] = this.Mat[k][j]/W[k];
	  W[j] = this.Mat[k][j];
	  this.axpy(j-k,-W[j],W,1,kp,1,kp,j);
E 3
I 3
	  }
	  Mat[k][j].divTo(W[k]);
	  W[j] = Mat[k][j];
	  this.axpy(j-k,W[j].mult(-1),W,1,kp,1,kp,j);
E 3
	}
      }
    }
  }
  private void chPivot(Pul P) {
    
    this.swaperSki(P);

    // change pivots //
    
    P.pu = cols-1;
    for(int k=P.pu;k>=P.pl;k--) {
      if(pivot[k] < 0) {
	pivot[k] = -pivot[k];
	if(P.pu != k) {
	  this.swap(k,1,0,k,this,1,0,P.pu);
	  this.swapElem(k,k,P.pu,P.pu);
D 3
	  for(int j=k+1;j<cols;j++) 
E 3
I 3
	  for(int j=k+1;j<cols;j++) {
E 3
	    this.chSwaps(k,j,P.pu);
D 3
	  FUtil.swapElems(pivot,k,P.pu);
E 3
I 3
	  }
	  NUtil.swapElems(pivot,k,P.pu);
E 3
	}
	P.pu--;
      }
    }
  }
E 5
  void swap2(int j, Pul P) {
    if(j != P.pl) {
      this.swap(P.pl,1,0,j,this,1,0,P.pl);
      this.swapElem(j,j,P.pl,P.pl);
D 3
      for(int q=P.pl+1;q<cols;q++) 
E 3
I 3
      for(int q=P.pl+1;q<cols;q++) {
E 3
	this.chSwaps(P.pl,q,j);
I 3
      }
E 3
      pivot[j] = pivot[P.pl];
      pivot[P.pl] = j+1;
    }
    P.pl++;
  }
I 6
  
  void decom(Pul P) 
       throws SingularMatrixException
  {
    LNumber[] W = new LNumber[cols];
    
    for(int k=0;k<cols;k++) {
      // Reduction loop //
      LNumber maxdia = Mat[k][k];
      int kp = k+1;
      int maxln = k;
      if((k >= P.pl) && (k < P.pu)) {
	for(int q=kp;q<=P.pu;q++) {
	  if(Mat[q][q].greaterThan(maxdia)) {
	    maxdia = this.Mat[q][q];
	    maxln = q;
	  }
	}
      }
      if(!maxdia.greaterOrEqual(0)) 
	throw new SingularMatrixException(k+1);
      else {
	if(k != maxln) {
	  this.swap(k,1,0,k,this,1,0,maxln);
	  Mat[maxln][maxln] = Mat[k][k];
	  Mat[k][k] = maxdia;
	  NUtil.swapElems(pivot, k, maxln);
	}
	W[k] = Mat[k][k].sqrt();
D 7
	Mat[k][k].set(W[k]);
E 7
I 7
	Mat[k][k] = W[k].Clone();
E 7
	for(int j=kp;j<cols;j++) {
	  if(k != maxln) {
	    this.chSwaps(k,j,maxln);
	  }
	  Mat[k][j].divTo(W[k]);
	  W[j] = Mat[k][j];
	  this.axpy(j-k,W[j].negate(),W,1,kp,1,kp,j);
	}
      }
    }
  }
  void chPivot(Pul P) {
    
    this.swaperSki(P);

    // change pivots //
    
    P.pu = cols-1;
    for(int k=P.pu;k>=P.pl;k--) {
      if(pivot[k] < 0) {
	pivot[k] = -pivot[k];
	if(P.pu != k) {
	  this.swap(k,1,0,k,this,1,0,P.pu);
	  this.swapElem(k,k,P.pu,P.pu);
	  for(int j=k+1;j<cols;j++) {
	    this.chSwaps(k,j,P.pu);
	  }
	  NUtil.swapElems(pivot,k,P.pu);
	}
	P.pu--;
      }
    }
  }
  void chSwaps(int k, int j, int q) {
    if(j < q) 
      this.swapElem(k,j,j,q);
    else if(j > q) 
      this.swapElem(k,j,q,j);
  }

E 6
D 5
  private void chSwaps(int k, int j, int q) {
    if(j < q) 
      this.swapElem(k,j,j,q);
    else if(j > q) 
      this.swapElem(k,j,q,j);
  }


E 5

  public void factor() 
       throws SingularMatrixException
  {
    for(int j=0;j<cols;j++) {
D 3
      float S = 0;
E 3
I 3
      LNumber S = Mat[0][0].Clone();
      S.setZero();
E 3
      for(int k=0;k<j;k++) {
D 3
	float T = this.Mat[k][j] - this.dot(k,1,0,k,this,1,0,j);
	T = T/this.Mat[k][k];
	this.Mat[k][j] = T;
	S += T*T;
E 3
I 3
	LNumber T = Mat[k][j].sub(this.dot(k,1,0,k,this,1,0,j));
	T.divTo(Mat[k][k]);
	Mat[k][j] = T;
	S.addTo(T.square());
E 3
      }
D 3
      S = this.Mat[j][j] - S;
      if(S <= 0) 
E 3
I 3
      S = Mat[j][j].sub(S);
      if(!S.greaterThan(0)) 
E 3
	throw new SingularMatrixException(j+1);
      else 
D 3
	this.Mat[j][j] = (float)Math.sqrt(S);
E 3
I 3
	Mat[j][j] = S.sqrt();
E 3
    }
  }  
  
  public LNumber condition() 
D 4
       throws SingularMatrixException, WrongDataTypeException
E 4
I 4
       throws SingularMatrixException
E 4
  {
D 3
    Vector Z = new FVector(cols);
E 3
I 3
    LNumber[] Z = new LNumber[cols];
E 3
    return this.condition(Z);
  }
D 3
  public LNumber condition(Vector Ze) 
E 3
I 3
  public LNumber condition(LNumber[] Z) 
E 3
D 4
       throws SingularMatrixException, WrongDataTypeException
E 4
I 4
       throws SingularMatrixException
E 4
  {
D 3
    float[] Z = Ze.getFloatArray();

    float anorm = this.oneNorm();

E 3
I 3
    LNumber anorm = this.oneNorm();
    
E 3
    //  Factor //
    
    this.factor();
    
    /*  RCond = 1/(norm(A)*(estimate of norm(inverse(A)))) .
	Estimate = norm(Z)/norm(Y) where  A*Z = Y  and  A*Y = E .
	The components of  E  are chosen to cause maximum local 
	growth in the elements of W  where  trans(R)*W = E .
D 3
	The vectors are frequently rescaled to avoid overflow.
E 3
I 3
	The LNumber[]s are frequently rescaled to avoid overflow.
E 3
	*/
    //  Solve trans(R)*W = E  //
    
D 3
    for(int j=0;j<cols;j++) 
      Z[j] = 0;
E 3
I 3
    for(int j=0;j<cols;j++) {
      Z[j] = Mat[0][0].Clone();
      Z[j].setZero();
    }
E 3
      
    this.solveTransUW(Z);
    
D 3
    float S = 1/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
E 3
I 3
D 6
    LNumber S = (NUtil.asum(cols,Z,1)).inv();
E 6
I 6
    LNumber S = (NUtil.asum(cols,Z,1)).invTo();
E 6
    NUtil.scal(cols,S,Z,1);
E 3

    //  Solve R*Y = W  //
    
D 3
    this.solveUZ(Z,0);
E 3
I 3
    this.solveUZ(Z);
E 3
    
    //  Solve trans(R)*V = Y  //
    
D 3
    float ynorm = this.solveTransRV(Z);
E 3
I 3
    LNumber ynorm = this.solveTransRV(Z);
E 3
    
    //  Solve R*Z = V  //
    
    ynorm = this.solveUZ(Z,ynorm);
    
D 3
    LFloat R = new LFloat();

    if(anorm != 0) 
      R.setFloat(ynorm/anorm);
  
    return R;
E 3
I 3
    if(anorm.equals(0))
      return anorm;
   
    ynorm.divTo(anorm);  
    return ynorm;
  }
  void solveUZ(LNumber[] Z) {
    for(int k=cols-1;k>=0;k--) {
      if((Z[k].abs()).greaterThan(Mat[k][k].abs())) {
	LNumber S = (Mat[k][k].abs()).div(Z[k].abs());
	NUtil.scal(cols,S,Z,1);
      } 
      if(!Mat[k][k].equals(0)) 
	Z[k].divTo(Mat[k][k]);
      else 
	Z[k].setOne();
      
D 6
      this.axpy(k,Z[k].mult(-1),1,0,k,Z,1,0);
E 6
I 6
      this.axpy(k,Z[k].negate(),1,0,k,Z,1,0);
E 6
    }
D 6
    LNumber S = (NUtil.asum(cols,Z,1)).inv();
E 6
I 6
    LNumber S = (NUtil.asum(cols,Z,1)).invTo();
E 6
    NUtil.scal(cols,S,Z,1);
E 3
  }
D 3
  private float solveTransRV (float[] Z) {
    float ynorm = 1;
E 3
I 3
  private LNumber solveTransRV (LNumber[] Z) {
    LNumber ynorm = Z[0].Clone();
    ynorm.setOne();
E 3
    for(int k=0;k<cols;k++) {
D 3
      Z[k] = Z[k] - this.dot(k,1,0,k,Z,1,0);
      if(Math.abs(Z[k]) > this.Mat[k][k]) {
	float S = this.Mat[k][k]/Math.abs(Z[k]);
	FUtil.scal(cols,S,Z,1);
	ynorm *= S;
E 3
I 3
      Z[k].subTo(this.dot(k,1,0,k,Z,1,0));
      if((Z[k].abs()).greaterThan(Mat[k][k])) {
	LNumber S = Mat[k][k].div(Z[k].abs());
	NUtil.scal(cols,S,Z,1);
	ynorm.multTo(S);
E 3
      }
D 3
      Z[k] = Z[k]/this.Mat[k][k];
E 3
I 3
      Z[k].divTo(Mat[k][k]);
E 3
    }
D 3
    float S = 1/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
    ynorm *= S;
  
E 3
I 3
D 6
    LNumber S = (NUtil.asum(cols,Z,1)).inv();
E 6
I 6
    LNumber S = (NUtil.asum(cols,Z,1)).invTo();
E 6
    NUtil.scal(cols,S,Z,1);
    ynorm.multTo(S);
    
E 3
    return ynorm;
  }

D 3
  public void solve(Vector B, int Job) 
E 3
I 3
D 4
  public void solve(LNumber[] B, int Job) 
E 3
       throws WrongDataTypeException
  {
E 4
I 4
  public void solve(LNumber[] B, int Job) {
E 4
    this.solve(B);
  }
D 3
  public void solve(Vector Be) 
E 3
I 3
D 4
  public void solve(LNumber[] B) 
E 3
       throws WrongDataTypeException
  {
E 4
I 4
  public void solve(LNumber[] B) {
E 4
D 3
    
    float[] B = Be.getFloatArray();

E 3
    // Solve Trans(R)*Y = B //
D 3

E 3
I 3
    
E 3
    this.solveTransAX(B);

    // Solve R*X = Y  //

    this.solveUX(B);

    return;
  }
  
D 3
  public Vector determ() {
    float[] Det = new float[2];
E 3
I 3
  public LNumber[] determ() {
    LNumber[] Det = new LNumber[2];
E 3
    
D 3
    Det[0] = 1;
    Det[1] = 0;
    for(int i=0;i<cols && Det[0] != 0;i++) {
      Det[0] *= (float)Math.pow(this.Mat[i][i],2);
      if(Det[0] != 0) 
	FUtil.detNorm(Det);
E 3
I 3
    Det[0] = Mat[0][0].Clone();
    Det[1] = Det[0].Clone();
    Det[0].setOne();
    Det[1].setZero();
    for(int i=0;i<cols;i++) {
      Det[0].multTo(Mat[i][i].square());
      if(!Det[0].equals(0)) 
	NUtil.detNorm(Det);
      else
	return Det;
E 3
    }
D 3
    FVector V = new FVector(Det);
    return V;
E 3
I 3
    return Det;
E 3
  }
  
  public void inverse() {
    
    //  Compute inverse(R)  //

    this.invertU();

    //  Form inv(R)*trans(inv(R))  //
    
    for(int j=0;j<cols;j++) {
      for(int k=0;k<j;k++) 
	this.axpy(k+1,this.Mat[k][j],1,0,j,this,1,0,k);
      this.scal(j+1,this.Mat[j][j],1,0,j);
    }
  }
}
E 1
