h34098
s 00003/00003/00319
d D 1.8 98/08/28 15:42:10 jpiper 9 8
c Fixed for limited access and complex numbers
e
s 00012/00012/00310
d D 1.7 98/08/12 17:07:59 jpiper 8 7
c adjusted for LNumbers
e
s 00004/00004/00318
d D 1.6 98/08/11 10:55:16 jpiper 7 6
c Abstracted a bit
e
s 00019/00024/00303
d D 1.5 98/08/06 16:22:23 jpiper 6 5
c fully debugged
e
s 00004/00008/00323
d D 1.4 98/07/31 18:02:08 jpiper 5 4
c removed WrongExcept
e
s 00121/00130/00210
d D 1.3 98/07/29 11:47:23 jpiper 4 3
c Needs testing
e
s 00000/00000/00340
d D 1.2 98/07/28 15:11:19 jpiper 3 1
c oops
e
s 00000/00000/00000
d R 1.2 98/07/28 15:10:29 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/NMatrix/NPoPack.java
e
s 00340/00000/00000
d D 1.1 98/07/28 15:10:28 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
/*  
D 4
 ##  class FPoPack
E 4
I 4
 ##  class NPoPack
E 4
 ##
 ##  This class contains the routines for positive definite matrices
 ##  in packed form.
 ##
 */

D 4
package edu.rice.linpack.Matrix.FMatrix;
E 4
I 4
package edu.rice.linpack.Matrix.NMatrix;
E 4
import edu.rice.linpack.util.*;
D 4
import edu.rice.linpack.Vector.*;
E 4
import edu.rice.linpack.LNumber.*;

D 4
public class FPoPack extends FPacked {
E 4
I 4
public class NPoPack extends NPacked {
E 4

D 4
  public FPoPack() {
E 4
I 4
  public NPoPack() {
E 4
    super();
    order = 0;
  }  
D 4
  public FPoPack(int o) {
E 4
I 4
  public NPoPack(int o) {
E 4
    order = o;
    float r = (float).5*(o*(o+1));
    rows = (int) r;
    cols = 1;
D 4
    Mat = new float[rows][1];
E 4
I 4
    Mat = new LNumber[rows][1];
E 4
  }
D 4
  public FPoPack(float[] f, int o) {
E 4
I 4
  public NPoPack(LNumber[] f, int o) {
E 4
    rows = f.length;
    cols = 1;
D 4
    Mat = new float[rows][cols];
E 4
I 4
    Mat = new LNumber[rows][cols];
E 4
    for(int i=0;i<rows;i++) 
      Mat[i][0] = f[i];
    order = o;
  }
D 4
  public FPoPack(float[][] f, int o) {
E 4
I 4
  public NPoPack(LNumber[][] f, int o) {
E 4
    rows = f.length;
    cols = 1;
    order = o;
D 4
    Mat = new float[rows][1];
    for(int i=0;i<rows;i++) 
      Mat[i][0] = f[i][0];
E 4
I 4
    Mat = new LNumber[rows][1];
    Mat = f;
E 4
  }
D 4
  public FPoPack(float[][] f) {
E 4
I 4
  public NPoPack(LNumber[][] f) {
E 4
    cols = 1;
    order = f.length;
    float r = (float).5*(order*(order + 1));
    rows = (int) r;
D 4
    Mat = new float[rows][1];
E 4
I 4
    Mat = new LNumber[rows][1];
E 4
    Mat = pack(f);
  }
D 4
  public FPoPack(FPoPack F) {
E 4
I 4
  public NPoPack(NPoPack F) {
E 4
D 7
    rows = F.rows;
E 7
I 7
    rows = F.numofRows();
E 7
    cols = 1;
D 4
    Mat = new float[rows][1];
E 4
I 4
    Mat = new LNumber[rows][1];
E 4
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) 
D 6
	Mat[i][j] = F.Mat[i][j];
E 6
I 6
D 7
	Mat[i][j] = F.Mat[i][j].Clone();
E 6
    order = F.order;
E 7
I 7
	Mat[i][j] = (F.getElem(i,j)).Clone();
    order = F.getOrder();
E 7
  }
D 4
  public FPoPack(FPoFull F) {
E 4
I 4
  public NPoPack(NPoFull F) {
E 4
    cols = 1;
    order = F.numofRows();
    float r = (float).5*(order*(order + 1));
    rows = (int)r;
D 4
    Mat = new float[rows][1];
E 4
I 4
    Mat = new LNumber[rows][1];
E 4
D 7
    Mat = pack(F.Mat);
E 7
I 7
D 8
    Mat = pack(F.getMat());
E 8
I 8
    Mat = pack(F.Mat);
E 8
E 7
  }

D 4
  public FPoFull unpack() {
E 4
I 4
  public NPoFull unpack() {
E 4
    int k = 0;
    int n = this.order;
D 4
    FPoFull R = new FPoFull(n,n);
E 4
I 4
    NPoFull R = new NPoFull(n,n);
E 4
    for(int j=0;j<n;j++) {
      for(int i=0;i<=j;i++) {
	R.Mat[i][j] = this.Mat[k][0];
	if(j != i)
	  R.Mat[j][i] = this.Mat[k][0];
	k++;
      }
    }	
    return R;
  }

D 4
  /* All have been completely tested
     
   */

E 4
  public void factor() 
       throws SingularMatrixException
  {
    int jj = -1;
D 4
    float S;
E 4
I 4

    LNumber S = Mat[0][0].Clone();
E 4

    for(int j=0;j<order;j++) {
D 4
      S = 0;
E 4
I 4
      S.setZero();
E 4
      if(j > 0) {
D 4
	int kj = (int)((float).5*(j*(j+1)));
E 4
I 4
	int kj = (int)(.5*(j*(j+1)));
E 4
	int kk = -1;
	for(int k=0;k<j;k++) {
D 4
	  float T = this.Mat[kj][0] - this.dot(k,1,kk+1,0,this,1,jj+1,0);
E 4
I 4
	  LNumber T = Mat[kj][0].sub(this.dot(k,1,kk+1,0,this,1,jj+1,0));
E 4
	  kk += k+1;
D 4
	  T = T/this.Mat[kk][0];
	  this.Mat[kj][0] = T;
	  S += T*T;
E 4
I 4
	  T.divTo(Mat[kk][0]);
	  Mat[kj][0] = T;
	  S.addTo(T.square());
E 4
	  kj++;
	}
      }
      jj += j+1;
D 4
      S = this.Mat[jj][0] - S;
      if(S <= 0) 
E 4
I 4
      S = Mat[jj][0].sub(S);
      if(!S.greaterThan(0)) 
E 4
	throw new SingularMatrixException(j+1);
      else 
D 4
	this.Mat[jj][0] = (float)Math.sqrt(S);
E 4
I 4
	Mat[jj][0] = S.sqrt();
E 4
    }
  } 

  public LNumber condition() 
D 5
       throws SingularMatrixException, WrongDataTypeException
E 5
I 5
       throws SingularMatrixException
E 5
  {
D 4
    Vector Z = new FVector(order);
E 4
I 4
    LNumber[] Z = new LNumber[order];
E 4
    return this.condition(Z);
  }
D 4
  public LNumber condition(Vector Ze) 
E 4
I 4
  public LNumber condition(LNumber[] Z) 
E 4
D 5
       throws SingularMatrixException, WrongDataTypeException
E 5
I 5
       throws SingularMatrixException
E 5
  {
D 4
    float[] Z = Ze.getFloatArray();

    float anorm = this.oneNorm();
E 4
I 4
    LNumber anorm = this.oneNorm();
E 4

    //  Factor  //

    this.factor();

D 4
    for(int j=0;j<order;j++) 
      Z[j] = 0;
    
E 4
I 4
    for(int j=0;j<order;j++) {
      Z[j] = Mat[0][0].Clone();
      Z[j].setZero();
    }    
E 4
    this.solveTransUW(Z);
D 4
      
    float S = 1/FUtil.asum(order,Z,1);
    FUtil.scal(order,S,Z,1);
E 4
I 4
    
D 8
    LNumber S = (NUtil.asum(order,Z,1)).inv();
E 8
I 8
    LNumber S = (NUtil.asum(order,Z,1)).invTo();
E 8
    NUtil.scal(order,S,Z,1);
E 4
     
    this.solveUZ(Z);

D 4
    float ynorm = this.solveTransRV(Z);
E 4
I 4
    LNumber ynorm = this.solveTransRV(Z);
E 4
D 6
    
E 6
I 6

E 6
    ynorm = this.solveUZ(Z,ynorm);
      
D 4
    LFloat R = new LFloat();

    if(anorm != 0)
      R.setFloat(ynorm/anorm);

    return R;
E 4
I 4
    if(anorm.equals(0))
      return anorm;
    
    ynorm.divTo(anorm);
    return ynorm;
E 4
  }
D 4
  private void solveTransUW(float[] Z) {
    float ek = 1;
E 4
I 4
  private void solveTransUW(LNumber[] Z) {
    LNumber ek = Z[0].Clone();
    ek.setOne();
E 4
    int kk = -1;
    for(int k=0;k<order;k++) {
      int kp = k+1;
      kk += kp;
D 4
      if(Z[k] != 0) 
	ek = FUtil.signOf(ek,-Z[k]);
      if(Math.abs(ek-Z[k]) > this.Mat[kk][0]) {
	float S = this.Mat[kk][0]/Math.abs(ek-Z[k]);
	FUtil.scal(order,S,Z,1);
	ek *= S;
E 4
I 4
      if(!Z[k].equals(0)) 
D 8
	ek = NUtil.signOf(ek,Z[k].mult(-1));
E 8
I 8
D 9
	ek = NUtil.signOf(ek,Z[k].negate());
E 9
I 9
	ek = NUtil.signOfA(ek,Z[k].negate());
E 9
E 8
      if(((ek.sub(Z[k])).abs()).greaterThan(Mat[kk][0])) {
	LNumber S = Mat[kk][0].div((ek.sub(Z[k])).abs());
	NUtil.scal(order,S,Z,1);
	ek.multTo(S);
E 4
      }
D 4
      float wk = ek - Z[k];
      float wkm = -ek - Z[k];
      float S = Math.abs(wk);
      float SM = Math.abs(wkm);
      wk = wk/this.Mat[kk][0];
      wkm = wkm/this.Mat[kk][0];
E 4
I 4
      LNumber wk = ek.sub(Z[k]);
D 8
      LNumber wkm = (ek.mult(-1)).sub(Z[k]);
E 8
I 8
      LNumber wkm = (ek.negate()).sub(Z[k]);
E 8
      LNumber S = wk.abs();
      LNumber SM = wkm.abs();
      wk.divTo(Mat[kk][0]);
      wkm.divTo(Mat[kk][0]);
E 4
      int kj = kk + kp;
      if(kp < order) {
	for(int j=kp;j<order;j++) {
D 4
	  SM += Math.abs(Z[j] + wkm*this.Mat[kj][0]);
	  Z[j] += wk*this.Mat[kj][0];
	  S += Math.abs(Z[j]);
E 4
I 4
	  SM.addTo((Z[j].add(wkm.mult(Mat[kj][0]))).abs());
	  Z[j].addTo(wk.mult(Mat[kj][0]));
	  S.addTo(Z[j].abs());
E 4
	  kj += j+1;
	}
D 4
	if(S < SM) {
	  float T = wkm - wk;
E 4
I 4
	if(SM.greaterThan(S)) {
	  LNumber T = wkm.sub(wk);
E 4
D 6
	  wk = wkm;
E 6
I 6
D 9
	  wk.set(wkm);
E 9
I 9
	  wk = wkm.Clone();
E 9
E 6
	  kj = kk + kp;
	  for(int j=kp;j<order;j++) {
D 4
	    Z[j] += T*this.Mat[kj][0];
E 4
I 4
	    Z[j].addTo(T.mult(Mat[kj][0]));
E 4
	    kj += j+1;
	  }
	}
      }
D 6
      Z[k] = wk;
E 6
I 6
D 9
      Z[k].set(wk);
E 9
I 9
      Z[k] = wk.Clone();
E 9
E 6
    }
  }
D 4
  private float solveUZ(float[] Z, float ynorm) {
E 4
I 4
  private LNumber solveUZ(LNumber[] Z, LNumber ynorm) {
E 4
    
    int kk = order*(order+1)/2 - 1;
    for(int k=order-1;k>=0;k--) {
D 4
      if(Math.abs(Z[k]) > this.Mat[kk][0]) {
	float S = this.Mat[kk][0]/Math.abs(Z[k]);
	FUtil.scal(order,S,Z,1);
	ynorm *= S;
E 4
I 4
      if((Z[k].abs()).greaterThan(Mat[kk][0])) {
	LNumber S = Mat[kk][0].div(Z[k].abs());
	NUtil.scal(order,S,Z,1);
	ynorm.multTo(S);
E 4
      }
D 4
      Z[k] = Z[k]/this.Mat[kk][0];
E 4
I 4
      Z[k].divTo(Mat[kk][0]);
E 4
      kk = kk - k - 1;
D 4
      this.axpy(k,-Z[k],1,kk+1,0,Z,1,0);
E 4
I 4
D 8
      this.axpy(k,Z[k].mult(-1),1,kk+1,0,Z,1,0);
E 8
I 8
      this.axpy(k,Z[k].negate(),1,kk+1,0,Z,1,0);
E 8
E 4
    }
D 4
    float S = 1/FUtil.asum(order,Z,1);
    FUtil.scal(order,S,Z,1);
    ynorm *= S;
E 4
I 4
D 8
    LNumber S = (NUtil.asum(order,Z,1)).inv();
E 8
I 8
    LNumber S = (NUtil.asum(order,Z,1)).invTo();
E 8
    NUtil.scal(order,S,Z,1);
    ynorm.multTo(S);
E 4

    return ynorm;
  }
D 4
  private void solveUZ(float[] Z) {
E 4
I 4
  private void solveUZ(LNumber[] Z) {
E 4
    int kk = order*(order+1)/2 - 1;
    for(int k=order-1;k>=0;k--) {
D 4
      if(Math.abs(Z[k]) > this.Mat[kk][0]) {
	float S = this.Mat[kk][0]/Math.abs(Z[k]);
	FUtil.scal(order,S,Z,1);
E 4
I 4
      if((Z[k].abs()).greaterThan(Mat[kk][0])) {
	LNumber S = Mat[kk][0].div(Z[k].abs());
	NUtil.scal(order,S,Z,1);
E 4
      }
D 4
      Z[k] = Z[k]/this.Mat[kk][0];
E 4
I 4
      Z[k].divTo(Mat[kk][0]);
E 4
      kk = kk - k - 1;
D 4
      this.axpy(k,-Z[k],1,kk+1,0,Z,1,0);
E 4
I 4
D 8
      this.axpy(k,Z[k].mult(-1),1,kk+1,0,Z,1,0);
E 8
I 8
      this.axpy(k,Z[k].negate(),1,kk+1,0,Z,1,0);
E 8
E 4
    }
D 4
    float S = 1/FUtil.asum(order,Z,1);
    FUtil.scal(order,S,Z,1);
E 4
I 4
D 8
    LNumber S = (NUtil.asum(order,Z,1)).inv();
E 8
I 8
    LNumber S = (NUtil.asum(order,Z,1)).invTo();
E 8
    NUtil.scal(order,S,Z,1);
E 4
  }
D 4
  private float solveTransRV(float[] Z) {
E 4
I 4
  private LNumber solveTransRV(LNumber[] Z) {
E 4
    
    int kk = -1;
D 4
    float ynorm = 1;
E 4
I 4
    LNumber ynorm = Z[0].Clone();
    ynorm.setOne();
E 4
    for(int k=0;k<order;k++) {
D 4
      Z[k] -= this.dot(k,1,kk+1,0,Z,1,0);
E 4
I 4
      Z[k].subTo(this.dot(k,1,kk+1,0,Z,1,0));
E 4
      kk += k+1;
D 4
      if(Math.abs(Z[k]) > this.Mat[kk][0]) {
	float S = this.Mat[kk][0]/Math.abs(Z[k]);
	FUtil.scal(order,S,Z,1);
	ynorm *= S;
E 4
I 4
      if((Z[k].abs()).greaterThan(Mat[kk][0])) {
	LNumber S = Mat[kk][0].div(Z[k].abs());
	NUtil.scal(order,S,Z,1);
D 6
	ynorm.mult(S);
E 6
I 6
	ynorm.multTo(S);
E 6
E 4
      }
D 4
      Z[k] = Z[k]/this.Mat[kk][0];
E 4
I 4
      Z[k].divTo(Mat[kk][0]);
E 4
    }
D 4
    float S = 1/FUtil.asum(order,Z,1);
    FUtil.scal(order,S,Z,1);
    ynorm *= S;
  
E 4
I 4
D 8
    LNumber S = (NUtil.asum(order,Z,1)).inv();
E 8
I 8
    LNumber S = (NUtil.asum(order,Z,1)).invTo();
E 8
    NUtil.scal(order,S,Z,1);
D 6
    ynorm.mult(S);
E 6
I 6
    ynorm.multTo(S);
E 6
    
E 4
    return ynorm;
  }
  
  
D 4
  public void solve(Vector B, int J) 
E 4
I 4
D 5
  public void solve(LNumber[] B, int J) 
E 4
       throws WrongDataTypeException
  {
E 5
I 5
  public void solve(LNumber[] B, int J) {
E 5
    this.solve(B);
  }
D 4
  public void solve(Vector Be) 
E 4
I 4
D 5
  public void solve(LNumber[] B) 
E 4
       throws WrongDataTypeException
  {
E 5
I 5
  public void solve(LNumber[] B) {
E 5
D 4
    
    float[] B = Be.getFloatArray();

E 4
    int kk = -1;
    for(int k = 0;k<order;k++) {
D 4
      float T = this.dot(k,1,kk+1,0,B,1,0);
E 4
I 4
      LNumber T = this.dot(k,1,kk+1,0,B,1,0);
E 4
      kk += k+1;
D 4
      B[k] = (B[k] - T)/this.Mat[kk][0];
E 4
I 4
      B[k] = (B[k].sub(T)).div(Mat[kk][0]);
E 4
    }
    for(int kb=0;kb<order;kb++) {
      int k = order - kb - 1;
D 4
      B[k] = B[k]/this.Mat[kk][0];
E 4
I 4
      B[k].divTo(Mat[kk][0]);
E 4
      kk -= k+1;
D 4
      this.axpy(k,-B[k],1,kk+1,0,B,1,0);
E 4
I 4
D 8
      this.axpy(k,B[k].mult(-1),1,kk+1,0,B,1,0);
E 8
I 8
      this.axpy(k,B[k].negate(),1,kk+1,0,B,1,0);
E 8
E 4
    }
  }
  
D 4
  public Vector determ() {
E 4
I 4
  public LNumber[] determ() {
E 4
    
D 4
    float[] Det = new float[2];
E 4
I 4
    LNumber[] Det = new LNumber[2];
E 4
    
D 4
    Det[0] = 1;
    Det[1] = 0;
E 4
I 4
    Det[0] = Mat[0][0].Clone();
    Det[1] = Det[0].Clone();
    Det[0].setOne();
    Det[1].setZero();
E 4
    
    int ii = 0;
    for(int k=0;k<order;k++) {
D 4
      Det[0] *= Math.pow(this.Mat[ii][0],2); 
E 4
I 4
      Det[0].multTo(Mat[ii][0].square()); 
E 4
D 6
      
E 6
D 4
      if(Det[0] == 0) {
	FVector V = new FVector(Det);
	return V;
      }
E 4
I 4
      if(Det[0].equals(0)) 
	return Det;
E 4
      else 
D 4
	FUtil.detNorm(Det);
E 4
I 4
	NUtil.detNorm(Det);
E 4
      ii += k+2;
    }
D 4
    FVector V2 = new FVector(Det);
    return V2;
E 4
I 4
    return Det;
E 4
  }

  public void inverse() {
    int kk = 0;
    int k1 = 0;
    for(int k=0;k<order;k++) {
D 4
      this.Mat[kk][0] = 1/this.Mat[kk][0];
      float T = -this.Mat[kk][0];
E 4
I 4
D 6
      Mat[kk][0] = Mat[kk][0].inv();
E 6
I 6
D 8
      Mat[kk][0].set(Mat[kk][0].inv());
E 6
      LNumber T = Mat[kk][0].mult(-1);
E 8
I 8
      Mat[kk][0].invTo();
      LNumber T = Mat[kk][0].negate();
E 8
E 4
      this.scal(k,T,1,k1,0);
      int kp = k+1;
      int j1 = kk+1;
      int kj = kk+k+1;
D 6
      if(order > kp) {
	for(int j=kp;j<order;j++) {
D 4
	  T = this.Mat[kj][0];
	  this.Mat[kj][0] = 0;
E 4
I 4
	  T = Mat[kj][0].Clone();
	  Mat[kj][0].setZero();
E 4
	  this.axpy(k+1,T,1,k1,0,this,1,j1,0);
	  j1 += j+1;
	  kj += j+1;
	}
E 6
I 6
      for(int j=kp;j<order;j++) {
	T = Mat[kj][0].Clone();
	Mat[kj][0].setZero();
	this.axpy(k+1,T,1,k1,0,this,1,j1,0);
	j1 += j+1;
	kj += j+1;
E 6
      }
      k1 = kk+1;
      kk += k+2;
    }
    int jj = 0;
    int j1 = 0;
    for(int j=0;j<order;j++) {
      int jm = j-1;
      k1 = 0;
      int kj = j1;
D 6
      if(j > 0) {
	for(int k=0;k<j;k++) {
D 4
	  float T = this.Mat[kj][0];
E 4
I 4
	  LNumber T = Mat[kj][0].Clone();
E 4
	  this.axpy(k+1,T,1,j1,0,this,1,k1,0);
	  k1 += k+1;
	  kj++;
	}
E 6
I 6
      for(int k=0;k<j;k++) {
	LNumber T = Mat[kj][0].Clone();
	this.axpy(k+1,T,1,j1,0,this,1,k1,0);
	k1 += k+1;
	kj++;
E 6
      }
D 4
      float T = this.Mat[jj][0];
E 4
I 4
D 6
      LNumber T = Mat[jj][0];
E 6
I 6
      LNumber T = Mat[jj][0].Clone();
E 6
E 4
      this.scal(j+1,T,1,j1,0);
      j1 = jj + 1;
      jj += j+2;
    }
  }
}
E 1
