h42913
s 00003/00003/00169
d D 1.5 98/08/28 15:42:45 jpiper 6 5
c Fixed for limited access and complex numbers
e
s 00008/00008/00164
d D 1.4 98/08/12 17:08:48 jpiper 5 4
c adjusted for LNumbers
e
s 00010/00015/00162
d D 1.3 98/08/11 16:44:52 jpiper 4 3
c debugged
e
s 00086/00083/00091
d D 1.2 98/08/03 18:50:36 jpiper 3 1
c written - not debugged
e
s 00000/00000/00000
d R 1.2 98/08/03 13:21:14 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/NMatrix/NTriLow.java
e
s 00174/00000/00000
d D 1.1 98/08/03 13:21:13 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
D 3
package edu.rice.linpack.Matrix.FMatrix;
E 3
I 3
package edu.rice.linpack.Matrix.NMatrix;

E 3
import edu.rice.linpack.util.*;
D 3
import edu.rice.linpack.Vector.*;
E 3
import edu.rice.linpack.LNumber.*;

D 3
public class FTriLow extends FTriFull {
E 3
I 3
public class NTriLow extends NTriFull {
E 3

D 3
  public FTriLow() {
E 3
I 3
  public NTriLow() {
E 3
    super();
  }
D 3
  public FTriLow(int i, int j) {
    Mat = new float[i][j];
E 3
I 3
  public NTriLow(int i, int j) {
    Mat = new LNumber[i][j];
E 3
    rows = i;
    cols = j;
  }
D 3
  public FTriLow(float[][] F) {
E 3
I 3
  public NTriLow(LNumber[][] F) {
E 3
    rows = F.length;
    cols = (F[0]).length;
    Mat = F;
  }
D 3
  public FTriLow(FTriLow M) {
E 3
I 3
  public NTriLow(NTriLow M) {
E 3
    rows = M.rows;
    cols = M.cols;
D 3
    Mat = new float[rows][cols];
E 3
I 3
    Mat = new LNumber[rows][cols];
E 3
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) 
D 3
	Mat[i][j] = M.Mat[i][j];
E 3
I 3
	Mat[i][j] = (M.getElem(i,j)).Clone();
E 3
  }

D 3
  protected float oneNorm() {
    float tnorm = 0;
E 3
I 3
  protected LNumber oneNorm() {
    LNumber tnorm = Mat[0][0].Clone();
    tnorm.setZero();
E 3
    for(int j=0;j<cols;j++) {
      int q = cols-j;
D 3
      tnorm = Math.max(tnorm,this.asum(q,1,j,j));
E 3
I 3
      tnorm.maxTo(this.asum(q,1,j,j));
E 3
    }
    return tnorm;
  }

D 3
  public LNumber condition(Vector Ze) 
       throws SingularMatrixException, WrongDataTypeException
E 3
I 3
  public LNumber condition(LNumber[] Z) 
       throws SingularMatrixException
E 3
  {
D 3
 
    float[] Z = Ze.getFloatArray();

    float S;
    float tnorm = this.oneNorm();
    float ynorm;
E 3
I 3
    LNumber S;
    LNumber tnorm = this.oneNorm();
    LNumber ynorm;
E 3

    try {
      this.zeroDiag();
    } finally {
      
D 3
      float ek = 1;
      for(int j=0;j<cols;j++) 
	Z[j] = 0;
E 3
I 3
      LNumber ek = Mat[0][0].Clone();
      ek.setOne();
      for(int j=0;j<cols;j++) {
D 4
	Mat[0][0].Clone();
E 4
I 4
	Z[j] = Mat[0][0].Clone();
E 4
	Z[j].setZero();
      }
E 3
      
      for(int k=cols-1;k>=0;k--) {
D 3
	if(Z[k] != 0) 
	  ek = FUtil.signOf(ek,-Z[k]); 
E 3
I 3
	if(!Z[k].equals(0)) 
D 5
	  ek = NUtil.signOf(ek,Z[k].mult(-1)); 
E 5
I 5
D 6
	  ek = NUtil.signOf(ek,Z[k].negate()); 
E 6
I 6
	  ek = NUtil.signOfA(ek,Z[k].negate()); 
E 6
E 5
E 3
D 4
	
E 4
D 3
	if(Math.abs(ek-Z[k]) > Math.abs(this.Mat[k][k])) {
	  S = Math.abs(this.Mat[k][k])/Math.abs(ek-Z[k]);
	  FUtil.scal(cols,S,Z,1);
	  ek *= S;
E 3
I 3
	if(((ek.sub(Z[k])).abs()).greaterThan(Mat[k][k].abs())) {
	  S = (Mat[k][k].abs()).div((ek.sub(Z[k])).abs());
	  NUtil.scal(cols,S,Z,1);
	  ek.multTo(S);
E 3
	}
D 3
	float wk = ek - Z[k];
	float wkm = -ek - Z[k];
	S = Math.abs(wk);
	float SM = Math.abs(wkm);
E 3
I 3
	LNumber wk = ek.sub(Z[k]);
D 4
	LNumber wkm = (ek.sub(Z[k])).negate();
E 4
I 4
D 5
	LNumber wkm = (ek.add(Z[k])).negate();
E 5
I 5
	LNumber wkm = (ek.add(Z[k])).negateTo();
E 5
E 4
	S = wk.abs();
	LNumber SM = wkm.abs();
E 3
      
D 3
	if(this.Mat[k][k] != 0) {
	  wk = wk/this.Mat[k][k];
	  wkm = wkm/this.Mat[k][k];
E 3
I 3
	if(!Mat[k][k].equals(0)) {
	  wk.divTo(Mat[k][k]);
	  wkm.divTo(Mat[k][k]);
E 3
	}
	else {
D 3
	  wk = 1;
	  wkm = 1;
E 3
I 3
	  wk.setOne();
	  wkm.setOne();
E 3
	}
	
	if(k > 0) {
	  for(int j=0;j<k;j++) {
D 3
	    SM += Math.abs(Z[j] + wkm*this.Mat[k][j]);
	    Z[j] += wk*this.Mat[k][j];
	    S += Math.abs(Z[j]);
E 3
I 3
D 4
	    SM.addTo((Z[j].abs()).add(wkm.mult(Mat[k][j])));
E 4
I 4
	    SM.addTo((Z[j].add(wkm.mult(Mat[k][j]))).abs());
E 4
	    Z[j].addTo(wk.mult(Mat[k][j]));
	    S.addTo(Z[j].abs());
E 3
	  }
D 3
	  if(S < SM) {
	    float T = wkm - wk;
	    wk = wkm;
E 3
I 3
	  if(SM.greaterThan(S)) {
	    LNumber T = wkm.sub(wk);
D 6
	    wk.set(wkm);
E 6
I 6
	    wk = wkm.Clone();
E 6
E 3
	    for(int j=0;j<k;j++) 
D 3
	      Z[j] += T*this.Mat[k][j];
E 3
I 3
	      Z[j].addTo(T.mult(Mat[k][j]));
E 3
	  }
I 3
	}
D 6
	Z[k].set(wk);
E 6
I 6
	Z[k] = wk.Clone();
E 6
E 3
      }
D 3
	Z[k] = wk;
      }
      S = 1/FUtil.asum(cols,Z,1);
      FUtil.scal(cols,S,Z,1);
E 3
I 3
D 5
      S = (NUtil.asum(cols,Z,1)).inv();
E 5
I 5
      S = (NUtil.asum(cols,Z,1)).invTo();
E 5
      NUtil.scal(cols,S,Z,1);
E 3

      ynorm = this.solveTZ(Z);
    }
D 3
    LFloat R = new LFloat();
    if(tnorm != 0) 
      R.setFloat(ynorm/tnorm);
E 3
I 3
    LNumber R;
D 4
    
E 4
I 4

E 4
    if(tnorm.equals(0))
      R = tnorm;
    else
      R = ynorm.div(tnorm);
E 3

    return R;
  }
D 3
  private float solveTZ(float[] Z) {
    float ynorm = 1;
E 3
I 3
  private LNumber solveTZ(LNumber[] Z) {
D 4
    
E 4
    LNumber ynorm = Z[0].Clone();
    ynorm.setOne();
E 3
    
    for(int k=0;k<cols;k++) {
D 3
      if(Math.abs(Z[k]) > Math.abs(this.Mat[k][k])) {
	float S = Math.abs(this.Mat[k][k])/Math.abs(Z[k]);
	FUtil.scal(cols,S,Z,1);
	ynorm *= S;
E 3
I 3
      if((Z[k].abs()).greaterThan(Mat[k][k].abs())) {
	LNumber S = (Mat[k][k].abs()).div(Z[k].abs());
	NUtil.scal(cols,S,Z,1);
	ynorm.multTo(S);
E 3
      }
D 3
      if(this.Mat[k][k] != 0) 
	Z[k] = Z[k]/this.Mat[k][k];
      else 
	Z[k] = 1;
      
E 3
I 3
      if(Mat[k][k].equals(0)) 
	Z[k].setOne();
D 4
      else
E 4
I 4
      else 
E 4
	Z[k].divTo(Mat[k][k]);
D 4

E 4
E 3
      int q = k+1;
      if(q < cols) 
D 3
	this.axpy(cols-q,-Z[k],1,q,k,Z,1,q);
E 3
I 3
D 5
	this.axpy(cols-q,Z[k].mult(-1),1,q,k,Z,1,q);
E 5
I 5
	this.axpy(cols-q,Z[k].negate(),1,q,k,Z,1,q);
E 5
E 3
    }
D 3
    float S = 1/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);
    ynorm *= S;
E 3
I 3
D 5
    LNumber S = (NUtil.asum(cols,Z,1)).inv();
E 5
I 5
    LNumber S = (NUtil.asum(cols,Z,1)).invTo();
E 5
    NUtil.scal(cols,S,Z,1);
    ynorm.multTo(S);
E 3

    return ynorm;
  }

D 3
  public void solve(Vector Be, int job) 
       throws WrongDataTypeException
  {    
    float[] B = Be.getFloatArray();
E 3
I 3
  public void solve(LNumber[] B, int job) {    
E 3

    if(job != 0) {
      int nm = cols-1;
D 3
      B[nm] = B[nm]/this.Mat[nm][nm];
E 3
I 3
      B[nm].divTo(Mat[nm][nm]);
E 3
D 4
      if(cols > 0) {
	for(int jj=1;jj<cols;jj++) {
	  int j = cols - jj - 1;
D 3
	  B[j] -= this.dot(jj,1,j+1,j,B,1,j+1);
	  B[j] = B[j]/this.Mat[j][j];
E 3
I 3
	  B[j].subTo(this.dot(jj,1,j+1,j,B,1,j+1));
	  B[j].divTo(Mat[j][j]);
E 3
	}
E 4
I 4
      for(int jj=1;jj<cols;jj++) {
	int j = cols - jj - 1;
	B[j].subTo(this.dot(jj,1,j+1,j,B,1,j+1));
	B[j].divTo(Mat[j][j]);
E 4
      }
    }
    else {
D 3
      B[0] = B[0]/this.Mat[0][0];
E 3
I 3
      B[0].divTo(this.Mat[0][0]);
E 3
      for(int j=1;j<cols;j++) {
D 3
	float T = -B[j-1];
E 3
I 3
D 5
	LNumber T = B[j-1].mult(-1);
E 5
I 5
	LNumber T = B[j-1].negate();
E 5
E 3
	this.axpy(cols-j, T, 1,j,j-1,B,1,j);
D 3
	B[j] = B[j]/this.Mat[j][j];    
E 3
I 3
	B[j].divTo(Mat[j][j]);    
E 3
      }
    }
  }
  
  public void inverse() {
    for(int k=cols-1;k>=0;k--) {
D 3
      if(this.Mat[k][k] == 0) 
E 3
I 3
      if(Mat[k][k].equals(0)) 
E 3
	return;
      else {
D 3
	this.Mat[k][k] = 1/this.Mat[k][k];
	float T = -this.Mat[k][k];
E 3
I 3
D 4
	Mat[k][k].inv();
E 4
I 4
D 5
	Mat[k][k].set(Mat[k][k].inv());
E 4
	LNumber T = Mat[k][k].mult(-1);
E 5
I 5
	Mat[k][k].invTo();
	LNumber T = Mat[k][k].negate();
E 5
E 3
	this.scal(cols-k-1,T,1,k+1,k);
	for(int j=0;j<k;j++) {
D 3
	  T = this.Mat[k][j];
	  this.Mat[k][j] = 0;
E 3
I 3
	  T = Mat[k][j].Clone();
	  Mat[k][j].setZero();
E 3
	  this.axpy(cols-k,T,1,k,k,this,1,k,j);
	}
      }
    }
  }
}
      
E 1
