h62604
s 00006/00006/00135
d D 1.4 98/08/12 17:07:28 jpiper 5 4
c adjusted for LNumber
e
s 00001/00001/00140
d D 1.3 98/08/11 16:44:35 jpiper 4 3
c debugged
e
s 00072/00053/00069
d D 1.2 98/08/03 18:50:22 jpiper 3 1
c written - not debugged
e
s 00000/00000/00000
d R 1.2 98/08/03 13:20:48 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/edu/rice/linpack/Matrix/NMatrix/NTriUp.java
e
s 00122/00000/00000
d D 1.1 98/08/03 13:20:47 jpiper 1 0
c 
e
u
U
f e 0
t
T
I 1
/*
D 3
 ##  class FTriUp
E 3
I 3
 ##  class NTriUp
E 3
 ##  
 ##  This class holds the routines for a upper triangular matrix stored
 ##  in full form.  There is no factor routine; triangular matrices are
 ##  already in factored form.
 ##
 */

D 3
package edu.rice.linpack.Matrix.FMatrix;
E 3
I 3
package edu.rice.linpack.Matrix.NMatrix;

E 3
import edu.rice.linpack.util.*;
D 3
import edu.rice.linpack.Vector.*;
E 3
import edu.rice.linpack.LNumber.*;

D 3
public class FTriUp extends FTriFull {
E 3
I 3
public class NTriUp extends NTriFull {
E 3

D 3
  public FTriUp() {
E 3
I 3
  public NTriUp() {
E 3
    super();
  }
D 3
  public FTriUp(int i, int j) {
    Mat = new float[i][j];
E 3
I 3
  public NTriUp(int i, int j) {
    Mat = new LNumber[i][j];
E 3
    rows = i;
    cols = j;
  }
D 3
  public FTriUp(float[][] F) {
E 3
I 3
  public NTriUp(LNumber[][] F) {
E 3
    rows = F.length;
    cols = (F[0]).length;
    Mat = F;
  }
D 3
  public FTriUp(FTriUp M) {
E 3
I 3
  public NTriUp(NTriUp M) {
E 3
    rows = M.rows;
    cols = M.cols;
D 3
    Mat = new float[rows][cols];
E 3
I 3
    Mat = new LNumber[rows][cols];
E 3
    for(int i=0;i<rows;i++)
      for(int j=0;j<cols;j++) 
D 3
	Mat[i][j] = M.Mat[i][j];
E 3
I 3
	Mat[i][j] = (M.getElem(i,j)).Clone();
E 3
  }
D 3

  protected float oneNorm() {
    float tnorm = 0;
E 3
I 3
  
  protected LNumber oneNorm() {
    LNumber tnorm = Mat[0][0].Clone();
    tnorm.setZero();
E 3
    for(int j=0;j<cols;j++) 
D 3
      tnorm = Math.max(tnorm,this.asum(j+1,1,0,j));
E 3
I 3
      tnorm.maxTo(this.asum(j+1,1,0,j));
E 3
    return tnorm;
  }
D 3

  public LNumber condition(Vector Ze) 
       throws WrongDataTypeException, SingularMatrixException
E 3
I 3
  
  public LNumber condition(LNumber[] Z) 
       throws SingularMatrixException
E 3
  {
D 3
 
    float[] Z = Ze.getFloatArray();

    float tnorm = this.oneNorm();
    float ynorm;

E 3
I 3
    LNumber tnorm = this.oneNorm();
    LNumber ynorm;
    
E 3
    try {
      this.zeroDiag();
    } finally {
D 3
    
    for(int j=0;j<cols;j++) 
      Z[j] = 0;
        
    this.solveTransUW(Z);

    float S = 1/FUtil.asum(cols,Z,1);
    FUtil.scal(cols,S,Z,1);

    ynorm = this.solveUZ(Z,1);
E 3
I 3
      
      for(int j=0;j<cols;j++) {
	Z[j] = Mat[0][0].Clone();
	Z[j].setZero();
      }
      this.solveTransUW(Z);
      
D 5
      LNumber S = (NUtil.asum(cols,Z,1)).inv();
E 5
I 5
      LNumber S = (NUtil.asum(cols,Z,1)).invTo();
E 5
      NUtil.scal(cols,S,Z,1);
      
      ynorm = this.solveUZ(Z);
E 3
    }
D 3
    LFloat R = new LFloat();
E 3
I 3
    LNumber R;
    
    if(tnorm.equals(0))
      R = tnorm;
    else
      R = ynorm.div(tnorm);
E 3
    
D 3
    if(tnorm != 0) 
      R.setFloat(ynorm/tnorm);

E 3
    return R;
  }
I 3
  LNumber solveUZ(LNumber[] Z) {
    LNumber ynorm = Z[0].Clone();
    ynorm.setOne();
    for(int k=cols-1;k>=0;k--) {
      if((Z[k].abs()).greaterThan(Mat[k][k].abs())) {
	LNumber S = (Mat[k][k].abs()).div(Z[k].abs());
	NUtil.scal(cols,S,Z,1);
	ynorm.multTo(S);
      } 
      if(!Mat[k][k].equals(0)) 
	Z[k].divTo(Mat[k][k]);
      else 
	Z[k].setOne();
E 3

D 3
  public void solve(Vector Be, int job) 
       throws WrongDataTypeException
  {
E 3
I 3
D 5
      this.axpy(k,Z[k].mult(-1),1,0,k,Z,1,0);
E 5
I 5
      this.axpy(k,Z[k].negate(),1,0,k,Z,1,0);
E 5
    }
D 5
    LNumber S = (NUtil.asum(cols,Z,1)).inv();
E 5
I 5
    LNumber S = (NUtil.asum(cols,Z,1)).invTo();
E 5
    NUtil.scal(cols,S,Z,1);
    ynorm.multTo(S);

    return ynorm;
  }
E 3

D 3
    float[] B = Be.getFloatArray();
E 3
I 3
  public void solve(LNumber[] B, int job) {
E 3

    if(job == 0) {
      int nm = cols-1;
D 3
      B[nm] = B[nm]/this.Mat[nm][nm];
E 3
I 3
      B[nm].divTo(Mat[nm][nm]);
E 3
      if(cols > 0) {
	for(int j=nm-1;j>=0;j--) {
D 3
	  float T = -B[j+1];
E 3
I 3
D 5
	  LNumber T = B[j+1].mult(-1);
E 5
I 5
	  LNumber T = B[j+1].negate();
E 5
E 3
	  this.axpy(j+1, T, 1,0,j+1,B,1,0);
D 3
	  B[j] = B[j]/this.Mat[j][j];    
E 3
I 3
	  B[j].divTo(Mat[j][j]);    
E 3
	}
      }
    }
    else {
D 3
      B[0] = B[0]/this.Mat[0][0];
E 3
I 3
      B[0].divTo(Mat[0][0]);
E 3
      if(cols > 1) {
	for(int j=1;j<cols;j++) {
D 3
	  B[j] -= this.dot(j,1,0,j,B,1,0);
	  B[j] = B[j]/this.Mat[j][j];
E 3
I 3
	  B[j].subTo(this.dot(j,1,0,j,B,1,0));
	  B[j].divTo(Mat[j][j]);
E 3
	}
      }
    }
  }
  
  public void inverse() {
    for(int k=0;k<cols;k++) {
D 3
      if(this.Mat[k][k] == 0)
E 3
I 3
      if(Mat[k][k].equals(0))
E 3
	return;
      else {
D 3
	this.Mat[k][k] = 1/this.Mat[k][k];
	float T = -this.Mat[k][k];
E 3
I 3
D 4
	Mat[k][k].inv();
E 4
I 4
D 5
	Mat[k][k].set(Mat[k][k].inv());
E 4
	LNumber T = Mat[k][k].mult(-1);
E 5
I 5
	Mat[k][k].invTo();
	LNumber T = Mat[k][k].negate();
E 5
E 3
	this.scal(k,T,1,0,k);
	int kp = k+1;
	for(int j=kp;j<cols;j++) {
D 3
	  T = this.Mat[k][j];
	  this.Mat[k][j] = 0;
E 3
I 3
	  T = Mat[k][j].Clone();
	  Mat[k][j].setZero();
E 3
	  this.axpy(k+1,T,1,0,k,this,1,0,j);
	}
      }
    }
  }
}
E 1
