/*
 ##  class DTrig
 ##  
 ##  This class holds the values for the sin and cos values computed
 ##  in subroutine rotg and used in subroutine rot.  rotg finds a 
 ##  Givens plane rotation and rot computes the rotation.
 ##
 */

package edu.rice.linpack.util;

public class DTrig extends Trig {

  private double sin;
  private double cos;
  private double A;
  private double B;

  public DTrig() {
    sin = 0;
    cos = 0;
    A = 0;
    B = 0;
  }
  public DTrig(DTrig F) {
    sin = F.sin;
    cos = F.cos;
    A = F.A;
    B = F.B;
  }
  public DTrig(double a, double b, double s,double c) {
    A = a;
    B = b;
    sin = s;
    cos = c;
  }
  public DTrig(double b, double s, double c) {
    sin = s;
    cos = c;
    A = 0;
    B = b;
  }

  public void setSin(double s) {
    sin = s;
  }
  public void setCos(double c) {
    cos = c;
  }
  public void setA(double a) {
    A = a;
  }
  public void setB(double b) {
    B = b;
  }
  public double getSin() {
    return sin;
  }
  public double getCos() {
    return cos;
  }
  public double getA() {
    return A;
  }
  public double getB() {
    return B;
  }
}
