/*
 ##  class FTrig
 ##  
 ##  This class holds the values for the sin and cos values computed
 ##  in subroutine rotg and used in subroutine rot.  rotg finds a 
 ##  Givens plane rotation and rot computes the rotation.
 ##
 */

package edu.rice.linpack.util;

public class FTrig extends Trig {

  private float sin;
  private float cos;
  private float A;
  private float B;

  public FTrig() {
    sin = 0;
    cos = 0;
    A = 0;
    B = 0;
  }
  public FTrig(FTrig F) {
    sin = F.sin;
    cos = F.cos;
    A = F.A;
    B = F.B;
  }
  public FTrig(float a, float b, float s,float c) {
    A = a;
    B = b;
    sin = s;
    cos = c;
  }
  public FTrig(float b, float s, float c) {
    sin = s;
    cos = c;
    A = 0;
    B = b;
  }

  public void setSin(float s) {
    sin = s;
  }
  public void setCos(float c) {
    cos = c;
  }
  public void setA(float a) {
    A = a;
  }
  public void setB(float b) {
    B = b;
  }
  public float getSin() {
    return sin;
  }
  public float getCos() {
    return cos;
  }
  public float getA() {
    return A;
  }
  public float getB() {
    return B;
  }
}
