/*
 ##  class NTrig
 ##  
 ##  This class holds the values for the sin and cos values computed
 ##  in subroutine rotg and used in subroutine rot.  rotg finds a 
 ##  Givens plane rotation and rot computes the rotation.
 ##
 */

package edu.rice.linpack.util;
import edu.rice.linpack.LNumber.*;

public class NTrig extends Trig {

  private LNumber sin;
  private LNumber cos;
  private LNumber A;
  private LNumber B;

  public NTrig() {
  } 
  public NTrig(LNumber b, LNumber s, LNumber c) {
    sin = s;
    cos = c;
    B = b;
  }
  public NTrig(LNumber a, LNumber b, LNumber s,LNumber c) {
    A = a;
    B = b;
    sin = s;
    cos = c;
  }
  public NTrig(NTrig F) {
    sin = (F.sin).Clone();
    cos = (F.cos).Clone();
    A = (F.A).Clone();
    B = (F.B).Clone();
  }

  public void setSin(LNumber s) {
    sin = s;
  }
  public void setCos(LNumber c) {
    cos = c;
  }
  public void setSinOne() {
    sin.setOne();
  }
  public void setCosOne() {
    cos.setOne();
  }
   public void setSinZero() {
    sin.setZero();
  }
  public void setCosZero() {
    cos.setZero();
  } 
  public void setA(LNumber a) {
    A = a;
  }
  public void setB(LNumber b) {
    B = b;
  }
  public LNumber getSin() {
    return sin.Clone();
  }
  public LNumber getCos() {
    return cos.Clone();
  }
  public LNumber getA() {
    return A.Clone();
  }
  public LNumber getB() {
    return B.Clone();
  }
}
